/*
 * Decompiled with CFR 0.152.
 */
package com.projity.menu;

import com.projity.menu.ExtMenuFactory;
import com.projity.menu.ExtToolBarFactory;
import com.projity.menu.HyperLinkToolTip;
import com.projity.pm.graphic.TabbedNavigation;
import com.projity.strings.DirectoryClassLoader;
import com.projity.util.ClassLoaderUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.batik.util.gui.resource.ActionMap;

public class MenuManager {
    private static final String MENU_BUNDLE = "com.projity.menu.menu";
    private static final String MENU_BUNDLE_CONF_DIR = "menu";
    public static final String STANDARD_MENU = "StandardMenuBar";
    public static final String MAC_STANDARD_MENU = "MacStandardMenuBar";
    public static final String SERVER_STANDARD_MENU = "ServerStandardMenuBar";
    public static final String SF_MENU = "SFMenuBar";
    public static final String STANDARD_TOOL_BAR = "StandardToolBar";
    public static final String MAC_STANDARD_TOOL_BAR = "MacStandardToolBar";
    public static final String FILE_TOOL_BAR = "FileToolBar";
    public static final String BIG_TOOL_BAR = "BigToolBar";
    public static final String VIEW_TOOL_BAR = "ViewToolBar";
    public static final String VIEW_TOOL_BAR_WITH_NO_SUB_VIEW_OPTION = "ViewToolBarNoSubView";
    public static final String PRINT_PREVIEW_TOOL_BAR = "PrintPreviewToolBar";
    static ResourceBundle bundle;
    ExtMenuFactory menuFactory;
    ExtToolBarFactory toolBarFactory;
    ActionMap rootActionMap;
    LinkedList tabbedNavigations = new LinkedList();

    public void add(TabbedNavigation tabbedNavigation) {
        this.tabbedNavigations.add(tabbedNavigation);
    }

    private MenuManager(ActionMap actionMap) {
        this.rootActionMap = actionMap;
        if (bundle == null) {
            try {
                DirectoryClassLoader directoryClassLoader = new DirectoryClassLoader();
                if (directoryClassLoader.isValid()) {
                    bundle = ResourceBundle.getBundle(MENU_BUNDLE_CONF_DIR, Locale.getDefault(), directoryClassLoader);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(MENU_BUNDLE, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
            }
        }
        this.menuFactory = new ExtMenuFactory(bundle, actionMap);
        this.toolBarFactory = new ExtToolBarFactory(bundle, actionMap);
    }

    public static MenuManager getInstance(ActionMap actionMap) {
        return new MenuManager(actionMap);
    }

    public JMenuBar getMenu(String string) {
        return this.menuFactory.createJMenuBar(string);
    }

    public JPopupMenu getPopupMenu(String string) {
        return this.menuFactory.createJPopupMenuBar(string);
    }

    public static String getMenuString(String string) {
        return bundle.getString(string);
    }

    public String getString(String string) {
        return this.menuFactory.getString(string);
    }

    public String getStringOrNull(String string) {
        try {
            return this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String getActionStringFromId(String string) {
        String string2 = this.menuFactory.getActionStringFromId(string);
        if (string2 == null) {
            System.out.println("Invalid item: " + string + " it must be a menu item in the menu properties, even if it's only shown in a toolbar");
        }
        return string2;
    }

    public Action getActionFromId(String string) {
        return this.menuFactory.getActionFromId(string);
    }

    public String getStringFromAction(Action action) {
        return this.menuFactory.getStringFromAction(action);
    }

    public JMenuItem getMenuItemFromId(String string) {
        return this.menuFactory.getMenuItemFromId(string);
    }

    public ArrayList getToolButtonsFromId(String string) {
        return this.toolBarFactory.getButtonsFromId(string);
    }

    public final ExtToolBarFactory getToolBarFactory() {
        return this.toolBarFactory;
    }

    public JToolBar getToolBar(String string) {
        return this.toolBarFactory.createJToolBar(string);
    }

    public void setActionEnabled(String string, boolean bl) {
        Object object;
        ArrayList arrayList = this.toolBarFactory.getButtonsFromId(string);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractButton abstractButton = (AbstractButton)object.next();
                if (abstractButton == null) continue;
                abstractButton.setEnabled(bl);
            }
        }
        if ((object = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((JMenuItem)object).setEnabled(bl);
        }
    }

    public void setActionVisible(String string, boolean bl) {
        Object object;
        ArrayList arrayList = this.toolBarFactory.getButtonsFromId(string);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractButton abstractButton = (AbstractButton)object.next();
                if (abstractButton == null) continue;
                abstractButton.setVisible(bl);
            }
        }
        if ((object = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((JComponent)object).setVisible(bl);
        }
    }

    public void setActionSelected(String string, boolean bl) {
        Object object;
        Object object2;
        ArrayList arrayList = this.toolBarFactory.getButtonsFromId(string);
        if (arrayList != null) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (AbstractButton)object2.next();
                if (object == null) continue;
                ((AbstractButton)object).setSelected(bl);
                if (!(object instanceof JToggleButton)) continue;
            }
        }
        if ((object2 = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((AbstractButton)object2).setSelected(bl);
        }
        object = this.tabbedNavigations.iterator();
        while (object.hasNext()) {
            ((TabbedNavigation)object.next()).setActivatedView(string, bl);
        }
    }

    public void setText(String string, String string2) {
        Object object;
        ArrayList arrayList = this.toolBarFactory.getButtonsFromId(string);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractButton abstractButton = (AbstractButton)object.next();
                if (abstractButton == null) continue;
                abstractButton.setToolTipText(string2);
            }
        }
        if ((object = this.menuFactory.getMenuItemFromId(string)) != null) {
            ((AbstractButton)object).setText(string2);
        }
    }

    public String getTextForId(String string) {
        return this.menuFactory.getTextForId(string);
    }

    public String getFullTipText(String string) {
        String string2 = this.getStringOrNull(string + ".tooltip");
        if (string2 != null) {
            String string3 = this.getStringOrNull(string + ".help");
            String string4 = this.getStringOrNull(string + ".demo");
            String string5 = this.getStringOrNull(string + ".doc");
            if (string5 != null) {
                string2 = HyperLinkToolTip.helpTipText(string2, string3, string4, string5);
            }
        }
        return string2;
    }
}

