/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.xbs;

import com.projity.graphic.configuration.BarFormat;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.graphic.configuration.TexturedShape;
import com.projity.pm.graphic.model.cache.GraphicDependency;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.network.NetworkParams;
import com.projity.pm.graphic.network.layout.AbstractNetworkLayout;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Closure;

public class XbsLayout
extends AbstractNetworkLayout {
    protected List dependencies = new ArrayList();
    protected TexturedShapeFinder texturedShapeFinder = new TexturedShapeFinder();

    public XbsLayout(NetworkParams networkParams) {
        super(networkParams);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void setCache(NodeModelCache nodeModelCache) {
        super.setCache(nodeModelCache);
    }

    protected TexturedShape findShape(GraphicNode graphicNode) {
        this.texturedShapeFinder.initialize(graphicNode);
        this.barStyles.apply(graphicNode.getNode().getImpl(), this.texturedShapeFinder);
        return this.texturedShapeFinder.getShape();
    }

    private void setShape(GraphicNode graphicNode, Rectangle2D rectangle2D, double d2, double d3) {
        TexturedShape texturedShape = this.findShape(graphicNode);
        if (texturedShape == null) {
            return;
        }
        GeneralPath generalPath = texturedShape.toGeneralPath(rectangle2D.getWidth(), rectangle2D.getHeight(), d2 - rectangle2D.getWidth() / 2.0, d3, null);
        graphicNode.setXbsShape(generalPath, d2, d3);
        Rectangle.union(this.bounds, this.network.scale(generalPath.getBounds()), this.bounds);
    }

    protected int updateBounds(Point2D point2D, Rectangle2D rectangle2D) {
        double d2 = point2D.getX() + rectangle2D.getWidth() / 2.0;
        double d3 = point2D.getY() + rectangle2D.getHeight() / 2.0;
        GraphicNode graphicNode = null;
        int n2 = 0;
        ListIterator listIterator = this.cache.getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode2 = (GraphicNode)listIterator.next();
            if (graphicNode2.getLevel() > n2) {
                n2 = graphicNode2.getLevel();
            }
            if (graphicNode != null && graphicNode2.getLevel() <= graphicNode.getLevel()) {
                this.setShape(graphicNode, rectangle2D, d2, d3 + (double)(graphicNode.getLevel() - 1) * rectangle2D.getMaxY());
                d2 += rectangle2D.getMaxX();
            }
            graphicNode = graphicNode2;
        }
        if (graphicNode != null) {
            this.setShape(graphicNode, rectangle2D, d2, d3 + (double)(graphicNode.getLevel() - 1) * rectangle2D.getMaxY());
        }
        return n2;
    }

    protected void updateBounds(int n2, Point2D point2D, Rectangle2D rectangle2D) {
        double d2 = point2D.getY() + rectangle2D.getHeight() / 2.0 + rectangle2D.getMaxY() * (double)(n2 - 1);
        ListIterator listIterator = this.cache.getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (graphicNode.getLevel() != n2) continue;
            double d3 = -1.0;
            double d4 = -1.0;
            boolean bl = false;
            while (listIterator.hasNext()) {
                GraphicNode graphicNode2 = (GraphicNode)listIterator.next();
                if (graphicNode2.getLevel() <= n2) {
                    listIterator.previous();
                    break;
                }
                if (graphicNode2.getLevel() != n2 + 1) continue;
                bl = true;
                Point2D point2D2 = graphicNode2.getXbsCenter();
                if (d3 == -1.0 || point2D2.getX() < d3) {
                    d3 = point2D2.getX();
                }
                if (d4 == -1.0 || point2D2.getX() > d4) {
                    d4 = point2D2.getX();
                }
                this.dependencies.add(new GraphicDependency(graphicNode, graphicNode2, null));
            }
            if (!bl) continue;
            this.setShape(graphicNode, rectangle2D, (d3 + d4) / 2.0, d2);
        }
    }

    public void updateBounds() {
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        Point2D.Double double_ = new Point2D.Double(graphicConfiguration.getTreeXOffset(), graphicConfiguration.getTreeYOffset());
        Rectangle2D.Double double_2 = new Rectangle2D.Double(graphicConfiguration.getTreeXOffset(), graphicConfiguration.getTreeYOffset(), graphicConfiguration.getTreeCellWidth(), graphicConfiguration.getTreeCellHeight());
        this.setEmpty();
        this.dependencies.clear();
        this.bounds.setFrame(0.0, 0.0, 0.0, 0.0);
        int n2 = this.updateBounds(double_, double_2);
        if (n2 == 0) {
            return;
        }
        for (int i2 = n2 - 1; i2 > 0; --i2) {
            this.updateBounds(i2, double_, double_2);
        }
        this.fireLayoutChanged();
    }

    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        if (!compositeCacheEvent.isNodeHierarchy()) {
            return;
        }
        this.updateBounds();
    }

    protected class TexturedShapeFinder
    implements Closure {
        protected BarFormat format;
        protected GraphicNode node;
        protected TexturedShape shape;

        protected TexturedShapeFinder() {
        }

        void initialize(GraphicNode graphicNode) {
            this.node = graphicNode;
            this.shape = null;
        }

        public void execute(Object object) {
            this.format = (BarFormat)object;
            if (this.format.getMiddle() != null) {
                this.shape = this.format.getMiddle();
            }
        }

        public TexturedShape getShape() {
            return this.shape;
        }
    }
}

