/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.snapshot;

import com.projity.configuration.Settings;
import com.projity.pm.snapshot.DataSnapshot;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.Task;
import com.projity.pm.task.TaskSnapshot;
import com.projity.strings.Messages;
import java.io.Serializable;
import org.apache.commons.collections.Closure;

public class SnapshottableImpl
implements Snapshottable,
Serializable {
    DataSnapshot[] snapshots = null;
    private static String[] snapshotNames = null;

    public SnapshottableImpl(int n2) {
        this.snapshots = new DataSnapshot[n2];
    }

    public DataSnapshot getSnapshot(Object object) {
        return this.snapshots[(Integer)object];
    }

    public void setSnapshot(Object object, DataSnapshot dataSnapshot) {
        this.snapshots[((Integer)object).intValue()] = this.cloneSnapshot(dataSnapshot);
    }

    public void saveCurrentToSnapshot(Object object) {
        this.setSnapshot(object, this.snapshots[CURRENT]);
    }

    public DataSnapshot getCurrentSnapshot() {
        return this.snapshots[CURRENT];
    }

    public void setCurrentSnapshot(DataSnapshot dataSnapshot) {
        this.snapshots[SnapshottableImpl.CURRENT.intValue()] = dataSnapshot;
    }

    public void clearSnapshot(Object object) {
        this.snapshots[((Integer)object).intValue()] = null;
    }

    public DataSnapshot cloneSnapshot(DataSnapshot dataSnapshot) {
        return dataSnapshot;
    }

    public static String snapshotName(int n2) {
        String string = Messages.getString("Text.Baseline");
        if (n2 > 0) {
            string = string + " " + n2;
        }
        return string;
    }

    public static String[] getSnapshotNames() {
        if (snapshotNames == null) {
            snapshotNames = new String[Settings.NUM_ARRAY_BASELINES];
            for (int i2 = 0; i2 < Settings.NUM_ARRAY_BASELINES; ++i2) {
                SnapshottableImpl.snapshotNames[i2] = SnapshottableImpl.snapshotName(i2);
            }
        }
        return snapshotNames;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object cloneWithTask(Task task) {
        SnapshottableImpl snapshottableImpl = (SnapshottableImpl)this.clone();
        snapshottableImpl.snapshots = new DataSnapshot[this.snapshots.length];
        for (int i2 = 0; i2 < this.snapshots.length; ++i2) {
            snapshottableImpl.snapshots[i2] = this.snapshots[i2] == null ? null : (DataSnapshot)((TaskSnapshot)this.snapshots[i2]).deepCloneWithTask(task);
        }
        return snapshottableImpl;
    }

    public static class ClearSnapshotClosure
    implements Closure {
        Object snapshotId;

        public ClearSnapshotClosure(Object object) {
            this.snapshotId = object;
        }

        public void execute(Object object) {
            if (object instanceof Snapshottable) {
                ((Snapshottable)object).clearSnapshot(this.snapshotId);
            }
        }
    }

    public static class SaveCurrentToSnapshotClosure
    implements Closure {
        Object snapshotId;

        public SaveCurrentToSnapshotClosure(Object object) {
            this.snapshotId = object;
        }

        public void execute(Object object) {
            if (object instanceof Snapshottable) {
                ((Snapshottable)object).saveCurrentToSnapshot(this.snapshotId);
            }
        }
    }
}

