/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import java.io.Serializable;

public abstract class WhiteSpaceProcessor
implements Serializable {
    public static final WhiteSpaceProcessor thePreserve = new Preserve();
    public static final WhiteSpaceProcessor theReplace = new Replace();
    public static final WhiteSpaceProcessor theCollapse = new Collapse();
    private static final WhiteSpaceProcessor backwardCompatibiliyHook1 = new WhiteSpaceProcessor(){

        public String process(String text) {
            throw new UnsupportedOperationException();
        }
    };
    private static final WhiteSpaceProcessor backwardCompatibiliyHook2 = new WhiteSpaceProcessor(){

        public String process(String text) {
            throw new UnsupportedOperationException();
        }
    };
    private static final WhiteSpaceProcessor backwardCompatibiliyHook3 = new WhiteSpaceProcessor(){

        public String process(String text) {
            throw new UnsupportedOperationException();
        }
    };

    public abstract String process(String var1);

    protected static final boolean isWhiteSpace(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    private static class Collapse
    extends WhiteSpaceProcessor {
        private Collapse() {
        }

        public String process(String text) {
            int len = text.length();
            StringBuffer result = new StringBuffer(len);
            boolean inStripMode = true;
            for (int i = 0; i < len; ++i) {
                char ch = text.charAt(i);
                boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
                if (inStripMode && b) continue;
                inStripMode = b;
                if (inStripMode) {
                    result.append(' ');
                    continue;
                }
                result.append(ch);
            }
            len = result.length();
            if (len > 0 && result.charAt(len - 1) == ' ') {
                result.setLength(len - 1);
            }
            return result.toString();
        }
    }

    private static class Replace
    extends WhiteSpaceProcessor {
        private Replace() {
        }

        public String process(String text) {
            int len = text.length();
            StringBuffer result = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char ch = text.charAt(i);
                if (WhiteSpaceProcessor.isWhiteSpace(ch)) {
                    result.append(' ');
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
    }

    private static class Preserve
    extends WhiteSpaceProcessor {
        private Preserve() {
        }

        public String process(String text) {
            return text;
        }
    }
}

