/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.LittleEndian;

public class LongField {
    private long _value;
    private final int _offset;

    public LongField(int offset) throws ArrayIndexOutOfBoundsException {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset: " + offset);
        }
        this._offset = offset;
    }

    public LongField(int offset, byte[] data) throws ArrayIndexOutOfBoundsException {
        this(offset);
        this.readFromBytes(data);
    }

    public long get() {
        return this._value;
    }

    public void readFromBytes(byte[] data) throws ArrayIndexOutOfBoundsException {
        this._value = LittleEndian.getLong(data, this._offset);
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

