(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* Copyright 2004 Yamagata Yoriyuki *)

let f mrph_list =
  let data_list = List.map Chasen.mrph_data_of_mrph mrph_list in
  let buf = Buffer.create 0 in
  let rec loop = function
      [] -> ();
    | data :: r ->
	Buffer.add_string buf (Chasen.surface_form data);
	loop r
  in
    loop data_list;
    Buffer.contents buf

let surface_form mrph =
  let d = Chasen.mrph_data_of_mrph mrph in
    Chasen.surface_form d
