/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* $Id: mrph-data.c 132 2005-08-07 18:05:59Z yori $ */

#include <string.h>
/* #include <stdio.h>*/
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include "chalib.h"
#include "dartsdic.h"
#include "tools.h"
#define NO_COMPOUND LONG_MAX

value mrph_data_posid (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->posid));
}

value mrph_data_inf_type (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->inf_type));
}

value mrph_data_inf_form (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->inf_form));
}

value mrph_data_weight (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->weight));
}

value mrph_data_con_tbl (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->con_tbl));
}

value mrph_data_dat_index (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->dat_index));
}

value mrph_data_keyword (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLlocal1 (string);

  string = alloc_string(((mrph_data_t*)mrph_data)->keyword_len);
  memcpy(String_val(string), 
	 ((mrph_data_t*)mrph_data)->keyword, 
	 ((mrph_data_t*)mrph_data)->keyword_len*sizeof(char));

  CAMLreturn (string);
}

value mrph_data_keyword_len (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->keyword_len));
}

value mrph_data_is_undef (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->is_undef));
}
value mrph_data_darts (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn ((value)((mrph_data_t*)mrph_data)->darts);
}

value mrph_data_headword (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLlocal1 (string);

  string = alloc_string(((mrph_data_t*)mrph_data)->headword_len);
  memcpy(String_val(string), 
	 ((mrph_data_t*)mrph_data)->headword, 
	 ((mrph_data_t*)mrph_data)->headword_len*sizeof(char));

  CAMLreturn (string);
}

value mrph_data_headword_len (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->headword_len));
}

value mrph_data_reading (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLlocal1 (string);

  string = alloc_string(((mrph_data_t*)mrph_data)->reading_len);
  memcpy(String_val(string), 
	 ((mrph_data_t*)mrph_data)->reading, 
	 ((mrph_data_t*)mrph_data)->reading_len*sizeof(char));

  CAMLreturn (string);
}

value mrph_data_reading_len (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->reading_len));
}

value mrph_data_pron (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLlocal1 (string);

  string = alloc_string(((mrph_data_t*)mrph_data)->pron_len);
  memcpy(String_val(string), 
	 ((mrph_data_t*)mrph_data)->pron, 
	 ((mrph_data_t*)mrph_data)->pron_len*sizeof(char));

  CAMLreturn (string);
}

value mrph_data_pron_len (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->pron_len));
}

value mrph_data_stem_len (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->stem_len));
}

value mrph_data_base (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (copy_string(((mrph_data_t*)mrph_data)->base));
}

value mrph_data_info (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (copy_string(((mrph_data_t*)mrph_data)->info));
}

value mrph_data_compound (value mrph_data){
  CAMLparam1 (mrph_data);
  CAMLreturn (Val_long(((mrph_data_t*)mrph_data)->compound));
}

CAMLprim value new_mrph_data_opt (value posid, 
				  value inf_type, 
				  value inf_form,
				  value weight,
				  value con_tbl,
				  value dat_index,
				  value keyword,
				  value is_undef,
				  value darts,
				  value headword,
				  value stem_len,
				  value reading,
				  value pron,
				  value base,
				  value info,
				  value compound){
  mrph_data_t *mrph_data;

  mrph_data = (mrph_data_t*)malloc(sizeof(mrph_data_t));
  
  mrph_data->posid = Long_val(posid);
  mrph_data->inf_type = Long_val(inf_type);
  mrph_data->inf_form = Long_val(inf_form);
  mrph_data->weight = Long_val(weight);
  mrph_data->con_tbl = Long_val(con_tbl);
  mrph_data->dat_index = Long_val(dat_index);

  mrph_data->keyword_len = string_length(keyword);
  mrph_data->keyword = copy_new_string(String_val(keyword),
				       mrph_data->keyword_len);

  mrph_data->is_undef = Long_val(is_undef);
  mrph_data->darts = (darts_t *)darts;

  mrph_data->headword_len = string_length(headword);
  mrph_data->headword = copy_new_string(String_val(headword),
					mrph_data->headword_len);

  mrph_data->stem_len = Long_val(stem_len);

  mrph_data->reading_len = string_length(headword);
  mrph_data->reading = copy_new_string(String_val(reading),
				       mrph_data->reading_len);

  mrph_data->pron_len = string_length(pron);
  mrph_data->pron = copy_new_string(String_val(pron),
				    mrph_data->pron_len);

  mrph_data->base = copy_new_string(String_val(base),
				    string_length(base));

  mrph_data->info = copy_new_string(String_val(info),
				    string_length(info));

  mrph_data->compound = Long_val(compound);

  return ((value)mrph_data);
}
    
CAMLprim value new_mrph_data_byte (value *argv, int argn){
  return new_mrph_data_opt(argv[0], argv[1], argv[2], argv[3], argv[4],
			   argv[5], argv[6], argv[7], argv[8], argv[9],
			   argv[10], argv[11], argv[12], argv[13],
			   argv[14], argv[15]);
}

value delete_mrph_data (value mrph_data){
  CAMLparam1 (mrph_data);
  /*  printf("delte mrph_data %d\n", mrph_data); */
  free(((mrph_data_t*)mrph_data)->keyword);
  free(((mrph_data_t*)mrph_data)->headword);
  free(((mrph_data_t*)mrph_data)->reading);
  free(((mrph_data_t*)mrph_data)->pron);
  free(((mrph_data_t*)mrph_data)->base);
  free(((mrph_data_t*)mrph_data)->info);
  free((mrph_data_t*)mrph_data);
  CAMLreturn (Val_unit);
}

value mrph_data_of_mrph (value v){
  CAMLparam1 (v);
  mrph_data_t *data;
  mrph_t *mrph;

  mrph = (mrph_t*)v;
  data = (mrph_data_t*)malloc(sizeof(mrph_data_t));
  memcpy(data, mrph, sizeof(mrph_t));
  data->keyword = copy_new_string(mrph->keyword, mrph->keyword_len);
  
  if (mrph->dat_index < 0) {
    data->headword = copy_new_string(mrph->headword, mrph->headword_len);
    data->reading = null_string();
    data->pron = null_string();
    data->base = null_string();
    data->info = null_string();
    data->compound = NO_COMPOUND;
    data->stem_len = 0;
  } else {
    da_dat_t d;
    void *p;
    
    p = da_get_dat_base(mrph->darts);
    memcpy(&d, p + mrph->dat_index, sizeof(da_dat_t));
    data->compound = d.compound;
    data->stem_len = d.stem_len;
    p += mrph->dat_index + sizeof(da_dat_t);
    data->headword = copy_new_string(p, d.heading_len);
    p += ((d.heading_len >= 0) ? d.heading_len : 0) + 1;
    data->reading = copy_new_string(p, d.reading_len);
    p += ((d.reading_len >= 0) ? d.reading_len : 0) + 1;
    data->pron = copy_new_string(p, d.pron_len);
    p += ((d.pron_len >= 0) ? d.pron_len : 0) + 1;
    data->base = copy_new_string(p, d.base_len);
    p += d.base_len + 1;
    data->info = copy_new_string(p, strlen(p));
    data->headword_len = d.heading_len;
    data->reading_len = d.reading_len;
    data->pron_len = d.pron_len;
  }

  CAMLreturn ((value)data);
}
