%{
  open ScmTypes

  let equivalent_expression symbol args =
    cons (gen_symbol symbol) (cons args scm_nil)
%}

%token LPARENT RPARENT
%token QUOTE SHARPLPARENT 
%token BACKQUOTE COMA COMAAT DOT 
%token EOF ARROW
%token <ScmTypes.datum> DATA

%start item
%type  <ScmTypes.datum> item
%%


item_list:
   item DOT item { cons $1 $3 }
   |  item item_list { cons $1 $2 }
   | { scm_nil }
;

item:
     DATA { $1 }
   | LPARENT item_list RPARENT { $2 }
   | QUOTE item { equivalent_expression "quote" $2 }
   | BACKQUOTE item { equivalent_expression "quasiquote" $2 }
   | COMA item { equivalent_expression "unquote" $2 }
   | COMAAT item { equivalent_expression "unquote-splicing" $2 }
   | SHARPLPARENT item_list RPARENT { vector_of_list $2 }
   | EOF { raise Exit }
;
