
open Graph.Pack.Digraph
open Printf

let g = create ()
let vertex = Array.init 10 (fun i -> let v = V.create i in add_vertex g v; v)
let add i j = add_edge g vertex.(i) vertex.(j)

let () = add 0 1; add 1 2; add 2 3; add 2 6; add 6 8; add 5 9; add 9 7; add 7 5

let pc = PathCheck.create g
let test i j = 
  printf "path %d -> %d = %b\n" i j 
    (PathCheck.check_path pc vertex.(i) vertex.(j))
let () = test 0 6
let () = test 0 4
let () = test 5 7
let () = test 5 7
let () = test 9 5
let () = test 6 1
let () = test 6 1
let () = test 6 7


let () = flush stdout
let () = display_with_gv g
