# This file is a generic Makefile to compile programs written in
# OCaml.  You can include it your specific Makefile.
#
# Author: Christoph Bauer. No Warranty.
#
# The you can set 
#   * SUBDIRS
#   * SOURCES
#   * PROGRAM
#   * INCLUDES
#   * PACKAGES
#   * BCFLAGS
#   * NCFLAGS
#   * LDOBJECTS
#   * BCLDFLAGS
#   * NCLDFLAGS
#   * OPTFLAGS
#   * CSOURCES
#   * LDFLAGS

OCAMLFIND=ocamlfind
DEBUGFLAG=-g
BCFLAGS=$(INCLUDES) $(DEBUGFLAG) 
NCFLAGS=$(INCLUDES)
AUTOMLI=automli

CC=ocamlc
#CCFLAGS= -O2 -fPIC -shared
CCFLAGS= -ccopt -O2 
CCINCLUDES += -I $(shell $(OCAMLFIND) ocamlc -where)
PREFIX=/usr/local
DESTDIR=
DESTPREF=$(if $(DESTDIR),$(DESTDIR)$(PREFIX),$(PREFIX))

CLEANUP  += *~

.PHONY: subdirsall do-all compile install-prog install-lib

all: do-all


ifdef SOURCES

MLSOURCES = $(patsubst %.mla,%.mli,$(SOURCES))
MLASOURCES = $(filter %.mla,$(SOURCES))
MLIOFMLAFILES = $(patsubst %.mla,%.mli,$(MLASOURCES))
MLISOURCES = $(MLIOFMLAFILES) $(filter %.mli,$(SOURCES))

CLEANUP += $(MLIOFMLAFILES)

TODO += depend compile

CMIFILES=$(patsubst %.mli,%.cmi,$(MLISOURCES))
MLFILES=$(filter %.ml,$(MLSOURCES))
BCOBJECTS=$(patsubst %.ml,%.cmo,$(MLFILES))
NCOBJECTS=$(patsubst %.ml,%.cmx,$(MLFILES))
COBJS=$(patsubst %.c,%.o,$(CSOURCES))

compile: $(CMIFILES) $(BCOBJECTS) $(NCOBJECTS)

endif


ifdef SUBDIRS

TODO += subdirs 
CLEANUP += subdirs

ifndef TOPDIR
TOPDIR := $(CURDIR)
endif

export TOPDIR

subdirs:
	for dir in $(SUBDIRS) ;\
	do \
	  $(MAKE) -C $${dir} $(MAKECMDGOALS); \
	done

endif 


OCAMLLDFLAGS=$(EXPANDEDPACKAGES) $(INCLUDES) $(LDFLAGS)
BCLDOBJECTS=$(patsubst %,%.cmo,$(LDOBJECTS))
NCLDOBJECTS=$(patsubst %,%.cmx,$(LDOBJECTS))

ifdef PROGRAM

TODO += program 
CLEANUP += $(PROGRAM) $(PROGRAM).opt

BCLDLIBS=$(patsubst %,%.cma,$(LIBS))
NCLDLIBS=$(patsubst %,%.cmxa,$(LIBS))


program: $(PROGRAM) $(PROGRAM).opt

$(PROGRAM): $(BCOBJETS) $(COBJS) $(CMIFILES)
	$(OCAMLFIND) ocamlc -linkpkg -o $(PROGRAM) $(COBJS)  $(OCAMLLDFLAGS) \
		$(CFLAGS)  $(BCLDFLAGS) $(BCLDLIBS) $(BCLDOBJECTS) \
	 	$(BCOBJECTS) $(DEBUGFLAG) 

$(PROGRAM).opt: $(NCOBJECTS) $(COBJS) $(CMIFILES)
	$(OCAMLFIND) ocamlopt -o $(PROGRAM).opt $(COBJS)  $(OCAMLLDFLAGS) \
		$(CFLAGS) $(OPTFLAGS) $(NCLDFLAGS) $(NCLDLIBS)  $(NCLDOBJECTS) \
		 $(NCOBJECTS) 


install-prog: $(PROGRAM).opt
	mkdir -p $(DESTPREF)/bin
	install $(PROGRAM).opt $(DESTPREF)/bin/$(PROGRAM)

else

install-prog: 

endif

ifdef LIBRARY

TODO += library
CLEANUP += $(LIBRARY).cma $(LIBRARY).cmxa

library: $(LIBRARY).cma $(LIBRARY).cmxa

$(LIBRARY).cma: $(BCOBJECTS) $(COBJS)
	$(OCAMLFIND) ocamlc -a -linkpkg -o $(LIBRARY).cma $(OCAMLLDFLAGS) \
		$(CFLAGS) $(BCLDFLAGS) $(BCLDLIBS) $(BCLDOBJECTS) \
		$(BCOBJECTS) $(DEBUGFLAG) $(COBJS) 


$(LIBRARY).cmxa: $(NCOBJECTS) $(COBJS)
	$(OCAMLFIND) ocamlopt -a -o $(LIBRARY).cmxa $(OCAMLLDFLAGS) \
		$(CFLAGS) $(OPTFLAGS)  $(NCLDFLAGS) $(NCLDLIBS) $(NCLDOBJECTS) \
		$(NCOBJECTS) $(COBJS) 

ALLCMIFILES=$(filter-out %.mli,$(patsubst %.ml,%.cmi,$(MLSOURCES)))
LIB_INSTALL=META $(LIBRARY).cma $(LIBRARY).cmxa $(LIBRARY).a  $(ALLCMIFILES)
DESTDIRFLAG=$(if $(DESTDIR),-destdir $(DESTDIR))

install-lib: $(LIB_INSTALL)
	ocamlfind remove $(DESTDURFLAG) $(LIBRARY)
	ocamlfind install $(DESTDIRFLAG) $(LIBRARY) $(LIB_INSTALL)

else

install-lib:

endif


install: $(TODO) install-prog install-lib
	echo done

do-all: $(TODO)

#.SUFFIXES: .ml .mli .cmo .cmi .cmx .opt .o *.a *.so


EXPANDEDPACKAGES := $(foreach p,$(PACKAGES),-package $(p))
PREDICATES=
SYNTAX=-syntax camlp4o
OCAMLCFLAGS=$(INCLUDES) $(EXPANDEDPACKAGES) $(CFLAGS) $(BCFLAGS) $(PREDICATES) \
	$(SYNTAX)
OCAMLOPTFLAGS=$(INCLUDES) $(EXPANDEDPACKAGES) $(CFLAGS)  $(NCFALGS) $(PREDICATES) \
	$(SYNTAX) $(OPTFLAGS)


%.cmo: %.ml
	$(OCAMLFIND) ocamlc $(OCAMLCFLAGS) -c $<

%.mli: %.mla
	$(AUTOMLI) $<

%.cmi: %.mli
	$(OCAMLFIND) ocamlc $(OCAMLCFLAGS) -c $<

%.cmx: %.ml
	$(OCAMLFIND) ocamlopt $(OCAMLOPTFLAGS) -c $<

%.o: %.c
	$(CC) $(CCFLAGS) $(CCINCLUDES)  $< -c

clean:

ifdef SUBDIRS
	for dir in $(SUBDIRS)  ;\
	  do \
	    $(MAKE) -C $${dir} clean ; \
	done 
endif
	rm -f *.cm[iox] *.o $(CLEANUP)
	rm -rf .depend 	


ifdef SOURCES


.depend: 
	$(OCAMLFIND) ocamldep  $(INCLUDES) $(EXPANDEDPACKAGES)  $(SYNTAX) \
	   $(MLSOURCES) > .depend

depend: .depend $(filter clean,$(MAKECMDGOALS))

-include .depend

endif

