(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* $Id: personalDict.mli 158 2005-11-21 18:16:30Z yori $ *)

(* ChasenPersonalDict⥸塼ɬΥ⥸塼̤ƥ
롣*)

type mrph
type state = int

val null_mrph : mrph
val compare_mrph : mrph -> mrph -> int

val keyword : mrph -> string
val surface_form : mrph -> string

(* ϢܤǤʤstate = -1 *)
val connect_mrph : state:state -> mrph:mrph -> state * int

(* [<>...]֤ *)
val lookup : string -> int -> int -> mrph list

(* [(<>, <Ĺ>)...]֤ *)
val lookup_prefix : string -> int -> int -> (mrph * int) list

val add : mrph -> unit
val remove : mrph -> unit
val incr_count : mrph -> unit
val add_new_word : kaki:string -> yomi:string -> unit

val undefwords : string -> mrph list

