/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.gui.CellInfo;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JDialogError;
import jdbcacsess.gui.RowInsertValueMode;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.OutputResultble;
import jdbcacsess.sql.PrepareExecUpdate;
import jdbcacsess.sql.SchemaTableName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableSqlModel
extends AbstractTableModel
implements OutputResultble {
    private static final long serialVersionUID = 1L;
    private List<String> headerList;
    private List<List<CellInfo>> detailList;
    private Vector<ColumnInfoResult> columnInfo;
    private boolean isAllCellEdit;
    private SchemaTableName tableName;
    private int insertRowIndex = -1;
    private Connection con;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public JTableSqlModel(Connection con) {
        this.init();
        this.con = con;
    }

    @Override
    public void init() {
        this.headerList = Collections.synchronizedList(new ArrayList());
        this.detailList = Collections.synchronizedList(new ArrayList());
        this.isAllCellEdit = false;
    }

    @Override
    public void setResultHeader(Vector<ColumnInfoResult> headerData) {
        this.columnInfo = headerData;
        for (ColumnInfoResult info : headerData) {
            this.headerList.add(info.getColumnLabel());
        }
        this.fireTableStructureChanged();
    }

    public ColumnInfoResult getColumnInfo(int idx) {
        return this.columnInfo.get(idx);
    }

    @Override
    public synchronized void setResultDetail(Vector detailData) {
        List<CellInfo> columnList = Collections.synchronizedList(new ArrayList());
        int i = 0;
        while (i < detailData.size()) {
            CellInfo cellInfo = new CellInfo();
            cellInfo.setValue(detailData.get(i));
            columnList.add(cellInfo);
            ++i;
        }
        this.detailList.add(columnList);
        int cnt = this.detailList.size() % 5000;
        if (cnt == 0) {
            System.out.println("wait\u3057\u307e\u3059");
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.out.println("\u518d\u958b\u3057\u307e\u3059");
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setUpdatable(boolean updatable) {
        this.isAllCellEdit = updatable;
    }

    @Override
    public void setTableName(SchemaTableName tableName) {
        this.tableName = tableName;
    }

    @Override
    public void completeQuery() {
        if (this.detailList.isEmpty() && this.isAllCellEdit) {
            List<CellInfo> newColumnList = Collections.synchronizedList(new ArrayList());
            newColumnList = Collections.synchronizedList(new ArrayList());
            int i = 0;
            while (i < this.columnInfo.size()) {
                CellInfo ci = new CellInfo();
                ci.setValue("");
                ci.setMode(CellMode.CELL_DELETE);
                newColumnList.add(ci);
                ++i;
            }
            this.detailList.add(newColumnList);
            this.fireTableDataChanged();
        }
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnInfo.get(columnIndex).getColumnClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.headerList.get(column);
    }

    @Override
    public int getColumnCount() {
        if (this.columnInfo == null) {
            return 0;
        }
        return this.columnInfo.size();
    }

    @Override
    public int getRowCount() {
        return this.detailList.size();
    }

    private CellInfo getCellInfo(int rowIndex, int columnIndex) {
        List<CellInfo> columnList = this.detailList.get(rowIndex);
        return columnList.get(columnIndex);
    }

    private void setCellInfo(int rowIdx, int colIdx, CellMode cellMode) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setMode(cellMode);
    }

    private void setCellInfo(int rowIdx, int colIdx, CellMode cellMode, Object aValue) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        cellInfo.setValue(aValue);
        cellInfo.setMode(cellMode);
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        CellInfo cellInfo = this.getCellInfo(rowIdx, colIdx);
        return cellInfo.getValue();
    }

    public CellMode getMode(int rowIndex, int columnIndex) {
        return this.getCellInfo(rowIndex, columnIndex).getMode();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isAllCellEdit) {
            return false;
        }
        return this.getCellInfo(rowIndex, columnIndex).isCellEditable();
    }

    @Override
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
        if (this.getMode(rowIndex, columnIndex) == CellMode.CELL_INSERT) {
            this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_INSERT, aValue);
            return;
        }
        final PrepareExecUpdate peu = new PrepareExecUpdate();
        peu.addStm("UPDATE " + this.tableName);
        peu.addStm(" SET " + this.columnInfo.get(columnIndex).getColumnLabel() + " = ?");
        peu.addParm(aValue, this.columnInfo.get(columnIndex).getColumnType());
        this.editWherePhrase(peu, rowIndex);
        this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_UPDATE);
        this.fireTableDataChanged();
        new Thread(){

            public void run() {
                try {
                    peu.execute(JTableSqlModel.this.con);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JDialogError.sqlErrorDialog(e, "\u30ab\u30e9\u30e0\u66f4\u65b0");
                    return;
                }
                JTableSqlModel.this.setCellInfo(rowIndex, columnIndex, CellMode.CELL_UPDATE_COMPLETE, aValue);
                JTableSqlModel.this.fireTableDataChanged();
            }
        }.start();
    }

    private void editWherePhrase(PrepareExecUpdate peu, int rowIndex) {
        peu.addStm(" WHERE ");
        boolean isFirst = true;
        int i = 0;
        while (i < this.columnInfo.size()) {
            ColumnInfoResult colInfo = this.columnInfo.get(i);
            if (colInfo.isPrimeKey()) {
                if (isFirst) {
                    peu.addStm(" ");
                    isFirst = false;
                } else {
                    peu.addStm(" AND ");
                }
                peu.addStm(String.valueOf(colInfo.getColumnLabel()) + " = ?");
                peu.addParm(this.getCellInfo(rowIndex, i).getValue(), this.columnInfo.get(i).getColumnType());
            }
            ++i;
        }
    }

    public void rowDelete(final int[] rowIndexs) {
        new Thread(){

            public void run() {
                int[] nArray = rowIndexs;
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int rowIndex = nArray[n];
                    switch (JTableSqlModel.this.getMode(rowIndex, 0)) {
                        case CELL_INSERT: {
                            JTableSqlModel.this.insertRowIndex = -1;
                            JTableSqlModel.this.detailList.remove(rowIndex);
                            break;
                        }
                        case CELL_DELETE_COMPLETE: {
                            break;
                        }
                        default: {
                            for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(rowIndex)) {
                                cellInfo.setMode(CellMode.CELL_DELETE);
                            }
                            PrepareExecUpdate peu = new PrepareExecUpdate();
                            peu.addStm("DELETE FROM " + JTableSqlModel.this.tableName);
                            JTableSqlModel.this.editWherePhrase(peu, rowIndex);
                            try {
                                peu.execute(JTableSqlModel.this.con);
                            }
                            catch (SQLException e) {
                                JDialogError.sqlErrorDialog(e, "\u884c\u524a\u9664");
                                e.printStackTrace();
                                return;
                            }
                            for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(rowIndex)) {
                                cellInfo.setMode(CellMode.CELL_DELETE_COMPLETE);
                            }
                        }
                    }
                    ++n;
                }
                JTableSqlModel.this.fireTableDataChanged();
            }
        }.start();
    }

    public void rowCopy(int orgRowIndex, RowInsertValueMode insertMode) {
        if (this.insertRowIndex != -1) {
            return;
        }
        List<CellInfo> newColumnList = Collections.synchronizedList(new ArrayList());
        switch (insertMode) {
            case VALUEROWNEW: {
                this.createInsertRowData(newColumnList);
                break;
            }
            case ALLNULLROWNEW: {
                this.createInsertRowNull(newColumnList);
                break;
            }
            case ROWCOPY: {
                for (CellInfo cellInfo : this.detailList.get(orgRowIndex)) {
                    newColumnList.add(cellInfo.copy());
                }
                break;
            }
        }
        this.insertRowIndex = orgRowIndex + 1;
        this.detailList.add(this.insertRowIndex, newColumnList);
        this.fireTableDataChanged();
    }

    private void createInsertRowData(List<CellInfo> newColumnList) {
        int i = 0;
        while (i < this.columnInfo.size()) {
            CellInfo ci = new CellInfo();
            Class<?> c = this.getColumnClass(i);
            try {
                if (String.class.isAssignableFrom(c)) {
                    if (this.getColumnInfo(i).isNullable()) {
                        ci.setValue(null);
                    } else {
                        ci.setValue("a");
                    }
                } else if (Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
                    ci.setValue(c.getConstructor(String.class).newInstance("0"));
                } else if (Date.class.isAssignableFrom(c)) {
                    ci.setValue(c.getConstructor(Long.TYPE).newInstance(new Long(new Date().getTime())));
                } else if (c.getCanonicalName().equals("byte[]")) {
                    ci.setValue(new byte[0]);
                } else {
                    ci.setValue(c.newInstance());
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            ci.setMode(CellMode.CELL_INSERT);
            newColumnList.add(ci);
            ++i;
        }
    }

    private void createInsertRowNull(List<CellInfo> newColumnList) {
        int i = 0;
        while (i < this.columnInfo.size()) {
            CellInfo ci = new CellInfo();
            ci.setValue(null);
            ci.setMode(CellMode.CELL_INSERT);
            newColumnList.add(ci);
            ++i;
        }
    }

    public void rowInsert(int selectRowIndex) {
        if (this.insertRowIndex == -1) {
            return;
        }
        System.out.println("Insert\u5bfe\u8c61\u884c:" + this.insertRowIndex + " " + "\u9078\u629e\u884c:" + selectRowIndex);
        if (selectRowIndex == this.insertRowIndex) {
            return;
        }
        final PrepareExecUpdate peu = new PrepareExecUpdate();
        peu.addStm("INSERT INTO " + this.tableName + "(");
        boolean first = true;
        for (ColumnInfoResult col : this.columnInfo) {
            if (!first) {
                peu.addStm(",");
            } else {
                first = false;
            }
            peu.addStm(col.getColumnLabel());
        }
        peu.addStm(") VALUES(");
        first = true;
        List<CellInfo> cellInfoList = this.detailList.get(this.insertRowIndex);
        int i = 0;
        while (i < cellInfoList.size()) {
            if (!first) {
                peu.addStm(",");
            } else {
                first = false;
            }
            peu.addStm("?");
            peu.addParm(cellInfoList.get(i).getValue(), this.columnInfo.get(i).getColumnType());
            ++i;
        }
        peu.addStm(")");
        new Thread(){

            public void run() {
                try {
                    peu.execute(JTableSqlModel.this.con);
                }
                catch (SQLException e) {
                    JDialogError.sqlErrorDialog(e, "\u884c\u633f\u5165");
                    e.printStackTrace();
                    return;
                }
                for (CellInfo cellInfo : (List)JTableSqlModel.this.detailList.get(JTableSqlModel.this.insertRowIndex)) {
                    cellInfo.setMode(CellMode.CELL_INSERT_COMPLETE);
                }
                JTableSqlModel.this.insertRowIndex = -1;
                JTableSqlModel.this.fireTableDataChanged();
            }
        }.start();
    }

    public synchronized void nextSearch() {
        this.notify();
    }

    public boolean isAllCellEdit() {
        return this.isAllCellEdit;
    }
}

