/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.SqlStatementCatgoly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAnalyze {
    private SchemaTableName schemaTableName;
    private Vector<ColumnInfoResult> selectColmunInfos;
    private boolean selectUpdatable;
    private String sqlStatement;
    private SqlStatementCatgoly sqlStatementCatgoly;
    private String errorReasonMsg;

    public SqlAnalyze(String sqlStatement) {
        this.sqlStatement = sqlStatement.trim();
        this.selectUpdatable = false;
        this.schemaTableName = new SchemaTableName();
        this.errorReasonMsg = "";
        StringTokenizer st = new StringTokenizer(sqlStatement, " \t;" + System.getProperty("line.separator"));
        if (st.hasMoreTokens()) {
            String command = st.nextToken().toLowerCase();
            if (command.equals("select")) {
                this.sqlStatementCatgoly = SqlStatementCatgoly.SELECT;
                this.selectUpdatable = this.checkUpdateble(st);
            } else {
                this.sqlStatementCatgoly = command.equals("insert") ? SqlStatementCatgoly.INSERT : (command.equals("update") ? SqlStatementCatgoly.UPDATE : (command.equals("delete") ? SqlStatementCatgoly.DELETE : SqlStatementCatgoly.UNKNOWN));
            }
        } else {
            this.sqlStatementCatgoly = SqlStatementCatgoly.UNKNOWN;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkUpdateble(StringTokenizer st) {
        do {
            if (st.hasMoreTokens()) continue;
            this.errorReasonMsg = "FROM\u304c\u3042\u308a\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09FROM\u304c\u7121\u3044");
            return false;
        } while (!st.nextToken().toUpperCase().equals("FROM"));
        if (!st.hasMoreTokens()) {
            this.errorReasonMsg = "FROM\u306e\u5f8c\u306b\u4f55\u3082\u3042\u308a\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09FROM\u306e\u5f8c\u306b\u4f55\u3082\u7121\u3044");
            return false;
        }
        tableName = st.nextToken();
        if (tableName.indexOf(44) != -1) {
            this.errorReasonMsg = "\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b\u3067\u306f\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b");
            return false;
        }
        if (!st.hasMoreTokens()) {
            this.schemaTableName = new SchemaTableName(tableName);
            return true;
        }
        tmpStr = st.nextToken();
        if (tmpStr.indexOf(44) != -1) {
            this.errorReasonMsg = "\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b\u3067\u306f\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b");
            return false;
        }
        if (!tmpStr.toLowerCase().equals("as")) ** GOTO lbl46
        if (!st.hasMoreTokens()) {
            this.errorReasonMsg = "as \u306e\u6b21\u304c\u7a7a\u3067\u3059";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09as \u306e\u6b21\u304c\u7a7a");
            return false;
        }
        tmpStr = st.nextToken();
        if (tmpStr.indexOf(44) != -1) {
            this.errorReasonMsg = "\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b\u3067\u306f\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b");
            return false;
        }
        if (!st.hasMoreTokens()) {
            this.schemaTableName = new SchemaTableName(tableName);
            return true;
        }
        tmpStr = st.nextToken();
        if (tmpStr.indexOf(44) == -1) ** GOTO lbl46
        this.errorReasonMsg = "\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b\u3067\u306f\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
        System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u8907\u6570\u30c6\u30fc\u30d6\u30eb\u306e\u554f\u3044\u5408\u308f\u305b");
        return false;
lbl-1000:
        // 1 sources

        {
            if (!st.nextToken().toUpperCase().equals("SELECT")) continue;
            this.errorReasonMsg = "\u526f\u554f\u3044\u5408\u308f\u305b\u3092\u542b\u3080\u306e\u3067\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u526f\u554f\u3044\u5408\u308f\u305b\u304c\u542b\u307e\u308c\u3066\u3044\u308b");
            return false;
lbl46:
            // 3 sources

            ** while (st.hasMoreTokens())
        }
lbl47:
        // 1 sources

        this.schemaTableName = new SchemaTableName(tableName);
        return true;
    }

    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public SqlStatementCatgoly getSqlStatementCatgoly() {
        return this.sqlStatementCatgoly;
    }

    private boolean isExistsColumnInfo(String primaryColumnName) {
        for (ColumnInfoResult colInfo : this.selectColmunInfos) {
            if (!primaryColumnName.equals(colInfo.getColumnLabel())) continue;
            colInfo.setIsPrimeKey(true);
            return true;
        }
        return false;
    }

    private boolean isExistsPrimeKey() throws SQLException {
        ArrayList<String> primaryKeys = SqlExec.getPrimaryKeys(this.schemaTableName.getSchemaName(), this.schemaTableName.getTableName());
        if (primaryKeys.size() == 0) {
            this.errorReasonMsg = "\u4e3b\u30ad\u30fc\u5b9a\u7fa9\u304c\u306a\u3044\u306e\u3067\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u4e3b\u30ad\u30fc\u5b9a\u7fa9\u304c\u306a\u3044\u3002#" + this.schemaTableName.getSchemaName() + "#" + this.schemaTableName.getTableName() + "#");
            return false;
        }
        for (String string : primaryKeys) {
            if (this.isExistsColumnInfo(string)) continue;
            this.errorReasonMsg = "\u5168\u3066\u306e\u4e3b\u30ad\u30fc\u304c\u691c\u7d22\u3055\u308c\u3066\u3044\u306a\u3044\u306e\u3067\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093";
            System.out.println("\uff08\u66f4\u65b0\u4e0d\u53ef\uff09\u5168\u3066\u306e\u4e3b\u30ad\u30fc\u304c\u691c\u7d22\u3055\u308c\u3066\u3044\u306a\u3044\u3002");
            return false;
        }
        return true;
    }

    public boolean isSelectUpdatable() {
        return this.selectUpdatable;
    }

    public void setSelectColmunInfo(Vector<ColumnInfoResult> selectColmunInfos) throws SQLException {
        this.selectColmunInfos = selectColmunInfos;
        if (this.sqlStatementCatgoly == SqlStatementCatgoly.SELECT && this.selectUpdatable) {
            this.selectUpdatable = this.isExistsPrimeKey();
        }
    }

    public String getErrorReasonMsg() {
        return this.errorReasonMsg;
    }
}

