/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.JTableSqlModel;

public class CellRendererSqlTable
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 7761617446993569948L;
    static /* synthetic */ Class class$0;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int width;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(table.getModel() instanceof JTableSqlModel)) {
            return this;
        }
        JTableSqlModel sqlTableModel = (JTableSqlModel)table.getModel();
        CellMode mode = sqlTableModel.getMode(row, column);
        if (!isSelected || hasFocus) {
            switch (mode) {
                case CELL_UPDATE: {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.RED);
                    break;
                }
                case CELL_UPDATE_COMPLETE: {
                    this.setForeground(Color.RED);
                    this.setBackground(Color.WHITE);
                    break;
                }
                case CELL_DELETE: {
                    this.setForeground(Color.LIGHT_GRAY);
                    this.setBackground(Color.BLACK);
                    break;
                }
                case CELL_DELETE_COMPLETE: {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.LIGHT_GRAY);
                    break;
                }
                case CELL_INSERT: {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLUE);
                    break;
                }
                case CELL_INSERT_COMPLETE: {
                    this.setForeground(Color.BLUE);
                    this.setBackground(Color.WHITE);
                    break;
                }
                default: {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.WHITE);
                }
            }
        }
        if (sqlTableModel.getColumnInfo(column).isPrimeKey()) {
            this.setFont(new Font("Dialog", 1, 14));
        }
        if (Number.class.isAssignableFrom(sqlTableModel.getColumnClass(column))) {
            this.setHorizontalAlignment(4);
        }
        if (sqlTableModel.getValueAt(row, column) == null) {
            this.setValue("#NULL#");
        }
        this.setToolTipText(sqlTableModel.getColumnInfo(column).getDisplayColumnName());
        TableColumnModel tcm = table.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        if ((tc.getPreferredWidth() == 75 && table.getTableHeader().getResizingColumn() == null || mode == CellMode.CELL_INSERT || mode == CellMode.CELL_UPDATE) && (width = this.getText().length() * 8) < 500 && tc.getWidth() < width) {
            tc.setPreferredWidth(width);
        }
        return this;
    }
}

