/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditImportSqlStatement {
    private SchemaTableName tbl;
    private ArrayList<String> lowHeader;
    private ArrayList<String> primeKeys;
    private ArrayList<ColumnInfoTable> columnInfos;
    private ArrayList<Integer> primeIdxNumber;
    private ArrayList<Integer> columnIdxNumber;

    public EditImportSqlStatement(SchemaTableName tbl, Vector<String> rowHeader) throws SQLException {
        this.tbl = tbl;
        this.lowHeader = new ArrayList();
        for (String str : rowHeader) {
            this.lowHeader.add(SqlExec.convertStoresIdentifiers(str));
        }
        this.columnInfos = SqlExec.getColumnMames(tbl.getSchemaName(), tbl.getTableName());
        this.primeKeys = SqlExec.getPrimaryKeys(tbl.getSchemaName(), tbl.getTableName());
        this.primeIdxNumber = new ArrayList();
        for (String str : this.primeKeys) {
            int idx = rowHeader.indexOf(str);
            if (idx == -1) continue;
            this.primeIdxNumber.add(idx);
        }
        this.columnIdxNumber = new ArrayList();
        block2: for (String str : rowHeader) {
            int i = 0;
            while (i < this.columnInfos.size()) {
                ColumnInfoTable element = this.columnInfos.get(i);
                if (element.getColumnName().equals(str)) {
                    this.columnIdxNumber.add(i);
                    continue block2;
                }
                ++i;
            }
        }
    }

    public String hasAllColumn() {
        for (String str : this.lowHeader) {
            boolean flg = false;
            int i = 0;
            while (i < this.columnInfos.size()) {
                ColumnInfoTable element = this.columnInfos.get(i);
                if (element.getColumnName().equals(str)) {
                    flg = true;
                }
                ++i;
            }
            if (flg) continue;
            return "\u30ab\u30e9\u30e0\u540d:[" + str + "] \u30c6\u30fc\u30d6\u30eb\u540d:[" + this.tbl + "]";
        }
        return "";
    }

    public String hasPrimeKey() {
        for (String str : this.primeKeys) {
            if (this.lowHeader.indexOf(str) != -1) continue;
            return "\u30ab\u30e9\u30e0\u540d:[" + str + "] \u30c6\u30fc\u30d6\u30eb\u540d:[" + this.tbl + "]";
        }
        return "";
    }

    public String getInsertOnlyValuePhrase(Vector<String> items) {
        StringBuffer insertCmd = new StringBuffer();
        boolean first = true;
        for (String item : items) {
            if (first) {
                first = false;
                insertCmd = insertCmd.append("INSERT INTO " + this.tbl.getCompleteTableName() + " VALUES(");
            } else {
                insertCmd.append(",");
            }
            this.addItemValue(insertCmd, item);
        }
        insertCmd.append(")");
        return insertCmd.toString();
    }

    public String getInsertColumnAndValue(Vector<String> items) {
        StringBuffer insertCmd = new StringBuffer();
        insertCmd.append("INSERT INTO " + this.tbl.getCompleteTableName() + " (");
        boolean first = true;
        for (Integer idx : this.columnIdxNumber) {
            if (first) {
                first = false;
            } else {
                insertCmd.append(",");
            }
            insertCmd.append(this.columnInfos.get(idx).getColumnName());
        }
        insertCmd.append(") VALUES(");
        first = true;
        for (String item : items) {
            if (first) {
                first = false;
            } else {
                insertCmd.append(",");
            }
            this.addItemValue(insertCmd, item);
        }
        insertCmd.append(")");
        return insertCmd.toString();
    }

    public String getUpdate(Vector<String> items) {
        StringBuffer updateCmd = new StringBuffer();
        updateCmd.append("UPDATE " + this.tbl.getCompleteTableName() + " SET ");
        int i = 0;
        while (i < items.size()) {
            if (i > 0) {
                updateCmd.append(" ,");
            }
            updateCmd.append(this.columnInfos.get(this.columnIdxNumber.get(i)) + "=");
            this.addItemValue(updateCmd, items.get(i));
            ++i;
        }
        updateCmd.append(" WHERE ");
        boolean first = true;
        for (Integer idx : this.primeIdxNumber) {
            if (first) {
                first = false;
            } else {
                updateCmd.append(" AND ");
            }
            updateCmd.append(String.valueOf(this.lowHeader.get(idx)) + "=");
            this.addItemValue(updateCmd, items.get(idx));
        }
        return updateCmd.toString();
    }

    private void addItemValue(StringBuffer updateCmd, String item) {
        if (item.equals("#$%&NULL&%$#")) {
            updateCmd.append("null");
        } else {
            updateCmd.append("'" + item + "'");
        }
    }
}

