/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.util.Enumeration;
import java.util.Vector;
import jdbcacsess.csv.CSVTokenizer;

public class CSVLine {
    public static final String copyright = "Copyright 1997 TAMURA Kent\nCopyright 1999 ANDOH Tomoharu";
    private Vector items = new Vector();
    private char token = (char)44;

    public void setToken(char token) {
        this.token = token;
    }

    public void addItem(String item) {
        this.addItem(item, false);
    }

    public void addItem(String item, boolean enquote) {
        this.items.addElement(new Element(item, enquote));
    }

    public void addItem(CSVTokenizer ct) {
        while (ct.hasMoreTokens()) {
            String item = ct.nextToken();
            this.items.addElement(new Element(item));
        }
    }

    public String getLine() {
        StringBuffer list = new StringBuffer();
        int n = 0;
        while (n < this.items.size()) {
            Element element = (Element)this.items.elementAt(n);
            String item = element.getItem();
            list.append(item);
            if (this.items.size() - 1 != n) {
                list.append(this.token);
            }
            ++n;
        }
        return new String(list);
    }

    public int size() {
        return this.items.size();
    }

    public String getItem(int n) {
        Element element = (Element)this.items.elementAt(n);
        return element.getRawItem();
    }

    public void removeItem(int n) {
        this.items.removeElementAt(n);
    }

    public Enumeration elements() {
        return new CSVLineEnumerator(this.items);
    }

    public String enquote(String item) {
        return this.enquote(item, false);
    }

    public String enquote(String item, boolean enquote) {
        if (item.length() == 0) {
            return item;
        }
        if (item.indexOf(34) < 0 && item.indexOf(this.token) < 0 && !enquote) {
            return item;
        }
        StringBuffer sb = new StringBuffer(item.length() * 2 + 2);
        sb.append('\"');
        int ind = 0;
        while (ind < item.length()) {
            char ch = item.charAt(ind);
            if ('\"' == ch) {
                sb.append("\"\"");
            } else {
                sb.append(ch);
            }
            ++ind;
        }
        sb.append('\"');
        return new String(sb);
    }

    class Element {
        private String item;
        private boolean enquote;

        Element(String item) {
            this(item, false);
        }

        Element(String item, boolean enquote) {
            this.item = item;
            this.enquote = enquote;
        }

        public String getItem() {
            return CSVLine.this.enquote(this.item, this.enquote);
        }

        public String getRawItem() {
            return this.item;
        }
    }

    class CSVLineEnumerator
    implements Enumeration {
        private Vector items;
        private int n;

        CSVLineEnumerator(Vector items) {
            this.items = items;
            this.n = 0;
        }

        public Object nextElement() {
            ++this.n;
            Element element = (Element)this.items.elementAt(this.n - 1);
            return element.getRawItem();
        }

        public boolean hasMoreElements() {
            return this.n < this.items.size();
        }
    }
}

