/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jdbcacsess.csv.CsvImport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInfoTableModel;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.csv.JDialogCsvMode;
import jdbcacsess.gui.ComponentProperty;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.sql.SqlExec;

public class JDialogImportHistory
extends JDialog {
    private static final long serialVersionUID = 7126241261349764262L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPanel jPanel = null;
    private JButton jButtonOK = null;
    private CsvInfoTableModel model;
    private JButton jButtondelete = null;
    private JButton jButtonDisplayUpdate = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItemEdit = null;

    public JDialogImportHistory() {
        this.initialize();
    }

    private void initialize() {
        ComponentProperty.restoreWindowPosition(this, 800, 400);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDialogImportHistory.this.dialogClosing();
            }
        });
        this.setTitle("CSV\u5165\u529b\u5c65\u6b74");
        this.model = new CsvInfoTableModel();
        this.jTable.setModel(this.model);
        this.jTable.setAutoResizeMode(0);
        this.jTable.setSelectionMode(2);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.getColumn(this.jTable.getColumnName(0)).setPreferredWidth(200);
        this.jTable.getColumn(this.jTable.getColumnName(1)).setPreferredWidth(200);
        this.jTable.setComponentPopupMenu(this.getJPopupMenu());
    }

    public void reLoad() {
        this.model.reLoad();
    }

    public void dialogClosing() {
        ComponentProperty.storeWindowPosition(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
        }
        return this.jTable;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButtonImport(), null);
            this.jPanel.add((Component)this.getJButtonDisplayUpdate(), null);
            this.jPanel.add((Component)this.getJButtonDelete(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonImport() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new JButton();
            this.jButtonOK.setText("Import\u5b9f\u884c");
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogImportHistory.this.actionPerformedImport();
                }
            });
        }
        return this.jButtonOK;
    }

    private void actionPerformedImport() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int index = nArray[n];
            new CsvImport(this.model.getCsvInfo(index)).start();
            ++n;
        }
    }

    private JButton getJButtonDelete() {
        if (this.jButtondelete == null) {
            this.jButtondelete = new JButton();
            this.jButtondelete.setText("\u524a\u9664");
            this.jButtondelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogImportHistory.this.actionPerformedDelete();
                }
            });
        }
        return this.jButtondelete;
    }

    private void actionPerformedDelete() {
        ArrayList<String> fileNames = new ArrayList<String>();
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int idx = nArray[n];
            fileNames.add(this.model.getKey(idx));
            ++n;
        }
        for (String key : fileNames) {
            this.model.remove(key);
        }
    }

    private JButton getJButtonDisplayUpdate() {
        if (this.jButtonDisplayUpdate == null) {
            this.jButtonDisplayUpdate = new JButton();
            this.jButtonDisplayUpdate.setText("\u8868\u793a\u3092\u66f4\u65b0");
            this.jButtonDisplayUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogImportHistory.this.reLoad();
                }
            });
        }
        return this.jButtonDisplayUpdate;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuItemEdit());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemEdit() {
        if (this.jMenuItemEdit == null) {
            this.jMenuItemEdit = new JMenuItem();
            this.jMenuItemEdit.setText("\u7de8\u96c6...");
            this.jMenuItemEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogImportHistory.this.actionPerformedEditCsvInfo();
                }
            });
        }
        return this.jMenuItemEdit;
    }

    private void actionPerformedEditCsvInfo() {
        int idx = this.jTable.getSelectedRow();
        if (idx == -1) {
            return;
        }
        JDialogCsv dlg = new JDialogCsv(JDialogCsvMode.EDIT, this.model.getCsvInfo(idx));
        dlg.setLocation(this.getLocation());
        dlg.setModal(true);
        dlg.setVisible(true);
        CsvInfo csvInfo = dlg.getCsvInfo();
        if (dlg.getCsvInfo() != null) {
            csvInfo.currentDataSave();
            this.model.fireTableDataChanged();
        }
    }
}

