/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import jdbcacsess.SettingFile;
import org.w3c.dom.Element;

public class ComponentProperty {
    Element element;
    SettingFile xml;

    public ComponentProperty() {
        this.init();
    }

    public ComponentProperty(String tagName) {
        this.init();
        this.element = this.xml.getElement(this.element, tagName);
    }

    private void init() {
        this.xml = SettingFile.getInstance();
        this.element = this.xml.getRootElement("component");
    }

    public void put(Class c, String key, String value) {
        Element guiElement = this.xml.getElement(this.element, c.getName());
        guiElement.setAttribute(key, value);
    }

    public void put(Class c, String key, Integer value) {
        this.put(c, key, value.toString());
    }

    public void storeWindowPosition(Component component) {
        Class<?> c = component.getClass();
        this.put(c, "height", component.getSize().height);
        this.put(c, "width", component.getSize().width);
        this.put(c, "x", component.getLocation().x);
        this.put(c, "y", component.getLocation().y);
    }

    public String getToString(Class c, String key) {
        Element guiElement = this.xml.getElement(this.element, c.getName());
        return guiElement.getAttribute(key);
    }

    public Integer getToInteger(Class c, String key) {
        Integer i = null;
        try {
            i = new Integer(this.getToString(c, key));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public void restoreWindowPosition(Component component, Integer width, Integer height) {
        Class<?> c = component.getClass();
        Integer widthInt = this.getToInteger(c, "width");
        Integer heightInt = this.getToInteger(c, "height");
        Integer xInt = this.getToInteger(c, "x");
        Integer yInt = this.getToInteger(c, "y");
        this.setWin(component, width, height, widthInt, heightInt, xInt, yInt);
    }

    private void setWin(Component component, Integer width, Integer height, Integer widthInt, Integer heightInt, Integer xInt, Integer yInt) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (heightInt == null || widthInt == null || xInt == null || yInt == null) {
            if (height > screenSize.height) {
                height = screenSize.height;
            }
            if (width > screenSize.width) {
                width = screenSize.width;
            }
            component.setSize(new Dimension(width, height));
            component.setLocation(0, 0);
        } else {
            if (screenSize.width < xInt + widthInt) {
                xInt = screenSize.width - widthInt;
            }
            if (screenSize.height < yInt + heightInt) {
                yInt = screenSize.height - heightInt;
            }
            if (xInt < 0) {
                xInt = 0;
            }
            if (yInt < 0) {
                yInt = 0;
            }
            component.setSize(new Dimension(widthInt, heightInt));
            component.setLocation(xInt, yInt);
        }
    }
}

