/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jdbcacsess.ConvertToCommponent2;
import jdbcacsess.SettingFile;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.sql.SqlMappingInfo;
import org.w3c.dom.Element;

public class JdbcAcsess {
    public static final String major = "1";
    public static final String minor = "2";
    public static final String date = "2006/09/12";
    private static boolean fource = false;

    private static void envDisplay() {
    }

    public static void main(String[] args) {
        try {
            FileHandler fh = new FileHandler(SettingFile.getInstance().getFileName("message.log"));
            fh.setFormatter(new SimpleFormatter());
            Logger.global.addHandler(fh);
            Logger.global.setLevel(JFrameSetting.getLoggerLevel());
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String className = new ComponentProperty().getToString(UIManager.class, "className");
        if ("".equals(className)) {
            className = UIManager.getSystemLookAndFeelClassName();
            new ComponentProperty().put(UIManager.class, "className", className);
        }
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        DriverManager.setLogWriter(new PrintWriter(System.out));
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        SettingFile sf = SettingFile.getInstance();
        Element element = sf.getRootElement("version");
        String major = major;
        String minor = "0";
        if (element.getAttributes().getLength() != 0) {
            major = element.getAttribute("major");
            minor = element.getAttribute("minor");
        }
        if (major.equals(major) && minor.equals("0")) {
            Logger.global.info("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e<component>\u3092<component2>\u3078\u5909\u63db\u3057\u307e\u3059\u3002");
            new ConvertToCommponent2();
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(major));
        if (Double.valueOf(stringBuilder.append(".").append(minor).toString()) < Double.valueOf("1.2")) {
            Logger.global.info("\u65b0\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u3059");
            element.setAttribute("major", major);
            element.setAttribute("minor", minor);
        }
        JdbcAcsess.saveDefaultMapping();
        new JFrameMain();
        JdbcAcsess.envDisplay();
    }

    private static void saveDefaultMapping() {
        Map map = new SqlMappingInfo().getInfoMap();
        JdbcAcsess.save(map, "Oracle", "BINARY_DOUBLE", "getDouble", "");
        JdbcAcsess.save(map, "Oracle", "BINARY_FLOAT", "getFloat", "");
        JdbcAcsess.save(map, "Oracle", "DATE", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
        JdbcAcsess.save(map, "Oracle", "TIMESTAMP", "getTimestamp", "");
        JdbcAcsess.save(map, "Oracle", "TIMESTAMPTZ", "getString", "");
        JdbcAcsess.save(map, "Oracle", "TIMESTAMPLTZ", "", "jdbcacsess.sql.column.GetColumnOracleTIMESTAMPLTZ");
        JdbcAcsess.save(map, "MySQL", "BIT", "", "jdbcacsess.sql.column.GetColumnBytesOrBinaryStream");
        JdbcAcsess.save(map, "MySQL", "DATETIME", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
        JdbcAcsess.save(map, "MySQL", "TIMESTAMP", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
        JdbcAcsess.save(map, "MySQL", "TINYINT", "getInt", "");
        JdbcAcsess.save(map, "MySQL", "YEAR", "", "jdbcacsess.sql.column.GetColumnDateYYYY");
        JdbcAcsess.save(map, "PostgreSQL", "bit", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "cidr", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "inet", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "interval", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "macaddr", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "timestamptz", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "varbit", "getString", "");
    }

    private static void save(Map map, String dbms, String type, String method, String cls) {
        SqlMappingInfo smi = new SqlMappingInfo();
        smi.setKey(dbms, type);
        if (map.get(smi.getKeyValue()) == null || fource) {
            smi.setResultSetMethodName(method);
            smi.setGetResultSetClassName(cls);
            smi.currentDataSave();
        }
    }
}

