/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.csv.CsvInfo;

public class ImportHistoryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2574911637821580582L;
    private List<CsvInfo> csvInfoList;
    private Vector<String> header = new CsvInfo().getHeader();
    private int columnCount = this.header.size();
    private List<Integer> convList = new ArrayList<Integer>();
    private int sortColumnIndex = 0;
    private boolean orderByAsc = false;

    public ImportHistoryTableModel() {
        this.setSortColumnIndex(this.sortColumnIndex);
    }

    public String getColumnName(int idx) {
        String allow = "";
        return String.valueOf(this.header.get(idx)) + allow;
    }

    public int getRowCount() {
        return this.csvInfoList.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.csvInfoList.get(this.convRowIndex(rowIndex)).getData(columnIndex);
    }

    public String getKey(int rowIndex) {
        return this.csvInfoList.get(this.convRowIndex(rowIndex)).getFileName();
    }

    public void remove(String key) {
        for (CsvInfo ci : this.csvInfoList) {
            if (!ci.getFileName().equals(key)) continue;
            this.csvInfoList.remove(ci);
            ci.removeParameter();
            break;
        }
    }

    public CsvInfo getCsvInfo(int rowIndex) {
        return this.csvInfoList.get(this.convRowIndex(rowIndex));
    }

    private int convRowIndex(int index) {
        return this.convList.get(index);
    }

    public void reLoad() {
        this.orderByAsc = !this.orderByAsc;
        this.setSortColumnIndex(this.sortColumnIndex);
    }

    public void setSortColumnIndex(int columnIndex) {
        if (this.sortColumnIndex == columnIndex) {
            this.orderByAsc = !this.orderByAsc;
        }
        this.sortColumnIndex = columnIndex;
        this.csvInfoList = new CsvInfo().getInfoList();
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        int rowIndex = 0;
        while (rowIndex < this.csvInfoList.size()) {
            map.put(String.valueOf(this.csvInfoList.get(rowIndex).getData(columnIndex)) + rowIndex, rowIndex);
            ++rowIndex;
        }
        this.convList.clear();
        for (Map.Entry i : map.entrySet()) {
            if (this.orderByAsc) {
                this.convList.add((Integer)i.getValue());
                continue;
            }
            this.convList.add(0, (Integer)i.getValue());
        }
        this.fireTableDataChanged();
    }
}

