/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInputDataView;
import jdbcacsess.csv.CsvInputImportToDB;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.ImportHistoryTableModel;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.gui.common.ColumnWidth;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFrameBase;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.gui.common.PopupKeybordAndMouse;
import jdbcacsess.sql.SqlExec;

public class JFrameImportHistory
extends JFrameBase {
    private static final long serialVersionUID = 7126241261349764262L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPanel jPanel = null;
    private JButton jButtonOK = null;
    private ImportHistoryTableModel importHistoryTableModel;
    private JButton jButtonDelete = null;
    private JButton jButtonDisplayUpdate = null;
    private JButton jButtonEditAndImport = null;
    private JButton jButtonEdit = null;
    private JPopupMenuCnageUI jPopupMenuChangeUI = null;
    private JMenuItem jMenuItemOK = null;
    private JMenuItem jMenuItemEditAndImport = null;
    private JMenuItem jMenuItemEdit = null;
    private JMenuItem jMenuItemDelete = null;
    private static JFrameImportHistory jDialogImportHistory;
    private JButton jButtonDataView = null;
    private JMenuItem jMenuItemDataView = null;
    private JMenuItem jMenuItemDisplayUpdate = null;

    public static JFrameImportHistory getInstance() {
        if (jDialogImportHistory == null) {
            jDialogImportHistory = new JFrameImportHistory();
        }
        return jDialogImportHistory;
    }

    private JFrameImportHistory() {
        this.initialize();
    }

    private void initialize() {
        this.setTitle("CSV\u5165\u529b\u5c65\u6b74");
        this.setSize(new Dimension(800, 400));
        this.setContentPane(this.getJContentPane());
        super.init();
        this.importHistoryTableModel = new ImportHistoryTableModel();
        this.jTable.setModel(this.importHistoryTableModel);
        this.jTable.setSelectionMode(2);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        new PopupKeybordAndMouse(this.jTable, (JPopupMenu)this.getJPopupMenuChangeUI());
        this.jTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int columnIndex = JFrameImportHistory.this.jTable.getTableHeader().columnAtPoint(e.getPoint());
                JFrameImportHistory.this.importHistoryTableModel.setSortColumnIndex(columnIndex);
            }
        });
        ColumnWidth.setColumnWidth(this.jTable);
        ComponentProperty cp = new ComponentProperty();
        int i = 0;
        while (i < this.jTable.getColumnCount()) {
            TableColumn tc = this.jTable.getTableHeader().getColumnModel().getColumn(i);
            Integer width = cp.getToInteger(this.getClass(), "col" + i);
            if (width != null) {
                tc.setPreferredWidth(width);
            }
            ++i;
        }
        this.getRootPane().setDefaultButton(this.jButtonDisplayUpdate);
    }

    public void reLoad() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrameImportHistory.this.importHistoryTableModel.reLoad();
            }
        });
    }

    public void frameClosing() {
        ComponentProperty cp = new ComponentProperty();
        int i = 0;
        while (i < this.jTable.getColumnCount()) {
            TableColumn tc = this.jTable.getTableHeader().getColumnModel().getColumn(i);
            cp.put(this.getClass(), "col" + i, tc.getWidth());
            ++i;
        }
        jDialogImportHistory = null;
    }

    private void actionPerformedExecuteImport() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (!this.isSelected()) {
            return;
        }
        ExecutorService e = Executors.newSingleThreadExecutor();
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int index = nArray[n];
            e.execute(new CsvInputImportToDB(this.importHistoryTableModel.getCsvInfo(index)));
            ++n;
        }
        e.shutdown();
    }

    private void actionPerformedDelete() {
        if (!this.isSelected()) {
            return;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int idx = nArray[n];
            fileNames.add(this.importHistoryTableModel.getKey(idx));
            ++n;
        }
        for (String key : fileNames) {
            this.importHistoryTableModel.remove(key);
        }
        this.importHistoryTableModel.reLoad();
    }

    private void actionPerformedEditAndImport() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (!this.isSelected()) {
            return;
        }
        ExecutorService e = Executors.newSingleThreadExecutor();
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int idx = nArray[n];
            JDialogCsv dlg = new JDialogCsv(CsvMode.IMPORT, this.importHistoryTableModel.getCsvInfo(idx));
            CsvInfo ci = dlg.getCsvInfo();
            if (ci != null) {
                ci.currentDataSave();
                e.execute(new CsvInputImportToDB(ci));
                this.importHistoryTableModel.fireTableRowsUpdated(idx, idx);
            }
            ++n;
        }
        e.shutdown();
    }

    private void actionPerformedEdit() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (!this.isSelected()) {
            return;
        }
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int idx = nArray[n];
            JDialogCsv dlg = new JDialogCsv(CsvMode.EDIT, this.importHistoryTableModel.getCsvInfo(idx));
            CsvInfo ci = dlg.getCsvInfo();
            if (ci != null) {
                ci.currentDataSave();
                this.importHistoryTableModel.fireTableRowsUpdated(idx, idx);
            }
            ++n;
        }
    }

    protected void actionPerformedDataView() {
        if (!this.isSelected()) {
            return;
        }
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int index = nArray[n];
            new CsvInputDataView(this.importHistoryTableModel.getCsvInfo(index));
            ++n;
        }
    }

    private boolean isSelected() {
        if (this.jTable.getSelectedColumnCount() == 0) {
            JDialogMessage.infoDialog("\u9078\u629e\u3055\u308c\u3066\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return false;
        }
        return true;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable(10, 10);
        }
        return this.jTable;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButtonDisplayUpdate(), null);
            this.jPanel.add((Component)this.getJButtonDataView(), null);
            this.jPanel.add((Component)this.getJButtonEditAndImport(), null);
            this.jPanel.add((Component)this.getJButtonEdit(), null);
            this.jPanel.add((Component)this.getJButtonDelete(), null);
            this.jPanel.add((Component)this.getJButtonImport(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonImport() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new JButton();
            this.jButtonOK.setText("Import\u5b9f\u884c");
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedExecuteImport();
                }
            });
        }
        return this.jButtonOK;
    }

    private JButton getJButtonDelete() {
        if (this.jButtonDelete == null) {
            this.jButtonDelete = new JButton();
            this.jButtonDelete.setText("\u6761\u4ef6\u524a\u9664");
            this.jButtonDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDelete();
                }
            });
        }
        return this.jButtonDelete;
    }

    private JButton getJButtonDisplayUpdate() {
        if (this.jButtonDisplayUpdate == null) {
            this.jButtonDisplayUpdate = new JButton();
            this.jButtonDisplayUpdate.setText("\u4e00\u89a7\u3092\u66f4\u65b0");
            this.jButtonDisplayUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.reLoad();
                }
            });
        }
        return this.jButtonDisplayUpdate;
    }

    private JButton getJButtonEditAndImport() {
        if (this.jButtonEditAndImport == null) {
            this.jButtonEditAndImport = new JButton();
            this.jButtonEditAndImport.setText("CSV\u5165\u529b...");
            this.jButtonEditAndImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedEditAndImport();
                }
            });
        }
        return this.jButtonEditAndImport;
    }

    private JButton getJButtonEdit() {
        if (this.jButtonEdit == null) {
            this.jButtonEdit = new JButton();
            this.jButtonEdit.setText("\u6761\u4ef6\u7de8\u96c6...");
            this.jButtonEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedEdit();
                }
            });
        }
        return this.jButtonEdit;
    }

    private JButton getJButtonDataView() {
        if (this.jButtonDataView == null) {
            this.jButtonDataView = new JButton();
            this.jButtonDataView.setText("\u30c7\u30fc\u30bf100\u4ef6\u53c2\u7167...");
            this.jButtonDataView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDataView();
                }
            });
        }
        return this.jButtonDataView;
    }

    private JPopupMenuCnageUI getJPopupMenuChangeUI() {
        if (this.jPopupMenuChangeUI == null) {
            this.jPopupMenuChangeUI = new JPopupMenuCnageUI();
            this.jPopupMenuChangeUI.add(this.getJMenuItemDisplayUpdate());
            this.jPopupMenuChangeUI.add(this.getJMenuItemDataView());
            this.jPopupMenuChangeUI.addSeparator();
            this.jPopupMenuChangeUI.add(this.getJMenuItemEditAndImport());
            this.jPopupMenuChangeUI.add(this.getJMenuItemEdit());
            this.jPopupMenuChangeUI.add(this.getJMenuItemDelete());
            this.jPopupMenuChangeUI.addSeparator();
            this.jPopupMenuChangeUI.add(this.getJMenuItemOK());
        }
        return this.jPopupMenuChangeUI;
    }

    private JMenuItem getJMenuItemOK() {
        if (this.jMenuItemOK == null) {
            this.jMenuItemOK = new JMenuItem();
            this.jMenuItemOK.setText("Import\u5b9f\u884c");
            this.jMenuItemOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedExecuteImport();
                }
            });
        }
        return this.jMenuItemOK;
    }

    private JMenuItem getJMenuItemEditAndImport() {
        if (this.jMenuItemEditAndImport == null) {
            this.jMenuItemEditAndImport = new JMenuItem();
            this.jMenuItemEditAndImport.setText("CSV\u5165\u529b...");
            this.jMenuItemEditAndImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedEditAndImport();
                }
            });
        }
        return this.jMenuItemEditAndImport;
    }

    private JMenuItem getJMenuItemEdit() {
        if (this.jMenuItemEdit == null) {
            this.jMenuItemEdit = new JMenuItem();
            this.jMenuItemEdit.setText("\u6761\u4ef6\u7de8\u96c6...");
            this.jMenuItemEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedEdit();
                }
            });
        }
        return this.jMenuItemEdit;
    }

    private JMenuItem getJMenuItemDelete() {
        if (this.jMenuItemDelete == null) {
            this.jMenuItemDelete = new JMenuItem();
            this.jMenuItemDelete.setText("\u6761\u4ef6\u524a\u9664");
            this.jMenuItemDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDelete();
                }
            });
        }
        return this.jMenuItemDelete;
    }

    private JMenuItem getJMenuItemDataView() {
        if (this.jMenuItemDataView == null) {
            this.jMenuItemDataView = new JMenuItem();
            this.jMenuItemDataView.setText("\u30c7\u30fc\u30bf100\u4ef6\u53c2\u7167...");
            this.jMenuItemDataView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDataView();
                }
            });
        }
        return this.jMenuItemDataView;
    }

    private JMenuItem getJMenuItemDisplayUpdate() {
        if (this.jMenuItemDisplayUpdate == null) {
            this.jMenuItemDisplayUpdate = new JMenuItem();
            this.jMenuItemDisplayUpdate.setText("\u4e00\u89a7\u3092\u66f4\u65b0");
            this.jMenuItemDisplayUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.reLoad();
                }
            });
        }
        return this.jMenuItemDisplayUpdate;
    }
}

