/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.dbconnect;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jdbcacsess.JTextFieldEdit;
import jdbcacsess.dbconnect.ConnectInfo;
import jdbcacsess.dbconnect.DBMSinfo;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JTextAreaNoEdit;
import jdbcacsess.sql.SqlExec;
import org.xml.sax.SAXException;

public class JDialogConnect
extends JDialog {
    private static final long serialVersionUID = 1752836929960335893L;
    private DefaultComboBoxModel modelDBMS = new DefaultComboBoxModel();
    private DefaultComboBoxModel modelProfName;
    private ConnectInfo connectInfo;
    private JPanel jContentPane = null;
    private JButton jButtonConnect = null;
    private JButton jButtonCancel = null;
    private JButton jButtonDelete = null;
    private JPanel jPanel = null;
    private JLabel jLabel9 = null;
    private JComboBox jComboBoxProfName = null;
    private JPanel jPanel6 = null;
    private JPanel jPanel7 = null;
    private JLabel jLabel7 = null;
    private JLabel jLabel12 = null;
    private JLabel jLabel13 = null;
    private JLabel jLabel14 = null;
    private JLabel jLabel15 = null;
    private JLabel jLabel16 = null;
    private JComboBox jComboBoxDBMS = null;
    private JTextFieldEdit jTextFieldHostName = null;
    private JTextFieldEdit jTextFieldPortNumber = null;
    private JTextFieldEdit jTextFieldDataBaseName = null;
    private JTextFieldEdit jTextFieldUserID = null;
    private JPasswordField jPasswordField = null;
    private JPanel jPanel8 = null;
    private JPanel jPanel1 = null;
    private JTextAreaNoEdit jTextAreaURL = null;
    private JLabel jLabel1 = null;
    private JTextFieldEdit jTextFieldOptionString = null;
    private JLabel jLabelClassName = null;
    private JTextFieldEdit jTextFieldClassName = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JTextFieldEdit jTextFieldDriverPath = null;
    private JButton jButton = null;
    private JTextAreaNoEdit jTextAreaNoEdit = null;
    private JCheckBox jCheckBoxSavePassword = null;

    public JDialogConnect() {
        this.initialize();
    }

    private void initialize() {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.setTitle("DB\u63a5\u7d9a");
        this.setDefaultCloseOperation(2);
        new ComponentProperty().restoreWindowPosition(this, 550, 450);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDialogConnect.this.dialogClosing();
            }
        });
        try {
            for (String e : DBMSinfo.getDBMSList()) {
                this.modelDBMS.addElement(e);
            }
            this.modelDBMS.setSelectedItem(null);
        }
        catch (SAXException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.jComboBoxDBMS.setModel(this.modelDBMS);
        this.connectInfo = new ConnectInfo();
        Vector<String> profNames = new Vector<String>();
        for (ConnectInfo ci : this.connectInfo.getInfoList()) {
            profNames.add(ci.getKeyValue());
        }
        this.modelProfName = new DefaultComboBoxModel(profNames);
        this.jComboBoxProfName.setModel(this.modelProfName);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDialogConnect.this.actionPerformedCancel();
            }
        });
        this.connectInfo.currentDataLoad();
        this.setConnectInfo(this.connectInfo);
        this.getRootPane().setDefaultButton(this.jButtonConnect);
        this.setVisible(true);
    }

    public void dialogClosing() {
        new ComponentProperty().storeWindowPosition(this);
    }

    private void displayEdittingUrl() {
        this.jTextAreaURL.setText(this.getConnectInfo().getUrl());
    }

    private ConnectInfo getConnectInfo() {
        ConnectInfo ci = new ConnectInfo();
        ci.setProfName((String)this.jComboBoxProfName.getSelectedItem());
        ci.setDBMS((String)this.jComboBoxDBMS.getSelectedItem());
        ci.setHostName(this.jTextFieldHostName.getText());
        ci.setPortNumber(this.jTextFieldPortNumber.getText());
        ci.setDataBaseName(this.jTextFieldDataBaseName.getText());
        ci.setOptionString(this.jTextFieldOptionString.getText());
        ci.setUserID(this.jTextFieldUserID.getText());
        ci.setPassword(this.jCheckBoxSavePassword.isSelected() ? new String(this.jPasswordField.getPassword()) : "");
        ci.setDriverPath(this.jTextFieldDriverPath.getText());
        ci.setClassPathTextInput(this.jTextFieldClassName.getText());
        ci.setSavePassword(this.jCheckBoxSavePassword.isSelected() ? "" : "no");
        return ci;
    }

    private void setConnectInfo(ConnectInfo ci) {
        this.jComboBoxProfName.setSelectedItem(ci.getProfName());
        this.jTextFieldHostName.setText(ci.getHostName());
        this.jTextFieldPortNumber.setText(ci.getPortNumber());
        this.jTextFieldDataBaseName.setText(ci.getDataBaseName());
        this.jTextFieldOptionString.setText(ci.getOptionString());
        this.jTextFieldUserID.setText(ci.getUserID());
        this.jPasswordField.setText(ci.getPassword());
        this.jTextFieldDriverPath.setText(ci.getDriverPath());
        this.jTextFieldClassName.setText(ci.getClassPathTextInput());
        this.jComboBoxDBMS.setSelectedItem(this.modelDBMS.getElementAt(this.modelDBMS.getIndexOf(ci.getDBMS())));
        this.jCheckBoxSavePassword.setSelected(!ci.getSavePassword().equals("no"));
    }

    private void actionPerformedConnect(ActionEvent e) {
        this.connectInfo = this.getConnectInfo();
        this.connectInfo.currentDataSave();
        try {
            URL[] driverUrlPath = null;
            if (!this.jTextFieldDriverPath.getText().equals("")) {
                StringTokenizer st = new StringTokenizer(this.jTextFieldDriverPath.getText(), System.getProperty("path.separator"));
                ArrayList<URL> jarUrlList = new ArrayList<URL>();
                while (st.hasMoreTokens()) {
                    if (st.equals("")) continue;
                    File file = new File(st.nextToken());
                    jarUrlList.add(file.toURL());
                }
                driverUrlPath = jarUrlList.toArray(new URL[jarUrlList.size()]);
            }
            SqlExec.connect(this.connectInfo.getUserID(), new String(this.jPasswordField.getPassword()), this.connectInfo.getUrl(), "Free Format".equals(this.connectInfo.getDBMS()) ? this.connectInfo.getClassPathTextInput() : this.connectInfo.getClassPath(), driverUrlPath);
        }
        catch (SQLException ex) {
            JDialogMessage.sqlErrorDialog(ex, "DB\u63a5\u7d9a");
            return;
        }
        catch (Exception ex) {
            JDialogMessage.errorDialog(ex);
            return;
        }
        this.dialogClosing();
        this.dispose();
    }

    private void actionPerformedCancel() {
        this.connectInfo.setProfName("");
        this.connectInfo.setDBMS("");
        this.connectInfo.setHostName("");
        this.connectInfo.setPortNumber("");
        this.connectInfo.setDataBaseName("");
        this.connectInfo.setOptionString("");
        this.connectInfo.setUserID("");
        this.connectInfo.setPassword("");
        this.connectInfo.setClassPathTextInput("");
        this.dialogClosing();
    }

    private void actionPerformedDelete(ActionEvent e) {
        String profName = (String)this.modelProfName.getSelectedItem();
        if (this.connectInfo.keyDataLoad(profName)) {
            this.connectInfo.removeParameter();
        }
        this.modelProfName.removeElement(profName);
    }

    private void actionPerformedProfName_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        String profName = (String)this.modelProfName.getSelectedItem();
        if (this.connectInfo.keyDataLoad(profName)) {
            this.setConnectInfo(this.connectInfo);
        }
    }

    private void actionPerformedFileChoice(ActionEvent e) {
        File file = new File(this.jTextFieldDriverPath.getText());
        JFileChooser jFileChooser = new JFileChooser(file.getAbsolutePath());
        jFileChooser.setMultiSelectionEnabled(false);
        int ans = jFileChooser.showOpenDialog(this);
        if (ans == 0) {
            String driverPath = this.jTextFieldDriverPath.getText();
            if (driverPath.equals("")) {
                this.jTextFieldDriverPath.setText(jFileChooser.getSelectedFile().getPath());
            } else {
                this.jTextFieldDriverPath.setText(String.valueOf(driverPath) + System.getProperty("path.separator") + jFileChooser.getSelectedFile().getPath());
            }
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel6(), "North");
            this.jContentPane.add((Component)this.getJPanel8(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JButton getJButtonConnect() {
        if (this.jButtonConnect == null) {
            this.jButtonConnect = new JButton();
            this.jButtonConnect.setText("\u63a5\u7d9a");
            this.jButtonConnect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogConnect.this.actionPerformedConnect(e);
                }
            });
        }
        return this.jButtonConnect;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("\u53d6\u6d88");
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogConnect.this.actionPerformedCancel();
                    JDialogConnect.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonDelete() {
        if (this.jButtonDelete == null) {
            this.jButtonDelete = new JButton();
            this.jButtonDelete.setText("\u8a2d\u5b9a\u524a\u9664");
            this.jButtonDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogConnect.this.actionPerformedDelete(e);
                }
            });
        }
        return this.jButtonDelete;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("\uff08\u63a5\u7d9a\u62bc\u4e0b\u3067\u81ea\u52d5\u4fdd\u5b58\uff09");
            this.jLabel9.setFont(new Font("Dialog", 0, 12));
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButtonConnect(), null);
            this.jPanel.add((Component)this.jLabel9, null);
            this.jPanel.add((Component)this.getJButtonCancel(), null);
        }
        return this.jPanel;
    }

    private JComboBox getJComboBoxProfName() {
        if (this.jComboBoxProfName == null) {
            this.jComboBoxProfName = new JComboBox();
            this.jComboBoxProfName.setPreferredSize(new Dimension(150, 25));
            this.jComboBoxProfName.setFont(new Font("Monospaced", 0, 12));
            this.jComboBoxProfName.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    JDialogConnect.this.actionPerformedProfName_itemStateChanged(e);
                }
            });
            this.jComboBoxProfName.setEditable(true);
        }
        return this.jComboBoxProfName;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("\u63a5\u7d9a\u540d\u79f0");
            this.jLabel2.setFont(new Font("Dialog", 0, 12));
            this.jPanel6 = new JPanel();
            this.jPanel6.add((Component)this.jLabel2, null);
            this.jPanel6.add((Component)this.getJComboBoxProfName(), null);
            this.jPanel6.add((Component)this.getJButtonDelete(), null);
        }
        return this.jPanel6;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 5;
            gridBagConstraints13.anchor = 18;
            gridBagConstraints13.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.gridy = 5;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 1;
            gridBagConstraints26.gridy = 7;
            gridBagConstraints26.weightx = 1.0;
            gridBagConstraints26.weighty = 1.0;
            gridBagConstraints26.gridwidth = 6;
            gridBagConstraints26.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints26.gridx = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 6;
            gridBagConstraints12.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints12.gridy = 6;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 6;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridwidth = 4;
            gridBagConstraints7.insets = new Insets(5, 3, 0, 5);
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridy = 6;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("\u30c9\u30e9\u30a4\u30d0\u30d5\u30a1\u30a4\u30eb\u540d");
            this.jLabel3.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 9;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.insets = new Insets(5, 3, 0, 5);
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints11.gridy = 9;
            this.jLabelClassName = new JLabel();
            this.jLabelClassName.setFont(new Font("Dialog", 0, 12));
            this.jLabelClassName.setText("\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u540d");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 3;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridwidth = 5;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints1.gridx = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints.gridy = 3;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\u63a5\u7d9aURL\u4ed8\u52a0\u6587\u5b57\u5217");
            this.jLabel1.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 2;
            gridBagConstraints25.gridy = 4;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.insets = new Insets(5, 3, 0, 5);
            gridBagConstraints25.gridx = 5;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 2;
            gridBagConstraints24.gridy = 4;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.insets = new Insets(5, 3, 0, 0);
            gridBagConstraints24.gridx = 2;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.gridy = 2;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.anchor = 17;
            gridBagConstraints23.insets = new Insets(5, 3, 0, 0);
            gridBagConstraints23.gridwidth = 3;
            gridBagConstraints23.gridx = 2;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 0;
            gridBagConstraints22.gridy = 1;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(5, 3, 0, 5);
            gridBagConstraints22.gridx = 5;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.insets = new Insets(5, 3, 0, 0);
            gridBagConstraints21.gridx = 2;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridy = 0;
            gridBagConstraints20.weightx = 1.0;
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.gridwidth = 3;
            gridBagConstraints20.insets = new Insets(5, 3, 5, 0);
            gridBagConstraints20.gridx = 2;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 4;
            gridBagConstraints19.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints19.fill = 0;
            gridBagConstraints19.anchor = 13;
            gridBagConstraints19.gridy = 4;
            this.jLabel16 = new JLabel();
            this.jLabel16.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
            this.jLabel16.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints18.fill = 0;
            gridBagConstraints18.anchor = 13;
            gridBagConstraints18.gridy = 4;
            this.jLabel15 = new JLabel();
            this.jLabel15.setText("\u30e6\u30fc\u30b6ID");
            this.jLabel15.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints17.fill = 0;
            gridBagConstraints17.anchor = 13;
            gridBagConstraints17.gridy = 2;
            this.jLabel14 = new JLabel();
            this.jLabel14.setText("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d");
            this.jLabel14.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 4;
            gridBagConstraints16.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints16.fill = 0;
            gridBagConstraints16.anchor = 13;
            gridBagConstraints16.gridy = 1;
            this.jLabel13 = new JLabel();
            this.jLabel13.setText("\u30dd\u30fc\u30c8\u756a\u53f7");
            this.jLabel13.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.anchor = 13;
            gridBagConstraints15.gridy = 1;
            this.jLabel12 = new JLabel();
            this.jLabel12.setText("\u30db\u30b9\u30c8\u540d");
            this.jLabel12.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints14.fill = 0;
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.gridy = 0;
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("DBMS");
            this.jLabel7.setFont(new Font("Dialog", 0, 12));
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new GridBagLayout());
            this.jPanel7.add((Component)this.jLabel7, gridBagConstraints14);
            this.jPanel7.add((Component)this.jLabel12, gridBagConstraints15);
            this.jPanel7.add((Component)this.jLabel13, gridBagConstraints16);
            this.jPanel7.add((Component)this.jLabel14, gridBagConstraints17);
            this.jPanel7.add((Component)this.jLabel15, gridBagConstraints18);
            this.jPanel7.add((Component)this.jLabel16, gridBagConstraints19);
            this.jPanel7.add((Component)this.getJComboBoxDBMS(), gridBagConstraints20);
            this.jPanel7.add((Component)this.getJTextFieldHostName(), gridBagConstraints21);
            this.jPanel7.add((Component)this.getJTextFieldPortNumber(), gridBagConstraints22);
            this.jPanel7.add((Component)this.getJTextFieldDataBaseName(), gridBagConstraints23);
            this.jPanel7.add((Component)this.getJTextFieldUserID(), gridBagConstraints24);
            this.jPanel7.add((Component)this.getJPasswordField(), gridBagConstraints25);
            this.jPanel7.add((Component)this.jLabel1, gridBagConstraints);
            this.jPanel7.add((Component)this.getJTextFieldOptionString(), gridBagConstraints1);
            this.jPanel7.add((Component)this.jLabelClassName, gridBagConstraints11);
            this.jPanel7.add((Component)this.getJTextFieldClassName(), gridBagConstraints2);
            this.jPanel7.add((Component)this.jLabel3, gridBagConstraints5);
            this.jPanel7.add((Component)this.getJTextFieldDriverPath(), gridBagConstraints7);
            this.jPanel7.add((Component)this.getJButton(), gridBagConstraints12);
            this.jPanel7.add((Component)this.getJTextAreaNoEdit(), gridBagConstraints26);
            this.jPanel7.add((Component)this.getJCheckBoxSavePassword(), gridBagConstraints13);
        }
        return this.jPanel7;
    }

    private JComboBox getJComboBoxDBMS() {
        if (this.jComboBoxDBMS == null) {
            this.jComboBoxDBMS = new JComboBox();
            this.jComboBoxDBMS.setPreferredSize(new Dimension(150, 20));
            this.jComboBoxDBMS.setToolTipText("<html>\u4e00\u89a7\u306b\u7121\u3044\u6642\u306f\u300eFree Format\u300f\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002<br>\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u540d\u304c\u5165\u529b\u3067\u304d\u308b\u3088\u3046\u306b\u306a\u308a\u307e\u3059\u3002</html>");
            this.jComboBoxDBMS.setFont(new Font("Dialog", 0, 12));
            this.jComboBoxDBMS.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        JDialogConnect.this.displayEdittingUrl();
                        if (e.getItem().equals("Free Format")) {
                            JDialogConnect.this.jTextFieldClassName.setEditable(true);
                            JDialogConnect.this.jTextFieldHostName.setEditable(false);
                            JDialogConnect.this.jTextFieldPortNumber.setEditable(false);
                            JDialogConnect.this.jTextFieldDataBaseName.setEditable(false);
                        } else {
                            JDialogConnect.this.jTextFieldClassName.setEditable(false);
                            JDialogConnect.this.jTextFieldClassName.setText(JDialogConnect.this.getConnectInfo().getClassPath());
                            JDialogConnect.this.jTextFieldHostName.setEditable(true);
                            JDialogConnect.this.jTextFieldPortNumber.setEditable(true);
                            JDialogConnect.this.jTextFieldDataBaseName.setEditable(true);
                        }
                    }
                }
            });
        }
        return this.jComboBoxDBMS;
    }

    private JTextFieldEdit getJTextFieldHostName() {
        if (this.jTextFieldHostName == null) {
            this.jTextFieldHostName = new JTextFieldEdit();
            this.jTextFieldHostName.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldHostName.setFont(new Font("Monospaced", 0, 12));
            this.jTextFieldHostName.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    JDialogConnect.this.displayEdittingUrl();
                }
            });
        }
        return this.jTextFieldHostName;
    }

    private JTextFieldEdit getJTextFieldPortNumber() {
        if (this.jTextFieldPortNumber == null) {
            this.jTextFieldPortNumber = new JTextFieldEdit();
            this.jTextFieldPortNumber.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldPortNumber.setColumns(5);
            this.jTextFieldPortNumber.setToolTipText("<html>DBMS\u30b5\u30fc\u30d0\u306e\u8a2d\u5b9a\u306b\u3088\u308a\u307e\u3059\u304c\u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u306f\u3001<br>Oracle\uff1a1521 PostgreSQL\uff1a5432 MySQL\uff1a3306 \u7b49\u3067\u3059\u3002<br>\u4f46\u3057\u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a\u306e\u6642\u306f\u7701\u7565\u51fa\u6765\u308b\u3068\u601d\u3044\u307e\u3059</html>");
            this.jTextFieldPortNumber.setFont(new Font("Monospaced", 0, 12));
            this.jTextFieldPortNumber.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    JDialogConnect.this.displayEdittingUrl();
                }
            });
        }
        return this.jTextFieldPortNumber;
    }

    private JTextFieldEdit getJTextFieldDataBaseName() {
        if (this.jTextFieldDataBaseName == null) {
            this.jTextFieldDataBaseName = new JTextFieldEdit();
            this.jTextFieldDataBaseName.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldDataBaseName.setFont(new Font("Monospaced", 0, 12));
            this.jTextFieldDataBaseName.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    JDialogConnect.this.displayEdittingUrl();
                }
            });
        }
        return this.jTextFieldDataBaseName;
    }

    private JTextFieldEdit getJTextFieldUserID() {
        if (this.jTextFieldUserID == null) {
            this.jTextFieldUserID = new JTextFieldEdit();
            this.jTextFieldUserID.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldUserID.setColumns(15);
            this.jTextFieldUserID.setFont(new Font("Monospaced", 0, 12));
        }
        return this.jTextFieldUserID;
    }

    private JPasswordField getJPasswordField() {
        if (this.jPasswordField == null) {
            this.jPasswordField = new JPasswordField();
            this.jPasswordField.setPreferredSize(new Dimension(100, 20));
            this.jPasswordField.setColumns(15);
            this.jPasswordField.setFont(new Font("Monospaced", 0, 12));
        }
        return this.jPasswordField;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel();
            this.jPanel8.setLayout(new BorderLayout());
            this.jPanel8.add((Component)this.getJPanel1(), "South");
            this.jPanel8.add((Component)this.getJPanel7(), "North");
        }
        return this.jPanel8;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "JDBC\u30c9\u30e9\u30a4\u30d0\u306b\u6e21\u3059\u63a5\u7d9aURL", 0, 0, new Font("Dialog", 0, 12), Color.black));
            this.jPanel1.add((Component)this.getJTextAreaURL(), "Center");
        }
        return this.jPanel1;
    }

    private JTextAreaNoEdit getJTextAreaURL() {
        if (this.jTextAreaURL == null) {
            this.jTextAreaURL = new JTextAreaNoEdit();
        }
        return this.jTextAreaURL;
    }

    private JTextFieldEdit getJTextFieldOptionString() {
        if (this.jTextFieldOptionString == null) {
            this.jTextFieldOptionString = new JTextFieldEdit();
            this.jTextFieldOptionString.setPreferredSize(new Dimension(100, 20));
            this.jTextFieldOptionString.setToolTipText("<html>\u63a5\u7d9aURL\u306e\u5f8c\u308d\u306b\u3001\u30aa\u30d7\u30b7\u30e7\u30f3\u3067\u6587\u5b57\u5217\u3092\u8ffd\u52a0\u3057\u305f\u3044\u6642\u306f\u3001\u3053\u3053\u306b\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002<br>DBMS\u3092\u300eFree Format\u300f\u306b\u3057\u305f\u6642\u306f\u3001\u300ejdbc\u300f\u4ee5\u964d\u306eURL\u3092\u5168\u3066\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044</html>");
            this.jTextFieldOptionString.setFont(new Font("Monospaced", 0, 12));
            this.jTextFieldOptionString.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    JDialogConnect.this.displayEdittingUrl();
                }
            });
        }
        return this.jTextFieldOptionString;
    }

    private JTextFieldEdit getJTextFieldClassName() {
        if (this.jTextFieldClassName == null) {
            this.jTextFieldClassName = new JTextFieldEdit();
            this.jTextFieldClassName.setFont(new Font("Monospaced", 0, 12));
            this.jTextFieldClassName.setText("");
            this.jTextFieldClassName.setToolTipText("DBMS\u3092\u300eFree Format\u300f\u306b\u3057\u305f\u3068\u304d\u3060\u3051\u5165\u529b\u3067\u304d\u307e\u3059\u3002");
            this.jTextFieldClassName.setPreferredSize(new Dimension(100, 20));
        }
        return this.jTextFieldClassName;
    }

    private JTextFieldEdit getJTextFieldDriverPath() {
        if (this.jTextFieldDriverPath == null) {
            this.jTextFieldDriverPath = new JTextFieldEdit();
            this.jTextFieldDriverPath.setFont(new Font("Monospaced", 0, 12));
            this.jTextFieldDriverPath.setToolTipText("<html>\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u7d76\u5bfe\u30d1\u30b9\u3067\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002<br>\u8907\u6570\u30d5\u30a1\u30a4\u30eb\u6307\u5b9a\u3059\u308b\u6642\u306f\u3001\uff62" + System.getProperty("path.separator") + "\uff63\u3067\u533a\u5207\u3063\u3066\u4e0b\u3055\u3044\u3002\u307e\u305f\u3001\u30c0\u30d6\u30eb\u30af\u30a9\u30fc\u30c8\u3067\u62ec\u3089\u306a\u3044\u3067\u4e0b\u3055\u3044\u3002</html>");
            this.jTextFieldDriverPath.setPreferredSize(new Dimension(10, 20));
        }
        return this.jTextFieldDriverPath;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("\u53c2\u7167...");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogConnect.this.actionPerformedFileChoice(e);
                }
            });
        }
        return this.jButton;
    }

    private JTextAreaNoEdit getJTextAreaNoEdit() {
        if (this.jTextAreaNoEdit == null) {
            this.jTextAreaNoEdit = new JTextAreaNoEdit();
            this.jTextAreaNoEdit.setText("\u203b\u300e\u30c9\u30e9\u30a4\u30d0\u30d5\u30a1\u30a4\u30eb\u540d\u300f\u306fjava\u30b3\u30de\u30f3\u30c9\u3067\u8d77\u52d5\u3059\u308b\u6642\u306e\u307f\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002JavaWebStart\u306b\u3066\u8d77\u52d5\u3059\u308b\u5834\u5408\u306f\u7a7a\u6587\u5b57\u5217\u306b\u3057\u3066\u3001\u30c9\u30e9\u30a4\u30d0\u30d5\u30a1\u30a4\u30eb\u3092jre/lib/ext\u306b\u683c\u7d0d\u3057\u3066\u4e0b\u3055\u3044\u3002m(__)m");
            this.jTextAreaNoEdit.setFont(new Font("Dialog", 0, 10));
        }
        return this.jTextAreaNoEdit;
    }

    private JCheckBox getJCheckBoxSavePassword() {
        if (this.jCheckBoxSavePassword == null) {
            this.jCheckBoxSavePassword = new JCheckBox();
            this.jCheckBoxSavePassword.setText("\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u4fdd\u5b58\u3059\u308b");
            this.jCheckBoxSavePassword.setToolTipText("<html>\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u30c1\u30a7\u30c3\u30af\u3092\u306f\u305a\u3057\u3066\u4e0b\u3055\u3044\u3002<br>\u306a\u304a\u3001\u4fdd\u5b58\u306f\u5e73\u6587\u3067\u3059\u3002</html>");
            this.jCheckBoxSavePassword.setFont(new Font("Dialog", 0, 12));
            this.jCheckBoxSavePassword.setSelected(true);
        }
        return this.jCheckBoxSavePassword;
    }
}

