/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import jdbcacsess.PrefixStringBuffer;
import jdbcacsess.SettingFile;
import jdbcacsess.gui.JPanelConditionTable;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.common.JFrameBase;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFrameCreateSqlFromTree
extends JFrameBase {
    private static final long serialVersionUID = 1L;
    private MouseMotionListener componentMouseMotionListener;
    private JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer firsstClickJoinPointer = null;
    private JButton jButtonOk = null;
    private JPanel jContentPane = null;
    private MouseListener joinPointerMouseListener;
    private JPanel jPanel = null;
    private JPanel jpanelWhereColumns = null;
    private JScrollPane jScrollPane = null;
    private JToggleButton jToggleButtonOuterJoin = null;
    private Point mousePoint = new Point();
    private JTextPaneSqlStatement sqlStatement;
    private ArrayList<JPanelConditionTable> tableInfos = new ArrayList();
    private ActionListener whereActionListener;
    private ArrayList<Condition> conditions = new ArrayList();

    public JFrameCreateSqlFromTree() {
        this.initialize();
    }

    protected void actionPerformedOk() {
        this.sqlStatement.clearAll();
        Collections.sort(this.conditions);
        PrefixStringBuffer psbSelectColumn = new PrefixStringBuffer("", " ,");
        PrefixStringBuffer psbFrom = new PrefixStringBuffer("", " ,");
        PrefixStringBuffer psbWhere = new PrefixStringBuffer("", " AND ");
        ArrayList<SchemaTableName> stnList = new ArrayList<SchemaTableName>();
        for (Condition item : this.conditions) {
            if (item.getStartComponent().getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_NONE) {
                psbWhere.appendItem(item.getCondition());
                continue;
            }
            SchemaTableName stn1 = item.getStartComponent().getJPanelColumns().getSchemaTableName();
            SchemaTableName stn2 = item.getEndComponent().getJPanelColumns().getSchemaTableName();
            if (stnList.contains(stn1) && stnList.contains(stn2)) {
                System.out.println("\u7de8\u96c6\u6e08:" + item.toString());
                continue;
            }
            if (!stnList.contains(stn1) && !stnList.contains(stn2)) {
                stnList.add(stn1);
                stnList.add(stn2);
                psbFrom.appendItem("");
                item.getOuterTable(psbFrom, true, item.getStartComponent());
            }
            if (stnList.contains(stn1) && !stnList.contains(stn2)) {
                stnList.add(stn2);
                item.getOuterTable(psbFrom, false, item.getStartComponent());
            }
            if (!stnList.contains(stn1) && stnList.contains(stn2)) {
                stnList.add(stn1);
                item.getOuterTable(psbFrom, false, item.getEndComponent());
            }
            PrefixStringBuffer psb = new PrefixStringBuffer("", " AND ");
            for (Condition pair : new SameTableIterator(item.getStartComponent(), item.getEndComponent(), true)) {
                psb.appendItem(pair.getCondition());
            }
            psbFrom.append(" " + psb.getString() + "\n");
        }
        Component[] componentArray = this.getJPanelWhereColumns().getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component component = componentArray[n];
            if (component instanceof JPanelConditionTable) {
                JPanelConditionTable jPanelConditionTable = (JPanelConditionTable)component;
                JPanelConditionTable.SelectColumns sc = jPanelConditionTable.getSelectColumns();
                ArrayList<ColumnInfoTable> selectColumnlist = sc.columnInfoTables;
                if (!selectColumnlist.isEmpty() || jPanelConditionTable.isUseJoinPointer()) {
                    if (sc.allSelected) {
                        psbSelectColumn.appendItem(String.valueOf(jPanelConditionTable.getTableAlias()) + ".*");
                    } else {
                        for (ColumnInfoTable item : selectColumnlist) {
                            psbSelectColumn.appendItem(String.valueOf(jPanelConditionTable.getTableAlias()) + "." + item.getColumnName());
                        }
                        if (selectColumnlist.size() != 0) {
                            psbSelectColumn.append("\n");
                        }
                    }
                    if (!stnList.contains(jPanelConditionTable.getSchemaTableName())) {
                        psbFrom.appendItem(String.valueOf(jPanelConditionTable.getSchemaTableName().getCompleteTableName()) + " " + jPanelConditionTable.getTableAlias());
                    }
                }
            }
            ++n;
        }
        this.sqlStatement.insertCurrentPosition("SELECT ");
        this.sqlStatement.insertCurrentPosition(psbSelectColumn.getStringLastLF());
        this.sqlStatement.insertCurrentPosition("FROM ");
        this.sqlStatement.insertCurrentPosition(psbFrom.getStringLastLF());
        if (psbWhere.length() != 0) {
            this.sqlStatement.insertCurrentPosition("WHERE ");
            this.sqlStatement.insertCurrentPosition(psbWhere.getStringLastLF());
        }
        this.sqlStatement.requestFocusInWindow();
    }

    private void addAllMouseMotionListener(JComponent jComponent, MouseMotionListener mouseMotionListener) {
        jComponent.addMouseMotionListener(mouseMotionListener);
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component childComponent = componentArray[n];
            if (childComponent instanceof JComponent) {
                this.addAllMouseMotionListener((JComponent)childComponent, mouseMotionListener);
            }
            ++n;
        }
    }

    private ArrayList<ColumnInfoTable> convertToColumnInfoTable(SchemaTableName stn, ArrayList<String> list, boolean allSelect) {
        ArrayList<ColumnInfoTable> rtn = new ArrayList<ColumnInfoTable>();
        try {
            ArrayList<ColumnInfoTable> defineCols = SqlExec.getColumnMames(stn);
            if (allSelect) {
                return defineCols;
            }
            block2: for (String columnName : list) {
                for (ColumnInfoTable defineCol : defineCols) {
                    if (!defineCol.getColumnName().equals(columnName)) continue;
                    rtn.add(defineCol);
                    continue block2;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rtn;
    }

    @Override
    public void frameClosing() {
        this.save();
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("SQL\u4f5c\u6210");
            this.jButtonOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateSqlFromTree.this.actionPerformedOk();
                    JFrameCreateSqlFromTree.this.save();
                }
            });
        }
        return this.jButtonOk;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new FlowLayout());
            this.jPanel.add((Component)this.getJToggleButtonOuterJoin(), null);
            this.jPanel.add(this.getJButtonOk());
        }
        return this.jPanel;
    }

    private JPanel getJPanelWhereColumns() {
        if (this.jpanelWhereColumns == null) {
            this.jpanelWhereColumns = new JPanel();
            this.jpanelWhereColumns.setLayout(new BoxLayout(this.jpanelWhereColumns, 2));
        }
        return this.jpanelWhereColumns;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJPanelWhereColumns());
            this.jScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        }
        return this.jScrollPane;
    }

    private JToggleButton getJToggleButtonOuterJoin() {
        if (this.jToggleButtonOuterJoin == null) {
            this.jToggleButtonOuterJoin = new JToggleButton();
            this.jToggleButtonOuterJoin.setText("\u5168\u90e8\u691c\u7d22\u6307\u5b9a(\u5916\u90e8\u7d50\u5408)");
        }
        return this.jToggleButtonOuterJoin;
    }

    private Element getSqlEditRoot() {
        PrefixStringBuffer buf = new PrefixStringBuffer("", "-");
        for (JPanelConditionTable item : this.tableInfos) {
            String tbl = item.getSchemaTableName().getCompleteTableName();
            buf.appendItem(tbl);
        }
        SettingFile sf = SettingFile.getInstance();
        Element topSqlEditElement = sf.getRootElement("sqlEdit");
        Element element = SettingFile.getElementSearchingAttribute(topSqlEditElement, "TABLES", "name", buf.getString());
        if (element == null) {
            element = sf.createElement("TABLES");
            element.setAttribute("name", buf.getString());
            topSqlEditElement.appendChild(element);
        }
        return element;
    }

    private void initialize() {
        this.setSize(500, 400);
        this.setContentPane(this.getJContentPane());
        this.setTitle("SQL\u6587\u751f\u6210");
        this.init();
        this.getRootPane().setDefaultButton(this.jButtonOk);
        ConditionLine jc = new ConditionLine();
        jc.setOpaque(false);
        this.setGlassPane(jc);
        this.getGlassPane().setVisible(true);
        this.whereActionListener = new JoinPointerActionListener();
        this.componentMouseMotionListener = new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                Point p = ((Component)e.getSource()).getLocationOnScreen();
                Point rp = JFrameCreateSqlFromTree.this.getRootPane().getLocationOnScreen();
                JFrameCreateSqlFromTree.this.mousePoint.setLocation(p.x - rp.x + e.getX(), p.y - rp.y + e.getY());
                if (JFrameCreateSqlFromTree.this.firsstClickJoinPointer != null) {
                    JFrameCreateSqlFromTree.this.getGlassPane().repaint();
                }
            }
        };
        this.joinPointerMouseListener = new JoinPointerMouseListener();
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    private void save() {
        Element top = this.getSqlEditRoot();
        ((Element)top.getParentNode()).removeChild(top);
        top = this.getSqlEditRoot();
        SettingFile sf = SettingFile.getInstance();
        for (JPanelConditionTable item : this.tableInfos) {
            String tbl = item.getSchemaTableName().getCompleteTableName();
            JPanelConditionTable.SelectColumns sc = item.getSelectColumns();
            Element tableElement = sf.createElement("TABLE");
            tableElement.setAttribute("name", tbl);
            tableElement.setAttribute("allSelect", Boolean.toString(sc.allSelected));
            top.appendChild(tableElement);
            if (sc.allSelected) continue;
            for (ColumnInfoTable item1 : sc.columnInfoTables) {
                Element columnElement = sf.createElement("SELCOLS");
                columnElement.setAttribute("name", item1.getColumnName());
                tableElement.appendChild(columnElement);
            }
        }
        for (Condition condition : this.conditions) {
            Element columnElement = sf.createElement("WHERECOLS");
            columnElement.setAttribute("starttbl", condition.getStartComponent().getColumnInfoTable().getSchemaTableName().getCompleteTableName());
            columnElement.setAttribute("startcol", condition.getStartComponent().getColumnInfoTable().getColumnName());
            columnElement.setAttribute("startcolside", condition.getStartComponent().getSide());
            columnElement.setAttribute("startjoin", condition.getStartComponent().getJoinStatus().toString());
            columnElement.setAttribute("endtbl", condition.getEndComponent().getColumnInfoTable().getSchemaTableName().getCompleteTableName());
            columnElement.setAttribute("endcol", condition.getEndComponent().getColumnInfoTable().getColumnName());
            columnElement.setAttribute("endcolside", condition.getEndComponent().getSide());
            columnElement.setAttribute("endjoin", condition.getEndComponent().getJoinStatus().toString());
            top.appendChild(columnElement);
        }
    }

    public void setSqlStatement(JTextPaneSqlStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public void setTablemap(TreeMap<SchemaTableName, ArrayList<ColumnInfoTable>> map) {
        this.tableInfos.clear();
        this.getJPanelWhereColumns().removeAll();
        this.getJPanelWhereColumns().repaint();
        this.conditions.clear();
        this.firsstClickJoinPointer = null;
        int tableNO = 0;
        for (SchemaTableName t : map.keySet()) {
            JPanelConditionTable p = new JPanelConditionTable(t, this.whereActionListener, "T" + ++tableNO, this.joinPointerMouseListener);
            this.getJPanelWhereColumns().add(p);
            this.tableInfos.add(p);
        }
        Element topElement = this.getSqlEditRoot();
        for (JPanelConditionTable item : this.tableInfos) {
            SchemaTableName stn = item.getSchemaTableName();
            ArrayList<ColumnInfoTable> columnInfoTables = map.get(stn);
            if (columnInfoTables.size() != 0) {
                item.setColumnInfoTables(map.get(stn));
                continue;
            }
            Element tableElement = SettingFile.getElementSearchingAttribute(topElement, "TABLE", "name", stn.getCompleteTableName());
            if (tableElement == null) {
                item.setColumnInfoTables(this.convertToColumnInfoTable(stn, null, true));
                continue;
            }
            boolean allSelect = new Boolean(tableElement.getAttribute("allSelect"));
            if (allSelect) {
                item.setColumnInfoTables(this.convertToColumnInfoTable(stn, null, true));
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (Element selColElement : SettingFile.getElements(tableElement, "SELCOLS")) {
                String colName = selColElement.getAttribute("name");
                list.add(colName);
            }
            item.setColumnInfoTables(this.convertToColumnInfoTable(stn, list, false));
        }
        for (Element whereElement : SettingFile.getElements(topElement, "WHERECOLS")) {
            SchemaTableName st = new SchemaTableName(whereElement.getAttribute("starttbl"));
            String sc = whereElement.getAttribute("startcol");
            String ss = whereElement.getAttribute("startcolside");
            String sj = whereElement.getAttribute("startjoin");
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer start = null;
            SchemaTableName et = new SchemaTableName(whereElement.getAttribute("endtbl"));
            String ec = whereElement.getAttribute("endcol");
            String es = whereElement.getAttribute("endcolside");
            String ej = whereElement.getAttribute("endjoin");
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer end = null;
            for (JPanelConditionTable jPanelConditionTable : this.tableInfos) {
                if (jPanelConditionTable.getSchemaTableName().equals(st)) {
                    start = jPanelConditionTable.getJoinPointer(sc, ss);
                    start.setSelected(true);
                    start.setJoinStatus(JPanelConditionTable.JoinStatus.defaultValueOf(sj));
                }
                if (!jPanelConditionTable.getSchemaTableName().equals(et)) continue;
                end = jPanelConditionTable.getJoinPointer(ec, es);
                end.setSelected(true);
                end.setJoinStatus(JPanelConditionTable.JoinStatus.defaultValueOf(ej));
            }
            if (start == null || end == null) continue;
            this.conditions.add(new Condition(start, end));
        }
        this.addAllMouseMotionListener(this.getJPanelWhereColumns(), this.componentMouseMotionListener);
    }

    class JoinPointerMouseListener
    implements MouseListener {
        private Border oldBorder;
        private Condition currentCondition;
        private Border activeBorder = new MatteBorder(2, 2, 2, 2, Color.red);

        JoinPointerMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (!JFrameCreateSqlFromTree.this.jToggleButtonOuterJoin.isSelected()) {
                return;
            }
            JFrameCreateSqlFromTree.this.jToggleButtonOuterJoin.setSelected(false);
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c = (JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer)e.getComponent();
            c.setEnabled(true);
            if (this.currentCondition != null) {
                if (c.getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_ALL) {
                    c.setJoinStatus(JPanelConditionTable.JoinStatus.OUTER_NONE);
                    this.currentCondition.getEither(c).setJoinStatus(JPanelConditionTable.JoinStatus.OUTER_NONE);
                } else {
                    this.setOuterToJoinPointers(c, this.currentCondition.getEither(c));
                }
                c.setBorder(this.oldBorder);
            }
            this.currentCondition = null;
            this.oldBorder = null;
        }

        public void mouseEntered(MouseEvent e) {
            if (!JFrameCreateSqlFromTree.this.jToggleButtonOuterJoin.isSelected()) {
                return;
            }
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c = (JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer)e.getComponent();
            c.setEnabled(false);
            this.currentCondition = this.searchConditions(c);
            if (this.currentCondition != null) {
                this.oldBorder = c.getBorder();
                c.setBorder(this.activeBorder);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!JFrameCreateSqlFromTree.this.jToggleButtonOuterJoin.isSelected()) {
                return;
            }
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c = (JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer)e.getComponent();
            c.setEnabled(true);
            if (this.currentCondition != null) {
                c.setBorder(this.oldBorder);
                this.currentCondition = null;
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        private Condition searchConditions(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            for (Condition item : JFrameCreateSqlFromTree.this.conditions) {
                if (item.getEither(c) == null) continue;
                return item;
            }
            return null;
        }

        private void setOuterToJoinPointers(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer baseComponent, JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer eitherComponent) {
            for (Condition pair : new SameTableIterator(baseComponent, eitherComponent, false)) {
                pair.equalsJPanelColumns(baseComponent).setJoinStatus(JPanelConditionTable.JoinStatus.OUTER_ALL);
                JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c = pair.getEither(pair.equalsJPanelColumns(baseComponent));
                if (c.getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_ALL) continue;
                c.setJoinStatus(JPanelConditionTable.JoinStatus.OUTER_EQUAL);
            }
        }
    }

    class ConditionLine
    extends JPanel {
        private static final long serialVersionUID = -3428287174938981130L;
        private Line2D.Double line = new Line2D.Double();

        ConditionLine() {
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (JFrameCreateSqlFromTree.this.firsstClickJoinPointer != null && JFrameCreateSqlFromTree.this.mousePoint != null) {
                this.line.setLine(JFrameCreateSqlFromTree.this.firsstClickJoinPointer.getConnecterPoint(), JFrameCreateSqlFromTree.this.mousePoint);
                g2.draw(this.line);
            }
            int i = 0;
            while (i < JFrameCreateSqlFromTree.this.conditions.size()) {
                g2.draw(((Condition)JFrameCreateSqlFromTree.this.conditions.get(i)).getLine());
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SameTableIterator
    implements Iterable<Condition> {
        private Iterator<Condition> iterator;
        private ArrayList<Condition> list = new ArrayList();

        public SameTableIterator(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer component, boolean outerOnly) {
            for (Condition item : JFrameCreateSqlFromTree.this.conditions) {
                if (item.equalsJPanelColumns(component) == null || (!outerOnly || item.getStartComponent().getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_NONE) && outerOnly) continue;
                this.list.add(item);
            }
            this.iterator = this.list.iterator();
        }

        public SameTableIterator(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer component1, JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer component2, boolean outerOnly) {
            for (Condition item : JFrameCreateSqlFromTree.this.conditions) {
                if (!item.equalsTable(component1, component2) || (!outerOnly || item.getStartComponent().getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_NONE) && outerOnly) continue;
                this.list.add(item);
            }
            this.iterator = this.list.iterator();
        }

        @Override
        public Iterator<Condition> iterator() {
            return this.iterator;
        }
    }

    class JoinPointerActionListener
    implements ActionListener {
        JoinPointerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer component = (JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer)e.getSource();
            if (!component.isSelected()) {
                this.deSelect(component);
            } else {
                this.select(component);
            }
            JFrameCreateSqlFromTree.this.repaint();
        }

        private void deSelect(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer component) {
            boolean hit = false;
            for (Condition item : JFrameCreateSqlFromTree.this.conditions) {
                JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer eitherComponent = item.getEither(component);
                if (eitherComponent == null) continue;
                if (JFrameCreateSqlFromTree.this.firsstClickJoinPointer == null) {
                    JFrameCreateSqlFromTree.this.firsstClickJoinPointer = eitherComponent;
                } else {
                    eitherComponent.setSelected(false);
                }
                item.getStartComponent().setJoinStatus(JPanelConditionTable.JoinStatus.OUTER_NONE);
                item.getEndComponent().setJoinStatus(JPanelConditionTable.JoinStatus.OUTER_NONE);
                JFrameCreateSqlFromTree.this.conditions.remove(item);
                hit = true;
                break;
            }
            if (!hit) {
                JFrameCreateSqlFromTree.this.firsstClickJoinPointer = null;
            }
        }

        private void select(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer component) {
            if (JFrameCreateSqlFromTree.this.firsstClickJoinPointer == null) {
                JFrameCreateSqlFromTree.this.firsstClickJoinPointer = component;
                return;
            }
            if (JFrameCreateSqlFromTree.this.firsstClickJoinPointer.getJPanelColumns() == component.getJPanelColumns()) {
                JFrameCreateSqlFromTree.this.firsstClickJoinPointer.setSelected(false);
                JFrameCreateSqlFromTree.this.firsstClickJoinPointer = component;
                return;
            }
            Iterator<Condition> iterator = new SameTableIterator(JFrameCreateSqlFromTree.this.firsstClickJoinPointer, component, false).iterator();
            if (iterator.hasNext()) {
                Condition pair = iterator.next();
                JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c1 = pair.equalsJPanelColumns(JFrameCreateSqlFromTree.this.firsstClickJoinPointer);
                JFrameCreateSqlFromTree.this.firsstClickJoinPointer.setJoinStatus(c1.getJoinStatus());
                JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c2 = pair.equalsJPanelColumns(component);
                component.setJoinStatus(c2.getJoinStatus());
            }
            Condition item = new Condition(JFrameCreateSqlFromTree.this.firsstClickJoinPointer, component);
            JFrameCreateSqlFromTree.this.conditions.add(item);
            JFrameCreateSqlFromTree.this.firsstClickJoinPointer = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Condition
    implements Comparable<Condition> {
        private JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer endComponent = null;
        private String key;
        private JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer startComponent = null;
        private CubicCurve2D.Double cubicCurve = new CubicCurve2D.Double();
        private Line2D.Double line = new Line2D.Double();

        public Condition(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer startComponent, JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer endComponent) {
            String startKey = this.keyTo(startComponent);
            String endKey = this.keyTo(endComponent);
            if (startKey.compareTo(endKey) < 0) {
                this.startComponent = startComponent;
                this.endComponent = endComponent;
                this.key = startKey;
            } else {
                this.startComponent = endComponent;
                this.endComponent = startComponent;
                this.key = endKey;
            }
        }

        private String column(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            return String.valueOf(c.getJPanelColumns().getTableAlias()) + "." + c.getColumnInfoTable().getColumnName();
        }

        @Override
        public int compareTo(Condition o) {
            return this.key.compareTo(o.key);
        }

        public JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer equalsJPanelColumns(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            if (this.startComponent.getJPanelColumns() == c.getJPanelColumns()) {
                return this.startComponent;
            }
            if (this.endComponent.getJPanelColumns() == c.getJPanelColumns()) {
                return this.endComponent;
            }
            return null;
        }

        public boolean equalsTable(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c1, JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c2) {
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer p2;
            JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer p1 = this.equalsJPanelColumns(c1);
            return p1 != null && (p2 = this.equalsJPanelColumns(c2)) != null;
        }

        public String getCondition() {
            return String.valueOf(this.column(this.startComponent)) + " = " + this.column(this.endComponent);
        }

        public JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer getEither(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            if (this.startComponent == c) {
                return this.endComponent;
            }
            if (this.endComponent == c) {
                return this.startComponent;
            }
            return null;
        }

        public JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer getEndComponent() {
            return this.endComponent;
        }

        public Shape getLine() {
            Point startPoint = this.startComponent.getConnecterPoint();
            Point endPoint = this.endComponent.getConnecterPoint();
            if (startPoint.y == endPoint.y) {
                int ctlx = startPoint.x + (endPoint.x - startPoint.x) / 2;
                int ctly = endPoint.y + (endPoint.x - startPoint.x) / 10;
                Point ctlPoint = new Point(ctlx, ctly);
                this.cubicCurve.setCurve(startPoint, ctlPoint, ctlPoint, endPoint);
                return this.cubicCurve;
            }
            this.line.setLine(startPoint, endPoint);
            return this.line;
        }

        public void getOuterTable(PrefixStringBuffer buf, boolean first, JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            if (this.startComponent.getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_NONE || this.endComponent.getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_NONE) {
                System.out.print("\u7570\u5e38\u3067\u3059");
                return;
            }
            if (first) {
                buf.append(this.table(c));
            } else {
                buf.insert(0, "(");
                buf.append(")");
            }
            buf.append(" " + this.tableEdit() + " JOIN " + this.table(this.getEither(c)) + " ON");
        }

        public JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer getStartComponent() {
            return this.startComponent;
        }

        public boolean isContain(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            if (this.startComponent == c) {
                return true;
            }
            return this.endComponent == c;
        }

        private String keyTo(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            return String.valueOf(c.getJPanelColumns().getSchemaTableName().getCompleteTableName()) + new DecimalFormat("000").format(c.getColumnInfoTable().getColumnIndex());
        }

        private String table(JPanelConditionTable.JPanelConditionColumn.JToggleButtonJoinPointer c) {
            return String.valueOf(c.getJPanelColumns().getSchemaTableName().getCompleteTableName()) + " " + c.getJPanelColumns().getTableAlias();
        }

        private String tableEdit() {
            String joinKey = this.startComponent.getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_EQUAL ? "RIGHT" : (this.endComponent.getJoinStatus() == JPanelConditionTable.JoinStatus.OUTER_EQUAL ? "LEFT" : "FULL");
            return joinKey;
        }

        public String toString() {
            return "Condition[start=" + this.keyTo(this.startComponent) + " " + "end=" + this.keyTo(this.endComponent) + "]";
        }
    }
}

