/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.JTextFieldEdit;
import jdbcacsess.gui.JFrameSqlMapping;
import jdbcacsess.gui.common.ColumnWidth;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFrameBase;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.sql.SqlMappingInfo;

public class JFrameSetting
extends JFrameBase {
    private static final String DEFAULT_NULLVALUE = "#$%&NULL&%$#";
    private static final String DEFAULT_TIMEZONE = "GMT-00:00";
    private static final Level DEFAULT_LOGGERLEVEL = Level.INFO;
    private static final long serialVersionUID = 4207458859175871604L;
    private JPanel jContentPane = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelCommon = null;
    private JPanel jPanelOracle = null;
    private JLabel jLabel = null;
    private JTextFieldEdit jTextFieldColumnOutNullValue = null;
    private JPanel jPanel = null;
    private JButton jButtonSaveAndExit = null;
    private JButton jButtonNoSaveAndExit = null;
    private JLabel jLabel1 = null;
    private JTextFieldEdit jTextFieldTimeZoneOfDBserver = null;
    private JLabel jLabel3 = null;
    private JComboBox jComboBoxColumnInOutEncodeing = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel4 = null;
    private JScrollPane jScrollPane = null;
    private JTable jTableSqlMapping = null;
    private JLabel jLabel5 = null;
    private static JFrameSetting jFrameSetting;
    private JPopupMenuCnageUI jPopupMenuCnageUI = null;
    private JMenuItem jMenuItemEdit = null;
    private JMenuItem jMenuItemDelete = null;
    private JMenuItem jMenuItemEnable = null;
    private SqlMappingTableModel tableModel;
    private JButton jButtonDefaultEncodeing = null;
    private JPanel jPanelLogger = null;
    private JLabel jLabel6 = null;
    private JComboBox jComboBoxLoggerLevel = null;

    public static JFrameSetting getInstance() {
        if (jFrameSetting == null) {
            jFrameSetting = new JFrameSetting();
        }
        return jFrameSetting;
    }

    private JFrameSetting() {
        this.initialize();
    }

    private void initialize() {
        this.setTitle("\u8a2d\u5b9a");
        this.setSize(new Dimension(450, 300));
        this.setContentPane(this.getJContentPane());
        super.init();
        this.jTextFieldColumnOutNullValue.setText(JFrameSetting.getColumnOutNullValue());
        this.jTextFieldTimeZoneOfDBserver.setText(JFrameSetting.getOracleTimeZoneOfDbserver());
        this.jComboBoxColumnInOutEncodeing.setSelectedItem(JFrameSetting.getColumnInOutEncodeing());
        this.tableModel = new SqlMappingTableModel();
        this.jTableSqlMapping.setModel(this.tableModel);
        this.jTableSqlMapping.setComponentPopupMenu(this.getJPopupMenuCnageUI());
        ColumnWidth.setColumnWidthResizeOff(this.jTableSqlMapping);
        this.jComboBoxLoggerLevel.setSelectedItem(JFrameSetting.getLoggerLevel());
    }

    private void datSave() {
        ComponentProperty cp = new ComponentProperty();
        cp.put(JFrameSetting.class, "columnOutNullValue", this.jTextFieldColumnOutNullValue.getText());
        cp.put(JFrameSetting.class, "oracleTimeZoneOfDbserver", this.jTextFieldTimeZoneOfDBserver.getText());
        cp.put(JFrameSetting.class, "columnInOutEncodeing", this.jComboBoxColumnInOutEncodeing.getSelectedItem().toString());
        this.tableModel.save();
        cp.put(JFrameSetting.class, "loggerLevel", this.jComboBoxLoggerLevel.getSelectedItem().toString());
        Logger.global.setLevel((Level)this.jComboBoxLoggerLevel.getSelectedItem());
    }

    public void frameClosing() {
        jFrameSetting = null;
    }

    public static String getColumnOutNullValue() {
        String rtn = new ComponentProperty().getToString(JFrameSetting.class, "columnOutNullValue");
        if (rtn.equals("")) {
            rtn = DEFAULT_NULLVALUE;
        }
        return rtn;
    }

    public static String getOracleTimeZoneOfDbserver() {
        String rtn = new ComponentProperty().getToString(JFrameSetting.class, "oracleTimeZoneOfDbserver");
        if (rtn.equals("")) {
            rtn = DEFAULT_TIMEZONE;
        }
        return rtn;
    }

    public static String getColumnInOutEncodeing() {
        String rtn = new ComponentProperty().getToString(JFrameSetting.class, "columnInOutEncodeing");
        if (rtn.equals("")) {
            rtn = Charset.defaultCharset().toString();
        }
        return rtn;
    }

    public static Level getLoggerLevel() {
        String str = new ComponentProperty().getToString(JFrameSetting.class, "loggerLevel");
        if (str.equals("")) {
            return DEFAULT_LOGGERLEVEL;
        }
        return Level.parse(str);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("\u5171\u901a", null, this.getJPanelCommon(), null);
            this.jTabbedPane.addTab("Oracle", null, this.getJPanelOracle(), null);
            this.jTabbedPane.addTab("Logger", null, this.getJPanelLogger(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelCommon() {
        if (this.jPanelCommon == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.gridy = 7;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 1;
            gridBagConstraints32.anchor = 17;
            gridBagConstraints32.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints32.gridwidth = 2;
            gridBagConstraints32.gridy = 8;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("\u30c7\u30fc\u30bf\u578b\u30de\u30c3\u30d4\u30f3\u30b0");
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridy = 9;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.gridwidth = 3;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 1;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("(\uff23\uff33\uff36\u5165\u51fa\u53ca\u3073\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u30b3\u30d4\u30fc\u6642\u306b\u4f7f\u7528\u3055\u308c\u307e\u3059)");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 7;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints31.gridy = 5;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("\u30ab\u30e9\u30e0\u5358\u4f4d\u306e\u30c6\u30ad\u30b9\u30c8\u5165\u51fa\u529b\u306e\u6587\u5b57\u30b3\u30fc\u30c9");
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridy = 3;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("NULL\u5024\u8868\u73fe\u6587\u5b57\u5217");
            this.jPanelCommon = new JPanel();
            this.jPanelCommon.setLayout(new GridBagLayout());
            this.jPanelCommon.add((Component)this.jLabel, gridBagConstraints);
            this.jPanelCommon.add((Component)this.getJTextFieldColumnOutNullValue(), gridBagConstraints1);
            this.jPanelCommon.add((Component)this.jLabel3, gridBagConstraints31);
            this.jPanelCommon.add((Component)this.getJComboBoxColumnInOutEncodeing(), gridBagConstraints7);
            this.jPanelCommon.add((Component)this.getJButtonDefaultEncodeing(), gridBagConstraints12);
            this.jPanelCommon.add((Component)this.jLabel4, gridBagConstraints11);
            this.jPanelCommon.add((Component)this.getJScrollPane(), gridBagConstraints22);
            this.jPanelCommon.add((Component)this.jLabel5, gridBagConstraints32);
        }
        return this.jPanelCommon;
    }

    private JPanel getJPanelOracle() {
        if (this.jPanelOracle == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 1;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("(DB\u30b5\u30fc\u30d0\u306e\u30bf\u30a4\u30e0\u30be\u30fc\u30f3\u3067\u3059)");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints2.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("TIMESTAMP LOCAL TIME ZONE\u578b\u306e\u30bf\u30a4\u30e0\u30be\u30fc\u30f3");
            this.jPanelOracle = new JPanel();
            this.jPanelOracle.setLayout(new GridBagLayout());
            this.jPanelOracle.add((Component)this.jLabel1, gridBagConstraints2);
            this.jPanelOracle.add((Component)this.getJTextFieldTimeZoneOfDBserver(), gridBagConstraints3);
            this.jPanelOracle.add((Component)this.jLabel2, gridBagConstraints4);
        }
        return this.jPanelOracle;
    }

    private JTextFieldEdit getJTextFieldColumnOutNullValue() {
        if (this.jTextFieldColumnOutNullValue == null) {
            this.jTextFieldColumnOutNullValue = new JTextFieldEdit();
            this.jTextFieldColumnOutNullValue.setToolTipText("\uff23\uff33\uff36\u53ca\u3073\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u6642\u306b\u4f7f\u7528\u3055\u308c\u307e\u3059");
            this.jTextFieldColumnOutNullValue.setPreferredSize(new Dimension(10, 22));
        }
        return this.jTextFieldColumnOutNullValue;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButtonSaveAndExit(), null);
            this.jPanel.add((Component)this.getJButtonNoSaveAndExit(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonSaveAndExit() {
        if (this.jButtonSaveAndExit == null) {
            this.jButtonSaveAndExit = new JButton();
            this.jButtonSaveAndExit.setText("\u4fdd\u5b58\u3057\u3066\u9589\u3058\u308b");
            this.jButtonSaveAndExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameSetting.this.datSave();
                    JFrameSetting.this.closeFrame();
                }
            });
        }
        return this.jButtonSaveAndExit;
    }

    private JButton getJButtonNoSaveAndExit() {
        if (this.jButtonNoSaveAndExit == null) {
            this.jButtonNoSaveAndExit = new JButton();
            this.jButtonNoSaveAndExit.setText("\u4fdd\u5b58\u305b\u305a\u9589\u3058\u308b");
            this.jButtonNoSaveAndExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameSetting.this.closeFrame();
                }
            });
        }
        return this.jButtonNoSaveAndExit;
    }

    private JTextFieldEdit getJTextFieldTimeZoneOfDBserver() {
        if (this.jTextFieldTimeZoneOfDBserver == null) {
            this.jTextFieldTimeZoneOfDBserver = new JTextFieldEdit();
        }
        return this.jTextFieldTimeZoneOfDBserver;
    }

    private JComboBox getJComboBoxColumnInOutEncodeing() {
        if (this.jComboBoxColumnInOutEncodeing == null) {
            this.jComboBoxColumnInOutEncodeing = new JComboBox();
            for (Charset c : Charset.availableCharsets().values()) {
                this.jComboBoxColumnInOutEncodeing.addItem(c.toString());
            }
        }
        return this.jComboBoxColumnInOutEncodeing;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableSqlMapping());
        }
        return this.jScrollPane;
    }

    private JTable getJTableSqlMapping() {
        if (this.jTableSqlMapping == null) {
            this.jTableSqlMapping = new JTable();
            this.jTableSqlMapping.setSelectionMode(0);
        }
        return this.jTableSqlMapping;
    }

    private JPopupMenuCnageUI getJPopupMenuCnageUI() {
        if (this.jPopupMenuCnageUI == null) {
            this.jPopupMenuCnageUI = new JPopupMenuCnageUI();
            this.jPopupMenuCnageUI.add(this.getJMenuItemEdit());
            this.jPopupMenuCnageUI.add(this.getJMenuItemDelete());
            this.jPopupMenuCnageUI.add(this.getJMenuItemEnable());
        }
        return this.jPopupMenuCnageUI;
    }

    private int getSelectRow() {
        int row = this.jTableSqlMapping.getSelectedRow();
        if (row == -1) {
            JDialogMessage.infoDialog("\u884c\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", "\u884c\u672a\u9078\u629e\u30a8\u30e9\u30fc");
        }
        return row;
    }

    private JMenuItem getJMenuItemEdit() {
        if (this.jMenuItemEdit == null) {
            this.jMenuItemEdit = new JMenuItem();
            this.jMenuItemEdit.setText("\u7de8\u96c6");
            this.jMenuItemEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = JFrameSetting.this.getSelectRow();
                    if (row != -1) {
                        JFrameSetting.this.tableModel.editData(row);
                    }
                }
            });
        }
        return this.jMenuItemEdit;
    }

    private JMenuItem getJMenuItemDelete() {
        if (this.jMenuItemDelete == null) {
            this.jMenuItemDelete = new JMenuItem();
            this.jMenuItemDelete.setText("\u524a\u9664");
            this.jMenuItemDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = JFrameSetting.this.getSelectRow();
                    if (row != -1) {
                        JFrameSetting.this.tableModel.delete(row);
                    }
                }
            });
        }
        return this.jMenuItemDelete;
    }

    private JMenuItem getJMenuItemEnable() {
        if (this.jMenuItemEnable == null) {
            this.jMenuItemEnable = new JMenuItem();
            this.jMenuItemEnable.setText("\u6709\u52b9/\u7121\u52b9\u306e\u5207\u66ff");
            this.jMenuItemEnable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = JFrameSetting.this.getSelectRow();
                    if (row != -1) {
                        JFrameSetting.this.tableModel.changeEnable(row);
                    }
                }
            });
        }
        return this.jMenuItemEnable;
    }

    private JButton getJButtonDefaultEncodeing() {
        if (this.jButtonDefaultEncodeing == null) {
            this.jButtonDefaultEncodeing = new JButton();
            this.jButtonDefaultEncodeing.setText("\u5b9f\u884c\u74b0\u5883\u30c7\u30d5\u30a9\u30eb\u30c8\u306b\u8a2d\u5b9a");
            this.jButtonDefaultEncodeing.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameSetting.this.jComboBoxColumnInOutEncodeing.setSelectedItem(Charset.defaultCharset().toString());
                }
            });
        }
        return this.jButtonDefaultEncodeing;
    }

    private JPanel getJPanelLogger() {
        if (this.jPanelLogger == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 0;
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Logger\u306e\u30ed\u30b0\u51fa\u529b\u30ec\u30d9\u30eb");
            this.jPanelLogger = new JPanel();
            this.jPanelLogger.setLayout(new GridBagLayout());
            this.jPanelLogger.add((Component)this.jLabel6, gridBagConstraints5);
            this.jPanelLogger.add((Component)this.getJComboBoxLoggerLevel(), gridBagConstraints6);
        }
        return this.jPanelLogger;
    }

    private JComboBox getJComboBoxLoggerLevel() {
        if (this.jComboBoxLoggerLevel == null) {
            this.jComboBoxLoggerLevel = new JComboBox();
            this.jComboBoxLoggerLevel.addItem(Level.SEVERE);
            this.jComboBoxLoggerLevel.addItem(Level.WARNING);
            this.jComboBoxLoggerLevel.addItem(Level.INFO);
            this.jComboBoxLoggerLevel.addItem(Level.CONFIG);
            this.jComboBoxLoggerLevel.addItem(Level.FINE);
            this.jComboBoxLoggerLevel.addItem(Level.FINER);
            this.jComboBoxLoggerLevel.addItem(Level.FINEST);
        }
        return this.jComboBoxLoggerLevel;
    }

    class SqlMappingTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4489565625774646866L;
        String[] header = new String[]{"\u6709\u52b9/\u7121\u52b9", "DBMS\u540d\u79f0", "DBMS\u30c7\u30fc\u30bf\u578b", "\u53d6\u5f97\u30e1\u30bd\u30c3\u30c9", "\u30c7\u30fc\u30bf\u53d6\u5f97\u30af\u30e9\u30b9\u540d", "\u30bb\u30eb\u30ec\u30f3\u30c0\u30e9\u30fc\u30af\u30e9\u30b9\u540d", "\u30bb\u30eb\u30a8\u30c7\u30a3\u30bf\u30fc\u30af\u30e9\u30b9\u540d"};
        List<SqlMappingInfo> sqlMappingList;
        private ArrayList<SqlMappingInfo> deleteList = new ArrayList();

        public SqlMappingTableModel() {
            this.sqlMappingList = new SqlMappingInfo().getInfoList();
        }

        public String getColumnName(int columnIndex) {
            return this.header[columnIndex];
        }

        public int getRowCount() {
            return this.sqlMappingList.size();
        }

        public int getColumnCount() {
            return this.header.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            SqlMappingInfo sqlMapping = this.sqlMappingList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return sqlMapping.getEnable() != false ? "\u6709\u52b9" : "\u7121\u52b9";
                }
                case 1: {
                    return sqlMapping.getDbms();
                }
                case 2: {
                    return sqlMapping.getType();
                }
                case 3: {
                    return sqlMapping.getResultSetMethodName();
                }
                case 4: {
                    return sqlMapping.getGetResultSetClassName();
                }
                case 5: {
                    return sqlMapping.getCellRendererClassName();
                }
                case 6: {
                    return sqlMapping.getCellEditorClassName();
                }
            }
            return null;
        }

        public void changeEnable(int rowIndex) {
            SqlMappingInfo sqlMapping;
            sqlMapping.setEnable((sqlMapping = this.sqlMappingList.get(rowIndex)).getEnable() == false);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public void editData(int rowIndex) {
            SqlMappingInfo sqlMapping = this.sqlMappingList.get(rowIndex);
            JFrameSqlMapping dlg = new JFrameSqlMapping();
            dlg.setSqlMappingInfo(sqlMapping);
            dlg.setVisible(true);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public void delete(int rowIndex) {
            this.deleteList.add(this.sqlMappingList.remove(rowIndex));
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void save() {
            for (SqlMappingInfo item : this.sqlMappingList) {
                item.currentDataSave();
            }
            for (SqlMappingInfo item : this.deleteList) {
                item.removeParameter();
            }
        }
    }
}

