/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jdbcacsess.csv.CSVLine;
import jdbcacsess.gui.CellEditorSqlTable;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.CellRendererSqlTable;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.gui.JTableSqlModel;
import jdbcacsess.gui.RowInsertValueMode;
import jdbcacsess.gui.cell.FileOutputBinary;
import jdbcacsess.gui.cell.FileOutputCharcter;
import jdbcacsess.gui.cell.JFrameViewerHex;
import jdbcacsess.gui.cell.JFrameViewerImage;
import jdbcacsess.gui.cell.ViewColumn;
import jdbcacsess.gui.cell.ViewerGetBinaryStream;
import jdbcacsess.gui.cell.ViewerGetBlob;
import jdbcacsess.gui.cell.ViewerGetBytes;
import jdbcacsess.gui.cell.ViewerGetChracterStream;
import jdbcacsess.gui.cell.ViewerGetString;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFileChooserLastUse;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.gui.common.PopupKeybordAndMouse;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.QueryExecuteAdapter;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.CharacterInputStream;
import jdbcacsess.sql.column.DenyEditInCell;

public class JTableSql
extends JTable
implements ClipboardOwner {
    private static final long serialVersionUID = -3304832537800845261L;
    private JPopupMenuCnageUI jPopupMenu = null;
    private JMenuItem jMenuItemSetNULL = null;
    private JMenuItem jMenuItemRowDelete = null;
    private JMenuItem jMenuItemRowInsert = null;
    private JMenuItem jMenuItemRowInsertNull = null;
    private JMenuItem jMenuItemRowCopy = null;
    private JMenuItem jMenuItemToClipRangeComma = null;
    private JMenuItem jMenuItemToClipRangeTab = null;
    private JMenuItem jMenuItemToClipRangeCond = null;
    private JMenuItem jMenuItemDefaultInsert = null;
    private JMenuItem jMenuItemSelectRow = null;
    private JMenuItem jMenuItemSelectAll = null;
    private JMenuItem jMenuItemHexGetBinaryStream = null;
    private JMenu jMenuHexViewer = null;
    private JMenuItem jMenuItemHexGetBlob = null;
    private JMenuItem jMenuItemHexGetBytes;
    private JMenu jMenuInputFile = null;
    private JMenuItem jMenuItemInputFileBinary = null;
    private JMenuItem jMenuItemInputFileChar = null;
    private JMenu jMenuOutputFile = null;
    private JMenuItem jMenuItemOutputFileBinary = null;
    private JMenuItem jMenuItemOutputFileChar = null;
    private JMenuItem jMenuItemTextEditer = null;
    private JMenuItem jMenuItemHexGetString = null;
    private JMenu jMenuImageViewer = null;
    private JMenuItem jMenuItemImageGetBinaryStream = null;
    private JMenuItem jMenuItemImageGetBlob = null;
    private JFileChooserLastUse lastOutputFile;
    private JFileChooserLastUse lastInputFile;
    private JMenuItem jMenuItemSqlMapping = null;
    JTableSql jtableSql;

    public JTableSql() {
        this.initialize();
    }

    private void initialize() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(1);
        ListSelectionModel model = this.getSelectionModel();
        model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JTableSql.this.tableSelectionValueChanged(e);
            }
        });
        new PopupKeybordAndMouse(this, (JPopupMenu)this.getJPopupMenu());
        this.jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                int row = JTableSql.this.getSelectedRow();
                int col = JTableSql.this.getSelectedColumn();
                JTableSqlModel model = (JTableSqlModel)JTableSql.this.getModel();
                CellMode cellMode = model.getMode(row, col);
                if (model.isCellEditable(row, col)) {
                    JTableSql.this.jMenuItemRowDelete.setEnabled(true);
                    JTableSql.this.jMenuItemRowCopy.setEnabled(true);
                } else {
                    if (cellMode == CellMode.CELL_INSERT) {
                        JTableSql.this.jMenuItemRowDelete.setEnabled(true);
                    } else {
                        JTableSql.this.jMenuItemRowDelete.setEnabled(false);
                    }
                    JTableSql.this.jMenuItemRowCopy.setEnabled(false);
                }
                if (model.isTableEditable()) {
                    switch (cellMode) {
                        case CELL_NON: 
                        case CELL_UPDATE: 
                        case CELL_UPDATE_COMPLETE: 
                        case CELL_INSERT: 
                        case CELL_INSERT_COMPLETE: 
                        case CELL_DENYEDIT_IN_CELL: {
                            JTableSql.this.jMenuItemSetNULL.setEnabled(true);
                            break;
                        }
                        default: {
                            JTableSql.this.jMenuItemSetNULL.setEnabled(false);
                            break;
                        }
                    }
                } else {
                    JTableSql.this.jMenuItemSetNULL.setEnabled(false);
                }
                JTableSql.this.jMenuHexViewer.setEnabled(false);
                JTableSql.this.jMenuImageViewer.setEnabled(false);
                JTableSql.this.jMenuInputFile.setEnabled(false);
                JTableSql.this.jMenuItemTextEditer.setEnabled(false);
                JTableSql.this.jMenuOutputFile.setEnabled(false);
                if (model.isTableEditable() && JTableSql.this.getSelectedRowCount() == 1 && JTableSql.this.getSelectedColumnCount() == 1) {
                    switch (cellMode) {
                        case CELL_NON: 
                        case CELL_UPDATE: 
                        case CELL_UPDATE_COMPLETE: 
                        case CELL_INSERT_COMPLETE: 
                        case CELL_DENYEDIT_IN_CELL: {
                            JTableSql.this.jMenuHexViewer.setEnabled(true);
                            JTableSql.this.jMenuImageViewer.setEnabled(true);
                            JTableSql.this.jMenuInputFile.setEnabled(true);
                            JTableSql.this.jMenuItemTextEditer.setEnabled(true);
                            JTableSql.this.jMenuOutputFile.setEnabled(true);
                        }
                    }
                }
                if (cellMode == CellMode.CELL_INSERT) {
                    JTableSql.this.jMenuItemDefaultInsert.setEnabled(true);
                    if (model.isDefaultInsert(row, col)) {
                        JTableSql.this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916\u3057\u306a\u3044");
                    } else {
                        JTableSql.this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916\u3059\u308b");
                    }
                } else {
                    JTableSql.this.jMenuItemDefaultInsert.setEnabled(false);
                }
            }
        });
        ActionMap am = this.getActionMap();
        am.put("copy", new AbstractAction(){
            private static final long serialVersionUID = 5414012911084954750L;

            public void actionPerformed(ActionEvent e) {
                JTableSql.this.actionPerformedCopyRange('\t');
            }
        });
        this.lastInputFile = new JFileChooserLastUse("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044", 0);
        this.lastOutputFile = new JFileChooserLastUse("\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044", 1);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u6240\u6709\u6a29\u3092\u5931\u3044\u307e\u3057\u305f");
    }

    private void actionPerformedCopyRange(char delim) {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        String lineSeparator = System.getProperty("line.separator");
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int[] selCols = this.getSelectedColumns();
        int[] selRows = this.getSelectedRows();
        StringBuffer selectString = new StringBuffer();
        int idxCol = 0;
        while (idxCol < selCols.length) {
            if (idxCol != 0) {
                selectString.append(delim);
            }
            selectString.append(tbl.getColumnName(selCols[idxCol]));
            ++idxCol;
        }
        selectString.append(lineSeparator);
        String nullValue = JFrameSetting.getColumnOutNullValue();
        boolean msgout = false;
        int idxRow = 0;
        while (idxRow < selRows.length) {
            CellMode cellMode = tbl.getMode(selRows[idxRow], 0);
            if (cellMode == CellMode.CELL_DELETE_COMPLETE) {
                msgout = this.msg(msgout);
            } else {
                CSVLine csvline = new CSVLine();
                csvline.setToken(delim);
                int idxCol2 = 0;
                while (idxCol2 < selCols.length) {
                    Object o = tbl.getValueAt(selRows[idxRow], selCols[idxCol2]);
                    if (o != null) {
                        csvline.addItem(o.toString());
                    } else {
                        csvline.addItem(nullValue);
                    }
                    ++idxCol2;
                }
                if (csvline.size() != 0) {
                    selectString.append(csvline.getLine()).append(lineSeparator);
                }
            }
            ++idxRow;
        }
        StringSelection ss = new StringSelection(selectString.toString());
        cb.setContents(ss, this);
    }

    private void actionPerformedCopyCond() {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        String lineSeparator = System.getProperty("line.separator");
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int[] selCols = this.getSelectedColumns();
        int[] selRows = this.getSelectedRows();
        StringBuffer selectString = new StringBuffer();
        boolean msgout = false;
        int idxRow = 0;
        while (idxRow < selRows.length) {
            CellMode cellMode = tbl.getMode(selRows[idxRow], selCols[0]);
            if (cellMode == CellMode.CELL_DELETE_COMPLETE) {
                msgout = this.msg(msgout);
            } else {
                if (idxRow != 0) {
                    selectString.append(lineSeparator);
                    selectString.append("or ");
                }
                selectString.append("(");
                int idxCol = 0;
                while (idxCol < selCols.length) {
                    if (idxCol != 0) {
                        selectString.append(" and ");
                    }
                    selectString.append(tbl.getColumnName(selCols[idxCol]));
                    Object o = tbl.getValueAt(selRows[idxRow], selCols[idxCol]);
                    if (o == null) {
                        selectString.append(" is NULL ");
                    } else {
                        selectString.append(" = ");
                        if (!Number.class.isAssignableFrom(o.getClass())) {
                            selectString.append("'");
                        }
                        selectString.append(o.toString());
                        if (!Number.class.isAssignableFrom(o.getClass())) {
                            selectString.append("'");
                        }
                    }
                    ++idxCol;
                }
                selectString.append(")");
            }
            ++idxRow;
        }
        selectString.append(lineSeparator);
        StringSelection ss = new StringSelection(selectString.toString());
        cb.setContents(ss, this);
    }

    private boolean msg(boolean msgout) {
        if (!msgout) {
            JDialogMessage.infoDialog("\u9078\u629e\u3055\u308c\u305f\u30bb\u30eb\u306e\u4e2d\u306b\u524a\u9664\u6e08\u884c\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u524a\u9664\u6e08\u884c\u306f\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u524a\u9664\u6e08\u884c\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
            msgout = true;
        }
        return msgout;
    }

    private void actionPerformedSetNULL(ActionEvent e) {
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int[] rows = this.getSelectedRows();
        int[] columns = this.getSelectedColumns();
        if (rows.length == 0 || columns.length == 0) {
            return;
        }
        tbl.setValueAt(null, rows, columns);
    }

    private void actionPerformedDefaultInsert(ActionEvent e) {
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int[] nArray = this.getSelectedColumns();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int col = nArray[n];
            int[] nArray2 = this.getSelectedRows();
            int n3 = 0;
            int n4 = nArray2.length;
            while (n3 < n4) {
                int row = nArray2[n3];
                tbl.reverseDefaultInsert(row, col);
                ++n3;
            }
            ++n;
        }
    }

    private void actionPerformedRowDelete(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowDelete(this.getSelectedRows());
    }

    private void actionPerformedRowInsert(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.VALUEROWNEW);
    }

    private void actionPerformedRowInsertNull(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.ALLNULLROWNEW);
    }

    private void actionPerformedRowCopy(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.ROWCOPY);
    }

    private void tableSelectionValueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectedRow() == -1) {
            return;
        }
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowInsert(this.getSelectedRow());
    }

    private void actionPerformedViewer(ViewColumn viewColumn) {
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.viewer(selectedRow, selectedCol, viewColumn);
    }

    private void actionPerformedFileInput(DenyEditInCell deic) {
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.setValueAt((Object)deic, selectedRow, selectedCol);
    }

    private void actionPerformedTextEditer() {
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.textEditer(selectedRow, selectedCol);
    }

    private void actionPerformedSqlMapping() {
        int selectedRow = this.getSelectedRows()[0];
        int selectedCol = this.getSelectedColumns()[0];
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.sqlMapping(selectedRow, selectedCol);
    }

    private JPopupMenuCnageUI getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenuCnageUI();
            this.jPopupMenu.add(this.getJMenuItemSetNULL());
            this.jPopupMenu.add(this.getJMenuItemDefaultInsert());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowDelete());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowInsert());
            this.jPopupMenu.add(this.getJMenuItemRowInsertNull());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowCopy());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemToClipRangeComma());
            this.jPopupMenu.add(this.getJMenuItemToClipRangeTab());
            this.jPopupMenu.add(this.getJMenuItemToClipRangeCond());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemSelectRow());
            this.jPopupMenu.add(this.getJMenuItemSelectAll());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuHexViewer());
            this.jPopupMenu.add(this.getJMenuImageViewer());
            this.jPopupMenu.add(this.getJMenuOutputFile());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemTextEditer());
            this.jPopupMenu.add(this.getJMenuInputFile());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemSqlMapping());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemSetNULL() {
        if (this.jMenuItemSetNULL == null) {
            this.jMenuItemSetNULL = new JMenuItem();
            this.jMenuItemSetNULL.setText("NULL\u306b\u66f4\u65b0");
            this.jMenuItemSetNULL.setToolTipText("SQL\u306eNULL\u5024\u306b\u66f4\u65b0\u3057\u307e\u3059");
            this.jMenuItemSetNULL.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedSetNULL(e);
                }
            });
        }
        return this.jMenuItemSetNULL;
    }

    private JMenuItem getJMenuItemRowDelete() {
        if (this.jMenuItemRowDelete == null) {
            this.jMenuItemRowDelete = new JMenuItem();
            this.jMenuItemRowDelete.setText("\u884c\u524a\u9664");
            this.jMenuItemRowDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowDelete(e);
                }
            });
        }
        return this.jMenuItemRowDelete;
    }

    private JMenuItem getJMenuItemRowInsert() {
        if (this.jMenuItemRowInsert == null) {
            this.jMenuItemRowInsert = new JMenuItem();
            this.jMenuItemRowInsert.setText("\u5024\u8a2d\u5b9a\u6e08\u884c\u633f\u5165");
            this.jMenuItemRowInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowInsert(e);
                }
            });
        }
        return this.jMenuItemRowInsert;
    }

    private JMenuItem getJMenuItemRowInsertNull() {
        if (this.jMenuItemRowInsertNull == null) {
            this.jMenuItemRowInsertNull = new JMenuItem();
            this.jMenuItemRowInsertNull.setText("null\u5024\u884c\u633f\u5165");
            this.jMenuItemRowInsertNull.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowInsertNull(e);
                }
            });
        }
        return this.jMenuItemRowInsertNull;
    }

    private JMenuItem getJMenuItemRowCopy() {
        if (this.jMenuItemRowCopy == null) {
            this.jMenuItemRowCopy = new JMenuItem();
            this.jMenuItemRowCopy.setText("\u884c\u8907\u5199");
            this.jMenuItemRowCopy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowCopy(e);
                }
            });
        }
        return this.jMenuItemRowCopy;
    }

    private JMenuItem getJMenuItemToClipRangeComma() {
        if (this.jMenuItemToClipRangeComma == null) {
            this.jMenuItemToClipRangeComma = new JMenuItem();
            this.jMenuItemToClipRangeComma.setText("\u30ab\u30f3\u30de\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc");
            this.jMenuItemToClipRangeComma.setToolTipText("<html>\u5404\u30ab\u30e9\u30e0\u3092\u30ab\u30f3\u30de\u3067\u7e4b\u3052\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u3078\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002<br>\uff11\u884c\u76ee\u306f\u30ab\u30e9\u30e0\u540d\u304c\u81ea\u52d5\u7684\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059\u3002</html>");
            this.jMenuItemToClipRangeComma.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyRange(',');
                }
            });
        }
        return this.jMenuItemToClipRangeComma;
    }

    private JMenuItem getJMenuItemToClipRangeTab() {
        if (this.jMenuItemToClipRangeTab == null) {
            this.jMenuItemToClipRangeTab = new JMenuItem();
            this.jMenuItemToClipRangeTab.setText("\u30bf\u30d6\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc CTRL+C");
            this.jMenuItemToClipRangeTab.setToolTipText("<html>\u5404\u30ab\u30e9\u30e0\u3092\u30bf\u30d6\u3067\u7e4b\u3052\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u3078\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002<br>\uff11\u884c\u76ee\u306f\u30ab\u30e9\u30e0\u540d\u304c\u81ea\u52d5\u7684\u306b\u30b3\u30d4\u30fc\u3055\u308c\u307e\u3059\u3002</html>");
            this.jMenuItemToClipRangeTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyRange('\t');
                }
            });
        }
        return this.jMenuItemToClipRangeTab;
    }

    private JMenuItem getJMenuItemToClipRangeCond() {
        if (this.jMenuItemToClipRangeCond == null) {
            this.jMenuItemToClipRangeCond = new JMenuItem();
            this.jMenuItemToClipRangeCond.setText("\u6761\u4ef6\u5f0f\u3067\u30b3\u30d4\u30fc");
            this.jMenuItemToClipRangeCond.setToolTipText("<html>\u30ab\u30e9\u30e0\u540d=\u5024\u306eand\u6761\u4ef6\u3068\u3057\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u3078\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002</html>");
            this.jMenuItemToClipRangeCond.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyCond();
                }
            });
        }
        return this.jMenuItemToClipRangeCond;
    }

    private JMenuItem getJMenuItemDefaultInsert() {
        if (this.jMenuItemDefaultInsert == null) {
            this.jMenuItemDefaultInsert = new JMenuItem();
            this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916");
            this.jMenuItemDefaultInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedDefaultInsert(e);
                }
            });
        }
        return this.jMenuItemDefaultInsert;
    }

    private JMenuItem getJMenuItemSelectRow() {
        if (this.jMenuItemSelectRow == null) {
            this.jMenuItemSelectRow = new JMenuItem();
            this.jMenuItemSelectRow.setText("\u884c\u9078\u629e");
            this.jMenuItemSelectRow.setToolTipText("\u30bb\u30eb\u9078\u629e\u3092\u884c\u9078\u629e\u3078\u62e1\u5927\u3057\u307e\u3059\u3002");
            this.jMenuItemSelectRow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.setColumnSelectionInterval(0, JTableSql.this.getColumnCount() - 1);
                }
            });
        }
        return this.jMenuItemSelectRow;
    }

    private JMenuItem getJMenuItemSelectAll() {
        if (this.jMenuItemSelectAll == null) {
            this.jMenuItemSelectAll = new JMenuItem();
            this.jMenuItemSelectAll.setText("\u5168\u3066\u9078\u629e");
            this.jMenuItemSelectAll.setToolTipText("<html>\u691c\u7d22\u53d6\u5f97\u6e08\u30c7\u30fc\u30bf\u306e\u5168\u3066\u3092\u9078\u629e\u3057\u307e\u3059\u3002<br>\u7d99\u7d9a\u53d6\u5f97\u3059\u3079\u304d\u30c7\u30fc\u30bf\u304c\u6b8b\u3063\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u305d\u306e\u5206\u306f\u9078\u629e\u3055\u308c\u307e\u305b\u3093\u3002</html>");
            this.jMenuItemSelectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.selectAll();
                }
            });
        }
        return this.jMenuItemSelectAll;
    }

    private JMenu getJMenuHexViewer() {
        if (this.jMenuHexViewer == null) {
            this.jMenuHexViewer = new JMenu();
            this.jMenuHexViewer.setText("\u30d0\u30a4\u30ca\u30ea\u30d3\u30e5\u30fc\u30ef\u753b\u9762\u3067\u8868\u793a");
            this.jMenuHexViewer.setToolTipText("<html>\uff11\uff16\u9032\u6587\u5b57\u5217\u3067\uff11\u30d0\u30a4\u30c8\u305a\u3064\u8868\u793a\u3057\u307e\u3059\u3002<br>\u66f4\u65b0\u306f\u753b\u9762\u304b\u3089\u306f\u51fa\u6765\u306a\u3044\u306e\u3067\u3001\u300e\u30ab\u30e9\u30e0\u66f4\u65b0(\u30d5\u30a1\u30a4\u30eb\u304b\u3089)\u300f\u3067\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002</html>");
            this.jMenuHexViewer.add(this.getJMenuItemHexGetBinaryStream());
            this.jMenuHexViewer.add(this.getJMenuItemHexGetBlob());
            this.jMenuHexViewer.add(this.getJMenuItemHexGetBytes());
            this.jMenuHexViewer.add(this.getJMenuItemHexGetString());
        }
        return this.jMenuHexViewer;
    }

    private JMenuItem getJMenuItemHexGetBinaryStream() {
        if (this.jMenuItemHexGetBinaryStream == null) {
            this.jMenuItemHexGetBinaryStream = new JMenuItem();
            this.jMenuItemHexGetBinaryStream.setText("\u30d0\u30a4\u30ca\u30ea[getBinaryStream()]...");
            this.jMenuItemHexGetBinaryStream.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedViewer(new ViewerGetBinaryStream(JFrameViewerHex.getInstance()));
                }
            });
        }
        return this.jMenuItemHexGetBinaryStream;
    }

    private JMenuItem getJMenuItemHexGetBlob() {
        if (this.jMenuItemHexGetBlob == null) {
            this.jMenuItemHexGetBlob = new JMenuItem();
            this.jMenuItemHexGetBlob.setText("\u30d0\u30a4\u30ca\u30ea[getBlob()]...");
            this.jMenuItemHexGetBlob.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedViewer(new ViewerGetBlob(JFrameViewerHex.getInstance()));
                }
            });
        }
        return this.jMenuItemHexGetBlob;
    }

    private JMenuItem getJMenuItemHexGetBytes() {
        if (this.jMenuItemHexGetBytes == null) {
            this.jMenuItemHexGetBytes = new JMenuItem();
            this.jMenuItemHexGetBytes.setText("\u30d0\u30a4\u30ca\u30ea[getBytes()]...");
            this.jMenuItemHexGetBytes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedViewer(new ViewerGetBytes(JFrameViewerHex.getInstance()));
                }
            });
        }
        return this.jMenuItemHexGetBytes;
    }

    private JMenuItem getJMenuItemHexGetString() {
        if (this.jMenuItemHexGetString == null) {
            this.jMenuItemHexGetString = new JMenuItem();
            this.jMenuItemHexGetString.setText("\u30c6\u30ad\u30b9\u30c8[getString()]...");
            this.jMenuItemHexGetString.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedViewer(new ViewerGetString(JFrameViewerHex.getInstance()));
                }
            });
        }
        return this.jMenuItemHexGetString;
    }

    private JMenu getJMenuOutputFile() {
        if (this.jMenuOutputFile == null) {
            this.jMenuOutputFile = new JMenu();
            this.jMenuOutputFile.setText("\u30ab\u30e9\u30e0\u51fa\u529b(\u30d5\u30a1\u30a4\u30eb\u3078)");
            this.jMenuOutputFile.setToolTipText("\uff11\u30ab\u30e9\u30e0select\u3092\u518d\u767a\u884c\u3057\u3066\u3001\u7d50\u679c\u3092\uff11\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u307f\u307e\u3059");
            this.jMenuOutputFile.add(this.getJMenuItemOutputFileBinary());
            this.jMenuOutputFile.add(this.getJMenuItemOutputFileChar());
        }
        return this.jMenuOutputFile;
    }

    private JMenuItem getJMenuItemOutputFileBinary() {
        if (this.jMenuItemOutputFileBinary == null) {
            this.jMenuItemOutputFileBinary = new JMenuItem();
            this.jMenuItemOutputFileBinary.setText("\u30d0\u30a4\u30ca\u30ea[getBinaryStream()]...");
            this.jMenuItemOutputFileBinary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File f = JTableSql.this.lastOutputFile.choice();
                    if (f != null) {
                        JTableSql.this.actionPerformedViewer(new ViewerGetBinaryStream(new FileOutputBinary(f)));
                    }
                }
            });
        }
        return this.jMenuItemOutputFileBinary;
    }

    private JMenuItem getJMenuItemOutputFileChar() {
        if (this.jMenuItemOutputFileChar == null) {
            this.jMenuItemOutputFileChar = new JMenuItem();
            this.jMenuItemOutputFileChar.setText("\u30c6\u30ad\u30b9\u30c8[getCharacterStream()]...");
            this.jMenuItemOutputFileChar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File f = JTableSql.this.lastOutputFile.choice();
                    if (f != null) {
                        JTableSql.this.actionPerformedViewer(new ViewerGetChracterStream(new FileOutputCharcter(f)));
                    }
                }
            });
        }
        return this.jMenuItemOutputFileChar;
    }

    private JMenuItem getJMenuItemTextEditer() {
        if (this.jMenuItemTextEditer == null) {
            this.jMenuItemTextEditer = new JMenuItem();
            this.jMenuItemTextEditer.setText("\u30c6\u30ad\u30b9\u30c8\u7de8\u96c6...");
            this.jMenuItemTextEditer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedTextEditer();
                }
            });
        }
        return this.jMenuItemTextEditer;
    }

    private JMenu getJMenuInputFile() {
        if (this.jMenuInputFile == null) {
            this.jMenuInputFile = new JMenu();
            this.jMenuInputFile.setText("\u30ab\u30e9\u30e0\u66f4\u65b0(\u30d5\u30a1\u30a4\u30eb\u304b\u3089)");
            this.jMenuInputFile.setToolTipText("\uff11\u30d5\u30a1\u30a4\u30eb\u5206\u306e\u5185\u5bb9\u5168\u4f53\u3067\u3001\uff11\u30ab\u30e9\u30e0update\u3092\u767a\u884c\u3057\u307e\u3059");
            this.jMenuInputFile.add(this.getJMenuItemInputFileBinary());
            this.jMenuInputFile.add(this.getJMenuItemInputFileChar());
        }
        return this.jMenuInputFile;
    }

    private JMenuItem getJMenuItemInputFileBinary() {
        if (this.jMenuItemInputFileBinary == null) {
            this.jMenuItemInputFileBinary = new JMenuItem();
            this.jMenuItemInputFileBinary.setText("\u30d0\u30a4\u30ca\u30ea[setBinaryStream()]...");
            this.jMenuItemInputFileBinary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File f = JTableSql.this.lastInputFile.choice();
                    if (f != null) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(f);
                        }
                        catch (FileNotFoundException e1) {
                            e1.printStackTrace();
                        }
                        BinaryInputStream deic = new BinaryInputStream(new BufferedInputStream(fis), (int)f.length());
                        JTableSql.this.actionPerformedFileInput(deic);
                    }
                }
            });
        }
        return this.jMenuItemInputFileBinary;
    }

    private JMenuItem getJMenuItemInputFileChar() {
        if (this.jMenuItemInputFileChar == null) {
            this.jMenuItemInputFileChar = new JMenuItem();
            this.jMenuItemInputFileChar.setText("\u30c6\u30ad\u30b9\u30c8[setCharacterStream]...");
            this.jMenuItemInputFileChar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File f = JTableSql.this.lastInputFile.choice();
                    if (f != null) {
                        InputStreamReader isr = null;
                        try {
                            isr = new InputStreamReader((InputStream)new FileInputStream(f), JFrameSetting.getColumnInOutEncodeing());
                        }
                        catch (UnsupportedEncodingException e1) {
                            e1.printStackTrace();
                        }
                        catch (FileNotFoundException e1) {
                            e1.printStackTrace();
                        }
                        CharacterInputStream deic = new CharacterInputStream(new BufferedReader(isr), (int)f.length());
                        JTableSql.this.actionPerformedFileInput(deic);
                    }
                }
            });
        }
        return this.jMenuItemInputFileChar;
    }

    private JMenu getJMenuImageViewer() {
        if (this.jMenuImageViewer == null) {
            this.jMenuImageViewer = new JMenu();
            this.jMenuImageViewer.setText("\u753b\u50cf\u30d3\u30e5\u30fc\u30ef\u753b\u9762\u3067\u8868\u793a");
            this.jMenuImageViewer.add(this.getJMenuItemImageGetBinaryStream());
            this.jMenuImageViewer.add(this.getJMenuItemImageGetBlob());
        }
        return this.jMenuImageViewer;
    }

    private JMenuItem getJMenuItemImageGetBinaryStream() {
        if (this.jMenuItemImageGetBinaryStream == null) {
            this.jMenuItemImageGetBinaryStream = new JMenuItem();
            this.jMenuItemImageGetBinaryStream.setText("\u30d0\u30a4\u30ca\u30ea[getBinaryStream()]...");
            this.jMenuItemImageGetBinaryStream.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedViewer(new ViewerGetBinaryStream(JFrameViewerImage.getInstance()));
                }
            });
        }
        return this.jMenuItemImageGetBinaryStream;
    }

    private JMenuItem getJMenuItemImageGetBlob() {
        if (this.jMenuItemImageGetBlob == null) {
            this.jMenuItemImageGetBlob = new JMenuItem();
            this.jMenuItemImageGetBlob.setText("\u30d0\u30a4\u30ca\u30ea[getBlob()]...");
            this.jMenuItemImageGetBlob.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedViewer(new ViewerGetBlob(JFrameViewerImage.getInstance()));
                }
            });
        }
        return this.jMenuItemImageGetBlob;
    }

    private JMenuItem getJMenuItemSqlMapping() {
        if (this.jMenuItemSqlMapping == null) {
            this.jMenuItemSqlMapping = new JMenuItem();
            this.jMenuItemSqlMapping.setText("SQL\u30c7\u30fc\u30bf\u578b\u30de\u30c3\u30d4\u30f3\u30b0...");
            this.jMenuItemSqlMapping.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedSqlMapping();
                }
            });
        }
        return this.jMenuItemSqlMapping;
    }

    public void insertMenuItem(Component menuItem, int index) {
        this.jPopupMenu.insert(menuItem, index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class registCellRendererAndEditor
    extends QueryExecuteAdapter {
        @Override
        public void setResultHeader(Vector<ColumnInfoResult> rowData, SqlAnalyze sqlAnalyze) {
            Enumeration<TableColumn> cols = JTableSql.this.getColumnModel().getColumns();
            int idx = 0;
            while (cols.hasMoreElements()) {
                TableColumn col = cols.nextElement();
                TableCellRenderer renderer = rowData.get(idx).getTableCellRenderer();
                if (renderer == null) {
                    col.setCellRenderer(new CellRendererSqlTable());
                } else {
                    col.setCellRenderer(renderer);
                }
                TableCellEditor editor = rowData.get(idx).getTableCellEditor();
                if (editor == null) {
                    col.setCellEditor(new CellEditorSqlTable());
                } else {
                    col.setCellEditor(editor);
                }
                ++idx;
            }
        }
    }
}

