/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import jdbcacsess.SettingFile;
import org.w3c.dom.Element;

public class ComponentProperty {
    Element element;
    SettingFile xml;
    private String attrKey = null;
    private String attrValue = null;

    public ComponentProperty() {
        this.init();
    }

    public void appendCondition(String attrKey, String attrValue) {
        this.attrKey = attrKey;
        this.attrValue = attrValue;
    }

    private void init() {
        this.xml = SettingFile.getInstance();
        this.element = this.xml.getRootElement("component2");
    }

    public void put(Class c, String key, String value) {
        Element guiElement = this.findAttr(c);
        if (guiElement == null) {
            guiElement = this.xml.createElement("window");
            guiElement.setAttribute("name", c.getName());
            if (this.attrKey != null) {
                guiElement.setAttribute(this.attrKey, this.attrValue);
            }
            this.element.appendChild(guiElement);
        }
        guiElement.setAttribute(key, value);
    }

    public void put(Class c, String key, Integer value) {
        this.put(c, key, value.toString());
    }

    public void storeWindowPosition(Component component) {
        Class<?> c = component.getClass();
        this.put(c, "height", component.getSize().height);
        this.put(c, "width", component.getSize().width);
        this.put(c, "x", component.getLocation().x);
        this.put(c, "y", component.getLocation().y);
    }

    public String getToString(Class c, String key) {
        Element guiElement = this.findAttr(c);
        if (guiElement == null) {
            return "";
        }
        return guiElement.getAttribute(key);
    }

    public Integer getToInteger(Class c, String key) {
        Integer i = null;
        try {
            i = new Integer(this.getToString(c, key));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public void restoreWindowPosition(Component component, Integer width, Integer height) {
        Class<?> c = component.getClass();
        Integer widthInt = this.getToInteger(c, "width");
        Integer heightInt = this.getToInteger(c, "height");
        Integer xInt = this.getToInteger(c, "x");
        Integer yInt = this.getToInteger(c, "y");
        this.setWin(component, width, height, widthInt, heightInt, xInt, yInt);
    }

    private Element findAttr(Class c) {
        Element guiElement = null;
        guiElement = this.attrKey == null ? SettingFile.getElementSearchingAttribute(this.element, "window", "name", c.getName()) : SettingFile.getElementSearchingAttribute2(this.element, "window", "name", c.getName(), this.attrKey, this.attrValue);
        return guiElement;
    }

    private void setWin(Component component, Integer width, Integer height, Integer widthInt, Integer heightInt, Integer xInt, Integer yInt) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (heightInt == null || widthInt == null || xInt == null || yInt == null) {
            if (height > screenSize.height) {
                height = screenSize.height;
            }
            if (width > screenSize.width) {
                width = screenSize.width;
            }
            component.setSize(new Dimension(width, height));
            component.setLocation(0, 0);
        } else {
            component.setSize(new Dimension(widthInt, heightInt));
            component.setLocation(xInt, yInt);
        }
    }
}

