/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTableName
implements Comparable<SchemaTableName> {
    private String schemaName;
    private String tableName;

    public SchemaTableName() {
        this.schemaName = "";
        this.tableName = "";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTableName other = (SchemaTableName)obj;
        return other.getSchemaName().equals(this.schemaName) && other.getTableName().equals(this.tableName);
    }

    public int hashCode() {
        return new String(String.valueOf(this.schemaName) + this.tableName).hashCode();
    }

    public SchemaTableName(String completeTableName) {
        if (completeTableName == null) {
            this.schemaName = "";
            this.tableName = "";
            return;
        }
        int idx = (completeTableName = completeTableName.trim()).indexOf(46);
        if (idx == -1) {
            this.schemaName = "";
            this.tableName = completeTableName;
            this.conv();
            return;
        }
        this.schemaName = completeTableName.substring(0, idx);
        this.tableName = completeTableName.substring(idx + 1);
        this.conv();
    }

    public SchemaTableName(String schemaName, String tableName) {
        this.schemaName = schemaName == null ? "" : schemaName.trim();
        this.tableName = tableName == null ? "" : tableName.trim();
        this.conv();
    }

    private void conv() {
        this.tableName = SqlExec.convertStoresIdentifiers(this.tableName);
        this.schemaName = SqlExec.convertStoresIdentifiers(this.schemaName);
    }

    public String getCompleteTableName() {
        if (this.schemaName.equals("")) {
            return this.tableName;
        }
        return String.valueOf(this.schemaName) + "." + this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return this.getCompleteTableName();
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public int compareTo(SchemaTableName o) {
        return this.getCompleteTableName().compareTo(o.getCompleteTableName());
    }
}

