/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.createdata;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import jdbcacsess.JTextFieldEdit;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.SettingFile;
import jdbcacsess.createdata.CellRendererColumns;
import jdbcacsess.createdata.ColumnsTableModel;
import jdbcacsess.createdata.JPanelCreateData;
import jdbcacsess.createdata.JPanelDateTime;
import jdbcacsess.createdata.JPanelDefault;
import jdbcacsess.createdata.JPanelFixList;
import jdbcacsess.createdata.JPanelSelectResult;
import jdbcacsess.createdata.JPanelSequence;
import jdbcacsess.csv.CsvExport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInputDataView;
import jdbcacsess.csv.CsvInputImportToDB;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.csv.JFrameImportHistory;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.common.ColumnWidth;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFrameBase;
import jdbcacsess.gui.common.JTextAreaNoEdit;
import jdbcacsess.sql.PrepareExecuteStatement;
import jdbcacsess.sql.QueryExecuteAdapter;
import jdbcacsess.sql.QueryExecuteSync;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFrameCreateDataSetting
extends JFrameBase {
    private static final String CREATEDATA_VER_OLD = "Ver 1.0.1";
    private static final String CREATEDATA_VER = "Ver 1.1.0";
    private static final long serialVersionUID = -2532898130845637801L;
    private JPanel jContentPane = null;
    private JTable jTable = null;
    private ColumnsTableModel columnsTableModel = null;
    private JPanel jPanel = null;
    private JComboBox jComboBox = null;
    private JButton jButtonApply = null;
    private JPanel jPanel1 = null;
    private JPanel jPanelCreateDataBase = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabelColumnName = null;
    private JPanelCreateData jPanelCreateDataCurrent;
    private Map<String, JPanelCreateData> createDataMap;
    private JButton jButtonCsvOutput = null;
    private JPanel jPanel3 = null;
    private SchemaTableName schemaTableName;
    private JButton jButtonRead = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanel4 = null;
    private JPanel jPanel5 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JTextAreaNoEdit jTextAreaNoEditSettingFileName = null;
    private JTextFieldEdit jTextFieldCreateCount = null;
    private JButton jButtonCsvImportHistory = null;
    private JButton jButtonDataView = null;
    private JButton jButtonCsvImport = null;
    private JLabel jLabel2 = null;
    private CsvInfo csvInfo;
    private ComponentProperty cp;
    private JPanel jPanel6 = null;
    private JPanel jPanel7 = null;
    private JLabel jLabel7 = null;
    private JButton jButtonSqlValidate = null;
    private JTextFieldEdit jTextFieldFetchCount = null;
    private JTextPaneSqlStatement jTextPaneSqlStatement = null;
    TreeMap<Integer, String> columnMap = new TreeMap();
    private JPanel jPanel8 = null;
    private JRadioButton jRadioButtonOneClick = null;
    private JRadioButton jRadioButtonTwoClick = null;
    private JCheckBox jCheckBoxFetchEnd = null;
    private JTextAreaNoEdit jTextAreaNoEditTableName = null;
    private JSplitPane jSplitPane1 = null;
    private JScrollPane jScrollPane1 = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel2 = null;
    private JPanel jPanel9 = null;

    public JFrameCreateDataSetting(SchemaTableName name) {
        String twoClick;
        String oneClick;
        Integer divider1;
        this.schemaTableName = name;
        this.createDataMap = new HashMap<String, JPanelCreateData>();
        JPanelCreateData cd = new JPanelSequence();
        this.createDataMap.put(cd.toString(), cd);
        cd = new JPanelFixList();
        this.createDataMap.put(cd.toString(), cd);
        cd = new JPanelDateTime();
        this.createDataMap.put(cd.toString(), cd);
        cd = new JPanelDefault();
        this.createDataMap.put(cd.toString(), cd);
        JPanelSelectResult cd2 = new JPanelSelectResult();
        cd2.setColumnMap(this.columnMap);
        this.createDataMap.put(cd2.toString(), cd2);
        this.setTitle("\u30c7\u30fc\u30bf\u751f\u6210 " + this.schemaTableName.getCompleteTableName());
        this.initialize();
        this.cp = this.init("table", this.schemaTableName.getCompleteTableName());
        Integer divider = this.cp.getToInteger(this.getClass(), "divider");
        if (divider != null) {
            this.jSplitPane.setDividerLocation(divider);
        }
        if ((divider1 = this.cp.getToInteger(this.getClass(), "divider1")) != null) {
            this.jSplitPane1.setDividerLocation(divider1);
        }
        if ((oneClick = this.cp.getToString(this.getClass(), "oneClick")) != null) {
            this.jRadioButtonOneClick.setSelected(new Boolean(oneClick));
        }
        if ((twoClick = this.cp.getToString(this.getClass(), "twoClick")) != null) {
            this.jRadioButtonTwoClick.setSelected(new Boolean(twoClick));
        }
        this.csvInfo = new CsvInfo();
        this.csvInfo.currentDataLoad();
        this.guideMessageDisplay(false);
        this.jTextPaneSqlStatement.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                JFrameCreateDataSetting.this.guideMessageDisplay(true);
            }

            public void focusLost(FocusEvent e) {
                JFrameCreateDataSetting.this.guideMessageDisplay(false);
            }
        });
    }

    private void guideMessageDisplay(boolean onlyClear) {
        String ttt = this.jTextPaneSqlStatement.getText().replaceAll("[\n\r\t ]", "");
        if (ttt.equals("")) {
            this.jTextPaneSqlStatement.setText("");
            if (!onlyClear) {
                JLabel jlabel = new JLabel("<html>\u751f\u6210\u624b\u9806\u300eSELECT\u7d50\u679c\u300f\u3092\u6307\u793a\u3059\u308b\u5834\u5408\u306f\u3001\u3053\u3053\u306bSQL\u6587\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002\u5165\u529b\u304c\u7d42\u3063\u305f\u3089\u300e" + this.jButtonSqlValidate.getText() + "\u300f\u30dc\u30bf\u30f3\u3067\u3001SQL\u6587\u30c1\u30a7\u30c3\u30af\u53ca\u3073\u30ab\u30e9\u30e0\u60c5\u5831\u53d6\u5f97\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002</html>");
                jlabel.setFont(jlabel.getFont().deriveFont(0, 10.0f));
                this.jTextPaneSqlStatement.insertComponent(jlabel);
            }
        }
    }

    private void initialize() {
        this.setSize(new Dimension(700, 550));
        this.setContentPane(this.getJContentPane());
        this.jTextFieldCreateCount.setText("1");
        this.jTextAreaNoEditSettingFileName.setText(this.getSettingFileName());
        for (String str : this.createDataMap.keySet()) {
            this.jComboBox.addItem(str);
        }
        try {
            this.columnsTableModel = new ColumnsTableModel();
            this.columnsTableModel.setTableName(this.schemaTableName);
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30c7\u30fc\u30bf\u751f\u6210\u3067\u30c6\u30fc\u30d6\u30eb\u60c5\u5831\u53d6\u5f97");
            return;
        }
        this.jTable.setModel(this.columnsTableModel);
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(new CellRendererColumns());
        this.jTable.setSelectionMode(0);
        if (this.isExistsSettingFine()) {
            this.createDataRead(this.getSettingFileName());
        }
        this.jTable.setRowSelectionInterval(0, 0);
        this.selectTableRow(0);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        ColumnWidth.setColumnWidthResizeOff(this.jTable);
    }

    private void createDataRead(String f) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            XMLDecoder d = new XMLDecoder(in);
            try {
                String version = (String)d.readObject();
                if (CREATEDATA_VER_OLD.equals(version)) {
                    SchemaTableName tableName = (SchemaTableName)d.readObject();
                    this.columnsTableModel.setCreateDataMap(this.readObject(d));
                    this.jTextFieldCreateCount.setText(((JTextFieldEdit)d.readObject()).getText());
                    System.out.println("\u30c6\u30fc\u30d6\u30eb\u751f\u6210\u624b\u9806\u8aad\u307f\u8fbc\u307f:" + tableName + " " + version);
                } else if (CREATEDATA_VER.equals(version)) {
                    SchemaTableName tableName = (SchemaTableName)d.readObject();
                    this.columnsTableModel.setCreateDataMap(this.readObject(d));
                    this.jTextFieldCreateCount.setText((String)d.readObject());
                    this.jTextFieldFetchCount.setText((String)d.readObject());
                    this.jTextPaneSqlStatement.setText((String)d.readObject());
                    this.jCheckBoxFetchEnd.setSelected((Boolean)d.readObject());
                    System.out.println("\u30c6\u30fc\u30d6\u30eb\u751f\u6210\u624b\u9806\u8aad\u307f\u8fbc\u307f:" + tableName + " " + version);
                } else {
                    JDialogMessage.infoDialog("\u65e7\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u751f\u6210\u624b\u9806\u306e\u305f\u3081\u3001\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002", "\u30a8\u30e9\u30fc");
                }
            }
            catch (Exception e) {
                JDialogMessage.errorDialog(e);
            }
            d.close();
            this.columnsTableModel.fireTableRowsUpdated(0, this.columnsTableModel.getRowCount() - 1);
        }
        catch (FileNotFoundException e1) {
            JDialogMessage.errorDialog(e1);
        }
    }

    private boolean isExistsSettingFine() {
        return new File(this.getSettingFileName()).isFile();
    }

    private Map<String, JPanelCreateData> readObject(XMLDecoder d) {
        return (Map)d.readObject();
    }

    private void selectTableRow(int rowIdx) {
        this.jLabelColumnName.setText((String)this.columnsTableModel.getValueAt(rowIdx, 0));
        JPanelCreateData jpcd = this.columnsTableModel.getJPanelCreateData(rowIdx);
        JPanelCreateData jpcdCopy = jpcd.copy();
        this.createDataMap.put(jpcd.toString(), jpcdCopy);
        this.jComboBox.setSelectedItem(jpcd.toString());
        this.changePanelCreateData(jpcdCopy);
    }

    private void changePanelCreateData(JPanelCreateData jpcd) {
        this.jPanelCreateDataBase.setVisible(false);
        this.jPanelCreateDataBase.removeAll();
        this.jPanelCreateDataBase.add((Component)jpcd, "Center");
        this.jPanelCreateDataBase.setVisible(true);
        this.getJContentPane().revalidate();
        this.jPanelCreateDataCurrent = jpcd;
    }

    protected void actionPerformedApply(ActionEvent e) {
        if (!this.jPanelCreateDataCurrent.isVisible()) {
            return;
        }
        int[] indexs = this.jTable.getSelectedRows();
        int i = 0;
        while (i < indexs.length) {
            JPanelCreateData newJpcd = this.jPanelCreateDataCurrent.copy();
            if (newJpcd == null) {
                return;
            }
            this.columnsTableModel.setJPanelCreateData(indexs[i], newJpcd);
            ++i;
        }
    }

    private void actionPerformedRead() {
        JFileChooser jFileChooser = new JFileChooser(this.getSettingPathName());
        private class FileFilterEx
        extends FileFilter {
            private String extension;
            private String msg;

            public FileFilterEx(String extension, String msg) {
                this.extension = extension;
                this.msg = msg;
            }

            public boolean accept(File f) {
                return f.getName().endsWith(this.extension);
            }

            public String getDescription() {
                return this.msg;
            }
        }
        FileFilterEx ff = new FileFilterEx(".xml", "XML \u30d5\u30a1\u30a4\u30eb(*.xml)");
        jFileChooser.addChoosableFileFilter(ff);
        jFileChooser.setFileFilter(ff);
        jFileChooser.setMultiSelectionEnabled(false);
        int ans = jFileChooser.showOpenDialog(this);
        if (ans == 0) {
            this.createDataRead(jFileChooser.getSelectedFile().getPath());
        }
    }

    protected void actionPerformmedCsvOutput() {
        int creatCnt = 0;
        try {
            creatCnt = new Integer(this.jTextFieldCreateCount.getText());
        }
        catch (NumberFormatException e2) {
            JDialogMessage.errorDialog(e2);
            return;
        }
        this.csvInfo.setPropTableName(this.schemaTableName);
        JDialogCsv dlg = new JDialogCsv(CsvMode.CREATEDATA, this.csvInfo);
        CsvInfo ci = dlg.getCsvInfo();
        if (ci == null) {
            return;
        }
        this.csvInfo = ci;
        this.columnsTableModel.removeOutputQueryExecuteListeners();
        this.columnsTableModel.addOutputQueryExecuteListener(new CsvExport(this.csvInfo));
        SelectQueryExecute selectQueryExecute = null;
        int i = 0;
        while (i < this.columnsTableModel.getRowCount()) {
            if (this.columnsTableModel.getJPanelCreateData(i) instanceof JPanelSelectResult) {
                JPanelSelectResult new_name = (JPanelSelectResult)this.columnsTableModel.getJPanelCreateData(i);
                if (selectQueryExecute == null) {
                    try {
                        selectQueryExecute = new SelectQueryExecute();
                    }
                    catch (JdbcacsessException e) {
                        JDialogMessage.errorDialog(e);
                        return;
                    }
                }
                selectQueryExecute.addQueryExecuteListener(new_name);
            }
            ++i;
        }
        try {
            try {
                boolean fetchEnd = false;
                int realOutputCnt = 0;
                this.columnsTableModel.initOutput();
                int rowCnt = 0;
                while (rowCnt < creatCnt) {
                    if (selectQueryExecute != null && !fetchEnd) {
                        boolean bl = fetchEnd = !selectQueryExecute.next();
                        if (fetchEnd && this.jCheckBoxFetchEnd.isSelected()) break;
                    }
                    ++realOutputCnt;
                    this.columnsTableModel.detailOutput();
                    ++rowCnt;
                }
                this.columnsTableModel.endOutput(realOutputCnt);
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
            catch (JdbcacsessException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        finally {
            if (selectQueryExecute != null) {
                try {
                    selectQueryExecute.end();
                }
                catch (JdbcacsessException e) {
                    JDialogMessage.errorDialog(e);
                }
            }
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.getSettingFileName()));
            XMLEncoder e = new XMLEncoder(out);
            e.writeObject(CREATEDATA_VER);
            e.writeObject(this.schemaTableName);
            e.writeObject(this.columnsTableModel.getCreateDataMap());
            e.writeObject(this.jTextFieldCreateCount.getText());
            e.writeObject(this.jTextFieldFetchCount.getText());
            e.writeObject(this.jTextPaneSqlStatement.getText());
            e.writeObject(this.jCheckBoxFetchEnd.isSelected());
            e.close();
        }
        catch (FileNotFoundException e) {
            JDialogMessage.errorDialog(e);
        }
    }

    private void actionPerformedCsvImport() {
        this.csvInfo.setPropTableName(this.schemaTableName);
        JDialogCsv dlg = new JDialogCsv(CsvMode.IMPORT, this.csvInfo);
        CsvInfo ci = dlg.getCsvInfo();
        if (ci == null) {
            return;
        }
        this.csvInfo = ci;
        new Thread(new CsvInputImportToDB(this.csvInfo)).start();
    }

    private String getSettingPathName() {
        return SettingFile.getInstance().getFileName("createData");
    }

    private String getSettingFileName() {
        String userPath = this.getSettingPathName();
        File path = new File(userPath);
        if (!path.isDirectory()) {
            path.mkdir();
        }
        String s = String.valueOf(userPath) + System.getProperty("file.separator") + this.schemaTableName.getCompleteTableName() + ".xml";
        return s;
    }

    @Override
    public void frameClosing() {
        this.cp.put(this.getClass(), "divider", this.jSplitPane.getDividerLocation());
        this.cp.put(this.getClass(), "divider1", this.jSplitPane1.getDividerLocation());
        this.cp.put(this.getClass(), "oneClick", new Boolean(this.jRadioButtonOneClick.isSelected()).toString());
        this.cp.put(this.getClass(), "twoClick", new Boolean(this.jRadioButtonTwoClick.isSelected()).toString());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel3(), "South");
            this.jContentPane.add((Component)this.getJPanel6(), "Center");
        }
        return this.jContentPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setAutoResizeMode(0);
            this.jTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == (JFrameCreateDataSetting.this.jRadioButtonTwoClick.isSelected() ? 2 : 1)) {
                        System.out.println("JFrameCreateDataSetting#mouseClicked:start");
                        JFrameCreateDataSetting.this.selectTableRow(JFrameCreateDataSetting.this.jTable.rowAtPoint(e.getPoint()));
                        System.out.println("JFrameCreateDataSetting#mouseClicked:end");
                    }
                }
            });
        }
        return this.jTable;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, "\u5404\u30ab\u30e9\u30e0\u306e\u30c7\u30fc\u30bf\u751f\u6210\u65b9\u6cd5", 0, 0, new Font("Dialog", 0, 12), Color.black));
            this.jPanel.add((Component)this.getJPanel1(), "North");
            this.jPanel.add((Component)this.getJPanelCreateDataBase(), "Center");
        }
        return this.jPanel;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setName("jComboBox");
            this.jComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    JFrameCreateDataSetting.this.changePanelCreateData((JPanelCreateData)JFrameCreateDataSetting.this.createDataMap.get((String)e.getItem()));
                }
            });
        }
        return this.jComboBox;
    }

    private JButton getJButtonApply() {
        if (this.jButtonApply == null) {
            this.jButtonApply = new JButton();
            this.jButtonApply.setText("\u9069\u7528");
            this.jButtonApply.setToolTipText("\u9078\u629e\u3055\u308c\u3066\u3044\u308b\u30ab\u30e9\u30e0\u884c\u5168\u3066\u306b\u53cd\u6620\u3057\u307e\u3059");
            this.jButtonApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedApply(e);
                }
            });
        }
        return this.jButtonApply;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 2;
            gridBagConstraints17.insets = new Insets(0, 0, 0, 15);
            gridBagConstraints17.gridwidth = 1;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.ipadx = 7;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.ipady = 5;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.ipadx = 11;
            gridBagConstraints1.ipady = 5;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.insets = new Insets(0, 3, 5, 5);
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipady = 5;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.jLabelColumnName = new JLabel();
            this.jLabelColumnName.setText(" ");
            this.jLabelColumnName.setFont(new Font("Monospaced", 1, 16));
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\u30ab\u30e9\u30e0\u540d");
            this.jLabel1.setHorizontalTextPosition(4);
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel = new JLabel();
            this.jLabel.setText("\u751f\u6210\u624b\u9806");
            this.jLabel.setHorizontalAlignment(4);
            this.jLabel.setHorizontalTextPosition(4);
            this.jLabel.setName("jLabel");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setMinimumSize(new Dimension(0, 0));
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
            this.jPanel1.add((Component)this.jLabelColumnName, gridBagConstraints1);
            this.jPanel1.add((Component)this.jLabel, gridBagConstraints2);
            this.jPanel1.add((Component)this.getJComboBox(), gridBagConstraints3);
            this.jPanel1.add((Component)this.getJButtonApply(), gridBagConstraints17);
        }
        return this.jPanel1;
    }

    private JPanel getJPanelCreateDataBase() {
        if (this.jPanelCreateDataBase == null) {
            this.jPanelCreateDataBase = new JPanel();
            this.jPanelCreateDataBase.setLayout(new BorderLayout());
            this.jPanelCreateDataBase.setBorder(BorderFactory.createTitledBorder(null, "\u751f\u6210\u30d1\u30e9\u30e1\u30fc\u30bf", 0, 0, new Font("Dialog", 0, 12), Color.black));
        }
        return this.jPanelCreateDataBase;
    }

    private JButton getJButtonCsvOutput() {
        if (this.jButtonCsvOutput == null) {
            this.jButtonCsvOutput = new JButton();
            this.jButtonCsvOutput.setText("CSV\u51fa\u529b...");
            this.jButtonCsvOutput.setToolTipText("\u30c7\u30fc\u30bf\u751f\u6210\uff06\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u3092\u884c\u3044\u3001\u6210\u529f\u3057\u305f\u5834\u5408\u306f\u8a2d\u5b9a\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb\u306b\u81ea\u50cd\u30bb\u30fc\u30d6\u3057\u307e\u3059");
            this.jButtonCsvOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformmedCsvOutput();
                }
            });
        }
        return this.jButtonCsvOutput;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.add((Component)this.getJButtonRead(), null);
            this.jPanel3.add((Component)this.getJButtonCsvOutput(), null);
            this.jPanel3.add((Component)this.getJButtonDataView(), null);
            this.jPanel3.add((Component)this.getJButtonCsvImport(), null);
            this.jPanel3.add((Component)this.getJButtonCsvImportHistory(), null);
        }
        return this.jPanel3;
    }

    private JButton getJButtonRead() {
        if (this.jButtonRead == null) {
            this.jButtonRead = new JButton();
            this.jButtonRead.setText("\u624b\u9806\u306e\u30de\u30fc\u30b8\u53d6\u8fbc...");
            this.jButtonRead.setToolTipText("\u4ed6\u30c6\u30fc\u30d6\u30eb\u306e\u8a2d\u5b9a\u3092\u53d6\u308a\u8fbc\u307f\u3001\u30ab\u30e9\u30e0\u540d\u304c\u4e00\u81f4\u3057\u3066\u3044\u308b\u884c\u306e\u5168\u3066\u3092\u7f6e\u304d\u63db\u3048\u307e\u3059");
            this.jButtonRead.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedRead();
                }
            });
        }
        return this.jButtonRead;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setDividerSize(7);
            this.jSplitPane.setDividerLocation(370);
            this.jSplitPane.setLeftComponent(this.getJPanel4());
            this.jSplitPane.setRightComponent(this.getJPanel());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("\u53f3\u753b\u9762\u3067\u306e\u7de8\u96c6\u958b\u59cb\u30af\u30ea\u30c3\u30af\u6570");
            this.jLabel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.add((Component)this.getJPanel5(), "North");
            this.jPanel4.add((Component)this.getJPanel2(), "Center");
            this.jPanel4.add((Component)this.getJPanel8(), "South");
        }
        return this.jPanel4;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 4;
            gridBagConstraints16.gridy = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 0;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints12.gridx = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 4;
            gridBagConstraints11.insets = new Insets(2, 5, 2, 0);
            gridBagConstraints11.anchor = 10;
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.gridheight = 2;
            gridBagConstraints10.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.gridy = 2;
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("FETCH\uff11\u56de\u306e\u751f\u6210\u884c\u6570");
            this.jLabel7.setToolTipText("");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 1;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints5.gridy = 1;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("\u8a2d\u5b9a\u4fdd\u5b58\u30d5\u30a1\u30a4\u30eb");
            this.jLabel5.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("\u751f\u6210\u884c\u6570");
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.jLabel4, gridBagConstraints5);
            this.jPanel5.add((Component)this.getJTextFieldCreateCount(), gridBagConstraints8);
            this.jPanel5.add((Component)this.jLabel7, gridBagConstraints10);
            this.jPanel5.add((Component)this.getJButtonSqlValidate(), gridBagConstraints11);
            this.jPanel5.add((Component)this.getJTextFieldFetchCount(), gridBagConstraints12);
            this.jPanel5.add((Component)this.getJCheckBoxFetchEnd(), gridBagConstraints16);
        }
        return this.jPanel5;
    }

    private JTextAreaNoEdit getJTextAreaNoEditSettingFileName() {
        if (this.jTextAreaNoEditSettingFileName == null) {
            this.jTextAreaNoEditSettingFileName = new JTextAreaNoEdit();
        }
        return this.jTextAreaNoEditSettingFileName;
    }

    private JTextFieldEdit getJTextFieldCreateCount() {
        if (this.jTextFieldCreateCount == null) {
            this.jTextFieldCreateCount = new JTextFieldEdit();
            this.jTextFieldCreateCount.setColumns(5);
            this.jTextFieldCreateCount.setMinimumSize(new Dimension(50, 22));
            this.jTextFieldCreateCount.setHorizontalAlignment(11);
        }
        return this.jTextFieldCreateCount;
    }

    private JButton getJButtonDataView() {
        if (this.jButtonDataView == null) {
            this.jButtonDataView = new JButton();
            this.jButtonDataView.setText("\u30c7\u30fc\u30bf100\u4ef6\u53c2\u7167...");
            this.jButtonDataView.setToolTipText("<html>\u4f5c\u6210\u3057\u305f\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u3092\u6700\u9ad8\uff11\uff10\uff10\u4ef6\u8aad\u8fbc\u3057\u3001\u53c2\u7167\u753b\u9762\u306b\u8868\u793a\u3057\u307e\u3059<br>DB\u5b9a\u7fa9\u30c1\u30a7\u30c3\u30af\u3084DB\u66f4\u65b0\u306f\u884c\u308f\u306a\u3044\u306e\u3067\u3001\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u3068\u5185\u5bb9\u78ba\u8a8d\u306e\u307f\u304c\u51fa\u6765\u307e\u3059</html>");
            this.jButtonDataView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new CsvInputDataView(JFrameCreateDataSetting.this.csvInfo);
                }
            });
        }
        return this.jButtonDataView;
    }

    private JButton getJButtonCsvImport() {
        if (this.jButtonCsvImport == null) {
            this.jButtonCsvImport = new JButton();
            this.jButtonCsvImport.setText("CSV\u5165\u529b...");
            this.jButtonCsvImport.setToolTipText("\u4f5c\u6210\u3057\u305f\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3059");
            this.jButtonCsvImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedCsvImport();
                }
            });
        }
        return this.jButtonCsvImport;
    }

    private JButton getJButtonCsvImportHistory() {
        if (this.jButtonCsvImportHistory == null) {
            this.jButtonCsvImportHistory = new JButton();
            this.jButtonCsvImportHistory.setText("CSV\u5165\u529b\u5c65\u6b74...");
            this.jButtonCsvImportHistory.setToolTipText("<html>\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb\u5165\u529b\u306e\u5b9f\u884c\u5c65\u6b74\u753b\u9762\u3092\u8868\u793a\u3057\u307e\u3059<br>\u30a4\u30f3\u30dd\u30fc\u30c8\u306e\u518d\u5b9f\u884c\u3092\u6307\u793a\u3082\u3067\u304d\u307e\u3059</html>");
            this.jButtonCsvImportHistory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.getInstance().setVisible(true);
                }
            });
        }
        return this.jButtonCsvImportHistory;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new BorderLayout());
            this.jPanel6.add((Component)this.getJPanel9(), "North");
            this.jPanel6.add((Component)this.getJSplitPane(), "Center");
            this.jPanel6.add((Component)this.getJPanel7(), "South");
        }
        return this.jPanel6;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.gridy = -1;
            gridBagConstraints4.fill = 0;
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new BorderLayout());
            this.jPanel7.setBorder(BorderFactory.createBevelBorder(1));
            this.jPanel7.add((Component)this.jLabel5, "West");
            this.jPanel7.add((Component)this.getJTextAreaNoEditSettingFileName(), "Center");
        }
        return this.jPanel7;
    }

    private JButton getJButtonSqlValidate() {
        if (this.jButtonSqlValidate == null) {
            this.jButtonSqlValidate = new JButton();
            this.jButtonSqlValidate.setText("SELECT\u6587\u691c\u8a3c");
            this.jButtonSqlValidate.setMargin(new Insets(4, 8, 4, 8));
            this.jButtonSqlValidate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameCreateDataSetting.this.actionPerformedSqlValidate();
                }
            });
        }
        return this.jButtonSqlValidate;
    }

    protected void actionPerformedSqlValidate() {
        PrepareExecuteStatement pe = new PrepareExecuteStatement();
        pe.addStm(this.jTextPaneSqlStatement.getText());
        Connection con = null;
        ResultSet rs = null;
        try {
            try {
                con = SqlExec.getNewConnection();
                pe.prepare(con);
                rs = pe.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                this.columnMap.clear();
                int i = 1;
                while (i < rsmd.getColumnCount() + 1) {
                    this.columnMap.put(i, rsmd.getColumnName(i));
                    ++i;
                }
                for (JPanelCreateData item : this.createDataMap.values()) {
                    if (!(item instanceof JPanelSelectResult)) continue;
                    JPanelSelectResult jpsr = (JPanelSelectResult)item;
                    jpsr.fireDataUpdate();
                }
                System.out.println(this.columnMap.toString());
            }
            catch (SQLException e) {
                JDialogMessage.sqlErrorDialog(e, "SQL\u6587\u306e\u691c\u8a3c");
                this.columnMap.clear();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                SqlExec.disconnect(con);
            }
        }
    }

    private JTextFieldEdit getJTextFieldFetchCount() {
        if (this.jTextFieldFetchCount == null) {
            this.jTextFieldFetchCount = new JTextFieldEdit();
            this.jTextFieldFetchCount.setColumns(5);
            this.jTextFieldFetchCount.setMinimumSize(new Dimension(50, 22));
            this.jTextFieldFetchCount.setHorizontalAlignment(11);
        }
        return this.jTextFieldFetchCount;
    }

    private JTextPaneSqlStatement getJTextPaneSqlStatement() {
        if (this.jTextPaneSqlStatement == null) {
            this.jTextPaneSqlStatement = new JTextPaneSqlStatement();
            this.jTextPaneSqlStatement.setBorder(this.getJTextFieldCreateCount().getBorder());
        }
        return this.jTextPaneSqlStatement;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 2;
            gridBagConstraints15.gridy = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.gridy = 0;
            this.jPanel8 = new JPanel();
            this.jPanel8.setLayout(new GridBagLayout());
            this.jPanel8.add((Component)this.jLabel2, new GridBagConstraints());
            this.jPanel8.add((Component)this.getJRadioButtonOneClick(), gridBagConstraints14);
            this.jPanel8.add((Component)this.getJRadioButtonTwoClick(), gridBagConstraints15);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getJRadioButtonOneClick());
            group.add(this.getJRadioButtonTwoClick());
        }
        return this.jPanel8;
    }

    private JRadioButton getJRadioButtonOneClick() {
        if (this.jRadioButtonOneClick == null) {
            this.jRadioButtonOneClick = new JRadioButton();
            this.jRadioButtonOneClick.setText("\uff11\u56de");
            this.jRadioButtonOneClick.setSelected(true);
        }
        return this.jRadioButtonOneClick;
    }

    private JRadioButton getJRadioButtonTwoClick() {
        if (this.jRadioButtonTwoClick == null) {
            this.jRadioButtonTwoClick = new JRadioButton();
            this.jRadioButtonTwoClick.setText("\uff12\u56de");
        }
        return this.jRadioButtonTwoClick;
    }

    private JCheckBox getJCheckBoxFetchEnd() {
        if (this.jCheckBoxFetchEnd == null) {
            this.jCheckBoxFetchEnd = new JCheckBox();
            this.jCheckBoxFetchEnd.setText("FETCH\u7d42\u4e86\u3067\u6253\u5207\u308b");
        }
        return this.jCheckBoxFetchEnd;
    }

    private JTextAreaNoEdit getJTextAreaNoEditTableName() {
        if (this.jTextAreaNoEditTableName == null) {
            this.jTextAreaNoEditTableName = new JTextAreaNoEdit();
            this.jTextAreaNoEditTableName.setFont(new Font("Monospaced", 1, 16));
            this.jTextAreaNoEditTableName.setText(this.schemaTableName.getCompleteTableName());
        }
        return this.jTextAreaNoEditTableName;
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setOrientation(0);
            this.jSplitPane1.setOneTouchExpandable(true);
            this.jSplitPane1.setDividerLocation(50);
            this.jSplitPane1.setTopComponent(this.getJScrollPane());
            this.jSplitPane1.setBottomComponent(this.getJScrollPane1());
        }
        return this.jSplitPane1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTable());
        }
        return this.jScrollPane1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextPaneSqlStatement());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.add((Component)this.getJSplitPane1(), "Center");
        }
        return this.jPanel2;
    }

    private JPanel getJPanel9() {
        if (this.jPanel9 == null) {
            this.jPanel9 = new JPanel();
            this.jPanel9.setLayout(new BorderLayout());
            this.jPanel9.setBorder(BorderFactory.createBevelBorder(1));
            this.jPanel9.add((Component)this.getJTextAreaNoEditTableName(), "Center");
        }
        return this.jPanel9;
    }

    class SelectQueryExecute {
        SqlAnalyze sa = null;
        QueryExecuteSync qes = null;
        Connection con = null;
        int fetchCnt = -1;
        int rowFetchCnt = 0;
        Exception exception = null;
        boolean first = true;

        SelectQueryExecute() throws JdbcacsessException {
            try {
                this.fetchCnt = new Integer(JFrameCreateDataSetting.this.jTextFieldFetchCount.getText());
            }
            catch (NumberFormatException e) {
                throw new JdbcacsessException("\u300e" + JFrameCreateDataSetting.this.jLabel7.getText() + "\u300f\u306b\u3001\uff11\u4ee5\u4e0a\u306e\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (this.fetchCnt < 1) {
                throw new JdbcacsessException("\u300e" + JFrameCreateDataSetting.this.jLabel7.getText() + "\u300f\u306b\u3001\uff11\u4ee5\u4e0a\u306e\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            this.sa = new SqlAnalyze(JFrameCreateDataSetting.this.jTextPaneSqlStatement.getText());
            try {
                this.con = SqlExec.getNewConnection();
            }
            catch (SQLException e) {
                throw new JdbcacsessException(e);
            }
            this.qes = new QueryExecuteSync(this, this.sa, this.con);
            this.qes.open();
            this.rowFetchCnt = 0;
            this.qes.addQueryExecuteListener(new QueryExecuteAdapter(){

                public void errorException(Exception ex) {
                    SelectQueryExecute.this.exception = ex;
                }
            });
            if (this.exception != null) {
                throw new JdbcacsessException(this.exception);
            }
        }

        void addQueryExecuteListener(JPanelSelectResult new_name) {
            this.qes.addQueryExecuteListener(new_name);
        }

        boolean next() throws JdbcacsessException {
            if (this.rowFetchCnt == 0 && !this.qes.read()) {
                if (this.exception != null) {
                    throw new JdbcacsessException(this.exception);
                }
                if (this.first) {
                    throw new JdbcacsessException("\u691c\u7d22\u7d50\u679c\u304c\uff10\u4ef6\u306a\u306e\u3067\u751f\u6210\u51fa\u6765\u307e\u305b\u3093");
                }
                return false;
            }
            ++this.rowFetchCnt;
            if (this.rowFetchCnt == this.fetchCnt) {
                this.rowFetchCnt = 0;
            }
            this.first = false;
            return true;
        }

        void end() throws JdbcacsessException {
            if (this.qes != null) {
                this.qes.close();
            }
            if (this.con != null) {
                SqlExec.disconnect(this.con);
            }
            if (this.exception != null) {
                throw new JdbcacsessException(this.exception);
            }
        }
    }
}

