/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Logger;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.csv.CsvImportSqlExecute;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInput;
import jdbcacsess.gui.common.ConstCommitCnt;
import jdbcacsess.gui.common.ConstDupliKeyAction;
import jdbcacsess.gui.common.ConstItemHeader;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.PrepareExecuteStatement;
import jdbcacsess.sql.SqlExec;

public class CsvInputImportToDB
extends CsvInput
implements Runnable {
    private Connection con;
    private int resultCntUpdate;
    private int resultCntInsert;
    private int resultCntDelete;

    public CsvInputImportToDB(CsvInfo info) {
        super(info);
    }

    public void run() {
        block11: {
            this.inputCnt = 0;
            this.resultCntUpdate = 0;
            this.resultCntInsert = 0;
            this.resultCntDelete = 0;
            this.in = null;
            this.con = null;
            try {
                try {
                    this.openInputFile();
                    this.connectDataBase();
                    CsvImportSqlExecute cise = this.headerCheck();
                    if (this.csvInfo.getDuplicateKeyAction() == ConstDupliKeyAction.ALLDELETE) {
                        this.allDelete();
                    }
                    this.fileImport(cise);
                    JDialogMessage.infoDialog(this.msg(), "Import\u6210\u529f");
                }
                catch (JdbcacsessException cie) {
                    if (this.con == null) break block11;
                    try {
                        if (!this.con.getAutoCommit()) {
                            try {
                                this.con.rollback();
                                Logger.global.info("RollBack\u3057\u307e\u3057\u305f");
                            }
                            catch (SQLException e) {
                                JDialogMessage.sqlErrorDialog(e, "RollBack\u306b\u5931\u6557" + this.msg());
                            }
                        }
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "AutoCommit\u53d6\u5f97");
                    }
                }
            }
            finally {
                this.closeInputFile();
                SqlExec.disconnect(this.con);
                this.csvInfo.setCurrentImportExecuted();
                this.csvInfo.currentDataSave();
            }
        }
    }

    private String msg() {
        return "\n" + this.csvInfo.getPropTableName().getCompleteTableName() + " \u306eImport\u7d42\u4e86" + "\n  INFILE: " + this.inputCnt + " \u30ec\u30b3\u30fc\u30c9" + "\n  UPDATE: " + this.resultCntUpdate + " \u884c" + "\n  INSERT: " + this.resultCntInsert + " \u884c" + "\n  DELETE: " + this.resultCntDelete + " \u884c" + "\n";
    }

    private void connectDataBase() throws JdbcacsessException {
        try {
            this.con = SqlExec.getNewConnection();
            if (this.csvInfo.getCommitCnt() == ConstCommitCnt.AUTO) {
                this.con.setAutoCommit(true);
            } else {
                this.con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "DB\u63a5\u7d9a\u3067\u30a8\u30e9\u30fc" + this.msg());
            throw new JdbcacsessException(e);
        }
    }

    private void allDelete() throws JdbcacsessException {
        PrepareExecuteStatement pes = new PrepareExecuteStatement();
        pes.addStm("DELETE FROM " + this.csvInfo.getPropTableName().getCompleteTableName());
        try {
            pes.prepare(this.con);
            this.resultCntDelete = pes.executeUpdate();
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u5168\u4ef6\u524a\u9664\u3067\u30a8\u30e9\u30fc" + pes.getStm() + this.msg());
            throw new JdbcacsessException(e);
        }
    }

    private CsvImportSqlExecute headerCheck() throws JdbcacsessException {
        CsvImportSqlExecute cise;
        Vector<String> header = new Vector();
        if (this.csvInfo.getItemHeader() == ConstItemHeader.TRUE) {
            try {
                header = this.readFile();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
                throw new JdbcacsessException(e);
            }
            if (header == null) {
                Exception e = new Exception("\u898b\u51fa\u3057\u6709\u308a\u306a\u306e\u306b\u3001\u7a7a\u30d5\u30a1\u30a4\u30eb\u3067\u3059" + this.msg());
                JDialogMessage.errorDialog(e);
                throw new JdbcacsessException(e);
            }
        }
        try {
            cise = new CsvImportSqlExecute(this.con, this.csvInfo.getPropTableName(), header);
        }
        catch (Exception e) {
            JDialogMessage.errorDialog(e);
            throw new JdbcacsessException(e);
        }
        if (this.csvInfo.getItemHeader() == ConstItemHeader.TRUE) {
            String str = cise.hasAllColumn();
            if (!str.equals("")) {
                Exception e = new Exception("CSV\u306e\u898b\u51fa\u3057\u30ab\u30e9\u30e0\u304c\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u306b\u7121\u3044\n" + str + this.msg());
                JDialogMessage.errorDialog(e);
                throw new JdbcacsessException(e);
            }
            if (!(this.csvInfo.getDuplicateKeyAction() != ConstDupliKeyAction.UPDATE && this.csvInfo.getDuplicateKeyAction() != ConstDupliKeyAction.NONE || (str = cise.hasPrimeKey()).equals(""))) {
                Exception e = new Exception("\u4e3b\u30ad\u30fc\u5b9a\u7fa9\u30ab\u30e9\u30e0\u304cCSV\u306e\u898b\u51fa\u3057\u306b\u7121\u3044\n" + str + this.msg());
                JDialogMessage.errorDialog(e);
                throw new JdbcacsessException(e);
            }
        }
        return cise;
    }

    private void fileImport(CsvImportSqlExecute cise) throws JdbcacsessException {
        int commitCnt = 1;
        try {
            Vector<String> rowData = this.readFile();
            while (rowData != null) {
                switch (this.csvInfo.getDuplicateKeyAction()) {
                    case UPDATE: {
                        int updateCnt = cise.execUpdate(rowData);
                        if (updateCnt == 0) {
                            this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                            break;
                        }
                        this.resultCntUpdate += updateCnt;
                        break;
                    }
                    case NONE: {
                        if (cise.querySelectCount(rowData) != 0) break;
                        this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                        break;
                    }
                    default: {
                        if (this.csvInfo.getItemHeader() == ConstItemHeader.TRUE) {
                            this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                            break;
                        }
                        this.resultCntInsert += cise.execInsertOnlyValuePhrase(rowData);
                    }
                }
                if (this.csvInfo.getCommitCnt() != ConstCommitCnt.AUTO && this.csvInfo.getCommitCnt() != ConstCommitCnt.LAST && ++commitCnt > this.csvInfo.getCommitCnt().getValue()) {
                    this.con.commit();
                    Logger.global.info("Commit\u3057\u307e\u3057\u305f(loop)");
                    commitCnt = 1;
                }
                rowData = this.readFile();
            }
            if (this.csvInfo.getCommitCnt() != ConstCommitCnt.AUTO) {
                Logger.global.info("Commit\u3057\u307e\u3057\u305f");
                this.con.commit();
            }
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "DB\u66f4\u65b0\u4e2d\u306b\u30a8\u30e9\u30fc" + this.msg());
            throw new JdbcacsessException(e);
        }
        catch (InterruptedIOException e) {
            JDialogMessage.infoDialog(this.msg(), "Import\u4e2d\u6b62");
            throw new JdbcacsessException(e);
        }
        catch (Exception e) {
            JDialogMessage.errorDialog(e);
            throw new JdbcacsessException(e);
        }
    }
}

