/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jdbcacsess.gui.CellRendererDataBaseObject;

public class JPanelSqlData
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private DefaultMutableTreeNode rootTreeNode;
    private DefaultTreeModel treeModel;

    public JPanelSqlData() {
        this.initialize();
        this.jTree.setRowHeight(this.getFontMetrics(CellRendererDataBaseObject.treeFontPrim).getHeight());
        this.jTree.setModel(null);
        this.jTree.setToggleClickCount(1);
        this.jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                DefaultMutableTreeNode dummyChild = (DefaultMutableTreeNode)node.getFirstChild();
                if (dummyChild.getUserObject() != null) {
                    return;
                }
                JPanelSqlData.this.addObject(node);
                node.remove(dummyChild);
                JPanelSqlData.this.treeModel.reload(node);
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
    }

    public void setTopObject(String fieldName, Class cls, Object obj) {
        this.rootTreeNode = this.addChileNode(fieldName, cls, obj);
        this.addObject(this.rootTreeNode);
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.jTree.setModel(this.treeModel);
        this.treeModel.reload(this.rootTreeNode);
    }

    private void addObject(DefaultMutableTreeNode node) {
        Object obj = ((SqlData)node.getUserObject()).getObject();
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        while (cls != Object.class) {
            Field[] fieldArray = cls.getDeclaredFields();
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field field = fieldArray[n];
                field.setAccessible(true);
                try {
                    node.add(this.addChileNode(field.getName(), field.getType(), field.get(obj)));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++n;
            }
            cls = cls.getSuperclass();
        }
    }

    private DefaultMutableTreeNode addChileNode(String fieldName, Class cls, Object obj) {
        DefaultMutableTreeNode node = null;
        if (obj == null) {
            node = new DefaultMutableTreeNode(new SqlDataNull(fieldName, cls));
        } else if (cls.isPrimitive()) {
            node = new DefaultMutableTreeNode(new SqlDataPrimitive(fieldName, obj));
        } else if (cls.isArray()) {
            node = new DefaultMutableTreeNode(new SqlData(fieldName, obj));
            int j = 0;
            while (j < Array.getLength(obj)) {
                DefaultMutableTreeNode arrayNode;
                Object arrayObj = Array.get(obj, j);
                if (arrayObj == null) {
                    arrayNode = new DefaultMutableTreeNode(new SqlDataNull("(" + j + ")", cls.getComponentType()));
                    node.add(arrayNode);
                } else {
                    arrayNode = new DefaultMutableTreeNode(new SqlData("(" + j + ")", arrayObj));
                    node.add(arrayNode);
                    arrayNode.add(this.addChileNode("", cls.getComponentType(), arrayObj));
                }
                if (j <= 999) {
                    ++j;
                    continue;
                }
                break;
            }
        } else {
            node = new DefaultMutableTreeNode(new SqlData(fieldName, obj));
            node.add(new DefaultMutableTreeNode(null));
        }
        return node;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree();
        }
        return this.jTree;
    }

    class SqlData {
        String fieldName;
        Object object;

        public SqlData(String fieldName, Object object) {
            this.fieldName = fieldName;
            this.object = object;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append(" " + this.object.getClass().getName() + " ");
            return sb.toString();
        }

        public Object getObject() {
            return this.object;
        }
    }

    class SqlDataPrimitive
    extends SqlData {
        public SqlDataPrimitive(String fieldName, Object object) {
            super(fieldName, object);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append(" ");
            sb.append(this.object);
            return sb.toString();
        }
    }

    class SqlDataNull
    extends SqlData {
        Class cls;

        public SqlDataNull(String fieldName, Class cls) {
            super(fieldName, null);
            this.cls = cls;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append(" " + this.cls.getName());
            sb.append(" #NULL#");
            return sb.toString();
        }
    }
}

