/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.sql.ExecuteSqlFactory;
import jdbcacsess.sql.SqlAnalyze;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteSqResultSetOnly
extends ExecuteSqlFactory {
    private ResultSet resultSet = null;
    private ArrayList<Object> rowData;

    public ExecuteSqResultSetOnly(Object source) {
        super(source);
    }

    public ExecuteSqResultSetOnly(Object source, ResultSet resultSet) {
        super(source);
        this.resultSet = resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public boolean initMethod() throws Exception {
        this.getHeaderFromResultSet(this.resultSet, this.selectColmunInfos);
        this.rowData = new ArrayList(this.selectColmunInfos.size());
        return true;
    }

    @Override
    public ArrayList<Object> getResultDetail() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException, IOException {
        this.rowData.clear();
        this.getDetailFromResultSet(this.resultSet, this.rowData);
        return this.rowData;
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.resultSet == null) {
            return false;
        }
        return this.resultSet.next();
    }

    @Override
    public void endMethod() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    SqlAnalyze getSqlAnalyze() {
        return null;
    }
}

