/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdbcacsess.sql.ColumnInfo;
import jdbcacsess.sql.ColumnInfoParameter;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.DBObjectProcedures;
import jdbcacsess.sql.SchemaTableColumnName;
import jdbcacsess.sql.SchemaTableName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExec {
    private static Connection _con;
    private static String _userId;
    private static String _passWord;
    private static String _jdbcUrl;
    private static boolean lower;
    private static boolean upper;
    private static Driver driver;
    private static String _driverClassName;
    private static URLClassLoader loader;
    static Map<String, ArrayList<String>> tableNamesMap;
    static Map<String, ArrayList<ColumnInfoTable>> columnInfoTableMap;
    static String[] sqlDataList;

    static {
        tableNamesMap = new HashMap<String, ArrayList<String>>();
        columnInfoTableMap = new HashMap<String, ArrayList<ColumnInfoTable>>();
        sqlDataList = new String[0];
    }

    public static boolean isConnect() {
        if (_con == null) {
            return false;
        }
        try {
            return !_con.isClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        if (loader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, loader);
    }

    public static void connect(String userId, String passWord, String jdbcUrl, String driverClassName, URL[] driverUrlPaths) throws SQLException, ClassNotFoundException, MalformedURLException, InstantiationException, IllegalAccessException {
        _userId = userId;
        _passWord = passWord;
        _jdbcUrl = jdbcUrl;
        _driverClassName = driverClassName;
        loader = driverUrlPaths == null ? null : new URLClassLoader(driverUrlPaths);
        driver = (Driver)SqlExec.classForName(_driverClassName).newInstance();
        SqlExec.disconnect();
        Properties info = new Properties();
        info.put("user", userId);
        info.put("password", passWord);
        _con = driver.connect(jdbcUrl, info);
        _con.setAutoCommit(true);
        lower = _con.getMetaData().storesLowerCaseIdentifiers();
        upper = _con.getMetaData().storesUpperCaseIdentifiers();
        tableNamesMap.clear();
        columnInfoTableMap.clear();
        Logger.global.info("URL:" + jdbcUrl.toString());
        Logger.global.info("\u30c9\u30e9\u30d0\u30af\u30e9\u30b9\u540d:" + driverClassName.toString());
        if (driverUrlPaths != null) {
            StringBuilder sb = new StringBuilder("\u30c9\u30e9\u30d0\u30e9\u30a4\u30d6\u30e9\u30ea\u30d1\u30b9:");
            int i = 0;
            while (i < driverUrlPaths.length) {
                sb.append("[" + i + "]" + driverUrlPaths[i].toString());
                ++i;
            }
            Logger.global.info(sb.toString());
        }
        SqlExec.mapping(_con);
    }

    public static String getConnectString() {
        return String.valueOf(_jdbcUrl) + " [User=" + _userId + "]" + " " + _driverClassName;
    }

    public static void disconnect() {
        if (SqlExec.isConnect()) {
            try {
                _con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        _con = null;
    }

    public static void disconnect(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<String> getPrimaryKeys(String schemaName, String tableName) throws SQLException {
        TreeMap<Short, String> columnNamesMap = new TreeMap<Short, String>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getPrimaryKeys(null, schemaName, tableName);
        while (rs.next()) {
            columnNamesMap.put(rs.getShort(5), rs.getString(4));
        }
        rs.close();
        ArrayList<String> currentTablePrimkeys = new ArrayList<String>();
        for (Short idx : columnNamesMap.keySet()) {
            currentTablePrimkeys.add((String)columnNamesMap.get(idx));
        }
        return currentTablePrimkeys;
    }

    public static ArrayList<String> getSchemaNames() throws SQLException {
        ArrayList<String> schemaNames = new ArrayList<String>();
        DatabaseMetaData md = _con.getMetaData();
        ResultSet rs = md.getSchemas();
        while (rs.next()) {
            String schema = rs.getString(1);
            schemaNames.add(schema);
        }
        rs.close();
        if (schemaNames.isEmpty()) {
            schemaNames.add(" ");
        }
        Logger.global.fine("_con.getMetaData().getSchemas():" + schemaNames.toString());
        return schemaNames;
    }

    private static ArrayList<String> getSimpleTableNames(String schema) throws SQLException {
        ArrayList<String> tableNames = tableNamesMap.get(schema);
        if (tableNames != null) {
            Logger.global.fine("schema:" + schema + " cache_tableNames:" + tableNames.toString());
            return tableNames;
        }
        tableNames = new ArrayList();
        DatabaseMetaData md = _con.getMetaData();
        String[] tableType = new String[]{"TABLE", "VIEW"};
        ResultSet rs = md.getTables(null, schema, null, tableType);
        while (rs.next()) {
            tableNames.add(rs.getString(3));
        }
        rs.close();
        tableNamesMap.put(schema, tableNames);
        Logger.global.fine("schema:" + schema + " _con.getMetaData().getTables():" + tableNames.toString());
        return tableNames;
    }

    public static ArrayList<SchemaTableName> getCompleteTableNames(String schema) throws SQLException {
        ArrayList<SchemaTableName> completeTableNames = new ArrayList<SchemaTableName>();
        for (String table : SqlExec.getSimpleTableNames(schema)) {
            completeTableNames.add(new SchemaTableName(schema, table));
        }
        Logger.global.fine("completeTableNames:" + completeTableNames);
        return completeTableNames;
    }

    public static ArrayList<ColumnInfoTable> getColumnMames(SchemaTableName schemaTable) throws SQLException {
        String schema = schemaTable.getSchemaName();
        String tableName = schemaTable.getTableName();
        ArrayList<ColumnInfoTable> columnInfoTable = columnInfoTableMap.get(String.valueOf(schema) + tableName);
        if (columnInfoTable != null) {
            return columnInfoTable;
        }
        columnInfoTable = new ArrayList();
        ArrayList<String> primaryKeys = SqlExec.getPrimaryKeys(schema, tableName);
        ResultSet rs = _con.getMetaData().getColumns(null, schema, tableName, null);
        while (rs.next()) {
            ColumnInfoTable ci = new ColumnInfoTable(rs.getInt(17), rs.getString(4), rs.getInt(5), rs.getString(6), rs.getInt(11), new SchemaTableName(schema, rs.getString(3)), rs.getInt(7), rs.getInt(9));
            ci.setRemarks(rs.getString(12));
            ci.setPrimaryKey(primaryKeys.contains(ci.getColumnName()));
            columnInfoTable.add(ci);
        }
        rs.close();
        Collections.sort(columnInfoTable, ColumnInfo.getComparatorByPosition());
        columnInfoTableMap.put(String.valueOf(schema) + tableName, columnInfoTable);
        return columnInfoTable;
    }

    public static ColumnInfoTable getColumnInfoTable(SchemaTableColumnName stcn) throws SQLException {
        for (ColumnInfoTable cit : SqlExec.getColumnMames(stcn.getSchemaTableName())) {
            if (!cit.getColumnName().equals(stcn.getColumnName())) continue;
            return cit;
        }
        return null;
    }

    public static String convertStoresIdentifiers(String str) {
        if (lower) {
            return str.toLowerCase();
        }
        if (upper) {
            return str.toUpperCase();
        }
        return str;
    }

    public static String getDatabaseProductName() throws SQLException {
        return _con.getMetaData().getDatabaseProductName();
    }

    public static Connection getNewConnection() throws SQLException {
        Properties info = new Properties();
        info.put("user", _userId);
        info.put("password", _passWord);
        Connection con = driver.connect(_jdbcUrl, info);
        con.setAutoCommit(_con.getAutoCommit());
        if (SqlExec.getDatabaseProductName().equals("Oracle")) {
            SqlExec.oracleSrtting(con);
        }
        SqlExec.mapping(con);
        return con;
    }

    private static void mapping(Connection con) {
        if (sqlDataList.length == 0) {
            return;
        }
        try {
            Map<String, Class<?>> map = con.getTypeMap();
            String[] stringArray = sqlDataList;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String element = stringArray[n];
                Class c = SqlExec.classForName(element);
                String typeName = ((SQLData)c.newInstance()).getSQLTypeName();
                map.put(typeName, c);
                ++n;
            }
            con.setTypeMap(map);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void oracleSrtting(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.execute("ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'");
        stmt.close();
        Logger.global.info("Oracle\u306a\u306e\u3067\u3001NLS_DATE_FORMAT\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002select * from nls_session_parameters \u3067\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044 ");
        try {
            try {
                stmt = con.createStatement();
                stmt.execute("ALTER SESSION SET NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9'");
                stmt.execute("ALTER SESSION SET NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF9 TZR'");
                Logger.global.info("Oracle\u306a\u306e\u3067\u3001NLS_TIMESTAMP_FORMAT\u3068NLS_TIMESTAMP_TZ_FORMAT\u3082\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002select * from nls_session_parameters \u3067\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044 ");
            }
            catch (SQLException e) {
                Logger.global.log(Level.SEVERE, "TIMESTAMP_FORMAT\u306ealter sessionn \u5931\u6557", e);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static String getDriverInfo() {
        String str;
        block3: {
            str = "";
            try {
                DatabaseMetaData dmd = SqlExec.getDatabaseMetaData();
                if (dmd != null) {
                    str = dmd.getDriverVersion();
                }
            }
            catch (SQLException e) {
                if (driver == null) break block3;
                str = "[" + driver.getClass().getName() + " Ver" + driver.getMajorVersion() + "." + driver.getMinorVersion() + "]";
            }
        }
        return str;
    }

    public static DatabaseMetaData getDatabaseMetaData() throws SQLException {
        if (_con == null) {
            return null;
        }
        return _con.getMetaData();
    }

    public static List<ColumnInfoParameter> getProcedureColumns(DBObjectProcedures.DBObjectProcedure procedure) throws SQLException {
        ArrayList<ColumnInfoParameter> rtn = new ArrayList<ColumnInfoParameter>();
        ResultSet rs = SqlExec.getDatabaseMetaData().getProcedureColumns(procedure.getProcedureCat(), procedure.getProcedureSchem(), procedure.getProcedureName(), null);
        int idx = 0;
        while (rs.next()) {
            ColumnInfoParameter cip = new ColumnInfoParameter(++idx, rs.getString(4), rs.getInt(6), rs.getString(7), rs.getInt(12), "java.lang.String", rs.getInt(8), rs.getInt(10), rs.getInt(5));
            if (rs.getMetaData().getColumnCount() > 12) {
                cip.setRemarks(rs.getString(13));
            }
            rtn.add(cip);
        }
        rs.close();
        return rtn;
    }
}

