/* Copyright (c) 2020-2021 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef CONTACTINFO_H
#define CONTACTINFO_H

#include <QDialog>
#include <QTimer>

namespace Ui {
class ContactInfo;
}

class ContactInfo : public QDialog
{
  Q_OBJECT

  typedef QDialog Parent;

public:
  explicit ContactInfo(QWidget * parent, class Contact * contact);
  ~ContactInfo();

  void restorePosition();

  void copySelection();

  void showEvent(QShowEvent * event) Q_DECL_OVERRIDE;
  void hideEvent(QHideEvent * event) Q_DECL_OVERRIDE;
  bool eventFilter(QObject * obj, QEvent * event) Q_DECL_OVERRIDE;

private slots:
  void on_okButton_clicked();

  void onItemDoubleClicked(const QModelIndex &);

  void onTimerTimeout(bool first = false);

  void onSignalLogout();

  void onCustomContextMenu(const QPoint & pos);

private:
  void setToolTip(int row, const QString & toolTip);
  void setInfo(int row, const QString & name, const QString & value, const QString & toolTip,
               const QString & pixmapName = QString());
  void setInfo(int row, const QString & name, const QString & value, const QString & toolTip, QColor color);

  QString getFlagNames(int flag1, int flag2, const char * name, const char * name1, const char * name2);

  Ui::ContactInfo * ui;
  Contact * m_contact;

  QTimer m_timer;

  int m_nickRow;
  int m_settingsRow;
  int m_statsRow;
};

#endif
