/* This file is in the Public Domain. */

#ifndef _INC_NETFW_H
#define _INC_NETFW_H

#ifdef __cplusplus
extern "C" {
#endif

#include "icftypes.h"
#include <oaidl.h>

DEFINE_GUID(CLSID_NetFwRule, 0x2c5bc43e, 0x3369, 0x4c33, 0xab,0x0c, 0xbe,0x94,0x69,0x67,0x7a,0xf4);
DEFINE_GUID(CLSID_NetFwPolicy2, 0xe2b3c97f, 0x6ae1, 0x41ac, 0x81,0x7a, 0xf6,0xf9,0x21,0x66,0xd7,0xdd);

typedef interface INetFwRule INetFwRule;
typedef interface INetFwRules INetFwRules;
typedef interface INetFwServiceRestriction INetFwServiceRestriction;
typedef interface INetFwPolicy2 INetFwPolicy2;

DEFINE_GUID(IID_INetFwRule, 0xaf230d27, 0xbaba, 0x4e42, 0xac,0xed, 0xf5,0x24,0xf2,0x2c,0xfc,0xe2);
typedef struct INetFwRuleVtbl {
BEGIN_INTERFACE
  HRESULT (STDMETHODCALLTYPE *QueryInterface) (INetFwRule *, REFIID, void **);
  ULONG (STDMETHODCALLTYPE *AddRef) (INetFwRule *);
  ULONG (STDMETHODCALLTYPE *Release) (INetFwRule *);
  HRESULT (STDMETHODCALLTYPE *GetTypeInfoCount) (INetFwRule *, UINT *);
  HRESULT (STDMETHODCALLTYPE *GetTypeInfo) (INetFwRule *, UINT, LCID, ITypeInfo **);
  HRESULT (STDMETHODCALLTYPE *GetIDsOfNames) (INetFwRule *, REFIID, LPOLESTR *, UINT, LCID, DISPID *);
  HRESULT (STDMETHODCALLTYPE *Invoke) (INetFwRule *, DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT *);

  HRESULT (STDMETHODCALLTYPE *get_Name) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_Name) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_Description) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_Description) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_ApplicationName) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_ApplicationName) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_ServiceName) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_ServiceName) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_Protocol) (INetFwRule *, LONG *);
  HRESULT (STDMETHODCALLTYPE *put_Protocol) (INetFwRule *, LONG);
  HRESULT (STDMETHODCALLTYPE *get_LocalPorts) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_LocalPorts) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_RemotePorts) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_RemotePorts) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_LocalAddresses) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_LocalAddresses) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_RemoteAddresses) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_RemoteAddresses) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_IcmpTypesAndCodes) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_IcmpTypesAndCodes) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_Direction) (INetFwRule *, NET_FW_RULE_DIRECTION *);
  HRESULT (STDMETHODCALLTYPE *put_Direction) (INetFwRule *, NET_FW_RULE_DIRECTION);
  HRESULT (STDMETHODCALLTYPE *get_Interfaces) (INetFwRule *, VARIANT *);
  HRESULT (STDMETHODCALLTYPE *put_Interfaces) (INetFwRule *, VARIANT);
  HRESULT (STDMETHODCALLTYPE *get_InterfaceTypes) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_InterfaceTypes) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_Enabled) (INetFwRule *, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *put_Enabled) (INetFwRule *, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *get_Grouping) (INetFwRule *, BSTR *);
  HRESULT (STDMETHODCALLTYPE *put_Grouping) (INetFwRule *, BSTR);
  HRESULT (STDMETHODCALLTYPE *get_Profiles) (INetFwRule *, LONG *);
  HRESULT (STDMETHODCALLTYPE *put_Profiles) (INetFwRule *, LONG);
  HRESULT (STDMETHODCALLTYPE *get_EdgeTraversal) (INetFwRule *, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *put_EdgeTraversal) (INetFwRule *, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *get_Action) (INetFwRule *, NET_FW_ACTION *);
  HRESULT (STDMETHODCALLTYPE *put_Action) (INetFwRule *, NET_FW_ACTION);
END_INTERFACE
} INetFwRuleVtbl;
interface INetFwRule {
  CONST_VTBL INetFwRuleVtbl *lpVtbl;
};

DEFINE_GUID(IID_INetFwRules, 0x9c4c6277, 0x5027, 0x441e, 0xaf,0xae, 0xca,0x1f,0x54,0x2d,0xa0,0x09);
typedef struct INetFwRulesVtbl {
BEGIN_INTERFACE
  HRESULT (STDMETHODCALLTYPE *QueryInterface) (INetFwRules *, REFIID, void **);
  ULONG (STDMETHODCALLTYPE *AddRef) (INetFwRules *);
  ULONG (STDMETHODCALLTYPE *Release) (INetFwRules *);
  HRESULT (STDMETHODCALLTYPE *GetTypeInfoCount) (INetFwRules *, UINT *);
  HRESULT (STDMETHODCALLTYPE *GetTypeInfo) (INetFwRules *, UINT, LCID, ITypeInfo **);
  HRESULT (STDMETHODCALLTYPE *GetIDsOfNames) (INetFwRules *, REFIID, LPOLESTR *, UINT, LCID, DISPID *);
  HRESULT (STDMETHODCALLTYPE *Invoke) (INetFwRules *, DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT *);

  HRESULT (STDMETHODCALLTYPE *get_Count) (INetFwRules *, LONG *);
  HRESULT (STDMETHODCALLTYPE *Add) (INetFwRules *, INetFwRule *);
  HRESULT (STDMETHODCALLTYPE *Remove) (INetFwRules *, BSTR);
  HRESULT (STDMETHODCALLTYPE *Item) (INetFwRules *, BSTR, INetFwRule **);
  HRESULT (STDMETHODCALLTYPE *get__NewEnum) (INetFwRules *, IUnknown **);
END_INTERFACE
} INetFwRulesVtbl;
interface INetFwRules {
  CONST_VTBL INetFwRulesVtbl *lpVtbl;
};

DEFINE_GUID(IID_INetFwPolicy2,0x98325047, 0xc671, 0x4174, 0x8d,0x81, 0xde,0xfc,0xd3,0xf0,0x31,0x86);
typedef struct INetFwPolicy2Vtbl {
BEGIN_INTERFACE
  HRESULT (STDMETHODCALLTYPE *QueryInterface) (INetFwPolicy2 *, REFIID, void **);
  ULONG (STDMETHODCALLTYPE *AddRef) (INetFwPolicy2 *);
  ULONG (STDMETHODCALLTYPE *Release) (INetFwPolicy2 *);
  HRESULT (STDMETHODCALLTYPE *GetTypeInfoCount) (INetFwPolicy2 *, UINT *);
  HRESULT (STDMETHODCALLTYPE *GetTypeInfo) (INetFwPolicy2 *, UINT, LCID, ITypeInfo **);
  HRESULT (STDMETHODCALLTYPE *GetIDsOfNames) (INetFwPolicy2 *, REFIID, LPOLESTR *, UINT, LCID, DISPID *);
  HRESULT (STDMETHODCALLTYPE *Invoke) (INetFwPolicy2 *, DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT *);

  HRESULT (STDMETHODCALLTYPE *get_CurrentProfileTypes) (INetFwPolicy2 *, LONG *);
  HRESULT (STDMETHODCALLTYPE *get_FirewallEnabled) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *put_FirewallEnabled) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *get_ExcludedInterfaces) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT *);
  HRESULT (STDMETHODCALLTYPE *put_ExcludedInterfaces) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT);
  HRESULT (STDMETHODCALLTYPE *get_BlockAllInboundTraffic) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *put_BlockAllInboundTraffic) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *get_NotificationsDisabled) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *put_NotificationsDisabled) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *get_UnicastResponsesToMulticastBroadcastDisabled) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *put_UnicastResponsesToMulticastBroadcastDisabled) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *get_Rules) (INetFwPolicy2 *, INetFwRules **);
  HRESULT (STDMETHODCALLTYPE *get_ServiceRestriction) (INetFwPolicy2 *, INetFwServiceRestriction **);
  HRESULT (STDMETHODCALLTYPE *EnableRuleGroup) (INetFwPolicy2 *, LONG, BSTR, VARIANT_BOOL);
  HRESULT (STDMETHODCALLTYPE *IsRuleGroupEnabled) (INetFwPolicy2 *, LONG, BSTR, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *RestoreLocalFirewallDefaults) (INetFwPolicy2 *);
  HRESULT (STDMETHODCALLTYPE *get_DefaultInboundAction) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, NET_FW_ACTION *);
  HRESULT (STDMETHODCALLTYPE *put_DefaultInboundAction) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, NET_FW_ACTION);
  HRESULT (STDMETHODCALLTYPE *get_DefaultOutboundAction) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, NET_FW_ACTION *);
  HRESULT (STDMETHODCALLTYPE *put_DefaultOutboundAction) (INetFwPolicy2 *, NET_FW_PROFILE_TYPE2, NET_FW_ACTION);
  HRESULT (STDMETHODCALLTYPE *get_IsRuleGroupCurrentlyEnabled) (INetFwPolicy2 *, BSTR, VARIANT_BOOL *);
  HRESULT (STDMETHODCALLTYPE *get_LocalPolicyModifyState) (INetFwPolicy2 *, NET_FW_MODIFY_STATE *);
END_INTERFACE
} INetFwPolicy2Vtbl;
interface INetFwPolicy2 {
  CONST_VTBL INetFwPolicy2Vtbl *lpVtbl;
};

#ifdef __cplusplus
}
#endif

#endif /*_INC_NETFW_H*/
