/* Copyright (c) 2020-2022 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef LOGIN_H
#define LOGIN_H

#include "logindialog.h"

namespace Ui {
class Login;
}

class Login : public LoginDialog
{
  Q_OBJECT

  typedef LoginDialog Parent;

public:
  explicit Login(QWidget * parent, const char * key);
  ~Login() Q_DECL_OVERRIDE;

  void setFormat();

  QString getKey() const;

  static QString translateKey(const QString & key);

public Q_SLOTS:
  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;

  void onShowPassToggled(bool);
  void onItemClicked(const QModelIndex &);

private slots:
  void on_shuffleButton_clicked();
  void on_formatButton_clicked();
  void on_loginButton_clicked();
  void on_generateButton_clicked();

  void on_actionQuit_triggered() { Parent::on_actionQuit_triggered(); }
  void on_actionConsole_triggered() { Parent::on_actionConsole_triggered(); }
  void on_actionAudioDevices_triggered() { Parent::on_actionAudioDevices_triggered(); }

  void on_actionEnglish_triggered();
  void on_actionFrench_triggered();
  void on_actionGerman_triggered();
  void on_actionUserManual_triggered() { Parent::on_actionUserManual_triggered(); }
  void on_actionAbout_triggered() { Parent::on_actionAbout_triggered(); }

private:
  bool checkKey(QKeyEvent * event) Q_DECL_OVERRIDE;
  void keyPressEvent(QKeyEvent * event) Q_DECL_OVERRIDE;

  static qulonglong getRandom(qulonglong max);

  Ui::Login * ui;

  bool m_password;
  bool m_sorted;
  int m_sortIndex[64];
  int m_format;

  QFont m_oldFont;
  QFont * m_newFont;
  int m_fontId;
};

#endif
