/*
  +----------------------------------------------------------------------+
  | PHP Version 4/5                                                      |
  +----------------------------------------------------------------------+
  | Author: Kazuhiro IIzuka                                              |
  +----------------------------------------------------------------------+
*/

/* $Id: simplate.cpp 49 2008-07-18 01:23:19Z kazuhiro $ */

/**
 * @file simplate.cpp
 * @brief Simplate class implementation
 * @author Kazuhiro IIzuka
 * @author Shimizu
 * @version $Id: simplate.cpp 49 2008-07-18 01:23:19Z kazuhiro $
 * Copyright (C) Kazuhiro IIzuka
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef PHP_WIN32
#include "config.w32.h"
#endif // PHP_WIN32

// C++ header...
#include <iostream>
#include <ctime>
#include <string>
#include <vector>
#include <set>
using std::cout;
using std::cerr;
using std::endl;
using std::string;
using std::vector;
using std::set;

extern "C" {
#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "ext/standard/php_var.h" // var_dump
//#include "ext/standard/file.h" // TODO: need it?
//#include "ext/standard/php_string.h" // TODO: need it?
#ifdef PHP_WIN32
#include "win32/flock.h"
#else
#include "ext/standard/flock_compat.h"
#endif // PHP_WIN32
}
#include "php_simplate.h"


//#define USE_ZEND_EXECUTE
#define SET_ZVAL_STRING(z,s) \
	INIT_PZVAL(&z); \
	Z_STRVAL(z) = estrndup(s,strlen(s)); \
	Z_STRLEN(z) = strlen(s); \
	Z_TYPE(z) = IS_STRING;




/* If you declare any globals in php_simplate.h uncomment this: */
ZEND_DECLARE_MODULE_GLOBALS(simplate)

/* True global resources - no need for thread safety here */
static int le_simplate;

// default parameters
#define DEFAULT_TEMPLATE_DIR "template"
#define DEFAULT_COMPILE_DIR "template_c"
#define DEFAULT_CACHE_DIR "cache"
#define DEFAULT_LEFT_DELIMITER "<{"
#define DEFAULT_RIGHT_DELIMITER "}>"
#define DEFAULT_COMPILE_CHECK true
#define DEFAULT_FORCE_COMPILE false
#define DEFAULT_LAZY_CHECK false
#define DEFAULT_CACHE_LIFETIME 3600
#define DEFAULT_CACHING 0 // 0 : no caching
                          // 1: use class cache_lifetime value
                          // 2: use cache_lifetime in cache file


#define SIMPLATE_FETCH 0
#define SIMPLATE_DISPLAY 1

// parameter names
#define TEMPLATE_DIR "template_dir"
#define COMPILE_DIR "compile_dir"
#define CACHE_DIR "cache_dir"
#define LEFT_DELIMITER "left_delimiter"
#define RIGHT_DELIMITER "right_delimiter"
#define COMPILE_CHECK "compile_check"
#define FORCE_COMPILE "force_compile"
#define LAZY_CHECK "lazy_check"
#define VERSION "0.4.1"
#define CACHE_LIFETIME "cache_lifetime"
#define CACHING "caching"

// class entry pointer
static zend_class_entry *simplate_entry_ptr;
static zend_function_entry php_simplate_functions[]={
#ifdef ZEND_ENGINE_2
  ZEND_ME(simplate,__construct,NULL,ZEND_ACC_PUBLIC)
  ZEND_ME(simplate,assign,NULL,ZEND_ACC_PUBLIC)
  ZEND_ME(simplate,fetch,NULL,ZEND_ACC_PUBLIC)
  ZEND_ME(simplate,display,NULL,ZEND_ACC_PUBLIC)
  ZEND_ME(simplate,clear_cache,NULL,ZEND_ACC_PUBLIC)
  ZEND_ME(simplate,register_prefilter,NULL,ZEND_ACC_PUBLIC)
  ZEND_ME(simplate,register_postfilter,NULL,ZEND_ACC_PUBLIC)
#else
  PHP_FALIAS(simplate,simplate_init,NULL)
  PHP_FALIAS(assign,simplate_assign,NULL)
  PHP_FALIAS(fetch,simplate_fetch,NULL)
  PHP_FALIAS(display,simplate_display,NULL)
  PHP_FALIAS(clear_cache,simplate_clear_cache,NULL)
  PHP_FALIAS(register_prefilter,simplate_register_prefilter,NULL)
  PHP_FALIAS(register_postfilter,simplate_register_postfilter,NULL)
#endif // ZEND_ENGINE_2
  {NULL,NULL,NULL}
};

/* {{{ simplate_functions[]
 *
 * Every user visible function must have an entry in simplate_functions[].
 */
function_entry simplate_functions[] = {
	{NULL, NULL, NULL}	/* Must be the last line in simplate_functions[] */
};
/* }}} */

/* {{{ simplate_module_entry
 */
zend_module_entry simplate_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"simplate",
	simplate_functions,
	PHP_MINIT(simplate),
	PHP_MSHUTDOWN(simplate),
	PHP_RINIT(simplate),		/* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(simplate),	/* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(simplate),
#if ZEND_MODULE_API_NO >= 20010901
	"0.1", /* Replace with version number for your extension */
#endif
	STANDARD_MODULE_PROPERTIES
};
/* }}} */

#ifdef COMPILE_DL_SIMPLATE
BEGIN_EXTERN_C()
ZEND_GET_MODULE(simplate)
END_EXTERN_C()
#endif

/* {{{ PHP_INI
 */
/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
    STD_PHP_INI_ENTRY("simplate.global_value",      "42", PHP_INI_ALL, OnUpdateLong, global_value, zend_simplate_globals, simplate_globals)
    STD_PHP_INI_ENTRY("simplate.global_string", "foobar", PHP_INI_ALL, OnUpdateString, global_string, zend_simplate_globals, simplate_globals)
PHP_INI_END()
*/
/* }}} */

/* {{{ php_simplate_init_globals
 */
/* Uncomment this function if you have INI entries */
static void php_simplate_init_globals(zend_simplate_globals *simplate_globals TSRMLS_DC)
{
	simplate_globals->global_string;
}
/* }}} */

#if 0
// create custom objects
typedef struct{
	string fetch_buffer;
	zend_object zo;
}simplate_object;

static void simplate_object_dtor(void *object,zend_object_handle handle TSRMLS_DC)
{
	zend_objects_destroy_object(object,handle TSRMLS_CC);
}
static void simplate_objects_clone(void *object,void **object_clone TSRMLS_DC)
{
	simplate_object *intern = (simplate_object*)object;
	simplate_object **intern_clone = (simplate_object**)object_clone;

	*intern_clone = emalloc(sizeof(simplate_object));
	(*intern_object)->zo.ce = intern->zo.ce;
	(*intern_object)->zo.in_get = 0;
	(*intern_object)->zo.in_set = 0;
	ALLOC_HASHTABLE((*intern_clone)->zo.properties);
	(*intern_clone)->fetch_buffer=

}
#endif // 0

static string get_include_filename(zval *obj,string template_dir,string filename TSRMLS_DC)
{
	string included_filename;
	if( filename.find("$")!=string::npos ){
		bool find_filename = false;
		string include_variable = "";
		for(int i=0;i<filename.length();i++){
			if( filename[i]=='$' ){
				find_filename = true;
			}else if( filename[i]=='.' ){
				break;
			}
			if( find_filename ){
				include_variable+=filename[i];
			}
//cerr << "[B2]include_variable=" << include_variable << endl;
		}
		include_variable.erase(0,1);
#ifdef ZEND_ENGINE_2
		zval *_tpl_vars=zend_read_property(Z_OBJCE_P(obj),obj,"_tpl_vars",strlen("_tpl_vars"),1 TSRMLS_CC);
#else
		zval *_tpl_vars;
		if (zend_hash_find(Z_OBJPROP_P(obj), "_tpl_vars", sizeof("_tpl_vars"), (void**)&_tpl_vars) != SUCCESS) {
// TODO:
		}
#endif // ZEND_ENGINE_2
		zval **zinclude_file;
		string new_filename;
		if( zend_hash_find(Z_ARRVAL_P(_tpl_vars),const_cast<char*>(include_variable.c_str()),include_variable.length()+1,(void**)&zinclude_file) == SUCCESS && Z_TYPE_PP(zinclude_file)==IS_STRING ){
//cerr << include_variable << " -> " << Z_STRVAL_PP(zinclude_file) << endl;
			new_filename = filename.replace(filename.find("$"),include_variable.length()+1,Z_STRVAL_PP(zinclude_file));
		}else{
			// TODO:
			zend_error(E_ERROR,"can't find include file.");
		}
		if( new_filename[0] == DEFAULT_SLASH ){
			included_filename = new_filename;
		}else{
			if( included_filename[0] == DEFAULT_SLASH ){
				included_filename = new_filename;
			}else{
				included_filename = template_dir;
				included_filename+= DEFAULT_SLASH;
				included_filename+= new_filename;
			}

		}
	}else if( filename[0] == DEFAULT_SLASH ){
		// <{include file="/path/to/file.tpl"}>
		included_filename=filename;
	}else{
		included_filename=template_dir;
		included_filename+=DEFAULT_SLASH;
		included_filename+=filename;
	}
	return included_filename;
}

static string _readfile(const char*filename TSRMLS_DC)
{
	string line;

	// check open_basedir restriction in php.ini
//zend_printf("open_basedir=%s\n",INI_STR("open_basedir"));
	if( php_check_open_basedir(filename TSRMLS_CC) ){
		return "";
	}

#ifdef PHP_WIN32
	php_stream *strm;
	char *buffer = NULL;
	size_t buffer_length = 0;

	strm = php_stream_open_wrapper((char*)filename,"rb",ENFORCE_SAFE_MODE|REPORT_ERRORS, NULL);
	if( !strm ){
		string error;
		error="Cannot read such file:";
		error+=filename;
		zend_error(E_ERROR,error.c_str());
		return "";
	}

	buffer_length = php_stream_copy_to_mem(strm, &buffer, PHP_STREAM_COPY_ALL, 0);
	php_stream_close(strm);
	if( buffer_length < 0 ){
		string error;
		error="Cannot read such file:";
		error+=filename;
		zend_error(E_ERROR,error.c_str());
		efree(buffer);
		return "";
	}
	line = buffer;
	efree(buffer);
#else
	FILE *fp;
	char buf[8192];
	fp = VCWD_FOPEN(filename,"rb");
	if (fp == NULL) {
		string error;
		error="Cannot read such file:";
		error+=filename;
		zend_error(E_ERROR,error.c_str());
		return "";
	}

	while (fgets(buf, sizeof(buf), fp) != 0 ){
		line+=buf;
	}

//cerr << "_readfile:" << line << endl;
	fclose(fp);
#endif // PHP_WIN32
	const char *xml_tag="<?xml";
	size_t pos = 0;
	string new_tag;
	while( (pos = line.find(xml_tag,pos)) != string::npos ){
		new_tag = "<?php echo \'";
		new_tag += xml_tag;
		new_tag += "\'; ?>";
		line.replace(pos,strlen(xml_tag),new_tag);
		pos += new_tag.length();

		new_tag = "<?php echo \'?>\'; ?>";
		pos = line.find("?>",pos);
		line.replace(pos,2,new_tag);
		pos += new_tag.length();
	}

	return line;
}

static string trim(const char *s)
{
	string new_str(s);
	// trim from left-side
	while (new_str[0] == ' ') {
		new_str.erase(0,1);
	}
	// trim from right-side
	while (new_str[new_str.length() - 1] == ' ') {
		new_str.erase(new_str.length()-1,1);
	}
	return new_str;
}

// replace sb into sa within str
static string& str_replace(string& str, const string sb, const string sa)
{
	string::size_type n, nb = 0;

	while ((n = str.find(sb,nb)) != string::npos){
		str.replace(n,sb.size(),sa);
		nb = n + sa.size();
	}
	return str;
}


static void split_element(const char *s,vector<string> &e,char separator='.')
{
//cerr << "split_element[" << s << "]" << endl;
	string str(s);
	size_t spos=0,epos=0;
	e.push_back(str.substr(spos,str.find(separator,spos)));
	while ((epos = str.find(separator, epos)) != string::npos) {
		e.push_back(str.substr(epos+1,str.find(separator,epos+1)-epos-1));
		epos++;
	}
}

static int get_identifier(const char *variable,int i,string &new_variable)
{
	int j=0;
	while( isalnum(variable[i]) || variable[i]=='_' ){
//cerr << "j=" << variable[i] << " ";
		new_variable+=variable[i];
		i++;
		j++;
	}
	return j;
}

static string parse_variable(const char *variable)
{
	const char *start_tag,*end_tag;
	string new_variable;

	if (variable[0] != '$' || strncmp(variable,"$this",5)==0 ) {
		new_variable=variable;
//		str_replace(new_variable,"[","[$");
//cerr << variable << " =>" << new_variable << endl;
		return new_variable;
	}

	new_variable="";
	if (strstr(variable, "[")) {
		// $hoge[i] -> _tpl_vars["hoge"][$i]
		// $hoge[i].foo.bar -> _tpl_vars["hoge"][$i]['foo']['bar']
		// $hoge[i].huga[j].foo -> _tpl_vars['hoge'][$i]['huga'][$j]['foo']
		// $hoge[i]->huga[j]->foo -> _tpl_vars['hoge'][$i]->huga[$j]->foo
//cerr << "variable=" << variable << " -> ";
		int i=0;
		while( variable[i] ){
//cerr << "i=" << variable[i] << " ";
			if( variable[i] == '$' ){
				new_variable+="$this->_tpl_vars['";
				i++;
				i+=get_identifier(variable,i,new_variable);
//cerr << "<<" << variable[i] << ">>" << endl;
				new_variable+="']";
			}else if( variable[i] == '.' ){
				new_variable+="['";
				i++;
				i+=get_identifier(variable,i,new_variable);
				new_variable+="']";
			}else if( variable[i] == '[' ){
				new_variable+="[$";
				i++;
				i+=get_identifier(variable,i,new_variable);
				new_variable+="]";
				i++;
			}else if( i>0 && variable[i] == '>' && variable[i-1] == '-'){
				new_variable+="->";
				i++;
				i+=get_identifier(variable,i,new_variable);
			}else{
				i++;
			}
		}
//cerr << "new_variable=" << new_variable << endl;
	}else if (strstr(variable, ".")) {
		vector<string> elements;
		split_element(variable+1,elements);
//for (vector<string>::iterator i = elements.begin(); i != elements.end(); ++i) {
//cerr << "<< " << *i << " >>" << endl;
//}
		if (elements.size() == 4 && elements[1] == "section" && elements[3] == "index") {
			new_variable+="$";
			new_variable+=elements[2];
		}else if (elements.size() == 4 && elements[1] == "section" && elements[3] == "count") {
			new_variable+="count($this->_tpl_vars[\"";
			new_variable+=elements[2];
			new_variable+="\"])";
		}else if (elements.size() == 4 && elements[1] == "section" && (elements[3] == "first"|| elements[3] == "last" )) {
			new_variable+="$this->_section['";
			new_variable+=elements[2];
			new_variable+="']['";
			new_variable+=elements[3];
			new_variable+="']";
		}else{
			new_variable+="$this->_tpl_vars";
			for (vector<string>::iterator i = elements.begin();i != elements.end(); ++i) {
				new_variable+="[\"";

				size_t pos=0;
				if( (pos=(*i).find("->"))!=string::npos ){
					new_variable+=(*i).substr(0,pos);
					new_variable+="\"]";
					new_variable+=(*i).substr(pos);
				}else{
					new_variable+=*i;
					new_variable+="\"]";
				}
			}
		}
	}else if(strstr(variable,"->")){
		string temp = variable;
		new_variable+="$this->_tpl_vars['";
		new_variable+=temp.substr(1,temp.find("->")-1);
		new_variable+="']";
		new_variable+=temp.substr(temp.find("->"));
	}else{
		// normal variable
		// {$key} -><?php $this->_tpl_vars['key']; ?>
		new_variable+="$this->_tpl_vars['";
		new_variable+=(variable+1);
		new_variable+="']";
	}
	return new_variable;

}

static string get_element(const char*s,const char* key)
{
	int i;
	string value="";
	string key_name;

	while (s = strstr(s, key)) {
		i=0;
		key_name="";
		while (isalnum(*(s+i))) {
			key_name+=*(s+i);
			i++;
		}
		if (strcmp(key_name.c_str(), key) == 0) {
			while (*(s+i) != '=') { i++; }
			i++;
			while (*(s+i) == '\'' || *(s+i) == '"' || *(s+i) == ' ') {
				i++;
			}
//			while (isalnum(*(s+i)) || *(s+i) == '$' || *(s+i) == '.' || *(s+i) == '[' || *(s+i) == ']' || *(s+i) == '_' ){
			while (*(s+i) != '\'' && *(s+i) != '"' && *(s+i) != ' ' && *(s+i) ) {
				value+=*(s+i);
				i++;
			}
			break;
		}
		s++;
	}
//cerr << "**" << value << "**" << endl;
	return value;
}

static inline bool _is_compiled(zval *obj, const char *template_dir, const char *compile_dir, const char *filename,const char *left_delimiter,const char *right_delimiter TSRMLS_DC)
{
	string error;
	bool compile_check=DEFAULT_COMPILE_CHECK;
	bool force_compile=0;
	bool lazy_check=0;

#ifdef ZEND_ENGINE_2
	zval *temp_zval;
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,COMPILE_CHECK,strlen(COMPILE_CHECK),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_BOOL ){
		compile_check = Z_BVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,FORCE_COMPILE,strlen(FORCE_COMPILE),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_BOOL ){
		force_compile = Z_BVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,LAZY_CHECK,strlen(LAZY_CHECK),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_BOOL ){
		lazy_check = Z_BVAL_P(temp_zval);
	}
#else
	zval **temp;
	if (zend_hash_find(Z_OBJPROP_P(obj), "compile_check", sizeof("compile_check"), (void**)&temp) == SUCCESS) {
		if (Z_TYPE_PP(temp) == IS_BOOL) {
			compile_check = Z_BVAL_PP(temp);
		}
	}
//cerr << "[_is_compiled]force_compile=" << force_compile << endl;
	if (zend_hash_find(Z_OBJPROP_P(obj), "force_compile", sizeof("force_compile"), (void**)&temp) == SUCCESS) {
		if (Z_TYPE_PP(temp) == IS_BOOL) {
//cerr << "temp=" << (*temp)->value.str.val << endl;
			force_compile = Z_BVAL_PP(temp);
//cerr << "force_compile:IS_BOOL" << Z_BVAL_PP(temp) << endl;
		}
	}
	if (zend_hash_find(Z_OBJPROP_P(obj), "lazy_check", sizeof("lazy_check"), (void**)&temp) == SUCCESS) {
		if (Z_TYPE_PP(temp) == IS_BOOL) {
			lazy_check = Z_BVAL_PP(temp);
		}
	}
#endif // ZEND_ENGINE_2

	if (force_compile) {
		return false;
	}

	//
	// Has the compiled file already exists?
	struct stat cs;
	string full_compile_filename(compile_dir);
	full_compile_filename+=DEFAULT_SLASH;
	full_compile_filename+=filename;
	if (VCWD_STAT(full_compile_filename.c_str(),&cs) == -1) {
		// the compiled file doesn't exists.
		return false;
	}

	if ( !compile_check ) {
		return true;
	}

	//
	// compare the file and compiled file.
	struct stat ts;
	string full_template_filename(template_dir);
	full_template_filename+=DEFAULT_SLASH;
	full_template_filename+=filename;

	if (VCWD_STAT(full_template_filename.c_str(),&ts) == -1) {
		error="cannot stat:";
		error+=full_template_filename;
		zend_error(E_ERROR,error.c_str());
		return false;
	}
//cerr << "[_is_compiled]" << full_compile_filename << endl;
//cerr << "[_is_compiled]" << full_template_filename << endl;
//cerr << "cs.st_mtime=" << cs.st_mtime << ",ts.st_mtime=" << ts.st_mtime << endl;
	// template file is newer than compiled file.
	if( cs.st_mtime<ts.st_mtime ){
		return false;
	}else{
		if( !lazy_check ){ // lazy check

			size_t pos=0;
			size_t tag_start_pos,tag_end_pos;
			size_t element_start_pos,element_end_pos;
			string item;
			string file_content = _readfile(full_template_filename.c_str() TSRMLS_CC);
			while ((pos = file_content.find(left_delimiter, pos)) != string::npos) {
				tag_start_pos=pos;
				element_start_pos=tag_start_pos+strlen(left_delimiter);
				element_end_pos=file_content.find(right_delimiter,tag_start_pos);
				if (element_end_pos == string::npos) {
					error="No closed delimiter:`";
					error+=right_delimiter;
					error+="' in ";
					error+=full_template_filename;
					zend_error(E_ERROR,error.c_str());
					return false;
				}
				tag_end_pos=element_end_pos+strlen(right_delimiter);
				item.assign(file_content,element_start_pos,element_end_pos-element_start_pos);
				item=trim(item.c_str());
				if (item[0]=='$') { pos++;continue; }
				if (item[0]=='*') { pos++;continue; }
				if (item.substr(0,7)=="include" ){
//cerr << "item=`" << item << "'" << endl;
					string filename=get_element(item.c_str(),"file");
					string included_filename = get_include_filename(obj,template_dir,filename TSRMLS_CC);
					// <{include file="$hoge"}> includes $smarty->_tpl_vars['hoge'] named file.

					struct stat is;
					// Check included template file timestamp
					if( VCWD_STAT(included_filename.c_str(),&is)== -1 ){
						error="cannot stat:";
						error+=included_filename;
						zend_error(E_ERROR,error.c_str());
						return false;
					}

//cerr << included_filename << endl;
//cerr << "cs.st_mtime=" << cs.st_mtime << ",ts.st_mtime=" << ts.st_mtime << endl;
					if( cs.st_mtime < is.st_mtime ){
						return false;
					}

					string new_condition = _readfile(included_filename.c_str() TSRMLS_CC);
					if (new_condition.find(filename) != string::npos) {
						error="Found recursive include:";
						error+=filename;
						zend_error(E_ERROR,error.c_str());
						return "";
					}
					file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,new_condition);
					continue;
				}
				pos++;
			}
		} // lazy check
	}

	return true;
}

void read_parse_template(INTERNAL_FUNCTION_PARAMETERS,char **fullfile_name,int mode,char **cache_content=NULL)
{
	zval *obj;
	char *resource_name=NULL;
	int resource_name_len=0;
	string template_dir;
	char *compile_dir;
	char *left_delimiter;
	char *right_delimiter;
	long caching=0;
	long cache_lifetime=0;
//	char temp[256];
	size_t i=0;
	string error;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &resource_name, &resource_name_len) == FAILURE) {
		return;
	}

	obj=getThis();
#ifdef ZEND_ENGINE_2
	zval *temp_zval;
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,TEMPLATE_DIR,strlen(TEMPLATE_DIR),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_STRING ){
		template_dir=Z_STRVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,COMPILE_DIR,strlen(COMPILE_DIR),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_STRING ){
		compile_dir=Z_STRVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,LEFT_DELIMITER,strlen(LEFT_DELIMITER),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_STRING ){
		left_delimiter=Z_STRVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,RIGHT_DELIMITER,strlen(RIGHT_DELIMITER),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_STRING ){
		right_delimiter=Z_STRVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,CACHING,strlen(CACHING),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_LONG ){
		caching = Z_LVAL_P(temp_zval);
	}
	temp_zval = zend_read_property(Z_OBJCE_P(obj),obj,CACHE_LIFETIME,strlen(CACHE_LIFETIME),1 TSRMLS_CC);
	if( Z_TYPE_P(temp_zval) == IS_LONG ){
		cache_lifetime = Z_LVAL_P(temp_zval);
	}
//cerr << "[" << __FILE__ << ":" << __LINE__ << "]caching=" << caching << endl;
#else
  zval **temp_zval;
//  char *k=0;
//  ulong i=0;
  // PHP4では、次のようにしないとvar_dump($this)が取れなかった。
  // $this=&$smarty;
//  zend_hash_update(&EG(symbol_table),"this",strlen("this")+1,&obj,sizeof(zval*),NULL);

  if (zend_hash_find(Z_OBJPROP_P(obj), TEMPLATE_DIR, sizeof(TEMPLATE_DIR), (void**)&temp_zval) == SUCCESS) {
    if ((*temp_zval)->type == IS_STRING) {
      template_dir=Z_STRVAL_PP(temp_zval);
    }
  }
  if (zend_hash_find(Z_OBJPROP_P(obj), COMPILE_DIR, sizeof(COMPILE_DIR), (void**)&temp_zval) == SUCCESS) {
    if ((*temp_zval)->type == IS_STRING) {
      compile_dir=Z_STRVAL_PP(temp_zval);
    }
  }
  if (zend_hash_find(Z_OBJPROP_P(obj), LEFT_DELIMITER, sizeof(LEFT_DELIMITER), (void**)&temp_zval) == SUCCESS) {
//cerr << "[zend_display]left_delimiter=" << Z_STRVAL_PP(temp_zval) << endl;
    if ((*temp_zval)->type == IS_STRING) {
      left_delimiter=Z_STRVAL_PP(temp_zval);
    }
  }
  if (zend_hash_find(Z_OBJPROP_P(obj), RIGHT_DELIMITER, sizeof(RIGHT_DELIMITER), (void**)&temp_zval) == SUCCESS) {
    if ((*temp_zval)->type == IS_STRING) {
      right_delimiter=Z_STRVAL_PP(temp_zval);
    }
  }
  if (zend_hash_find(Z_OBJPROP_P(obj), CACHING, sizeof(CACHING), (void**)&temp_zval) == SUCCESS) {
    if ((*temp_zval)->type == IS_LONG) {
      caching=Z_LVAL_PP(temp_zval);
    }
  }
  if (zend_hash_find(Z_OBJPROP_P(obj), CACHE_LIFETIME, sizeof(CACHE_LIFETIME), (void**)&temp_zval) == SUCCESS) {
    if ((*temp_zval)->type == IS_LONG) {
      cache_lifetime=Z_LVAL_PP(temp_zval);
    }
  }
#endif // ZEND_ENGINE_2

	if (template_dir[template_dir.length() - 1] == DEFAULT_SLASH /*'/'*/) {
		template_dir.erase(template_dir.length()-1,1);
	}
	string full_template_filename(template_dir);
	full_template_filename+=DEFAULT_SLASH;
	full_template_filename+=resource_name;
//cerr << "full_template_filename=" << full_template_filename << endl;
//cerr << "compile_dir=" << compile_dir << endl;
	string full_compile_filename(compile_dir);
	if (full_compile_filename[full_compile_filename.length() - 1] != DEFAULT_SLASH /*'/'*/) {
		full_compile_filename+=DEFAULT_SLASH;
	}
	full_compile_filename+=resource_name;
//cerr << "full_compile_filename=" << full_compile_filename << endl;
	// 
	if( caching ){
		struct stat cache_stat;
		char *cache_dir;
		bool compile_check;
		bool force_compile;
#ifdef ZEND_ENGINE_2
		cache_dir = Z_STRVAL_P(zend_read_property(Z_OBJCE_P(obj),obj,CACHE_DIR,strlen(CACHE_DIR),1 TSRMLS_CC));
		compile_check = Z_BVAL_P(zend_read_property(Z_OBJCE_P(obj),obj,COMPILE_CHECK,strlen(COMPILE_CHECK),1 TSRMLS_CC));
		force_compile = Z_BVAL_P(zend_read_property(Z_OBJCE_P(obj),obj,FORCE_COMPILE,strlen(FORCE_COMPILE),1 TSRMLS_CC));
#else
#endif // ZEND_ENGINE_2
		if (cache_dir[strlen(cache_dir)-1] == DEFAULT_SLASH /*'/'*/) {
			cache_dir[strlen(cache_dir)-1] = '\0';
		}
		// cache directory exists?
		if (VCWD_STAT(cache_dir, &cache_stat) != -1) {
			if (!S_ISDIR(cache_stat.st_mode)) {
				error = "does not exist cache directory: ";
				error += cache_dir;
				zend_error(E_ERROR, error.c_str());
				return;
			}
		}
		string full_cache_filename(cache_dir);
		full_cache_filename+=DEFAULT_SLASH;
		full_cache_filename+=resource_name;
		// there are no cache file.
		if (VCWD_STAT(full_cache_filename.c_str(),&cache_stat) == -1 || force_compile) {

create_cache:
			if( VCWD_STAT(full_compile_filename.c_str(),&cache_stat) == -1){
				goto compile;
			}

			zend_file_handle file_handle;
			zend_op_array *op_array;
			file_handle.filename=const_cast<char*>(full_compile_filename.c_str());
			file_handle.free_filename=0;
			file_handle.type=ZEND_HANDLE_FILENAME;
			file_handle.opened_path=NULL;
			op_array = zend_compile_file(&file_handle,ZEND_INCLUDE TSRMLS_CC);

			SIMPLATE_G(global_string.str(std::string())); // let global_string empty.
			int (*old_output_func)(const char*,unsigned int TSRMLS_DC);
			old_output_func=OG(php_body_write);
			OG(php_body_write)=php_my_output_func;
			zend_execute(op_array TSRMLS_CC);
			OG(php_body_write)=old_output_func;

//cerr << "[" << __FILE__ << "," << __LINE__ << "]" << SIMPLATE_G(global_string).str().length() << endl;
			if(mode == SIMPLATE_FETCH ){
				*cache_content = estrndup(SIMPLATE_G(global_string).str().c_str(),SIMPLATE_G(global_string).str().length());
			}else{
				if( SIMPLATE_G(global_string).str().length()>0 ){
					zend_printf("%s",SIMPLATE_G(global_string).str().c_str());
				}
			}
//cerr << "[" << __FILE__ << "," << __LINE__ << "]" << endl;
#ifdef PHP_WIN32
			php_stream *strm = php_stream_open_wrapper(const_cast<char*>(full_cache_filename.c_str()), "wb", ENFORCE_SAFE_MODE|REPORT_ERRORS, NULL);
			if( strm ){
				if( php_stream_supports_lock(strm) ){
					php_stream_lock(strm, LOCK_EX);
				}
				if( SIMPLATE_G(global_string).str().length()>0 ){
					php_stream_write_string(strm, const_cast<char*>(SIMPLATE_G(global_string).str().c_str()));
				}
				if( php_stream_supports_lock(strm) ){
					php_stream_lock(strm, LOCK_UN);
				}
				php_stream_close(strm);
			}
#else
			FILE *fp = VCWD_FOPEN(full_cache_filename.c_str(),"wb");
			if (fp == NULL) {
				// fail to create cache
				error = "fail to create cache:";
				error += full_cache_filename;
				zend_error(E_ERROR, error.c_str());
				return;
			}
			if (fwrite(SIMPLATE_G(global_string).str().c_str(), 1, SIMPLATE_G(global_string).str().length(), fp) != SIMPLATE_G(global_string).str().length()) {
				// fail to write cache
				error = "fail to write cache:";
				error += full_cache_filename;
				zend_error(E_ERROR, error.c_str());
				// Notice: don't retun,yet.
			}
			fclose(fp);
#endif // PHP_WIN32
			return;
		}else{
			if ( compile_check ) {
				// check cache filestamp
				time_t now;
				time(&now);
				if (now - cache_stat.st_mtime > cache_lifetime) {
					goto create_cache;
				}
			}
//zend_printf("cache:%ld,now:%ld(%ld)<br>\n",cache_stat.st_mtime,now,now-cache_stat.st_mtime);
			string file_contents = _readfile(full_cache_filename.c_str() TSRMLS_CC);
			if(mode == SIMPLATE_FETCH ){
				*cache_content = estrndup(file_contents.c_str(),file_contents.length());
			}else{
				zend_printf("%s",file_contents.c_str());
			}
			return;
		}
	}else{



	// the directory for compiled templates exists?
	struct stat compile_dir_stat;
	if (VCWD_STAT(compile_dir,&compile_dir_stat) != -1) {
		if (!S_ISDIR(compile_dir_stat.st_mode)) {
			error=compile_dir;
			error+=" is not directory";
			zend_error(E_ERROR,error.c_str());
			return;
		}
	}else{
		// mkdir recursively
		php_stream_context *context = NULL;
		if( !php_stream_mkdir(compile_dir,0777,(PHP_STREAM_MKDIR_RECURSIVE|REPORT_ERRORS),context) ){
			zend_error(E_ERROR,"fail to mkdir (%s)",compile_dir);
			return;
		}

/*
		if( mkdir(compile_dir,0755) != 0 ){
			zend_error(E_ERROR,"fail to mkdir (%s)",compile_dir);
			return;
		}
*/
	}

	// already compiled
	if (_is_compiled(obj, template_dir.c_str(), compile_dir, resource_name, left_delimiter, right_delimiter TSRMLS_CC)) {
	
	}else{
compile:
		// compile now
		string compiled_file_content = _readfile(full_template_filename.c_str() TSRMLS_CC);

		// prefilter
		zval *plugins = zend_read_property(Z_OBJCE_P(obj),obj,"_plugins",strlen("_plugins"),1 TSRMLS_CC);
		if( plugins && Z_TYPE_P(plugins) == IS_ARRAY ){
			zval **prefilter;
			if( zend_hash_find(Z_ARRVAL_P(plugins),"prefilter",sizeof("prefilter"),(void**)&prefilter) == SUCCESS && Z_TYPE_PP(prefilter) == IS_ARRAY ){
				zval **elem;
				zend_hash_internal_pointer_reset(Z_ARRVAL_PP(prefilter));
				while (zend_hash_get_current_data(Z_ARRVAL_PP(prefilter), (void**)&elem) == SUCCESS) {

//cout << "prefilter function=" << Z_STRVAL_PP(elem) << endl;
					zval prefilter_function,prefilter_ret;
					zval zcontent;
					zval *prefilter_argv[1];
					prefilter_argv[0] = &zcontent;
					SET_ZVAL_STRING(zcontent,compiled_file_content.c_str());

					INIT_ZVAL(prefilter_function);
					ZVAL_STRING(&prefilter_function,Z_STRVAL_PP(elem),1);


					if( call_user_function(EG(function_table),NULL,&prefilter_function,&prefilter_ret,1,prefilter_argv TSRMLS_CC) == FAILURE ){
						zval_dtor(&zcontent);
						zend_error(E_ERROR,"fail to %s",Z_STRVAL_PP(elem));
						return;
					}
					zval_dtor(&prefilter_function);
					zval_dtor(&zcontent);

//zval *p = &prefilter_ret;php_var_dump(&p,1 TSRMLS_CC);
					compiled_file_content = Z_STRVAL(prefilter_ret);
//cout << "compiled_file_content=" << compiled_file_content << endl;
					zval_dtor(&prefilter_ret);
					zend_hash_move_forward(Z_ARRVAL_PP(prefilter));
				}
			}
		}

//cout << "[is_compile]" << endl;
//php_var_dump(&plugins,1 TSRMLS_CC);









		size_t pos=0;
		size_t tag_start_pos,tag_end_pos;
		size_t element_start_pos,element_end_pos;
		string item;
		char end_comment_tag[12];
		string new_condition;
		sprintf(end_comment_tag,"*%s",right_delimiter);
		while ((pos = compiled_file_content.find(left_delimiter, pos)) != string::npos) {
//cerr << compiled_file_content << "," << pos << endl; // 20060527
//cerr << pos << endl;
			// <{$hoge}>
			// ^         :tag_start_pos
			//   ^       :element_start_pos
			//        ^  :element_end_pos
			//          ^:tag_end_pos

			tag_start_pos=pos;
			element_start_pos=tag_start_pos+strlen(left_delimiter);
			element_end_pos=compiled_file_content.find(right_delimiter,tag_start_pos);
			if (element_end_pos == string::npos) {
				error="No closed delimiter:`";
				error+=right_delimiter;
				error+="' in ";
				error+=full_template_filename;
				zend_error(E_ERROR,error.c_str());
				return;
			}
			tag_end_pos=element_end_pos+strlen(right_delimiter);

			item.assign(compiled_file_content,element_start_pos,element_end_pos-element_start_pos);
			item=trim(item.c_str());
			string variable;
			string new_variable;
//cerr << "item=" << item << endl; // 20060527
			if (item[0] == '$') { // variables
#ifdef DEBUG
cerr << "VARIABLES:'" << item << "'" << endl;
#endif // DEBUG
cond_var:
				new_condition="<?php echo ";

				i=0;
//cerr << "tag_start_pos=" << tag_start_pos << endl;
				while (element_start_pos + i < element_end_pos) {
					if (compiled_file_content[element_start_pos + i] == '+'
					 || (compiled_file_content[element_start_pos + i] == '-' && compiled_file_content.at(element_start_pos+i+1)!='>')
					 || compiled_file_content[element_start_pos + i] == '*'
					 || compiled_file_content[element_start_pos + i] == '/'
					 || compiled_file_content[element_start_pos + i] == '%'
					 || compiled_file_content[element_start_pos + i] == '('
					 || compiled_file_content[element_start_pos + i] == ')'
					 || compiled_file_content[element_start_pos + i] == ','
					 || compiled_file_content[element_start_pos + i] == '\''
					 || compiled_file_content[element_start_pos + i] == '"'
					 || compiled_file_content[element_start_pos + i] == '?'
					 || compiled_file_content[element_start_pos + i] == ':'
					 || compiled_file_content[element_start_pos + i] == ';'
					 || compiled_file_content[element_start_pos + i] == ','
					 || compiled_file_content[element_start_pos + i] == ' '
					) {

						if( variable!="$" ){
							new_variable = parse_variable(variable.c_str());
//cerr << "val1=" << variable << " -> " << new_variable << endl;
						}else{
							new_variable = variable;
						}
						new_condition+=new_variable;
						new_condition+=compiled_file_content[element_start_pos+i];
						variable="";
					}else{
						variable+=compiled_file_content[element_start_pos+i];
					}
					i++;
				}
				new_variable = parse_variable(variable.c_str());
//cerr << "val2=" << variable << " -> " << new_variable << endl;
				new_condition+=new_variable;
				new_condition+="; ?>";
//cerr << "new_condition=" << new_condition << endl;
				compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,new_condition);
				pos+=new_condition.length()-1; // 20060527
			}else if (item[0] == '*') { // Comment
				if (item[item.length() - 1] != '*') { // support multi-line comment
					tag_end_pos=compiled_file_content.find(end_comment_tag,tag_end_pos)+strlen(end_comment_tag);
//cerr << "MULTILINE:" << end_comment_tag << ":" <<tag_end_pos << endl;
				}
//cerr << "COMMENT:'" << compiled_file_content.substr(tag_start_pos,tag_end_pos-tag_start_pos) << "'" << endl;
#ifdef DEBUG
cerr << "COMMENT:" << compiled_file_content.substr(tag_start_pos,tag_end_pos-tag_start_pos+strlen(end_comment_tag)) << endl;
#endif // DEBUG
				compiled_file_content.erase(tag_start_pos,tag_end_pos-tag_start_pos);
			}else{
//cerr << "CONDITION:'" << item << "'" << endl;
				string command_tag;
				string condition;
				if (item.find(" ") != string::npos) {
					command_tag=item.substr(0,item.find(" "));
					condition=item.substr(item.find(" ")+1);
				}else{
					command_tag=item;
				}
#ifdef DEBUG
cerr << "COMMAND:" << command_tag << ",CONDITION:" << condition << endl;
#endif // DEBUG
				if (command_tag == "if") {
					new_condition="<?php if (";
cond_if:
					bool is_operand=false;
					i=0;
					while (i < condition.length()) {
						if (condition[i]=='+'
						  ||(condition[i]=='-' && condition.at(i+1)!='>')
						  ||condition[i]=='*'
						  ||condition[i]=='/'
						  ||condition[i]=='%'
						  ||condition[i]=='<'
						  ||(condition[i]=='>' && condition.at(i-1)!='-')
						  ||condition[i]=='='
						  ||condition[i]=='!'
						  ||condition[i]=='|'
						  ||condition[i]=='&'
						  ||condition[i]=='('
						  ||condition[i]==')'
						  ||condition[i]==','
						  ||condition[i]==' '
						) {
							new_variable = parse_variable(variable.c_str());
							new_condition+=new_variable;
							new_condition+=condition[i];
							variable="";
						}else{
							variable+=condition[i];
						}
						i++;
					}
					new_variable = parse_variable(variable.c_str());
					new_condition+=new_variable;
					new_condition+=" ){ ?>";
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,new_condition);
					pos+=new_condition.length()-1; // 20060527
				}else if (command_tag == "/if") {
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,"<?php } ?>");
					pos+=strlen("<?php } ?>")-1; // 20060527
				}else if (command_tag == "else") {
					if (item.find("else if") != string::npos ){
						new_condition="<?php }else if (";
						condition=item.substr(item.find("else if")+strlen("else if"));
						condition=trim(condition.c_str());
						goto cond_if;
					}
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,"<?php }else{ ?>");
					pos+=strlen("<?php }else{ ?>")-1; // 20060527
				}else if (command_tag == "elseif") {
					new_condition="<?php }else if (";
					goto cond_if;
				}else if (command_tag == "section") {
					string section_name=get_element(item.c_str(),"name");
					string section_loop=get_element(item.c_str(),"loop");
					string section_start=get_element(item.c_str(),"start");
					string section_step=get_element(item.c_str(),"step");

//					string new_section_loop=parse_variable(section_loop.c_str());
					string new_section_loop2="";
					condition = section_loop;
//cerr << "section_loop=" << section_loop << endl;
					i=0;
					while (i < condition.length()) {
						if (condition[i]=='+'
						  ||condition[i]=='-'
						  ||condition[i]=='*'
						  ||condition[i]=='/'
						  ||condition[i]=='%'
						  ||condition[i]=='<'
						  ||condition[i]=='>'
						  ||condition[i]=='='
						  ||condition[i]=='!'
						  ||condition[i]=='|'
						  ||condition[i]=='&'
						  ||condition[i]=='('
						  ||condition[i]==')'
						) {
							new_variable = parse_variable(variable.c_str());
							new_section_loop2 += new_variable;
							new_section_loop2 += condition[i];
//cerr << "v1=" << variable << " => " << new_section_loop2 << endl;
							variable = "";
						}else{
							if (condition[i] != ' ') {
								variable += condition[i];
							}
//cerr << "v2=" << variable << endl;
						}
						i++;
					}
//cerr << "v3=" << variable << " -> " << parse_variable(variable.c_str()) << endl;
					new_section_loop2+=parse_variable(variable.c_str());
//cerr << "new_section_loop2=" << new_section_loop2 << endl;
					new_condition="<?php ";
					new_condition+="$this->_section['";
					new_condition+=section_name;
					new_condition+="']['total']=";
					new_condition+="count(";
					new_condition+=new_section_loop2;
					new_condition+=");\n";
					new_condition+="for ($";
					new_condition+=section_name;
					new_condition+="=";
					if (section_start.length() > 0) {
						new_condition+=section_start;
					}else{
						new_condition+="0";
					}
					new_condition+=",$this->_section['";
					new_condition+=section_name;
					new_condition+="']['iteration']=1;$";
					new_condition+=section_name;
					new_condition+="<$this->_section['";
					new_condition+=section_name;
//					new_condition+=new_section_loop;
					new_condition+="']['total'];$";
					new_condition+=section_name;
					if (section_step.length() > 0) {
						new_condition+="+=";
						new_condition+=section_step;
					}else{
						new_condition+="++";
					}
					new_condition+=",$this->_section['";
					new_condition+=section_name;
					new_condition+="']['iteration']++";
					new_condition+="){\n";
					new_condition+="$this->_section['";
					new_condition+=section_name;
					new_condition+="']['first'] = ($";
					new_condition+=section_name;
					new_condition+=" == ";
					if (section_start.length() > 0){
						new_condition+=section_start;
					}else{
						new_condition+="0";
					}
					new_condition+=");\n";
					new_condition+="$this->_section['";
					new_condition+=section_name;
					new_condition+="']['last'] = ($this->_section['";
					new_condition+=section_name;
					new_condition+="']['iteration']";
					new_condition+=" == $this->_section['";
					new_condition+=section_name;
					new_condition+="']['total']);\n";
					new_condition+="?>";
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,new_condition);
					pos+=new_condition.length()-1; // 20060527
				}else if (command_tag == "/section") {
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,"<?php } ?>");
					pos+=strlen("<?php } ?>")-1; // 20060527
				}else if (command_tag == "foreach") {
					string foreach_key=get_element(item.c_str(),"key");
					string foreach_item=get_element(item.c_str(),"item");
					string foreach_from=get_element(item.c_str(),"from");

					string new_foreach_from2 = "";
					condition = foreach_from;
					i=0;
					while (i < condition.length()) {
						if (condition[i]=='+'
						  ||condition[i]=='-'
						  ||condition[i]=='*'
						  ||condition[i]=='/'
						  ||condition[i]=='%'
						  ||condition[i]=='<'
						  ||condition[i]=='>'
						  ||condition[i]=='='
						  ||condition[i]=='!'
						  ||condition[i]=='|'
						  ||condition[i]=='&'
						  ||condition[i]=='('
						  ||condition[i]==')'
						) {
							new_variable = parse_variable(variable.c_str());
							new_foreach_from2 += new_variable;
							new_foreach_from2 += condition[i];
							variable = "";
						} else {
							if (condition[i] != ' ') {
								variable += condition[i];
							}
						}
						i++;
					}
					new_foreach_from2 += parse_variable(variable.c_str());
					new_condition = "<?php ";
					new_condition += "if( !is_array(";
					new_condition += new_foreach_from2;
					new_condition += ") && !is_object(";
					new_condition += new_foreach_from2;
					new_condition += ") ){settype(";
					new_condition += new_foreach_from2;
					new_condition += ",'array'); }";
					new_condition += "if( count(";
					new_condition += new_foreach_from2;
					new_condition += ") ){";

					new_condition +="foreach( ";
					new_condition += new_foreach_from2;
					new_condition += " as ";
					if (foreach_key.length() > 0) {
						new_condition += "$this->_tpl_vars[\"";
						new_condition += foreach_key;
						new_condition += "\"]=>";
					}
					new_condition += "$this->_tpl_vars[\"";
					new_condition += foreach_item;
					new_condition += "\"] ){ ?>";

					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,new_condition);
					pos+=new_condition.length()-1; // 20060527

				}else if (command_tag == "/foreach") {
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,"<?php }} ?>"); // endforeach,endif
					pos+=strlen("<?php }} ?>")-1; // 20060527
				}else if (command_tag == "include") {
					string filename=get_element(item.c_str(),"file");
					string included_filename = get_include_filename(obj,template_dir,filename TSRMLS_CC);

					new_condition = _readfile(included_filename.c_str() TSRMLS_CC);
					if (new_condition.find(filename) != string::npos) {
						error="Found recursive include:";
						error+=filename;
						zend_error(E_ERROR,error.c_str());
						return;
					}
					compiled_file_content.replace(tag_start_pos,tag_end_pos-tag_start_pos,new_condition);
					continue; // don't skip with pos
				}else if (command_tag == "php") {
					string end_php_tag;
					size_t php_tag_end_pos;
					end_php_tag  = left_delimiter;
					end_php_tag += "/php";
					end_php_tag += right_delimiter;
					php_tag_end_pos = compiled_file_content.find(end_php_tag,tag_end_pos);
					new_condition  = "<?php ";
					new_condition += compiled_file_content.substr(tag_end_pos,php_tag_end_pos-tag_end_pos);
					new_condition += " ?>";
					compiled_file_content.replace(tag_start_pos,php_tag_end_pos+end_php_tag.length()-tag_start_pos,new_condition);
					pos+=new_condition.length()-1;
				}else if (command_tag == "literal") {
					string end_literal = left_delimiter;
					end_literal+="/literal";
					end_literal+=right_delimiter;
					// TODO:tidy up??
					new_condition=compiled_file_content.substr(tag_end_pos,compiled_file_content.find(end_literal,element_end_pos)-tag_end_pos);
//cerr << "NEW_CONDITION:" << new_condition << "*" << endl;
					compiled_file_content.replace(tag_start_pos,compiled_file_content.find(end_literal,element_end_pos)+end_literal.length()-tag_start_pos,new_condition);
					pos+=new_condition.length()-1;
				}else{
					goto cond_var;
				}

			}
			pos++;
//cerr << "\nlast_pos=" << pos << endl; // 20060527
		}
#ifdef DEBUG
cerr << "FILE:[[" << compiled_file_content << "]]" << endl;
#endif // DEBUG

		// postfilter
		if( plugins && Z_TYPE_P(plugins) == IS_ARRAY ){
			zval **postfilter;
			if( zend_hash_find(Z_ARRVAL_P(plugins),"postfilter",sizeof("postfilter"),(void**)&postfilter) == SUCCESS && Z_TYPE_PP(postfilter) == IS_ARRAY ){
				zval **elem;
				zend_hash_internal_pointer_reset(Z_ARRVAL_PP(postfilter));
				while (zend_hash_get_current_data(Z_ARRVAL_PP(postfilter), (void**)&elem) == SUCCESS) {

					zval postfilter_function,postfilter_ret;
					zval zcontent;
					zval *postfilter_argv[1];
					postfilter_argv[0] = &zcontent;
					SET_ZVAL_STRING(zcontent,compiled_file_content.c_str());

					INIT_ZVAL(postfilter_function);
					ZVAL_STRING(&postfilter_function,Z_STRVAL_PP(elem),1);

					if( call_user_function(EG(function_table),NULL,&postfilter_function,&postfilter_ret,1,postfilter_argv TSRMLS_CC) == FAILURE ){
						zval_dtor(&zcontent);
						zend_error(E_ERROR,"fail to %s",Z_STRVAL_PP(elem));
						return;
					}
					zval_dtor(&postfilter_function);
					zval_dtor(&zcontent);

					compiled_file_content = Z_STRVAL(postfilter_ret);
					zval_dtor(&postfilter_ret);

					zend_hash_move_forward(Z_ARRVAL_PP(postfilter));
				}
			}
		}

#ifdef PHP_WIN32
		php_stream *strm = php_stream_open_wrapper(const_cast<char*>(full_compile_filename.c_str()), "wb", ENFORCE_SAFE_MODE|REPORT_ERRORS, NULL);
		if( !strm ){
			// TODO:if full_complile_filename includes sub directory,try making  subdirectory once..
		}
		if( strm ){
			if( php_stream_supports_lock(strm) ){
				php_stream_lock(strm, LOCK_EX);
			}
			if( compiled_file_content.length()>0 ){
				php_stream_write_string(strm, const_cast<char*>(compiled_file_content.c_str()));
			}
			if( php_stream_supports_lock(strm) ){
				php_stream_lock(strm, LOCK_UN);
			}
			php_stream_close(strm);
		}
#else
		// write compiled file
		FILE *fp = VCWD_FOPEN(full_compile_filename.c_str(),"wb");
		if (fp == NULL) {
			// check sub directory exists or not.
			if( full_compile_filename.find(DEFAULT_SLASH) != string::npos ){
				vector<string> elements;
				split_element(const_cast<char*>(full_compile_filename.c_str()),elements,DEFAULT_SLASH);
				string sub_directory=elements[0];
				for(vector<string>::iterator i = elements.begin()+1; i != elements.end()-1; ++i){
					sub_directory+=DEFAULT_SLASH;
					sub_directory+=(*i);
					struct stat cs;
					if (VCWD_STAT(sub_directory.c_str(),&cs) == -1) {
						mkdir(sub_directory.c_str(),0755);
					}
				}
			}

			fp = VCWD_FOPEN(full_compile_filename.c_str(),"wb");
			if( fp == NULL ){
				// error handling
				zend_error(E_ERROR,"fail to write : %s",full_compile_filename.c_str());
				return;
			}
		}
		if (fwrite(compiled_file_content.c_str(), 1, compiled_file_content.length(), fp) != compiled_file_content.length()) {
			error="fail to write :";
			error+=full_compile_filename;
			zend_error(E_WARNING,error.c_str());
			return;
		}
		fclose(fp);
#endif // PHP_WIN32
	}

	*fullfile_name = estrndup(full_compile_filename.c_str(),full_compile_filename.length());
//	return const_cast<char*>(full_compile_filename.c_str());
		return;
	}
}

static void register_simplate_properties(TSRMLS_D)
{
  zend_class_entry simplate_ce;
  zval *tmp;

  // register class entry
  INIT_CLASS_ENTRY(simplate_ce,"Simplate",php_simplate_functions);
  simplate_entry_ptr = zend_register_internal_class(&simplate_ce TSRMLS_CC);

#ifdef ZEND_ENGINE_2
  /**
   * Class property
   */
  // directory parameter seting
  zend_declare_property_string(simplate_entry_ptr,TEMPLATE_DIR,strlen(TEMPLATE_DIR),DEFAULT_TEMPLATE_DIR,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_string(simplate_entry_ptr,COMPILE_DIR,strlen(COMPILE_DIR),DEFAULT_COMPILE_DIR,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_string(simplate_entry_ptr,CACHE_DIR,strlen(CACHE_DIR),DEFAULT_CACHE_DIR,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_long(simplate_entry_ptr,CACHING,strlen(CACHING),DEFAULT_CACHING,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_long(simplate_entry_ptr,CACHE_LIFETIME,strlen(CACHE_LIFETIME),DEFAULT_CACHE_LIFETIME,ZEND_ACC_PUBLIC TSRMLS_CC);

  // delimitter
  zend_declare_property_string(simplate_entry_ptr,LEFT_DELIMITER,strlen(LEFT_DELIMITER),DEFAULT_LEFT_DELIMITER,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_string(simplate_entry_ptr,RIGHT_DELIMITER,strlen(RIGHT_DELIMITER),DEFAULT_RIGHT_DELIMITER,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_bool(simplate_entry_ptr,COMPILE_CHECK,strlen(COMPILE_CHECK),DEFAULT_COMPILE_CHECK,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_bool(simplate_entry_ptr,FORCE_COMPILE,strlen(FORCE_COMPILE),DEFAULT_FORCE_COMPILE,ZEND_ACC_PUBLIC TSRMLS_CC); // force_compile
  zend_declare_property_bool(simplate_entry_ptr,LAZY_CHECK,strlen(LAZY_CHECK),DEFAULT_LAZY_CHECK,ZEND_ACC_PUBLIC TSRMLS_CC);
  zend_declare_property_string(simplate_entry_ptr,"version",strlen("version"),VERSION,ZEND_ACC_PUBLIC TSRMLS_CC); // version

  // temporary
  zend_declare_property_null(simplate_entry_ptr,"_tpl_vars",strlen("_tpl_vars"),ZEND_ACC_PUBLIC TSRMLS_CC);
  // plugins
  zend_declare_property_null(simplate_entry_ptr,"_plugins",strlen("_plugins"),ZEND_ACC_PUBLIC TSRMLS_CC);
#endif // ZEND_ENGINE_2
}

/* {{{ PHP_MINIT_FUNCTION
 */
PHP_MINIT_FUNCTION(simplate)
{
	/* If you have INI entries, uncomment these lines 
	ZEND_INIT_MODULE_GLOBALS(simplate, php_simplate_init_globals, NULL);
	REGISTER_INI_ENTRIES();
	*/
	ZEND_INIT_MODULE_GLOBALS(simplate, php_simplate_init_globals, NULL);
	register_simplate_properties(TSRMLS_C);

	return SUCCESS;
}
/* }}} */

/* {{{ PHP_MSHUTDOWN_FUNCTION
 */
PHP_MSHUTDOWN_FUNCTION(simplate)
{
	/* uncomment this line if you have INI entries
	UNREGISTER_INI_ENTRIES();
	*/
	return SUCCESS;
}
/* }}} */

/* Remove if there's nothing to do at request start */
/* {{{ PHP_RINIT_FUNCTION
 */
PHP_RINIT_FUNCTION(simplate)
{
	return SUCCESS;
}
/* }}} */

/* Remove if there's nothing to do at request end */
/* {{{ PHP_RSHUTDOWN_FUNCTION
 */
PHP_RSHUTDOWN_FUNCTION(simplate)
{
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_MINFO_FUNCTION
 */
PHP_MINFO_FUNCTION(simplate)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "simplate support", "enabled");
	php_info_print_table_row(2, "Version", VERSION);
	php_info_print_table_end();

	/* Remove comments if you have entries in php.ini
	DISPLAY_INI_ENTRIES();
	*/
}
/* }}} */

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,__construct)
#else
PHP_FUNCTION(simplate_init)
#endif // ZEND_ENGINE_2
{
//cerr << "simplate::__construct" << endl;
#ifdef ZEND_ENGINE_2
#else
  zval *obj = getThis();
  object_init_ex(obj,simplate_entry_ptr);
  add_property_string(obj, TEMPLATE_DIR, DEFAULT_TEMPLATE_DIR, 1);
  add_property_string(obj, COMPILE_DIR, DEFAULT_COMPILE_DIR, 1);
  add_property_string(obj, CACHE_DIR, DEFAULT_CACHE_DIR, 1);
  add_property_long(obj, CACHING, DEFAULT_CACHING);
  add_property_long(obj, CACHE_LIFETIME, DEFAULT_CACHE_LIFETIME);

  add_property_string(obj, LEFT_DELIMITER, DEFAULT_LEFT_DELIMITER, 1);
  add_property_string(obj, RIGHT_DELIMITER, DEFAULT_RIGHT_DELIMITER, 1);
  add_property_bool(obj, COMPILE_CHECK, DEFAULT_COMPILE_CHECK);
  add_property_bool(obj, FORCE_COMPILE, DEFAULT_FORCE_COMPILE);
  add_property_bool(obj, LAZY_CHECK, DEFAULT_LAZY_CHECK);
  add_property_string(obj, "version", VERSION, 1);
#endif // ZEND_ENGINE_2
}
#ifdef ZEND_ENGINE_2
#else
/** Set already exist array on new array recursively(PHP4).
 * @param struc old array
 * @param new_array new array to be set
 * @retval -
 */
static void php_set_r(zval **struc,zval **new_array)
{
//cerr << "[IN php_set_r]" << *struc << endl;
  zval **elem;
  char *k=0;
  ulong i=0;
  char buf[128];

  zend_hash_internal_pointer_reset(Z_ARRVAL_PP(struc));
  while (zend_hash_get_current_data(Z_ARRVAL_PP(struc), (void **)&elem) == SUCCESS) {
    zend_hash_get_current_key(Z_ARRVAL_PP(struc),&k,&i,0);
    sprintf(buf,"%d",i);
    switch( Z_TYPE_PP(elem) ){
    case IS_NULL:
      add_assoc_unset(*new_array,k);
      break;
    case IS_BOOL:
      add_assoc_bool(*new_array,k,Z_BVAL_PP(elem));
      break;
    case IS_LONG:
//cerr << "[php_set_r]IS_LONG(" << k << "," << i << "," << Z_LVAL_PP(elem) << ")" << endl;
      add_assoc_long(*new_array,k,Z_LVAL_PP(elem));
      break;
    case IS_DOUBLE:
//cerr << "[php_set_r]IS_DOUBLE(" << k << "," << i << "," << Z_DVAL_PP(elem) << ")" << endl;
      add_assoc_double(*new_array,k,Z_DVAL_PP(elem));
      break;
    case IS_STRING:
//cerr << "[php_set_r]IS_STRING1(" << k << "," << i << "," << Z_STRVAL_PP(elem) << ")" << endl;
      add_assoc_stringl(*new_array,k,Z_STRVAL_PP(elem),Z_STRLEN_P(elem)/* (*elem)->value.str.val */,1);
      break;
    case IS_ARRAY:
      zval_add_ref(elem);
      add_assoc_zval(*new_array,k,*elem);
    }
    zend_hash_move_forward(Z_ARRVAL_PP(struc));
  }
//cerr << "[OUT php_set_r]" << endl;
}
#endif // ZEND_ENGINE_2

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,assign)
#else
PHP_FUNCTION(simplate_assign)
#endif // ZEND_ENGINE_2
{
  char *key=NULL;
  zval *zvalue;
  int key_len;

//cerr << "simplate::assign" << endl;
  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "sz", &key, &key_len, &zvalue) == FAILURE) {
      return;
  }
  zval *obj=getThis();
  zval *new_array;

#ifdef ZEND_ENGINE_2
  new_array=zend_read_property(Z_OBJCE_P(obj),obj,"_tpl_vars",strlen("_tpl_vars"),1 TSRMLS_CC);
  // initialize.use new_array on the first time.
  if (new_array == EG(uninitialized_zval_ptr) || Z_TYPE_P(new_array) == IS_NULL) {
    MAKE_STD_ZVAL(new_array);
    array_init(new_array);
    ZVAL_DELREF(new_array);
  }
#else
  zval **tmp;
  MAKE_STD_ZVAL(new_array);
  array_init(new_array);
  // the ``_tpl_vars'' exists already.
  if (zend_hash_find(Z_OBJPROP_P(obj), "_tpl_vars", sizeof("_tpl_vars"), (void**)&tmp) == SUCCESS) {
    // set old array to new array recursively.
    php_set_r(tmp,&new_array);
  }
#endif // ZEND_ENGINE_2

  switch( Z_TYPE_P(zvalue) ){
  case IS_NULL:
    add_assoc_unset(new_array,key);
    break;
  case IS_BOOL:
    add_assoc_bool(new_array,key,Z_BVAL_P(zvalue));
    break;
  case IS_DOUBLE:
    add_assoc_double(new_array,key,Z_DVAL_P(zvalue));
    break;
  case IS_STRING:
    add_assoc_stringl(new_array,key,Z_STRVAL_P(zvalue),Z_STRLEN_P(zvalue),1);
    break;
  case IS_LONG:
    add_assoc_long(new_array,key,Z_LVAL_P(zvalue));
    break;
  case IS_ARRAY:
    zval_add_ref(&zvalue); // don't forget this!
    add_assoc_zval(new_array,key,zvalue);
    break;
  case IS_OBJECT:
    zval_add_ref(&zvalue);
    add_assoc_zval(new_array,key,zvalue);
  }

#ifdef ZEND_ENGINE_2
  zend_update_property(Z_OBJCE_P(obj),obj,"_tpl_vars",strlen("_tpl_vars"),new_array TSRMLS_CC);
#else
  zend_hash_update(Z_OBJPROP_P(obj),"_tpl_vars",strlen("_tpl_vars")+1,&new_array,sizeof(zval*),NULL);
#endif // ZEND_ENGINE_2
	return;
}

static int php_my_output_func(const char *str,uint str_len TSRMLS_DC)
{
//cerr << "php_my_output_func(" << str << ")" << endl;
//fwrite(str,9,str_len,stdout);
#ifdef _SEGFAULT_
//	SIMPLATE_G(global_string)+=str;
#endif // _SEGFAULT_
	SIMPLATE_G(global_string)<<str;
	return str_len;
}

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,fetch)
#else
PHP_FUNCTION(simplate_fetch)
#endif // ZEND_ENGINE_2
{
	string error;
	char *fullfile_name = NULL;
	char *fetch_content = NULL;
	read_parse_template(INTERNAL_FUNCTION_PARAM_PASSTHRU, &fullfile_name,SIMPLATE_FETCH,&fetch_content);

	if( fetch_content ){
		RETURN_STRING(fetch_content,1);
	}

	if (!fullfile_name || strlen(fullfile_name) <= 0 ){
		return;
	}

	//
	// Execute compiled file
	//
	zend_file_handle file_handle;
	zend_op_array *op_array;
	file_handle.filename=fullfile_name;
	file_handle.free_filename=0;
	file_handle.type=ZEND_HANDLE_FILENAME;
	file_handle.opened_path=NULL;
	op_array = zend_compile_file(&file_handle,ZEND_INCLUDE TSRMLS_CC);
	if (!op_array) {
		error="Error parsing script:";
		error+=fullfile_name;
		zend_error(E_ERROR,error.c_str());
		return;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

#ifdef _SEGFAULT_
//	SIMPLATE_G(global_string)="";
#endif // _SEGFAULT_

#ifdef USE_ZEND_EXECUTE
	SIMPLATE_G(global_string.str(std::string()));
	int (*old_output_func)(const char*,unsigned int TSRMLS_DC);
	old_output_func=OG(php_body_write);
	OG(php_body_write)=php_my_output_func;
	zend_execute(op_array TSRMLS_CC);
	OG(php_body_write)=old_output_func;

//cerr << "global_string=`" << SIMPLATE_G(global_string) << "'" << endl;
//	return;
//	RETURN_STRING(const_cast<char*>(SIMPLATE_G(global_string).c_str()),1);
	RETURN_STRING(const_cast<char*>(SIMPLATE_G(global_string).str().c_str()),1);
#else
	// ob_start();
	zval *output_handler=NULL;
	zend_bool erase=1;
	long chunk_size=0;
	if (php_start_ob_buffer(output_handler, chunk_size, erase TSRMLS_CC) == FAILURE) {
		zend_error(E_ERROR,"Error: fail to ob_start");
		RETURN_FALSE;
	}
	// include
	string include_execute="include '";
	include_execute+=fullfile_name;
	include_execute+="';";
	zend_eval_string(const_cast<char*>(include_execute.c_str()),NULL,"simplate" TSRMLS_CC);
//cerr << "[fetch]include_execute=" << include_execute << endl;


#ifdef ZEND_ENGINE_2
    destroy_op_array(op_array TSRMLS_CC);
#else
    destroy_op_array(op_array);
#endif // ZEND_ENGINE_2
    efree(op_array);
	efree(fullfile_name);
	if (php_ob_get_buffer(return_value TSRMLS_CC)==FAILURE) {
		RETURN_FALSE;
	}

	// ob_end_clean();
/*
	if (!OG(ob_nesting_level)) {
		php_error_docref("ref.outcontrol" TSRMLS_CC, E_NOTICE, "failed to delete buffer. No buffer to delete.");
		RETURN_FALSE;
	}
	if (OG(ob_nesting_level) && !OG(active_ob_buffer).status && !OG(active_ob_buffer).erase) {
		php_error_docref("ref.outcontrol" TSRMLS_CC, E_NOTICE, "failed to delete buffer %s.", OG(active_ob_buffer).handler_name);
		RETURN_FALSE;
	}
*/
	php_end_ob_buffer(0, 0 TSRMLS_CC);
#endif // USE_ZEND_EXECUTE

}

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,display)
#else
PHP_FUNCTION(simplate_display)
#endif // ZEND_ENGINE_2
{
    char *fullfile_name = NULL;
	read_parse_template(INTERNAL_FUNCTION_PARAM_PASSTHRU, &fullfile_name,SIMPLATE_DISPLAY);
	if (!fullfile_name || strlen(fullfile_name) <= 0 ){
		return;
	}
	//
	// Execute compiled file
	//
#ifdef USE_ZEND_EXECUTE
	zend_file_handle file_handle;
	zend_op_array *op_array;
	file_handle.filename=full_compile_filename;
	file_handle.free_filename=0;
	file_handle.type=ZEND_HANDLE_FILENAME;
	file_handle.opened_path=NULL;
	op_array = zend_compile_file(&file_handle,ZEND_INCLUDE TSRMLS_CC);
	if (!op_array) {
		string error = "Error parsing script:";
		error += full_compile_filename;
		zend_error(E_ERROR,error.c_str());
		efree(error);
		efree(fullfile_name);
		return;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_execute(op_array TSRMLS_CC);
#else
	// This way is safer
	string include_execute = "include '";
	include_execute += fullfile_name;
	include_execute += "';";
//cerr << "[display]include_execute=" << include_execute << endl;
	zend_eval_string(const_cast<char*>(include_execute.c_str()),NULL,"simplate" TSRMLS_CC);
#endif // USE_ZEND_EXECUTE
	efree(fullfile_name);
	return;
}

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,clear_cache)
#else
PHP_FUNCTION(simplate_clear_cache)
#endif // ZEND_ENGINE_2
{
	zval *obj;
	char *resource_name=NULL;
	int resource_name_len=0;
	long caching=0;
	char *cache_dir;
	string error;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &resource_name, &resource_name_len) == FAILURE) {
		RETURN_FALSE;
	}

	obj=getThis();
#ifdef ZEND_ENGINE_2
	caching = Z_LVAL_P(zend_read_property(Z_OBJCE_P(obj),obj,CACHING,strlen(CACHING),1 TSRMLS_CC));
#else
#endif // ZEND_ENGINE_2
	if( caching ){
#ifdef ZEND_ENGINE_2
		cache_dir = Z_STRVAL_P(zend_read_property(Z_OBJCE_P(obj),obj,CACHE_DIR,strlen(CACHE_DIR),1 TSRMLS_CC));
#else
#endif // ZEND_ENGINE_2

		if (cache_dir[strlen(cache_dir)-1] == DEFAULT_SLASH /*'/'*/) {
			cache_dir[strlen(cache_dir)-1] = '\0';
		}

		struct stat cache_stat;
		// cache directory exists?
		if (VCWD_STAT(cache_dir, &cache_stat) != -1) {
			if (!S_ISDIR(cache_stat.st_mode)) {
				error = "does not exist cache directory: ";
				error += cache_dir;
				zend_error(E_ERROR, error.c_str());
			}
		}
		string full_cache_filename(cache_dir);
		full_cache_filename+=DEFAULT_SLASH;
		full_cache_filename+=resource_name;
		if (VCWD_STAT(full_cache_filename.c_str(),&cache_stat) != -1) {
			unlink(full_cache_filename.c_str());
		}
	}

}

// register filter into plugins.
void register_plugins(INTERNAL_FUNCTION_PARAMETERS,char *filter_name)
{


	char *function_name = NULL;
	int function_name_len=0;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &function_name, &function_name_len) == FAILURE) {
		return;
	}
//cout << "filter_name=" << filter_name << ",function_name=" << function_name << endl;

	zval *obj = getThis();
	zval *_plugins;
//cout << "[register_prefilter(" << function_name << ")" << endl;
#ifdef ZEND_ENGINE_2
	_plugins=zend_read_property(Z_OBJCE_P(obj),obj,"_plugins",strlen("_plugins"),1 TSRMLS_CC);
	// initialize.use _plugins on the first time.
	if (_plugins == EG(uninitialized_zval_ptr) || Z_TYPE_P(_plugins) == IS_NULL) {
		MAKE_STD_ZVAL(_plugins);
		array_init(_plugins);
		ZVAL_DELREF(_plugins);
	}
#else
#endif // ZEND_ENGINE_2
//php_var_dump(&_plugins,1 TSRMLS_CC);

	zval **zfilter;
	// filter
	if( zend_hash_find(Z_ARRVAL_P(_plugins),filter_name,strlen(filter_name)+1,(void**)&zfilter) == SUCCESS ){

//php_var_dump(zfilter,1 TSRMLS_CC);
		add_assoc_string(*zfilter,function_name,function_name,1);

	}else{
		zval *data;
		MAKE_STD_ZVAL(data);
		array_init(data);

		add_assoc_string(data,function_name,function_name,1);
		add_assoc_zval(_plugins,filter_name,data);

	}
#ifdef ZEND_ENGINE_2
	zend_update_property(Z_OBJCE_P(obj),obj,"_plugins",strlen("_plugins"),_plugins TSRMLS_CC);
#else
#endif // ZEND_ENGINE_2



}

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,register_prefilter)
#else
PHP_FUNCTION(simplate_register_prefilter)
#endif // ZEND_ENGINE_2
{
	register_plugins(INTERNAL_FUNCTION_PARAM_PASSTHRU,"prefilter");
}

#ifdef ZEND_ENGINE_2
ZEND_METHOD(simplate,register_postfilter)
#else
PHP_FUNCTION(simplate_register_postfilter)
#endif // ZEND_ENGINE_2
{
	register_plugins(INTERNAL_FUNCTION_PARAM_PASSTHRU,"postfilter");
}




/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 sts=4 fdm=marker
 * vim<600: noet sw=4 ts=4 sts=4
 */
