<?php
    function microtime_float () 
    { 
        list ($msec, $sec) = explode(' ', microtime()); 
        $microtime = (float)$msec + (float)$sec; 
        return $microtime; 
    }
    // 保存するデータ数
    $execCount = 100;

    print("<p>Target Data Count : " . $execCount);

    // Config 設定
    define('SIMPLECACHE_DATA_FILE_DIR', '/var/tmp/data1');
    define('SIMPLECACHE_LOCK_FILE_PATH', '/var/tmp/data1/.lock1');
    define('SIMPLECACHE_DATA_ALGORITHM', '1');


    require_once("SimpleCache.class.php");

    // instance 取得
    $dataMgr = SimpleCache::getInstance();

    $start = microtime_float(); 

    // Data Regist
    $start1 = microtime_float(); 
    for ($i = 1; $i < $execCount; $i++) {
        $dataMgr->setData("abc" . $i, "aabbcc" . $i);
    }
    $end1 = microtime_float(); 

    print('<p>Time to register all data : ' . round($end1 - $start1, 3) . ' seconds');
    print('<br>');
    print('<p>Time to register one data : ' . round(($end1 - $start1) / $execCount, 3) . ' seconds');


    // Data Get
    $start2 = microtime_float(); 
    for ($t = 1; $t < $execCount; $t++) {
        if (("aabbcc" . $t) !== $dataMgr->getData("abc" . $t)) {
            print("<p>ERROR1");
        }
    }
    $end2 = microtime_float(); 

    print('<p>Time to Search all data : ' . round($end2 - $start2, 3) . ' seconds');
    print('<br>');
    print('<p>Time to Search one data : ' . round(($end2 - $start2) / $execCount, 3) . ' seconds');


    $end = microtime_float(); 

    print '<p>Script Execution Time: ' . round($end - $start, 3) . ' seconds'; 


?>