%bcond_without	libcurl

Name:		simplesok
Version:	1.0.4
Release:	1%{?dist}
Summary:	Simple Sokoban is a colorful Sokoban game
License:	MIT and CC-BY
URL:		http://simplesok.sourceforge.net/
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-1.0.4.tar.xz

BuildRequires:	gcc
BuildRequires:	SDL2-devel >= 2.0.1
BuildRequires:	zlib-devel
%if %{with libcurl}
BuildRequires:	libcurl-devel
%endif
BuildRequires:	desktop-file-utils
Requires:	hicolor-icon-theme

%description
Simple Sokoban is a colorful Sokoban game aimed for playability and portability
across systems. It is written in ANSI C89, using SDL2 for user interactions.


#-------------------------------------------------------------------------------
%prep
#-------------------------------------------------------------------------------

%autosetup -p1 -n %{name}-1.0.4

#	Convert to NL line ending.
for TXT in *.txt
do	sed -i 's/\r$//' "${TXT}"
done


#-------------------------------------------------------------------------------
%build
#-------------------------------------------------------------------------------

%configure								\
%if !%{with libcurl}
	--disable-libcurl
%endif

%{make_build}


#-------------------------------------------------------------------------------
%install
#-------------------------------------------------------------------------------

#	Install application.
%{make_install}

#	Install desktop menu entry.
mkdir -p '%{buildroot}%{_datadir}/applications'
cat > '%{name}.desktop' << EOF
[Desktop Entry]
Name=Simplesok
Comment=Slide boxes to solve the puzzles
Comment[fr]=Poussez les boîtes pour résoudre les casse-têtes
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;LogicGame;
EOF

desktop-file-install							\
	--dir "%{buildroot}/%{_datadir}/applications"			\
	"%{name}.desktop"

install -D -m 644 simplesok.png						\
		'%{buildroot}%{_datadir}/icons/hicolor/48x48/apps/simplesok.png'


#-------------------------------------------------------------------------------
%files
#-------------------------------------------------------------------------------

%doc simplesok.txt history.txt xsb_format.txt
%{_bindir}/simplesok
%{_datadir}/simplesok/skins/*.bmp.gz
%{_datadir}/applications/*
%{_datadir}/icons/hicolor/48x48/apps/simplesok.png
%{_mandir}/man6/simplesok.6*


#-------------------------------------------------------------------------------
%changelog
#-------------------------------------------------------------------------------

* Tue Jun 13 2023 Mateusz <mateusz@mateusz> 1.0.4
- New upstream release.

* Sun Feb 12 2023 Patrick Monnerat <patrick@monnerat.net> 1.0.2-1
- Initial Fedora spec file adapted from project's spec file.

* Thu Dec 16 2021 Mateusz Viste <mateusz@viste-family.net> 1.0.2
 - version 1.0.2 released
