#
# Mail ĥ饹
#
# $Id: mailext.rb 6 2007-12-06 10:03:04Z isr $
#
require 'mailread'
require "#{LIB_DIR}/utils.rb"

$KCODE = 'e'

# mailread  Mail 饹ĥ
class Mail
	include Utils

	# 褷ޤ
	# Reply-To, Sender, From νǤ
	def resolv_to_address
		return self['reply-to'] if exist_address?(self['reply-to'])
		return self['sender'] if exist_address?(self['sender'])
		return self['from'] if exist_address?(self['from'])
		return ''
	end


	# resolv_to_address()  Reply-To 򳰤
	def sender_or_from
		return self['sender'] if exist_address?(self['sender'])
		return self['from'] if exist_address?(self['from'])
		return ''
	end


	# Reply-To, Sender, From Υɥ쥹ꥹȤ֤
	def get_reply_sender_from
		as = []
		as << make_address_list_from_field(self['reply-to'])
		as << make_address_list_from_field(self['sender'])
		as << make_address_list_from_field(self['from'])
		return as.flatten
	end


	# From, Sender, Reply-To ˳륢ɥ쥹뤫
	def is_address_written?(address)
		as = get_reply_sender_from
		return (as.index(address) != nil)
	end


	# Subject åץ饰ѤƤϤ̾ȥץȴФ
	# ץ饰Ѥʤ nil ֤
	def get_plugin_and_opts
		return nil, nil if self['subject']

		s = self['subject'].sub(/^\s+/, '').sub(/\s+$/, '')
		unless s =~ /^[0-9]/ or s =~ /^every/ or s =~ /^plugin:/ or s =~ /^plg:/
			return nil, nil
		end

		di, pname, opts = s.split(':', 3)
		return pname, opts
	end
end


__END__
