#
# SimRM plugin 饹
#
# NOTE: ʤɤ˵ä note/plugin.txt ɤΤ
#
# $Id: pmanager.rb 6 2007-12-06 10:03:04Z isr $
#

require "#{LIB_DIR}/utils.rb"
require 'singleton'

$KCODE = 'e'

# Pmanager ϡ⡹ 1 Ĥ󥹥󥹤
class Pmanager
	include Singleton

	# ̾ȿΥѥ
	NAME_VIO = /[^0-9a-z_]/

	def initialize()
		@plist = []  # plugin Υꥹ ("Plugin_" դƤʤ)
		@folder = "" # plugin ǥ쥯ȥ
	end


	# Singleton#instance ϰʤᡢӤδؿȤäƽ
	# folder ˤ plugin եΥѥϤ
	#
	# NOTE: ץ饰ȤʤȤϡ use  false ꤹ뤳
	def init(folder, use)
		if @folder != "" or @plist.size != 0
			Utils::cputs('error', "Pmanager::init() was called again")
			return -1
		end
		
		@folder = folder
		return (use ? reload() : 0)
	end
	
	
	# Ϳ줿ǥ쥯ȥѥåơ
	# ץ饰ΥꥹȤ򹹿
	#
	# :  0 -> 
	#         -1 -> ۾ΤᡢλƤʤ (򻲾ȤΤ)
	#
	# NOTE: init() Ѥ
	# TODO: ʣΥåɤƱ˸ƤФ뤳ȤϤʤΤsync ȤǤϤ
	def reload(folder = "")
		if (folder == nil or folder == "") && @folder == ""
			Utils::cputs('error', "Pmanager::reload() is NOT called properly")
			return -1
		end

		if folder == nil or folder == ""
			folder = @folder
		end

		unless File.directory?(folder)
			Utils::cputs('error', "Plugin directory '#{b}' is NOT directory")
			return -1
		end

		oldlist = @plist
		@plist = []
		# ǥ쥯ȥ smplg.rb ե򸡺
		Dir.glob("#{@folder}/*.smplg.rb").each {|f|
			b = File.basename(f)
			name = b.sub(/\.smplg\.rb$/, '')
			if name.index(NAME_VIO) != nil
				Utils::cputs('warn', "The name of plugin '#{b}' is not acceptable: this file is ignored")
				next
			end
			if oldlist.include?(name)
				Utils::cputs('info', "Plugin '#{b}' will be reloaded, so you will get some unexpected results maybe")
			end

			begin 
				load "#{f}"
			rescue LoadError => e
				Utils::cputs('error', "Can't load #{f}: #{e.to_s}")
				next
			end

			begin
				unless eval("Plugin_#{name}").use_this_class?
					Utils::cputs('info', "Plugin '#{name}' is prohibited")
					next
				end
			rescue => e
				Utils::cputs('error', "Can't eval plugin '#{name}': #{e.to_s}")
				next
			end

			Utils::cputs('debug', "Plugin '#{name}' was loaded")
			@plist << name
		}
		@plist.sort!
		return 0
	end


	# ȤͿ줿ץ饰̾Ȥ뤫ɤ
	def include?(pname)
		return @plist.include?(pname)
	end


	# ѤǤץ饰Υꥹ
	# NOTE: ѹƤ⹽ʤ褦ˡʸ dup Ƥ
	def get_plugin_names()
		ret = []
		@plist.each {|p| ret << p.dup }
		return ret
	end
end


__END__
