#
# SimRM ᡼饹
#
# NOTE:
# ƥȻ˥᡼餺ɸϤ˥᡼ƤФȤ
# @@NO_SMTP  true ˤƤ
#
# $Id: sending.rb 6 2007-12-06 10:03:04Z isr $
#

require 'net/smtp'
require 'nkf'
require "#{LIB_DIR}/mailext.rb"
require "#{LIB_DIR}/userlist.rb"
require "#{LIB_DIR}/utils.rb"

$KCODE = 'e' # ʸн


# SMTP Фؤ³ɬפʾ¤
class SmtpInfo
	attr_reader :helo_domain, :host, :port, :user, :passwd, :authtype
	def initialize(helo_domain, host, port, user, passwd, authtype)
		@helo_domain, @host, @port, @user, @passwd, @authtype = 
			helo_domain, host, port, user, passwd, authtype
	end
end


# إס顼ƥʥ󥹤ʤɤΥ᡼᤿¤
class MailFiles
	attr_reader :help, :error, :mainte
	def initialize(error, help, mainte)
		@error, @help, @mainte = error, help, mainte
	end
end


# ۥ磻ȥꥹȤʤɤΥѥ¤
class ListFiles
	attr_reader :userfile, :addmefile
	def initialize(userfile, addmefile)
		@userfile, @addmefile = userfile, addmefile
	end
end


# 󥹥󥹤ȼưŪ SMTP åĥΤǡ
# ⤦Ȥʤʤä sfree() ƤǤ
class SendingMail
	APP  = 'SimRM'
	TAG = "[#{APP}]"

	# NO_SMTP  true ʤС᡼餺ɸϤƱƤϤޤ
	attr_reader :from, :reply, :sinfo, :mailfiles, :listfiles
	@@NO_SMTP = false
	@@org_mail_start = 'Original Mail Info ------'
	@@org_mail_end   = '-------------------------'

	def initialize(from, reply, smtpinfo, mailfiles, listfiles)
		@from, @reply, @sinfo, @mailfiles, @listfiles = 
			from, reply, smtpinfo, mailfiles, listfiles
		@userlist = UserList.new(listfiles.userfile, listfiles.addmefile)

		# ºݤ˥᡼ޤǥåϺʤȤˤƤ
		@session = nil

		# ƥեƤɬפȤʤޤɤ߹ޤʤ
		@helpbody = ''
		@errbody = ''
		@maintebody = ''
	end


	# SMTP Υåĥ꤬ݤʤΤǴؿ
	def make_smtp_session()
		raise unless @sinfo
		return Net::SMTP.start(
				@sinfo.host, @sinfo.port,
				@sinfo.helo_domain, @sinfo.user,
				@sinfo.passwd, @sinfo.authtype)
	end
	private :make_smtp_session


	# session free
	def sfree()
		@session.finish if @session
		@session = nil
	end


	# 귿
	def make_error_msg(str)
		str = "unknown" unless str
		return "Error: " + str 
	end
	private :make_error_msg


	# 'Name <user@hoge.jp>'  user@hoge.jp Τߤ֤
	# TODO: ȴФʰŪĴ٤ΤݤʤΤǤΤ
	def get_address_only(str)
		ad = str.dup
		ad.sub!(/^.*<(.*)>.*$/, '\1')
		return ad
	end
	private :get_address_only


	# ᡼ǻȤإå
	# NOTE: ǸιԤ϶ԤǤ뤳Ȥ
	def get_common_headers(mail, to, sub)
		hs = <<EOS
To: #{to}
From: #{@from}
Subject: #{sub}
Date: #{Time::now.strftime("%a, %d %b %Y %X %z")}
Content-Type: text/plain; charset=ISO-2022-JP
Content-Transfer-Encoding: 7bit
EOS
		hs << "X-Simrm-Saved: #{mail['x-simrm-saved']}\n"   if mail['x-simrm-saved']
		hs << "X-Simrm-Caller: #{mail['x-simrm-caller']}\n" if mail['x-simrm-caller']
		hs << "\n"
		return hs
	end
	private :get_common_headers


	# To եɤƥ᡼륢ɥ쥹Ф
	# NOTE: 'Name <foo@hoge.jp>'  foo@hoge.jp ΤߤФ
	# TODO: ȴФʰŪĴ٤ΤݤʤΤǤΤ
	def get_mail_addresses(to)
		ads = to.split(", ")
		ads.each { |ad| 
			ad.strip!
			#  ad = get_address_only(ad) ȤƤȿǤʤ褦
			ad.sub!(/^.*<(.*)>.*$/, '\1')
		}
		return ads 
	end
	private :get_mail_addresses


	# ᡼ؿ
	def send_mail_sub(contents, to)
		raise if to.index("\n")

		# ᡼륢ɥ쥹 , ǶڤƤ (?) Τǡƥɥ쥹
		# ζʸϺƤ
		# TODO: (?) οΤ뤳 (Thunderbird ϤʤäƤ)
		to_members = get_mail_addresses(to)

		# ᡼ꤲ뤫ɸϤ˽Ф
		if @@NO_SMTP
			print "\n- mail start -----------------------------\n"
			print contents
			print "\n- mail end -------------------------------\n"
		else
			# 褬ʤʤ
			return if to_members.empty?

			# sfree() Τ nil θƤ
			@session = make_smtp_session() unless @session
			@session.send_mail(contents, get_address_only(@from), to_members)
			Utils::cputs('info', "sent mail to #{to_members.join(', ')}")
		end
	end
	private :send_mail_sub


	# filebody ʸΤȤϡ
	# file Ƥˤäƾ񤭤
	# filetype ˤ "إץե"  "ƥʥ󥹼Υե" ʤɤ뤳
	def send_foo_file!(mail, subject, file, filebody, filetype)
		# 桼ꥹȤϿƤʤʤ
		usrfrom = mail['from'] ? NKF.nkf('-mj', mail['from']) : ''
		unless @userlist.send_ok?(usrfrom)
			Utils::cputs('info', "#{usrfrom} is denied")
			return
		end

		# եʸƤ
		if filebody == ''
			begin 
				filebody = File.readlines(file).to_s
			rescue
				filebody = filetype + "ɤ߹ߤ˼Ԥޤ\n" +
				           'ԤϢäƤߤƤ'
			end
			filebody = NKF.nkf('-j', filebody)
		end

		# ᡼
		to = mail.resolv_to_address.gsub(/\n/, ' ')
		usrd = mail['date'] ? mail['date'] : ''
		usrsub = mail['subject'] ? NKF.nkf('-mj', mail['subject']) : ''

		# ǽ Reply-To 򤷤ΤΤ
		contents = Utils::exist_address?(@reply) ? "Reply-To: #{@reply}\n" : ''
		contents += get_common_headers(mail, to, subject)
		contents += <<EOS
#{@@org_mail_start}
 Date: #{usrd}
 From: #{usrfrom}
 Subject: #{usrsub}
#{@@org_mail_end}

#{filebody}
EOS
		# 
		send_mail_sub(contents, to)
	end
	private :send_foo_file!


	# Υ᡼ؿ
	# clean ϡֻ露ʤƿʤפʥե饰
	# plg_body  plugin Ȥäʸ
	def send_time_mail(mail, fname, clean, plg_body = nil)
		# 桼ꥹȤϿƤʤʤ
		usrfrom = mail['from'] ? NKF.nkf('-mj', mail['from']) : ''
		unless @userlist.send_ok?(usrfrom)
			Utils::cputs('info', "#{usrfrom} is denied")
			return
		end

		# եʸƤ
		clean_msg = ''
		if clean
			clean_msg = "Υ᡼ϡˤʤ󤫤ͳǤʤä᡼Ǥ\n\n"
			clean_msg = NKF.nkf('-j', clean_msg)
		end
			         
		stop_msg = ''
		base = File.basename(fname)
		if base.index(/\d/) > 0 # ¤ǤϤʤ
			stop_msg = "Ͽ줿᡼ۿߤˤ\n" +
				       "stop:" + base + " Ȥ̾ǥ᡼äƤ\n\n"
			stop_msg = NKF.nkf('-j', stop_msg)
		end
		body = (plg_body != nil) ? plg_body.to_s : mail.body.to_s
		body = NKF.nkf('-j', body) unless body.empty?

		# ᡼
		to = mail.resolv_to_address.gsub(/\n/, ' ')
		sub = "#{TAG} Reminder: " + (mail['subject'] ? mail['subject'] : '')
		usrd = mail['date'] ? mail['date'] : ''
		usrsub = mail['subject'] ? NKF.nkf('-mj', mail['subject']) : ''

		# ǽ Reply-To 򤷤ΤΤ
		contents = Utils::exist_address?(@reply) ? "Reply-To: #{@reply}\n" : ''
		contents += get_common_headers(mail, to, sub)
		contents += <<EOS
#{clean_msg}#{stop_msg}#{@@org_mail_start}
 Date: #{usrd}
 From: #{usrfrom}
 Subject: #{usrsub}
#{@@org_mail_end}

#{body}
EOS
		# 
		send_mail_sub(contents, to)
	end


	# إץ᡼
	def send_help(mail)
		send_foo_file!(mail, "#{TAG} Help", 
					   @mailfiles.help, @helpbody,
					   'إץե')
	end


	# ƥʥ󥹼Υ᡼
	def send_maintenance(mail)
		send_foo_file!(mail, "#{TAG} Maintenance",
					   @mailfiles.mainte, @maintebody,
					   'ƥʥ󥹼Υե')
	end


	# 顼åդ
	# NOTE: sender  from οͤ롣⤷ʤСreply-to å
	def send_error_mail(mail, errmsg)
		# 桼ꥹȤϿƤʤʤ
		usrfrom = mail['from'] ? NKF.nkf('-mj', mail['from']) : ''
		unless @userlist.send_ok?(usrfrom)
			Utils::cputs('info', "#{usrfrom} is denied")
			return
		end

		# 顼᡼ʸƤ
		if @errbody == ''
			begin 
				@errbody = File.readlines(@mailfiles.error).to_s
			rescue
				@errbody = "顼եɤ߹ߤ˼Ԥޤ\n" +
				           'ԤϢäƤߤƤ'
			end
			@errbody = NKF.nkf('-j', @errbody)
		end

		# ʸ
		to = mail.sender_or_from.gsub(/\n/, ' ')
		to = mail.resolv_to_address.gsub(/\n/, ' ') if to == ''
		errmsg = NKF.nkf('-j', make_error_msg(errmsg))
		usrd = mail['date'] ? mail['date'] : ''
		usrsub = mail['subject'] ? NKF.nkf('-mj', mail['subject']) : ''
		usrtype = mail['content-type'] ? mail['content-type'].gsub(/\n/, "\n  ") : ''

		contents = Utils::exist_address?(@reply) ? "Reply-To: #{@reply}\n" : ''
		contents += get_common_headers(mail, to, "#{TAG} Error")
		contents += <<EOS
#{errmsg}

#{@@org_mail_start}
 Date: #{usrd}
 From: #{usrfrom}
 Subject: #{usrsub}
 Content-Type: #{usrtype}
#{@@org_mail_end}

#{@errbody}
EOS
		# 
		send_mail_sub(contents, to)
	end

	# OK åʥ᡼
	def send_ok_mail(mail, to, subject, ok_msg, body)
		# 桼ꥹȤϿƤʤʤ
		usrfrom = mail['from'] ? NKF.nkf('-mj', mail['from']) : ''
		unless @userlist.send_ok?(usrfrom)
			Utils::cputs('info', "#{usrfrom} is denied")
			return
		end

		# ᡼
		usrd = mail['date'] ? mail['date'] : ''
		usrsub = mail['subject'] ? NKF.nkf('-mj', mail['subject']) : ''
		usrrep = mail['reply-to'] ? NKF.nkf('-mj', mail['reply-to']) : ''

		# ǽ Reply-To 򤷤ΤΤ
		contents = Utils::exist_address?(@reply) ? "Reply-To: #{@reply}\n" : ''
		contents += get_common_headers(mail, to, subject)
		contents += <<EOS
#{ok_msg}

#{@@org_mail_start}
 Date: #{usrd}
 From: #{usrfrom}
 Subject: #{usrsub}
 Reply-To: #{usrrep}
#{@@org_mail_end}

#{body}
EOS
		# 
		send_mail_sub(contents, to) 
	end
	private :send_ok_mail


	# ᡼Ȥ
	# ΤȤ Sender, From οͤ˥᡼뤹
	def send_accept(fname)
		f = File.open(fname)
		mail = Mail.new(f)

		# եʸ
		ok_msg = "ξĥ᡼Ͽޤ\n" +
				 'äˤ stop:' + File.basename(fname) + 
				 ' Ȥ̾ǥ᡼äƤ'
		ok_msg = NKF.nkf('-j', ok_msg)
		# ץ饰󤫤ƤФ줿Ϥλݤ򵭽
		if mail['x-simrm-caller']
			tmp_s = "\n* Υ᡼ '" + mail['x-simrm-caller'] + "' 𤷤ƺޤ"
			ok_msg << NKF.nkf('-j', tmp_s)
		end

		body = mail.body.to_s
		body = NKF.nkf('-j', body) unless body.empty?

		to = mail.sender_or_from.gsub(/\n/, ' ')
		sub = "#{TAG} Accepted: " + (mail['subject'] ? mail['subject'] : '')

		# ºݤν
		send_ok_mail(mail, to, sub, ok_msg, body)

		# 
		f.close
	end


	# ᡼μ
	def send_accept_for_memo(fname)
		f = File.open(fname)
		mail = Mail.new(f)

		# եʸ
		ok_msg = "ξĥϿޤ\n" +
				 'ˤƱ̾ʸΥ᡼äƤ'
		ok_msg = NKF.nkf('-j', ok_msg)
		# ץ饰󤫤ƤФ줿Ϥλݤ򵭽
		if mail['x-simrm-caller']
			tmp_s = "\n* Υ᡼ '" + mail['x-simrm-caller'] + "' 𤷤ƺޤ"
			ok_msg << NKF.nkf('-j', tmp_s)
		end

		body = mail.body.to_s
		body = NKF.nkf('-j', body) unless body.empty?

		to = mail.sender_or_from.gsub(/\n/, ' ')
		sub = "#{TAG} Accepted Memo: " + (mail['subject'] ? mail['subject'] : '')

		# ºݤν
		send_ok_mail(mail, to, sub, ok_msg, body)

		# 
		f.close
	end


	# ߤΥ
	def send_memo(fname, from_mail)
		f = File.open(fname)
		memo_mail = Mail.new(f)

		body = memo_mail.body.to_s
		body = NKF.nkf('-j', body) unless body.empty?

		d = Time::now.strftime("%a, %d %b %Y %X %z")
		to = from_mail.resolv_to_address.gsub(/\n/, ' ')
		subject = "#{TAG} Memo: " +
			(memo_mail['subject'] ? memo_mail['subject'].sub(/^.*?:/, '') : '')

		# ǽ Reply-To 򤷤ΤΤ
		contents = Utils::exist_address?(@reply) ? "Reply-To: #{@reply}\n" : ''
		contents += get_common_headers(memo_mail, to, subject)
		contents += body

		# 
		send_mail_sub(contents, to) 

		# 
		f.close
	end


	# ꥹȤΥ᡼
	# memolist: ̾Υꥹ
	def send_memolist_mail(mail, memolist)
		# եʸ
		ok_msg = "ϿƤΰǤ"
		ok_msg = NKF.nkf('-j', ok_msg)

		if memolist.size == 0
			body = 'ϿƤϤޤ'
		else
			body = ""
			memolist.each { |m|
				body += "- #{m}\n"
			}
		end
		body = NKF.nkf('-j', body) unless body.empty?

		to = mail.resolv_to_address.gsub(/\n/, ' ')
		i = memolist.size
		sub = "#{TAG} Memo List: #{i} item" + (i > 1 ? 's' : '')

		send_ok_mail(mail, to, sub, ok_msg, body)
	end


	# κ
	def send_delete_for_memo(mail)
		mtitle = (mail['subject'] ? mail['subject'].sub(/^.*?:/, '') : '')

		# եʸ
		ok_msg = " " + mtitle + " ޤ"
		ok_msg = NKF.nkf('-j', ok_msg)

		body = ''

		to = mail.resolv_to_address.gsub(/\n/, ' ')
		sub = "#{TAG} Deleted Memo: " + mtitle

		# ºݤν
		send_ok_mail(mail, to, sub, ok_msg, body)
	end


	# stop ᡼Ȥ
	# fname  basename Ǥ뤳Ȥ
	def send_stop_ok(mail, fname)
		# եʸ
		ok_msg = "ξĥ᡼ۿߤޤ"
		ok_msg = NKF.nkf('-j', ok_msg)

		body = mail.body.to_s
		body = NKF.nkf('-j', body) unless body.empty?

		to = mail.resolv_to_address.gsub(/\n/, ' ')
		sub = "#{TAG} Stopped: " + fname

		# ºݤν
		send_ok_mail(mail, to, sub, ok_msg, body)
	end


	# addme ᡼Ȥ
	# TODO:  Sender ˤб⤷ʤ
	def send_added(mail)
		# եʸ
		ok_msg = " From ˵ܤ줿ɥ쥹򡢥ƥѲǽʥɥ쥹ȤϿޤ"
		ok_msg = NKF.nkf('-j', ok_msg)

		to = mail.resolv_to_address.gsub(/\n/, ' ')
		sub = "#{TAG} Added You"

		# ºݤν (body ϶ʸǤϤ)
		send_ok_mail(mail, to, sub, ok_msg, '')
	end


	# list ᡼
	# sub_body  subject  body Υڥ
	def send_list_mail(mail, sub_body)
		# եʸ
		ok_msg = "ͽΥ᡼Ǥ"
		ok_msg = NKF.nkf('-j', ok_msg)

		to = mail.resolv_to_address.gsub(/\n/, ' ')

		if sub_body.empty?
			body = 'ߡͽΥ᡼Ϥޤ'
			body = NKF.nkf('-j', body)
		else
			# ᡼ʸ
			body = ''
			# ޤϷ̾ꥹȤ
			sub_body.each do |pair|
				body << '- ' + pair[0] + "\n"
			end
			body << "\n"
			# ͽ᡼ʸꥹȤƤ
			sub_body.each do |pair|
				body << "-----------------------------------------------\n"
				body << "Subject: #{pair[0]}\n\n"
				body << pair[1]
				body << "-----------------------------------------------\n\n"
			end
		end
		i = sub_body.size
		sub = "#{TAG} List: #{i} item" + (i > 1 ? 's' : '')

		# ºݤν (body ϶ʸǤϤ)
		send_ok_mail(mail, to, sub, ok_msg, body)
	end


	# С (verstr ʸɤѤ)
	# version
	def send_version!(mail, verstr)
		# եʸ
		ok_msg = "SimRM ˴ؤСǤ"
		ok_msg = NKF.nkf('-j', ok_msg)

		if verstr.size == 0
			body = 'СǤޤǤ'
		else
			body = verstr
		end
		body = NKF.nkf('-j', body) unless body.empty?

		to = mail.resolv_to_address.gsub(/\n/, ' ')
		sub = "#{TAG} Version"

		send_ok_mail(mail, to, sub, ok_msg, body)
	end


	def send_plugin_result(mail, pname, body)
		# եʸ
		ok_msg = "ץ饰 '#{pname}' μ¹Է̤Ǥ"
		ok_msg = NKF.nkf('-j', ok_msg)

		to = mail.resolv_to_address.gsub(/\n/, ' ')
		sub = "#{TAG} Plugin: #{pname}"

		send_ok_mail(mail, to, sub, ok_msg, body)
	end


	# userlist Υåѡؿ
	def send_ok?(mail)
		usrfrom = mail['from'] ? NKF.nkf('-mj', mail['from']) : ''
		return @userlist.send_ok?(usrfrom)
	end

	# addme ᡼ From Ͽ
	# OK             ->  0
	# ˵ҺѤ   ->  1
	# ʥɥ쥹 -> -1
	def add_addme_user(mail)
		usrfrom = mail['from'] ? NKF.nkf('-mj', mail['from']) : ''
		@userlist.add_addme_user!(usrfrom)
	end

	def write_back_addme()
		@userlist.write_back_addme()
	end
end

__END__
