#
# 桼ƥƥ⥸塼
#
# $Id: utils.rb 6 2007-12-06 10:03:04Z isr $
#
$KCODE = 'e'

require 'date'
require 'etc'
require 'logger'

# Logger
$utils_log = nil

module Utils
	# ʹߤδؿƥ⥸塼ؿȤ
	module_function

	# ʸ˥᡼륢ɥ쥹뤫ɤåޤ
	# TODO: ʤʰŪ
	def exist_address?(str)
		return false unless str
		return str.index('@') != nil
	end


	# ᡼إåΥեɤ᡼륢ɥ쥹
	# ΥꥹȤ֤
	# TODO: ʤʰŪ
	def make_address_list_from_field(str)
		return [] unless str
		return str.scan(/[^<,\s]+@[^>,\s]+/)
	end


	# եΥ 0 ˤ
	# OK -> true
	# NG -> false
	def do_filesize0(fpath)
		begin
			f = open(fpath, "w")
			f.close
			return true
		rescue
			return false
		end
	end


	# դå
	# OK -> true
	# NG -> false
	def day_range_ok?(day, month, year)
		r30 = [4, 6, 9, 11]
		r31 = [1, 3, 5, 7, 8, 10, 12]

		# 2 ̤ȽꤷƤɬפ
		# leap? ϱǯȽ᥽å
		if month == 2
			max = (Date.new(year).leap?) ? 29 : 28
			return (1 <= day and day <= max)
		end

		return (1 <= day and day <= 30)  if r30.index(month) 
		return (1 <= day and day <= 31)  if r31.index(month) 
		raise "Control never reach: check_day_range"
	end


	# ֤ɤΥå
	# yaer, month, week, day, hour, min Ϥ줾 nil Ǥ
	# OK -> true
	# NG -> false
	def time_range_ok?(year, month, week, day, hour, min)
		# year  1 ̤ǤʤХ襷Ȥ
		return false if year and year < 1
		# month  1  12 ޤ
		return false if month and (month < 1 or 12 < month)
		# week  0  6 ޤ
		return false if week and (week < 0 or 6 < week)
		# day  month, year αƶ
		if day and month and year
			return false unless day_range_ok?(day, month, year) 
		else
			return false if day and (day < 1 or 31 < day)
		end
		# hour  0  23 ޤ
		return false if hour and (hour < 0 or 23 < hour)
		# min  0  59 ޤ
		return false if min and (min < 0 or 59 < min)
		# OK
		return true
	end

	# UTC ȤΥեåȤ֤
	# 㤨ܤʤ "+0900" Ȥʸ֤Ϥ
	# NOTE: äڤΤ
	def get_utc_offset_str()
		num = Time::now.utc_offset
		h   = num / 3600
		num = num % 3600
		m   = num / 60

		# ʸ
		s = sprintf("%+03d", h)
		s << sprintf("%02d", m)
		return s
	end

	# grep ǽ󶡤
	# :
	#   ĤäԤ󥪥֥Ȥ֤
	#   (Ĥʤǿ 0 󥪥֥)
	# Usage:
	#   grep("/path/to/file", /^StringA:/)
	# NOTE: 㳰 catch Τޤ֤
	def grep(fpath, re)
		a = []
		File.foreach(fpath) {|line|
			a << line if line =~ re
		}
		return a
	end


	# ǡ
	# NOTE: å줿Ȥˤcd / ϤʤǤ
	def simple_daemon()
		cpid = Process.fork {
			Process.setsid
			File.open("/dev/null"){|f|
				STDIN.reopen f
				STDOUT.reopen f
				STDERR.reopen f
			}
			yield
		}
		return cpid
	end


	# ⤷ʤ
	def do_nothing
	end


	# ѡ桼̥桼˰Ūڤؤ
	# NOTE: force  false ʤСȤ root (id=0) ǤϤʤȤڤ
	#       user ΤȤϲ⤻
	def switch_euid(user, force = false)
		old_uid = nil
		return -1 if (!force && Process.uid != 0)
		if (user == nil or user == '')
			return yield if force
			return -2
		end

		old_uid = Process.euid
		Process.euid = Etc.getpwnam(user).uid
		return yield
	ensure
		Process.euid = old_uid if old_uid
	end


	# ѡ桼¤˼ΤƤ
	# NOTE: root (id=0) Ǥʤв⤻
	def switch_uid(user)
		return -1 if (Process.uid != 0)
		return -2 if (user == nil or user == '')

		uid = Etc.getpwnam(user).uid
		return Process::UID.change_privilege(uid)
	end


	# custom puts
	#
	# utils_log  Logger ֥Ȥϥ
	# Ǥʤ STDERR  (ޤΤȤϥ٥˴طʤϤ)
	#
	# NOTE: severity  String ΤȤϡ
	# 'fatal', 'error', 'warn', 'info', 'debug' (ʸʸʤ)
	# ʸ˹碌Ŭڤ Integer ͤˤ
	#
	# NOTE: head  false ΤȤ STDERR ϤˤĤ
	# 'ERROR:', 'WARNING:' ʤɤμ̾ղäʤ
	def cputs(severity, msg, head = true)
		m = msg
		s = severity

		if severity.instance_of?(String)
			case severity.downcase
			when 'fatal' then s = Logger::FATAL
			when 'error' then s = Logger::ERROR
			when 'warn'  then s = Logger::WARN
			when 'info'  then s = Logger::INFO
			when 'debug' then s = Logger::DEBUG
			else
				s = Logger::FATAL 
				m = "Sevirity '#{severity}' is NOT recognized: #{msg}" 
			end
		end

		if $utils_log == nil
			if head
				case s
				when Logger::FATAL then m = 'FATAL: '   + msg
				when Logger::ERROR then m = 'ERROR: '   + msg
				when Logger::WARN  then m = 'WARNING: ' + msg
				when Logger::INFO  then m = 'INFO: '    + msg
				when Logger::DEBUG then m = 'DEBUG: '   + msg
				else m = 'UNKNOWN: ' + msg
				end
			end

			STDERR.puts m
		else
			$utils_log.add(s, m)
		end
	end


	# ᡼η̾ǽפʤΤΤǤ褦ˤ
	def important_subject?(sub)
		return IMPORTANT_SUBJECT.key?(sub)
	end
	# Subject Data
	IMPORTANT_SUBJECT = {
		'Returned mail: see transcript for details' => true
	}


	# ǥ쥯ȥΥե
	# NOTE: ƵŪˤϥåʤ
	def dir_filenum(dir_path)
		cnt = 0
		Dir.foreach(dir_path) {|item|
			cnt += 1 if File.file?(dir_path + '/' + item)
		}
		return cnt
	end


	# ǥ쥯ȥιץե륵
	# : [size, file_num]
	#
	# NOTE: ͤηդ뤳
	# NOTE: ƵŪˤϥåʤ
	def dir_filesize(dir_path)
		s   = 0 
		cnt = 0
		Dir.foreach(dir_path) {|item|
			if File.file?(dir_path + '/' + item)
				s += File.size(dir_path + '/' + item)
				cnt += 1
			end
		}
		return s, cnt
	end
end

__END__
