#!/usr/bin/env ruby
#
# You can create a plugin base file with this.
#
# $Id: make_plugin.rb 6 2007-12-06 10:03:04Z isr $
#

DAT = File.dirname($0) + '/make_plugin.dat'

name  = '' 
fname = ''
pname = ''
loop {
	print "Plugin name? []: "
	name = gets
	name.chomp!
	if name =~ /^\s*$/ or name =~ /[^0-9a-z_]/
		STDERR.puts "Your input is invalid. So, try again."
		next
	end

	fname = "#{name}.smplg.rb"
	pname = "Plugin_#{name}"

	if File.exist?(fname)
		STDERR.puts "'#{fname}' already exists. So, input the other name."
		next
	end

	puts "OK, your plugin name is '#{pname}'."
	break
}

f = open("#{fname}", 'w')
File.foreach(DAT) {|l| 
	f.print l.sub(/_PLUGIN_NAME_/, pname)
}
f.close

puts "A base file '#{fname}' was prepared."
puts "Enjoy it!"
