<?php
/**
 * SimRM plugin for PukiWiki
 * $Id: simrm.inc.php 6 2007-12-06 10:03:04Z isr $
 */
require_once (LIB_DIR . 'mimeDecode.php');

/** 
 * SimRM μ¹ԥѥȥإץƥȤꤷƤ
 */
define('SIMRM_EXE',  '/var/www/html/8080/wiki/simrm/bin/simrm.rb');

/** 
 * SimRM  DATADIR ꤷƤ
 */
define('DATADIR', '/var/www/html/8080/wiki/simrm');
define('RESERVED_DIR', DATADIR . '/reserve');

/** 
 * wiki ʸ󥳡ǥ
 * mb_convert_encoding() ȤʤʤΤǡiconv ѡ
 * äơHTML-ENTITIES ϻѤǤʤʸɤꤹ뤳ȡ
 */
define('WIKI_ENCODE', 'EUC-JP');		// ѹ뤳
define('MAIL_ENCODE', 'ISO-2022-JP');	// ᡼ iso-2022-jp 


// ------------------------------------------------------------------

/**
 * إå򻲾Ȥ롣
 * Reply-To, Sender, From ν硣
 */
function resolv_to_address($headers) 
{
	if ($headers['Reply-to']) return $headers['Reply-to'];
	if ($headers['Sender']) return $headers['Sender'];
	if ($headers['From']) return $headers['From'];
	return '';
}


/**
 * ǥ쥯ȥ꤫¸Υ᡼եɤ߽Ф
 * ʰ׾Υơ֥֤
 */
function make_reserved_str()
{
	// ǥ쥯ȥΥ顼å
	if (!is_dir(RESERVED_DIR) || !is_readable(RESERVED_DIR)) {
		return '<table border="1" align="center" width="98%">'
			 . '<tr><td>ERROR: ' . RESERVED_DIR . ' is not readable.</td></tr></table>';
	}

	$ret = '<table border="1" align="center" width="98%">';
	$items = '';
	foreach (glob(RESERVED_DIR . '/*') as $fname) {
		// եǤʤм 
		if (!is_file($fname)) {
			continue;
		}

		$bname = basename($fname);
		$items .= '<tr><td>' . $bname . '</td>';
		if (!is_readable($fname)) {
			$items .= "<td>ERROR: This file is not readable.</td></tr>\n";
			continue;
		}

		// ᡼եإåʸʬ䤹
		$mail = file_get_contents($fname);
		$decode = new Mail_mimeDecode($mail);
		$decode->decode();
		$parts = $decode->getSendArray();
		if (PEAR::isError($parts)) {
			$items .= "<td>ERROR: getSendArray()</td></tr>\n";
			continue;
		}
		list($recipients, $headers, $body) = $parts;

		// إå鰸
		$h = resolv_to_address($headers);
		$h = iconv(MAIL_ENCODE, WIKI_ENCODE, $h);
		$h = htmlentities($h, ENT_QUOTES, WIKI_ENCODE);
		$items .= '<td>' . $h . '</td>';
		
		// ʸ HTML ɽǽʸˤ
		$b = iconv(MAIL_ENCODE, WIKI_ENCODE, $body);
		$b = htmlentities($b, ENT_QUOTES, WIKI_ENCODE);
		$b = preg_replace('/\r/', '', $b);
		$b = preg_replace('/\n/', '<br/>', $b);
		$items .= '<td>' . $b . "</td></tr>\n";

	}
	
	/* ƥब 1 Ĥ̵Ϥλݤɽ */
	if (strcmp($items, '') == 0) {
		$items .= '<tr><td>NO ITEM</td></tr>';
	}
	else {
		$items = "<tr><td>ե̾</td><td></td><td>ʸ</td></tr>\n"
			   . $items;
	}
	return '<table border="1" align="center" width="98%">' . "\n" .
		   $items . "</table>\n";
}


/**
 * POST ǡΥ顼å
 */
function check_post_data()
{
	global $post;
	if (strpos($post['to'], '@') === FALSE) {
		return '<p>˥ɥ쥹ޤ</p>';
	}
	return '';
}


/**
 * simrm.rb ¹ԤɸϤʸήؿ
 * 顼ϥ顼ʸ󥪥֥Ȥ֤
 */
function exec_simrm($in_str, $oldurl)
{
	if (! $p = popen(SIMRM_EXE . ' stdin', "w")) {
		$body = '<p>' . SIMRM_EXE . ' μ¹Ԥ˼Ԥޤ</p>' . "\n"
		      . '<p><a href="' . $oldurl . '">Υڡ</a></p>' . "\n";
		return $body;
	}
	if (fwrite($p, $in_str) === FALSE) {
		$body = '<p>' . SIMRM_EXE . ' ؤΥǡϤ˼Ԥޤ</p>' . "\n"
		      . '<p><a href="' . $oldurl . '">Υڡ</a></p>' . "\n";
		return $body;
	}
	$status = pclose($p);
	if ($status != 0) {
		$body = '<p>' . SIMRM_EXE . ' Ͻλơ '
		      . $status . ' ֤ޤ<br/>' . "\n"
		      . 'ܤ HTTP ФΥ顼ʤɤ򻲾ȤƤ</p>' . "\n"
		      . '<p><a href="' . $oldurl . '">Υڡ</a></p>' . "\n";
		return $body;
	}

	// ʲｪλ
	return NULL;
}


/**
 * POST ˸ƤФؿ
 * POST 줿Ƥåsimrm ƤϤ
 */
function plugin_simrm_action()
{
	global $post;

	// ȸ路Ȥϥȥåץڡ᤹
	if ($post['plugin'] != 'simrm') return FALSE;
	if ($post['mode'] != 'submit') return FALSE;
	if (strlen($post['oldurl']) < 5) return FALSE;

	// Wiki Υإååʸ
	$msg  = '';
	$body = '<a href="' . $post['oldurl'] . '">Υڡ</a>';

	// 顼å
	$err = check_post_data();
	if ($err != '') {
		$msg  = 'Error of SimRM';
		$body .= $err;
		$body .= '<p><a href="' . $post['oldurl'] . '">Υڡ</a></p>';
		return (array('msg' => $msg, 'body' => $body));
	}

	// SimRM Ϥ᡼ƤŬڤʥ󥳡ǥ󥰤ܤ
	// TODO: To, Subject եɤˤ MIME 󥳡ɤɬפʤϤ
	// TODO: To, Subject եɤϲԤʤƤϤʤ
	$jto   = iconv(WIKI_ENCODE, MAIL_ENCODE, $post['to']);
	$jsub  = iconv(WIKI_ENCODE, MAIL_ENCODE, $post['subject']);
	// NOTE: ʸƹƬ From  > դ (Thunderbird ä)
	$jbody = preg_replace("/^(from\s)/mi", ">\\1", $post['body']);
	$jbody = iconv(WIKI_ENCODE, MAIL_ENCODE, $jbody);

	// NOTE: From:  $post['to'] ƤΤϴְ㤤ǤϤʤ
	$mail_str = <<<M_END
To: SimRM
From: $jto
Subject: $jsub
Content-Type: text/plain; charset=ISO-2022-JP
Content-Transfer-Encoding: 7bit
X-Simrm-Caller: PukiWiki

$jbody
M_END;

	// simrm.rb μ¹
	$ebody = exec_simrm($mail_str, $post['oldurl']);
	if (!is_null($ebody)) {
		$msg  = 'Error of SimRM';
		$body .= $ebody;
		return (array('msg' => $msg, 'body' => $body));
	}

	// ʲｪλ
	$msg  = 'Result of SimRM';
	$body .= <<<EOS
<p>ƤΥ᡼ SimRM Ϥޤ顼С˥᡼뤬ޤ
<table border="1">
  <tr><td></td><td>{$post['to']}</td></tr>
  <tr><td>̾</td><td>{$post['subject']}</td></tr>
  <tr><td>ʸ</td><td>{$post['body']}</td></tr>
</table>
</p>
<a href="{$post['oldurl']}">Υڡ</a>
EOS;
	return (array('msg' => $msg, 'body' => $body));
}


/**
 * ץ饰Υᥤؿ
 * ̾ GET ɽ롣
 */
function plugin_simrm_convert()
{
	global $script, $vars;
	$_page  = isset($vars['page']) ? $vars['page'] : '';
	$r_page = rawurlencode($_page);

	// եκ
	$ret = <<<EOS
<h3>SimRM plugin</h3>
<p>
ʣɥ쥹򵭽Ҥݤ ', ' (ޤȾѥڡ) ǶڤäƤ<br/>
(: foo@abc.com, hoo@a.b.c.com, haa@a.b.c.net)<br/>
ޤ̾ help Ƚ񤯤Ȥǥإץ᡼뤬ޤ
</p>
<p>
<form action="$script?plugin=simrm" method="post">
  : <input type="text" name="to" value="" size="50" /><br/>
  ̾: <input type="text" name="subject" value="" size="50" /><br/>
  : <textarea name="body" cols="60" rows="10"></textarea><br/>
  <input type="hidden" name="plugin" value="simrm" />
  <input type="hidden" name="mode" value="submit" />
  <input type="hidden" name="oldurl" value="$script?$r_page" />
  <input type="submit" value=""/>
  <input type="reset" value="ꥢ"/>
</form>
</p>
EOS;
	// ¸եΥꥹȺ
	$ret .= make_reserved_str();
	return $ret;
}

?>
