#!/usr/bin/env ruby
#
# SIMple Reminder Mail
#
# NOTE:
#   1 ܤμ¹ԥѥϤǤХեѥ꤬˾ޤ
#   env Ȥä ruby ưϥƥδĶѿ˺뤿ᡢ
#   ͽ̷̤Ȥʤ뤳Ȥ롣
#
# NOTE:
#   FileUtils.mv ϥѡƥ󤬰ۤʤݡ
#   copy_entry() Ԥä unlink() 򤷤Ƥ롣
#   copy_entry() θ mbox ιä
#   unlink() Ŭڤʥե뤳Ȥˤʤ롣
#   mv ޥɤƱͤν򤷤ƤΤFileUtils.mv ˥Хꡢ
#   ΥƥǤưʤȤΤǡȤݤ mv ޥɤѤ롣
#
# See: http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-dev/28239 
#
# $Id: simrm.rb 6 2007-12-06 10:03:04Z isr $
#

$KCODE = 'e' # !! եʸɤѹݤϤѹ뤳

# SimRM ư¸Ƥ (˥ץ饰)
START_TIME = Time.now

# μ饤֥ϼ¹ԥեƱǥ쥯ȥ꤫ ./lib ֤
$: << File.dirname($0) 

# ط饤֥ɹ
require 'config.rb' # 桼

require 'fileutils'
require 'logger'
require 'net/pop'
require 'net/smtp'
require 'nkf'
require 'tempfile'
require 'tmpdir.rb'

# ץ饰󡢥饤֥¸ǥ쥯ȥꤷפʥ饤֥ɹ
LIB_DIR    = File.dirname($0) + '/lib'
PLUGIN_DIR = File.dirname($0) + '/plugin'
require "#{LIB_DIR}/errmsg.rb"
require "#{LIB_DIR}/mailext.rb"
require "#{LIB_DIR}/pmanager.rb"
require "#{LIB_DIR}/sending.rb"
require "#{LIB_DIR}/utils.rb"
require "#{PLUGIN_DIR}/plugin.rb"


# ޤ¾οͤ¸᡼򸫤ʤᡢumask ѹ
UMASK = 027

# إ׵ڤӥ顼ʸե
HELP_FILE   = File.dirname($0) + '/mail/help.txt'
ERR_FILE    = File.dirname($0) + '/mail/error.txt'
MAINTE_FILE = File.dirname($0) + '/mail/maintenance.txt'
USAGE_FILE  = File.dirname($0) + '/usage.txt'

# ԤľϿ桼ɥ쥹ե (Ūˤ DATADIR ֤ޤ)
USER_LIST = DATADIR + '/userlist.txt'
# addme:PASSWD ˤäɲä륢ɥ쥹ե
ADDME_LIST = DATADIR + '/addme.txt'
# USER_LIST Υƥץ졼ȥե
USER_LIST_TEMPLATE =  File.dirname($0) + '/template/userlist.txt'
# DATADIR Υǥ쥯ȥ
LOG_DIR = DATADIR + '/log'			# ե뤬֤ǥ쥯ȥ
MEMO_DIR = DATADIR + '/memo'		# ե뤬֤ǥ쥯ȥ
RESERVED_DIR = DATADIR + '/reserve'	# ͽΥ᡼뤬ǥ쥯ȥ
WORKING_DIR = DATADIR + '/working'	# ¿ʥ󥰥ǥ쥯ȥ

#  ARGV Ȥδط
MODE = 0
MBOX = 1

# 軰˥եѥ륪ץ
ARG_THREE_MODES = ['dcsm', 'mbox']
# ǡȤʤȤΥ⡼ɥץ
DAEMON_MODES = ['dcs', 'dcsm', 'dcsp']

# UTC եå ("+0900" Τ褦ʸ)
UTC_OFFSET_STR = Utils::get_utc_offset_str()

# -----------------------------------------------------------------------------

# plugin ν
# Pmanager  singleton Ǥ
def init_plugin()
	p = Pmanager.instance
	return p.init(PLUGIN_DIR, PLUGIN_USE)
end


# force ƤȶŪ˻ˡɽޤ
def usage(argc, force = false)

	# οȥ⡼ɤб狼䤹
	ok = false
	ok |= (argc == 1 and ARGV[MODE] == 'clean') 
	ok |= (argc == 1 and ARGV[MODE] == 'dcs') 
	ok |= (argc == 2 and ARGV[MODE] == 'dcsm') 
	ok |= (argc == 1 and ARGV[MODE] == 'dcsp') 
	ok |= (argc == 1 and ARGV[MODE] == 'hup') 
	ok |= (argc == 1 and ARGV[MODE] == 'kill') 
	ok |= (argc == 2 and ARGV[MODE] == 'mbox') 
	ok |= (argc == 1 and ARGV[MODE] == 'pop3') 
	ok |= (argc == 1 and ARGV[MODE] == 'send') 
	ok |= (argc == 1 and ARGV[MODE] == 'stdin') 

	if force or !ok
		File.readlines(USAGE_FILE, nil).each {|all|
			print NKF.nkf('-ed', all)
		}
		# ¿ʬƤʤ顢¾Υå⤷Ƥ
		return 10 + 
			check_and_mkdir_wrap() + 
			check_userlist(USER_LIST, USER_LIST_TEMPLATE)
	end

	return 0
end


# from  to  cp from 򥵥 0 ˤ
# to Υեϥɥ֤
# ɤʤ nil ֤
# NOTE: /var/mail/user  Permission ꤫ mv Ǥʤ 
def move_and_open(from, to)
	unless FileTest.readable_real?(from)
		Utils::cputs('debug', "#{ARGV[MBOX]} is NOT readable.")
		return nil
	end
	#  0 ξ nil
	return nil unless FileTest.size?(from)

	begin
		FileUtils.copy(from, to, {:preserve => true})
		raise unless Utils::do_filesize0(from)
		return File.open(to)
	rescue
		Utils::cputs('error', "Can't handle the files")
		exit 20
	end
end


# 桼ꥹȤ뤫ɤγǧ
# ʤк
def check_userlist(fpath, template)
	if FileTest.file?(fpath) and FileTest.readable_real?(fpath) and 
	   FileTest.writable?(fpath)
		return 0
	end

	Utils::cputs('warn', "#{fpath} is not found")
	# ԤƤ³
	FileUtils.copy(template, fpath) rescue nil
	msg = 'Touch the file ... ' + (FileTest.readable_real?(fpath) ? 'OK.' : 'NG!!')
	Utils::cputs('info', msg)

	# ٳǧƤ
	if FileTest.file?(fpath) and FileTest.readable_real?(fpath) and 
	   FileTest.writable?(fpath)
		return 0
	end

	Utils::cputs('error', "Can't make #{fpath}")
	return 25
end


# ǡǥ쥯ȥ桼ꥹȤγǧڤ
def check_and_mkdir(dirs)

	# DATADIR βˤ⤤Ĥǥ쥯ȥ꤬ɬ
	dirs.each do |d|
		# ˥ǥ쥯ȥ꤬ʤɤ
		next if FileTest.directory?(d)

		if FileTest.exist?(d)
			Utils::cputs('error', "#{d} is not directory")
			return 30
		end

		# ̵褦ʤΤǺ
		begin 
			FileUtils.mkdir(d)
		rescue
			Utils::cputs('error', "Can't mkdir #{d}")
			return 31
		end
	end

	# ǡǥ쥯ȥγǧλ
	return 0
end


# check_and_mkdir() 褯Ѥǥ쥯ȥ
def check_and_mkdir_wrap()
	return check_and_mkdir([DATADIR, LOG_DIR, MEMO_DIR, RESERVED_DIR, WORKING_DIR])
end


# ¾ͤʤ褦ˤƤ
# ä˥桼եϽ
# (svn up  mode äƤޤ¹Ԥ˼֤ݤ롣
#  äơѹƤޤ)
def check_and_chmod(fpath, mode)
	return true if (File::stat(fpath).mode & 0007) == 0

	# ⡼ɤŬڤʤΤѹ
	Utils::cputs('warn', "Others can manipulate '#{fpath}'")

	ret = true
	File.chmod(mode, fpath) rescue ret = false
	Utils::cputs((ret ? 'info' : 'warn'),
				 'Change the file mode ... ' + (ret ? 'OK.' : 'NG!!'))
	return ret
end


# ȼ˷Ҥ褦Ƚꤹ
def check_setting()
	# umask 
	if (UMASK & 0007) != 7
		Utils::cputs('error', "Others can manipulate mail files")
		return 40
	end

	# ᡼¸ǥ쥯ȥå
	if RESERVED_DIR == File.dirname($0)
		Utils::cputs('error', "Subject 'stop:foo' can remove foo in this program directory")
		return 41
	end

	# եΥ⡼ɤŬڤɤå
	# ŬڤʤѹȤԤ
	return 42 unless check_and_chmod($0, 0740)
	return 43 unless check_and_chmod(File.dirname($0) + '/config.rb', 0640)

	# ѥ
	if ADDME_PASSWD.empty?
		Utils::cputs('error', "ADDME_PASSWD is empty")
		return 44
	end

	return 0
end


# ⡼ɤ¾˰åԤ
# NOTE: usage() ǥ⡼ɤϥåƤ뤳
def check_args()
	# եϥեѥǤ뤳
	# NOTE: ǡʳäԶ̵ϤʤΤǡٹˤ롣
	if ARG_THREE_MODES.index(ARGV[MODE])
		if ARGV[MBOX][0].chr != '/'
			Utils::cputs('warn', "mbox path must be full path")
		end
	end

	return 0
end


# ե̾ʣʤ褦parse_subject() ƤФ
# Ŭڤʥե̾ĤäʤС¨¤ touch Ƥ
# (get_uniq_fname() ٤Ʊե֤̾ʤ褦ˤ뤿ν)
#
# ͤϥեѥˤʤäƤΤա
#
# NOTE:
# ϥե¸̵ͭǤϤʤ
#  0 ˤʤäƤʤɤΥåɬ
def get_uniq_fname(base, datadir)
	i = 0
	s = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"

	# ˡʥե̾Ĥޤǥ롼
	# NOTE: 10000 ¹Ԥơܤʤ
	while true
		i += 1
		fname = datadir + '/' + base
		fname << s[rand(62)] << s[rand(62)] << s[rand(62)] << s[rand(62)] 
		fname << s[rand(62)] << s[rand(62)] << s[rand(62)] << s[rand(62)] 
		if FileTest.exist?(fname)
			next if i < 10000
			return nil, ERR_UNIQ_FILE
		end

		# Υե̵̾餷Τǡ touch
		# TODO: ˾ͤϵʤ
		begin 
			FileUtils.touch(fname)
			break
		# touch Ǥʤм¹ԴĶ路Τǥ顼ˤƤ
		rescue
			return nil, ERR_TOUCH_FILE
		end
	end
	return fname, nil
end



# ֤ʰץå
# ꤹե̾ YYYYmmdd_HHMM_*,
# ޤ HOUR, DAY, WEEK ʤɤ every ꡼
# OK -> true
# NG -> false
def check_time_range(fname)
	# HOUR_xx_ ûե̾Ȼפ
	return false if fname.length < 8 

	year = mon = week = day = hour = min = nil

	# ʸ󤫤֤
	if fname.index(/\d/) == 0
		raise if fname.length != 14
		year, mon, day, hour, min =
			fname[0..3].to_i,  fname[4..5].to_i,  fname[6..7].to_i,
			fname[9..10].to_i, fname[11..12].to_i
	elsif fname.index("HOUR_")  == 0
		raise if fname.length != "HOUR_mm_".length
		min = fname[5..6].to_i
	elsif fname.index("DAY_")   == 0
		raise if fname.length != "DAY_hhmm_".length
		hour = fname[4..5].to_i
		min  = fname[6..7].to_i
	elsif fname.index("WEEK_")  == 0
		raise if fname.length != "WEEK_w_hhmm_".length
		week = fname[5].chr.to_i
		hour = fname[7..8].to_i
		min  = fname[9..10].to_i
	elsif fname.index("MONTH_") == 0
		raise if fname.length != "MONTH_dd_hhmm_".length
		day  = fname[6..7].to_i
		hour = fname[9..10].to_i
		min  = fname[11..12].to_i
	elsif fname.index("YEAR_")  == 0
		raise if fname.length != "YEAR_MMdd_hhmm_".length
		mon  = fname[5..6].to_i
		day  = fname[7..8].to_i
		hour = fname[10..11].to_i
		min  = fname[12..13].to_i
	end

	# ֤ϰϤå
	return Utils::time_range_ok?(year, mon, week, day, hour, min)
end


# Ť᡼ true ֤
# ꤹե̾ YYYYmmdd_HHMM_*
def is_old_filename(fname, tm, plus_sec)
	limit = Time.at(tm) + plus_sec
	ftime = Time.local(fname[0..3], fname[4..5], fname[6..7],
					   fname[9..10], fname[11..12])
	# limit 礭
	return (limit <=> ftime) >= 0
end


# ̾ʸѡ郎Ҥ줿ʬե֤̾
# ʤƱ郎äƤ᡼ֹ䤷ʣʤ褦ˤ
# 郎 2006-01-08T00:00+09:00 ʤС
# 20060108_0000_id Ȥʤޤ
# ( W3C-DTF Ȥ󤷤ƥե̾ꤿɡ
#  ե륷ƥȤοʤΤȼˤޤ)
#
# every ϼΥե̾ˤʤޤ
# HOUR_15_id        #  15 ʬ
# DAY_0345_id       #  3  45 ʬ
# WEEK_3_1105_id    # 轵 3  45 ʬ (0..6; 0 )
# MONTH_29_2020_id  #  29  20  20 ʬ
#                   # (η¸ߤʤʤʤ)
# YEAR_0302_1420_id # ǯ 3  2  14  20 ʬ 
#                   # (ǯ¸ߤʤʤʤ)
#
# WARNING: subject ν񤭴ΤǡꥸʥǡϤʤ
#
def parse_subject!(subject, datadir, tm)
	# ̵ȤǾƤ
	# ޤʸζϥץ饰βǽ뤿ᡢĤƤ
	subject.sub!(/^\s+/, '')
	subject.sub!(/\s+$/, '')
	subject.gsub!(/\n/, '')

	# ':.*' ϥץ饰б
	[
		[/^(\d{8})(\d{4})$/,	'\1_\2_'],
		[/^(\d{8})(\d{4}):.*$/,	'\1_\2_'],
		[/^(\d{6})(\d{4})$/,	'\1_\2_'],
		[/^(\d{6})(\d{4}):.*$/,	'\1_\2_'],
		[/^(\d{4})(\d{4})$/,	'\1_\2_'],
		[/^(\d{4})(\d{4}):.*$/,	'\1_\2_'],
		[/^(\d{2})(\d{4})$/,	'\1_\2_'],
		[/^(\d{2})(\d{4}):.*$/,	'\1_\2_'],
		[/^(\d{4})$/,			'_\1_'],
		[/^(\d{4}):.*$/,		'_\1_'],
		[/^(\d{2})$/,			'_\1'],
		[/^(\d{2}):.*$/,		'_\1']
	].each do |a|
		# ִʤ nil ֤Τǡ
		if subject.sub!(a[0], a[1])
			case subject.length
			when 14 # ϴʤΤǲ⤷ʤ
				subject
			when 12 # ξ 2 夬­ʤ
				subject = tm.strftime('%Y')[0..1] + subject
			when 10 # 񤬾άƤ
				subject = tm.strftime('%Y') + subject
			when  8 # 񡢷άƤ
				subject = tm.strftime('%Y%m') + subject
			when  6 # ǯάƤ
				subject = tm.strftime('%Y%m%d') + subject
			when  3 # ǯ0 ʬάƤ
				subject = tm.strftime('%Y%m%d') + subject + '00_'
			else
				raise 'program mistake: ' + subject
			end

			# ¸ߤʤ֤ؤƤΤϥ顼 
			return nil, ERR_TIME_RANGE unless check_time_range(subject)

			# ̤λؤƤʤΤϥ顼 
			return nil, ERR_OLD_TIME   if is_old_filename(subject, tm, (5 * 60) - 1)

			# id 
			return get_uniq_fname(subject, datadir)
		end
	end

	# every ꡼
	[
		[/^everyhour:(\d{2})$/,            'HOUR_\1_'],
		[/^everyhour:(\d{2}):.*$/,         'HOUR_\1_'],
		[/^everyday:(\d{4})$/,             'DAY_\1_'],
		[/^everyday:(\d{4}):.*$/,          'DAY_\1_'],
		[/^everyweek:(\d)(\d{4})$/,        'WEEK_\1_\2_'],
		[/^everyweek:(\d)(\d{4}):.*$/,     'WEEK_\1_\2_'],
		[/^everymonth:(\d{2})(\d{4})$/,    'MONTH_\1_\2_'],
		[/^everymonth:(\d{2})(\d{4}):.*$/, 'MONTH_\1_\2_'],
		[/^everyyear:(\d{4})(\d{4})$/,     'YEAR_\1_\2_'],
		[/^everyyear:(\d{4})(\d{4}):.*$/,  'YEAR_\1_\2_']
	].each do |a|
		if subject.sub!(a[0], a[1])
			# ¸ߤʤ֤ؤƤΤϥ顼 
			return nil, ERR_TIME_RANGE unless check_time_range(subject)

			# id 
			return get_uniq_fname(subject, datadir)
		end
	end

	return nil, ERR_PARSE_SUBJECT
end


# ᡼ 1 ̤¸ؿ
#
# NOTE:
# fname ϥեѥǤ뤳
# ®ǤɬפʤΤǡcopy ƤƥݥեФ
# FileUtils.mv ϥХ뤫Ȥʤ
# File.rename  savedir  workdir ̥ѡƥβǽΤǻȤʤ
def save_mail(fname, mail, workdir)

	# ޤϥ᡼ƤȤƥإå
	# إåιƤޤϥإå̾ 1024 ʸʾäإåȥå
	# ʪƤ
	# Sender, From, Reply-To ̵ǻĤ
	# إåϾʸΤޤޤ OK
	i = 1
	contents = ''
	mail.header.each_pair { |k, v|
		wk = k.dup
		wv = v.gsub(/\n/, "\n ")
		if (!['from', 'reply-to', 'sender'].index(wk)) and
		   (wk.length >= 1024 or wv.length >= 1024)
			wk = 'overheadersize' + i.to_s
			wv = ''
			i += 1
		end
		contents << wk << ': ' << wv << "\n"
	}
	# إåɲ
	contents << "X-Simrm-Saved: "
	contents << Time.now.strftime("%a, %d %b %Y %H:%M:%S ")
	contents << UTC_OFFSET_STR << "\n"

	# إåλ ------------------------
	contents << "\n"


	# ʸϰΥ˼
	# NOTE: mail.body ϾʤȤ [] ˤʤäƤΤ each ϸƤ٤
	size = 0
	mail.body.each do |line|
		size += line.length
		if size > BODY_MAX_SIZE
			contents << "size over\n"
			break
		end
		contents << line
	end

	# ƥݥեκȽ񤭹
	bname = File.basename(fname)
	tf = Tempfile.new(bname, workdir)
	tf.print contents
	tf.close(false)

	FileUtils.copy(tf.path, fname)
	Utils::cputs('info', "#{fname} was saved")

	# TempFile  GC ˤäƺΤǤΤޤ
end


# ̾ʸѡ̾񤫤줿ʬե֤̾
# :
# nil, 顼å -> 
# fpath, nil -> 񤭹߲ǽ
#
# WARNING: subject ν񤭴ΤǡꥸʥǡϤʤ
#
def parse_subject_for_memo!(subject, datadir)
	subject.gsub!(/\s/, '') # ̵ȤǾ

	case subject
	when /^memoput:/, /^mp:/, /^memoget:/, /^mg:/
		subject.sub!(/^.*?:/, '')
	else
		return nil, ERR_DEVMISS_MEMO
	end

	# Υȥ뤬ͤƤ뤫
	return nil, ERR_MEMO_TITLE unless subject =~ /^[a-zA-Z0-9]{1,32}$/

	fpath = datadir + '/MEMO_' + subject
	return fpath, nil
end


# եΥСɤå
def check_memo_member(fpath, mail)
	return false unless FileTest.exist?(fpath)

	# Ʊե뤬¸ߤ Sender, From, Reply-To إåå
	f = nil
	w_ok = false
	begin 
		f = File.open(fpath)
		m = Mail.new(f)
		Utils::make_address_list_from_field(mail.sender_or_from).each {|ad|
			w_ok = true if m.is_address_written?(ad)
		}
	rescue
		Utils::cputs('warn', "Can't process #{fpath}")
	ensure
		f.close if f
	end
	return w_ok
end


# ؿ
# :
# nil -> λ
# errmsg -> 顼ä
#
# NOTE:
# fpath ϥեѥǤ뤳
def delete_memo(fpath, mail)
	return ERR_MEMO_EXIST_DEL unless FileTest.exist?(fpath)
	return ERR_MEMO_MEMBER_DEL unless check_memo_member(fpath, mail)

	begin
		File.unlink(fpath)
	rescue
		Utils::cputs('warn', "Can't unlink #{fpath}")
		return ERR_MEMO_DEL
	end

	# ｪλ
	return nil
end


# ᡼ 1 ̤¸ؿ
# :
# nil -> ¸λ
# errmsg -> 顼ä
#
# NOTE:
# fpath ϥեѥǤ뤳
def save_memo(fpath, mail, workdir)
	if FileTest.exist?(fpath)
		return ERR_MEMO_MEMBER_PUT unless check_memo_member(fpath, mail)
	end
	
	# Τޤ޻Ȥä̵
	save_mail(fpath, mail, workdir)
	return nil
end


# ̾ addme Υ᡼
# OK -> true,  nil
# NG -> false, ERRMSG
def process_addme_mail(sm, mail)
	raise 'no subject' unless mail['subject']

	pw = NKF.nkf('-me', mail['subject'])
	pw.sub!(/^addme:(.*)$/, '\1')
	# 顼å֤ºݤ˥顼᡼Фʤ
	return false, ERR_NOMATCH_PASSWD if pw != ADDME_PASSWD

	case sm.add_addme_user(mail)
	when  0
		return true, nil
	when -1
		return false, ERR_WRONG_ADDRESS
	when  1 # ¿ʬˤʤȻפǰΤ
		return false, ERR_ALREADY_ADDED
	else
		raise 'Control never reach: process_addme_mail'
	end
end


# ̾ del, delete, stop Υ᡼
# ̵˺ǤȤоݼԤ˥᡼
# OK -> true,  nil
# NG -> false, ERRMSG
def process_stop_mail(sm, mail)
	# 桼ꥹȤϿƤʤʤ
	# (顼å֤Ƥ뤬顼᡼ʤ)
	return false, ERR_STOP_USER unless sm.send_ok?(mail)

	raise 'no subject' unless mail['subject']
	fname = NKF.nkf('-me', mail['subject'])
	# 虜虜ʸ饹ꤷƤΤϡ
	# ޥХбɽ \w ѱѿóݤƤޤ褦ʤΤ
	fname.sub!(/^(del|delete|stop):([0-9a-zA-Z_]*).*$/, '\2')
	fname.gsub!(/[+*.\/]/, '') # ʸϥåȤƤ
	return false, ERR_STOP_FILE if fname.empty?

	# եѥ
	path = RESERVED_DIR + '/' + fname

	# оݥեå
	if FileTest.file?(path) and FileTest.owned?(path) and 
	   FileTest.writable?(path) and FileTest.size?(path)
		begin
			# stop оݥե򳫤ݤ
			f = File.open(path)
			stopm = Mail.new(f)
			sm.send_stop_ok(stopm, fname)
			f.close

			# Ǥäȥե
			File.unlink(path)
			return true, nil
		rescue
			return false, ERR_RM_FILE_EXP
		end
	end

	# 
	return false, ERR_RM_FILE_CHK
end


# ᡼ե򳫤줬ʬǤ뤫ɤå
# ʬΥ᡼: subject, body
# ʬǤϤʤ᡼: nil, nil
#
# NOTE: subject ϸ᡼η̾
#       body ϥإåƤʸ (3 ) Ȥ
def parse_for_list(fpath, from)
	# оݥեå
	return nil, nil unless FileTest.file?(fpath) and FileTest.readable?(fpath)

	begin
		f = File.open(fpath)
		m = Mail.new(f)
		return nil, nil if m.header.empty?

		# ʬå
		ad = m.resolv_to_address.gsub(/\n/, ' ')
		unless ad.index(from)
			f.close
			return nil, nil
		end

		# body ϤȤꤢ 3 ʬ
		subject = m['subject'] ? NKF.nkf('-mj', m['subject']) : 'unknown'
		body = m.body ? NKF.nkf('-j', m.body[0..2].join) : ''

		f.close
		return subject, body
	rescue
		# ⤷ʤǤ
	end

	return nil, nil
end


# ̾ list Υ᡼
# 褬 From or Sender ˵ҤƤ륢ɥ쥹ȰפʤС
# ꥹȲ
# NOTE: ¸Ƥ᡼̤ˤ뤬Ϸ빽Ť
# OK -> true,  nil
# NG -> false, ERRMSG
def process_list_mail(sm, mail)
	# 桼ꥹȤϿƤʤʤ
	# (顼å֤Ƥ뤬顼᡼ʤ)
	return false, ERR_LIST_USER unless sm.send_ok?(mail)

	# ԤΥɥ쥹
	from = mail.sender_or_from.gsub(/\n/, ' ')
	return false, ERR_WRONG_ADDRESS unless Utils::exist_address?(from)
	# From ʣΥɥ쥹ʤХ顼Ȥ롣
	# ޤadds  Name <add@res.net>  add@res.net ʬΤߤФΤǤ롣
	adds = Utils::make_address_list_from_field(from)
	return false, ERR_FROM_MULTI unless adds.length == 1
	from = adds[0]

	# ǥ쥯ȥΥեƤоݤȤ
	# ȤѡƼʬʤФƤ
	s_b  = []	# -j Ƥ뤳
	Dir.glob(RESERVED_DIR + '/*').each do |fpath|
		sub, body = parse_for_list(fpath, from)
		if sub and body
			s_b << [sub, body]
		end
	end

	# list ᡼
	sm.send_list_mail(mail, s_b)
	return true, nil
end


# ƥݻƤΥꥹȤ֤
# ʬ˻ȡԽ¤̵ȤƤΥΥꥹȤ֤
def process_memolist_mail(sm, mail)
	base = MEMO_DIR + '/MEMO_'

	# ǥ쥯ȥΥեƤоݤȤ
	# ȤѡƼʬʤФƤ
	mlist  = []
	Dir.glob(base + '*').each do |fpath|
		mlist << fpath.sub(/#{base}/, '')
	end

	# memolist ᡼
	sm.send_memolist_mail(mail, mlist)
	return true, nil
end


# С֤
# TODO: ¹ˡˤäƤϥץȤΥեѥ (̵)
def process_version(sm, mail)
	verstr = "Ruby Version: #{RUBY_VERSION}\n"
	verstr << "SimRM Scripts Version:\n"

	# ¹ԥǥ쥯ȥ lib ǥ쥯ȥ겼ΥץȤ
	Dir.glob("#{File.dirname($0)}/{.,lib}/*.rb").each {|f|
        ret = Utils::grep(f, /\$Id.*\$\s*$/)
		if ret.size == 0
			verstr << "#{f}: No Id\n"
		else
			# #{s} ˤϲԤޤޤƤ
			ret.each {|s| verstr << "#{f}: #{s}" }
		end
	}

	sm.send_version!(mail, verstr)
	return true, nil
end


#  or Խ
# OK -> true,  nil
# NG -> false, ERRMSG
def process_memoput_mail(sm, mail)
	# fname ϥեѥ
	fpath, errmsg = parse_subject_for_memo!(mail['subject'].dup, MEMO_DIR)
	return false, errmsg if errmsg

	# ¸
	# (᡼ body  \s Τ, ޤ϶ʸǹƤϺ)
	if mail.body.to_s.gsub(/\s/, '') == ''
		errmsg = delete_memo(fpath, mail)
		return false, errmsg if errmsg

		# ξõλΤ
		sm.send_delete_for_memo(mail)
	else
		errmsg = save_memo(fpath, mail, WORKING_DIR)
		return false, errmsg if errmsg

		# ¸λΤ
		sm.send_accept_for_memo(fpath)
	end

	return true, nil
end


# 
# OK -> true,  nil
# NG -> false, ERRMSG
def process_memoget_mail(sm, mail)
	# fname ϥեѥ
	fpath, errmsg = parse_subject_for_memo!(mail['subject'].dup, MEMO_DIR)
	return false, errmsg if errmsg

	# ե뤬뤫
	return false, ERR_MEMO_EXIST_GET unless FileTest.exist?(fpath)
	# ȤǤФ
	return false, ERR_MEMO_MEMBER_GET unless check_memo_member(fpath, mail)

	# 
	sm.send_memo(fpath, mail)
	return true, nil
end


# ץ饰Ϣη̾ʸѡŬڤͤʬ䤹
#
# :
# nil, nil, nil, 顼å -> 
# directive("plugin", ͽʤ), plugin̾options, nil -> 
#
# NOTE: ͤ options  nil Ȥʤ뤳Ȥ
#
# WARNING: subject ν񤭴ΤǡꥸʥǡϤʤ
def parse_subject_for_plugin!(subject)
	# ǽȺǸˤ̵ȤǾ
	subject.sub!(/^\s+/, '')
	subject.sub!(/\s+$/, '')
	subject.gsub!(/\n/, '')

	di = pname = opts = nil
	if subject =~ /^every/
		ev, d, pname, opts = subject.split(':', 4)
		return nil, nil, nil, ERR_PARSE_EVERY_TYPE if ev == nil
		return nil, nil, nil, ERR_PARSE_EVERY_DATE if d == nil
		di = "#{ev}:#{d}"
	else
		#  di ˤ "plugin", "plg" ޤͽ
		di, pname, opts = subject.split(':', 3)
	end
	return nil, nil, nil, ERR_PARSE_PLUGIN_DIRECTIVE if di == nil
	return nil, nil, nil, ERR_PARSE_PLUGIN_NAME if pname == nil

	return di, pname, opts, nil
end


# ץ饰Υ᡼ˤꡢʸ롣
# 顼äϥ顼å롣
#
# : Τ褦ɬå֥Ȥ֤
#   true,  msg
#   false, msg
#
def get_plugin_body(mail)
	di, pname, opts, errmsg = parse_subject_for_plugin!(mail['subject'].dup)
	return false, errmsg if errmsg

	# ץ饰󤬤뤫
	return false, ERR_PLUGIN_NO_EXIST unless Pmanager.instance.include?(pname)

	# mail_error  Plugin::IGNORE_ME ʳʤ᡼ʸ٤ get_mail_body() ¹Ԥ롣
	plg = nil
	body = nil
	begin
		# ץ饰󥪥֥Ȥ
		plg = eval("Plugin_#{pname}").new(mail, opts, Plugin::MODE_SEND)

		# 顼å
		case plg.mail_error
		# 
		when Plugin::NO_ERROR
			;
		# 顼
		when Plugin::ERROR
			errmsg = ERR_PLUGIN_ERROR_MAIL + plg.mail_error_msg
			return false, errmsg
		# NOTE: 衢̵ͤ IGNORE_ME ΤȤǤ뤬
		#       ¾ͤꤵƤȤƱͤȤ
		# NOTE: ͤȤ nil ֤Ȥǥ᡼ʤ褦ˤƤ
		else
			Utils::cputs('info', "ignored: Plugin_#{pname}.mail_error = #{plg.mail_error}") 
			return true, nil
		end

		body = plg.get_mail_body(mail, opts, Plugin::MODE_SEND)
		body = body ? NKF.nkf('-j', body) : ''
	rescue Exception => e
		Utils::cputs('error', "'Plugin_#{pname}' raised in new() or get_mail_body() : #{e.to_s}") 
		return false, ERR_PLUGIN_EXCEPTION
	ensure
		begin
			plg.delete() if plg != nil
		rescue Exception
			Utils::cputs('error', "'Plugin_#{pname}' raised in delete()") 
		end
	end

	return true, body
end


# plugin ᡼¸Ƥå (MODE_SAVE ǥå)
# OK -> true,  nil
# NG -> false, ERRMSG
def check_save_plugin_mail(mail)
	di, pname, opts, errmsg = parse_subject_for_plugin!(mail['subject'].dup)
	return false, errmsg if errmsg

	# ץ饰󤬤뤫
	return false, ERR_PLUGIN_NO_EXIST unless Pmanager.instance.include?(pname)

	# mail_error  Plugin::NO_ERROR ʳʤХ顼Ȥ
	plg = nil
	begin
		# ץ饰󥪥֥Ȥ
		plg = eval("Plugin_#{pname}").new(mail, opts, Plugin::MODE_SAVE)

		# 顼å
		if plg.mail_error != Plugin::NO_ERROR
			errmsg = ERR_PLUGIN_SAVE_MAIL + plg.mail_error_msg
			return false, errmsg
		end
	rescue Exception => e
		Utils::cputs('error', "'Plugin_#{pname}' raised in new() : #{e.to_s}") 
		return false, ERR_PLUGIN_EXCEPTION
	ensure
		begin
			plg.delete() if plg != nil
		rescue Exception
			Utils::cputs('error', "'Plugin_#{pname}' raised in delete()") 
		end
	end

	return true, nil
end


# ץ饰ν
# OK -> true,  nil
# NG -> false, ERRMSG
def process_plugin_mail(sm, mail)
	di, pname, opts, errmsg = parse_subject_for_plugin!(mail['subject'].dup)
	return false, errmsg if errmsg

	# ץ饰󤬤뤫
	return false, ERR_PLUGIN_NO_EXIST unless Pmanager.instance.include?(pname)

	# mail_error  Plugin::IGNORE_ME ʳʤ᡼ʸ٤ get_mail_body() ¹Ԥ롣
	plg = nil
	begin
		# ץ饰󥪥֥Ȥ
		plg = eval("Plugin_#{pname}").new(mail, opts, Plugin::MODE_SEND)

		# 顼å
		case plg.mail_error
		# 
		when Plugin::NO_ERROR
			;
		# 顼᡼
		when Plugin::ERROR
			errmsg = ERR_PLUGIN_ERROR_MAIL + plg.mail_error_msg
			return false, errmsg
		# NOTE: 衢̵ͤ IGNORE_ME ΤȤǤ뤬
		#       ¾ͤꤵƤȤƱͤȤ
		else
			Utils::cputs('info', "ignored: Plugin_#{pname}.mail_error = #{plg.mail_error}") 
			return true, nil
		end

		body = plg.get_mail_body(mail, opts, Plugin::MODE_SEND)
		body = body ? NKF.nkf('-j', body) : ''
		sm.send_plugin_result(mail, pname, body)
	rescue Exception => e
		Utils::cputs('error', "'Plugin_#{pname}' raised in new() or get_mail_body() : #{e.to_s}") 
		return false, ERR_PLUGIN_EXCEPTION
	ensure
		begin
			plg.delete() if plg != nil
		rescue Exception
			Utils::cputs('error', "'Plugin_#{pname}' raised in delete()") 
		end
	end

	return true, nil
end


# ޥ᡼ν
# OK -> true,  nil
# NG -> false, ERRMSG
def process_reminder_mail(sm, mail, time_now)
	# fname ϥեѥ
	fname, errmsg = parse_subject!(mail['subject'].dup, RESERVED_DIR, time_now)
	return false, errmsg if errmsg

	# plugin ξ SAVE Ƥ褤å
	# NOTE: ñ ':' 뤫åȡñʤ every ꡼óݤäƤޤ
	if mail['subject'] =~ /[0-9]:.*/
		ret, errmsg = check_save_plugin_mail(mail)
		# NOTE: parse_subject!()  fname ե touch ǺѤߡäơϺɬ
		unless ret 
			File.unlink(fname) rescue Utils::cputs('error', "Can't unlink a file '#{fname}'")
			return false, errmsg
		end
	end

	# ˥᡼Ф褦ʬ䤷᡼¸
	save_mail(fname, mail, WORKING_DIR)
	# Ȥ (ե̾ stop ΰоݤˤǤ褦ˤ)
	sm.send_accept(fname)
	return true, nil
end


# ᡼åŬڤ̾դեʬ䤷Ƥ
# mbox  nil ʤв⤻
# NOTE: mbox Ϥδؿ close ΤǡƤ¦ close ʤ
def process_incoming_mail(mbox)
	return 0 unless mbox 

	time_now = Time.now

	# ᡼饹ν
	listfiles = ListFiles.new(USER_LIST, ADDME_LIST)
	mailfiles = MailFiles.new(ERR_FILE, HELP_FILE, MAINTE_FILE)
	sinfo = SmtpInfo.new(SMTP_HELO, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS, SMTP_AUTH)
	sm = SendingMail.new(FROM_ADDR, RPLY_ADDR, sinfo, mailfiles, listfiles)

	until (m = Mail.new(mbox)).header.empty?
		# ̾ʤΤ̵
		unless m['subject']
			Utils::cputs('debug', "process_incoming_mail(): no subject") 
			sm.send_error_mail(m, ERR_NO_SUBJECT)
			next
		end

		# ̾ǥХåȤƥ˽ФƤ
		if Utils::important_subject?(m['subject'])
			Utils::cputs('warn', "mail having the subject of " +
			                     "'#{m['subject']}' was recieved, but " +
			                     "it will be discarded maybe") 
		else
			Utils::cputs('debug', "process_incoming_mail(): subject '#{m['subject']}'") 
		end

		# Content-Type ˰ͤ餺ĤƤʤ桼ǤȯԤ̿
		case m['subject']
		# ̾Ƭ addme: ʤХۥ磻ȥꥹȤؤɲý
		when /^addme:/
			ok, errmsg = process_addme_mail(sm, m)
			# Ԥˤäꤲ᡼뤬ۤʤ
			# Ԥξ硢桼ꥹȤ¸ߤ륢ɥ쥹ʳʤС
			# ᡼ϼºݤˤФʤ
			ok ? sm.send_added(m) : sm.send_error_mail(m, errmsg)
			next
		# ̾Ƭ help ʤХإץ᡼
		when /^help/
			sm.send_help(m)
			next
		end

		#
		# ʹߡĤ줿桼ǤʤФʤʤ
		#
		next unless sm.send_ok?(m)

		# Content-Type ˰ͤʤ̿
		case m['subject']
		# ̾Ƭ list ʤмʬϤ᡼
		when /^list/
			ok, errmsg = process_list_mail(sm, m)
			sm.send_error_mail(m, errmsg) unless ok
			next
		# ̾Ƭ del:, delete:, stop: ʤл᡼
		when /^del:/, /^delete:/, /^stop:/
			ok, errmsg = process_stop_mail(sm, m)
			sm.send_error_mail(m, errmsg) unless ok
			next
		# ꥹ
		when /^memolist/, /^ml/
			ok, errmsg = process_memolist_mail(sm, m)
			sm.send_error_mail(m, errmsg) unless ok
			next
		# С
		# NOTE: Ĥ줿桼ΤߤȯԤ
		when /^version/, /^vr/
			ok, errmsg = process_version(sm, m)
			sm.send_error_mail(m, errmsg) unless ok
			next
		end

		#
		# ʹߡContent-Type  text/plain ǤʤΤϥ顼Ȥ
		#
		if m['content-type'] and m['content-type'].index("text/plain") == nil
			sm.send_error_mail(m, ERR_CONTENT_TYPE)
			next
		end

		# ƥʥʬ¸ʤΤǡΥ᡼ФƤ
		if NOW_MAINTENANCE
			sm.send_maintenance(m)
			next
		end

		case m['subject']
		# 
		when /^memoput:/, /^mp:/
			ok, errmsg = process_memoput_mail(sm, m)
		# 
		when /^memoget:/, /^mg:/
			ok, errmsg = process_memoget_mail(sm, m)
		# ¨Ԥץ饰
		when /^plugin:/, /^plg:/
			ok, errmsg = process_plugin_mail(sm, m)
		# ͽʤ (ץ饰ޤ)
		else
			ok, errmsg = process_reminder_mail(sm, m, time_now)
		end
		sm.send_error_mail(m, errmsg) unless ok
	end

	# 
	mbox.close
	sm.sfree              # SMTP Υåɬ
	sm.write_back_addme() # addme ɲʬ񤭽Ф

	return 0
end


# Ϥ줿 Time ֥ȤѤ
# Ūʥ᡼ե֤̾
def make_time_filenames(tm)
	return [
		tm.strftime('HOUR_%M_'), 
		tm.strftime('DAY_%H%M_'), 
		tm.strftime('WEEK_%w_%H%M_'),
		tm.strftime('MONTH_%d_%H%M_'), 
		tm.strftime('YEAR_%m%d_%H%M_'), 
		tm.strftime('%Y%m%d_%H%M_')
	]
end


# ꤵ줿᡼ե
# fpath ϥեѥǤ뤳
# 꼡衢ΥեϺ
def send_mail_file(fpath, sendmail, clean)
	# ¸ߤʤޤϥ 0  nil
	return false unless FileTest.size?(fpath)

	# ᡼
	begin
		f = File.open(fpath, "r+") # r'+' ϥåΤ
		raise unless f.flock(File::LOCK_EX | File::LOCK_NB) == 0
		m = Mail.new(f)

		# ץ饰åȥ᡼
		if m['subject'] =~ /[0-9]:.*/
			ok, plg_body = get_plugin_body(m)
			# plg_body  nil ǤϤʤ¤ꡢȤꤢ᡼
			# (plugin η̤ǤϤʤ顼åβǽ)
			sendmail.send_time_mail(m, fpath, clean, plg_body) if plg_body != nil
		else
			sendmail.send_time_mail(m, fpath, clean)
		end

		# Υåη̤ϸʤƤ⤤
		f.flock(File::LOCK_UN)
		f.close
		f = nil # ;פ close ʤ褦ˤƤ
	rescue
		Utils::cputs('warn', "Can't process #{fpath}")
		f.close if f
		return false
	end

	# ⤦פʤʤäե
	begin
		# ե̾Ƭͤʤ every ꡼ǤϤʤ
		# ơϰ¤Ȥư˺
		File.unlink(fpath) if File.basename(fpath).index(/\d/) == 0
		return true
	rescue
		Utils::cputs('warn', "Can't unlink #{fpath}")
		return false
	end

	raise 'Control never reach: send_mail_file'
end


# Υ᡼
# ̵ 0 ֤ȤˤƤ
# ( 0 ȻפΤ)
def mode_send(tm)
	# ᡼饹ν
	listfiles = ListFiles.new(USER_LIST, ADDME_LIST)
	mailfiles = MailFiles.new(ERR_FILE, HELP_FILE, MAINTE_FILE)
	sinfo = SmtpInfo.new(SMTP_HELO, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS, SMTP_AUTH)
	sm = SendingMail.new(FROM_ADDR, RPLY_ADDR, sinfo, mailfiles, listfiles)

	sum = 0
	make_time_filenames(tm).each do |bname|
		path = RESERVED_DIR + '/' + bname + '*'
		# ǥ쥯ȥ꤫鳺ե̾
		Dir.glob(path).each do |fname|
			# ̵Ǥʤ䤷Ƥ
			sum += 1 if send_mail_file(fname, sm, false)
		end
	end
	
	# 
	sm.sfree # SMTP Υåɬ

	return 0
end


# åԤǡˤʤȤϼ¹ԥ桼ѹȤʤ뤿ᡢ
# ǡեڤӥǥ쥯ȥγǧӹԤȤˤ
def main_check()
	# οäƤв⤷ʤ
	# ⡼ɤå
	ret = usage(ARGV.length)
	return ret if ret != 0

	# ⡼ɰʳΰå
	ret = check_args()
	return ret if ret != 0

	# ǡ⡼ɡޤ hup ʤ
	return 0 if DAEMON_MODES.index(ARGV[MODE])
	return 0 if 'hup' == ARGV[MODE]


	# ǡǥ쥯ȥγǧ
	ret = check_and_mkdir_wrap()
	return ret if ret != 0

	# plugin ɹ
	ret = init_plugin()
	return ret if ret != 0

	# 桼ꥹȤγǧ
	ret = check_userlist(USER_LIST, USER_LIST_TEMPLATE)
	return ret if ret != 0

	# ȼ˷Ҥϵʤ
	# ȤͤΤݤʤΤǡؿǹѿ򤽤Τޤ޻Ȥ
	ret = check_setting()
	return ret if ret != 0

	return 0
end


# ǡȤʤäǹԤƼå
# NOTE: δؿϥ桼 D_USER_NAME ǽ٤
def daemon_check_by_switched_user()
	# ǡǥ쥯ȥγǧ
	ret = check_and_mkdir_wrap()
	return ret if ret != 0

	# plugin ɹ
	ret = init_plugin()
	return ret if ret != 0

	# 桼ꥹȤγǧ
	ret = check_userlist(USER_LIST, USER_LIST_TEMPLATE)
	return ret if ret != 0

	# ȼ˷Ҥϵʤ
	# ȤͤΤݤʤΤǡؿǹѿ򤽤Τޤ޻Ȥ
	ret = check_setting()
	return ret if ret != 0

	return 0
end


# POP3 ǥåΥ᡼뤬ΥƥసɤȽꤹ
def is_mail_to_system(popmail)
	hs = popmail.header.split("\n")
	return false if hs.empty?

	# each ˤʤΤϡԤľ̤뤿
	for i in 0 .. hs.length - 1
		# To եɤǤʤмԤ
		#  To ȻפʸʸɤΤϤ
		next unless hs[i].sub!(/^to: (.*)$/i, '\1')

		# ʸ󤬤СƥసƤǧ
		return true if hs[i].index(POP3_TO_ADDR) 
		# Ԥ³礬Τǡб
		loop {
			i += 1
			return false if hs[i].index(' ') != 0
			return true  if hs[i].index(POP3_TO_ADDR) 
		}
	end
	return false
end


# POP3 Ф饷ƥసΥ᡼
# ե¸롣
# ͤϤΥեϥɥ롣
# ᡼뤬ʤäȤ nil ֤
#
# 
# fname ᡼Ǽե̾
def get_mail_by_pop3(fname)
	ret = nil
	# POP3_APOP  true ʤ Net:APOP 饹֤
	pop_apop = Net::POP3.APOP(POP3_APOP).new(POP3_HOST, POP3_PORT)
	pop_apop.start(POP3_USER, POP3_PASS) { |session|
		# ᡼뤬̵Ȥ
		return nil if session.mails.empty?

		# POP3 оΥ᡼
		f = nil
		session.each_mail do |m|
			# ΥƥసƤǤʤм
			next unless is_mail_to_system(m)

			# ΥƥసƤʤΤǥեؽ񤭹
			f = File.open(fname, "w") unless f
			f.write m.pop
			m.delete
		end

		# 
		if f
			f.close
			ret = File.open(fname)
		end
	}
	return ret
end


# ʤä᡼򤳤Υߥ󥰤
# θ롣
# NOTE: 㤨СŸƤʤɤ̤Υ᡼ϽФƤϤ
def mode_clean()
	# ¤Υ᡼򽦤夲
	files = Dir.glob(RESERVED_DIR + "/[0-9]*")
	return 0 if files.empty?

	# ᡼饹ν
	listfiles = ListFiles.new(USER_LIST, ADDME_LIST)
	mailfiles = MailFiles.new(ERR_FILE, HELP_FILE, MAINTE_FILE)
	sinfo = SmtpInfo.new(SMTP_HELO, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS, SMTP_AUTH)
	sm = SendingMail.new(FROM_ADDR, RPLY_ADDR, sinfo, mailfiles, listfiles)

	files.each do |fpath|
		name = File.basename(fpath)
		# ʬŤХ᡼
		if is_old_filename(name, Time.now, (-1 * 60)) 
			send_mail_file(fpath, sm, true)
		end
	end

	# 
	sm.sfree # SMTP Υåɬ

	return 0
end


# mbox ⡼ɤϥեƥݥ경Ȥ˳
# TODO: տŪ˹⤹뤳Ȥ mbox ⡼ɤΥƥݥեϾ񤭤ǽ
def mode_mbox()
	mbox_temp = Dir.tmpdir + "/mbox_" + Time.now.strftime('%Y%m%d%H%M%S') + $$.to_s

	mbox = move_and_open(ARGV[MBOX], mbox_temp)
	ret = process_incoming_mail(mbox)
	return ret unless mbox

	File.unlink(mbox_temp) rescue ret += 62
	return ret
end


# pop3 ⡼ɤ˼ʬƤΥ᡼
# θ˥᡼βϺȤԤ
# TODO: mbox ⡼ɤȽ¤äƤ뤬ƱΤͤ
# TODO: տŪ˹⤹뤳Ȥ pop3 ⡼ɤΥƥݥեϾ񤭤ǽ
def mode_pop3()
	pop3_temp = Dir.tmpdir + "/pop3_" + Time.now.strftime('%Y%m%d%H%M%S') + $$.to_s

	mbox = get_mail_by_pop3(pop3_temp)
	ret = process_incoming_mail(mbox)
	return ret unless mbox

	File.unlink(pop3_temp) rescue ret += 60
	return ret
end


# pid եĤƤ
def write_pid_file(pid_file, pid, cmd_str)
	ret = 0
	fname = pid_file ? pid_file : 'nil'
	s = cmd_str ? cmd_str : 'nil'
	Utils::cputs('debug', "pid_file=#{fname}, pid=#{pid}, cmd_str=#{s}")

	begin
		f = File.open(pid_file, 'w')
		f.puts pid
		f.puts cmd_str if cmd_str
	rescue
		Utils::cputs('warn', "Can't write pid file: pid_file=#{fname}, " +
					         "pid=#{pid}, cmd_str=#{s}")
		ret = 70
	ensure
		f.close if f
	end

	return ret
end


# utils.rb  utils_log 
def init_logger()
	fpath = LOG_DIR + '/simrm.log'
	$utils_log = Logger.new(fpath, 'daily')
	$utils_log.level = D_LOG_LEVEL
end


# ǡΥᥤ
#
# NOTE: ǡΥᥤ󥹥åɤ 1 äȤ˽Ԥ
#       Ū˻֤γݤϹԤʤȡ
#       塼ǰ롣
def daemon_process(f_receive, d_receive)
	# ѡ桼¤ΤƤ
	Utils::switch_uid(D_USER_NAME)

	# ⤦ stdout, stderr ȤʤΤ Logger ֥ȤȤ
	init_logger()
	Utils::cputs('debug', "Daemon and logger started!!")

	# ʥ trap Ƥ
	is_signal = false
	trap("SIGINT") { is_signal = true; Utils::cputs('debug', "Caught 'SIGINT'") }
	trap("SIGTERM"){ is_signal = true; Utils::cputs('debug', "Caught 'SIGTERM'") }
	trap("SIGHUP") { is_signal = true; Utils::cputs('debug', "Caught 'SIGHUP'") }

	# ɬ줾Υ⡼ɤ¹Ԥ褦ˤ
	old_send_sec = 61
	old_clean_time   = Time.local(2000)
	old_receive_time = Time.local(2000)

	loop {
		t = Time.new
		if t.sec < old_send_sec
			old_send_sec = t.sec + 1
			Thread.new { 
				begin
					mode_send(Time.now)
				rescue Exception => e
					Utils::cputs('error', "mode_send(): raise: #{e.to_s}")
				end
			}
		end
		if t - old_clean_time >= D_CLEAN_INTERVAL
			old_clean_time = t
			Thread.new { 
				begin
					mode_clean()
				rescue Exception => e
					Utils::cputs('error', "mode_clean(): raise: #{e.to_s}")
				end
			}
		end
		if t - old_receive_time >= d_receive
			old_receive_time = t
			Thread.new { 
				begin
					f_receive.call()
				rescue Exception => e
					Utils::cputs('error', "f_receive.call(): raise: #{e.to_s}")
				end
			}
		end

		# ʥƤʤå
		# NOTE: ¾åɤνԤθ塢λ
		if is_signal
			Thread.list.each { |th| 
				th.join if th != Thread.main
			}
			Utils::cputs('debug', "Other threads exited, and main thread will be end, too")
			Utils::cputs('info', "BYE!")
			exit 0
		end

		sleep 1
	}
end


# ǡ
# mode:
# nil    -> ᡼μȤϤʤ (pukiwiki ѻʤ)
# 'mbox' -> ᡼μ mbox ⡼ɤ
# 'pop3' -> ᡼μ pop3 ⡼ɤ
#
# See: note/daemon_thread.txt
def mode_daemon(mode)
	
	# ᥽åɥ֥ȤȤܲ
	begin
		case mode
		when nil
			include Utils # for do_nothing
			receive = method(:do_nothing)
			# Ū˼᡼åɬפʤŬͤǤ褤
			d_receive_interval = 60 * 60 * 60
		when 'mbox'
			receive = method(:mode_mbox)
			d_receive_interval = D_MBOX_INTERVAL
		when 'pop3'
			receive = method(:mode_pop3)
			d_receive_interval = D_POP3_INTERVAL
		else
			Utils::cputs('fatal', "'#{mode}' mode is invalid")
			return 110
		end
	rescue
		Utils::cputs('fatal', "method() occurs exception")
		return 111
	end

	# pid եν񤭹ߥå (ޤºݤˤϽ񤭹ޤʤ)
	begin
		f = File.open(D_PID_FILE, 'a')
		f.close
	rescue
		Utils::cputs('error', "Can't write pid file #{D_PID_FILE}")
		return 112
	end

	# եǥ쥯ȥΥå
	ret = Utils::switch_euid(D_USER_NAME, true) {
		daemon_check_by_switched_user()
	}
	return ret if ret != 0

	# ǡ
	cpid = Utils::simple_daemon() { 
		daemon_process(receive, d_receive_interval)
	}
	# NOTE: ʹߤϿƥץΤߤνȤʤ

	# ҥץֹΤäΤǡpid եƽλ
	ret = write_pid_file(D_PID_FILE, cpid, "#{ARGV.join(' ')}")
	exit! ret
end


# kill 
# NOTE: Ȥ root ʤХ桼ѹ뤳
# See: note/kill_hup.txt
def kill_proc(pid)
	ret = Utils::switch_euid(D_USER_NAME, true) {
		Process.kill('SIGTERM', pid)
	}
	if ret != 1
		Utils::cputs('error', "Can't kill pid=#{pid}")
		return 90
	end

	return 0
end


# pid եɤ߹߽
# : [pid, args]
# See: note/kill_hup.txt
def read_pid_file(fpath)
	begin
		f = File.open(fpath)
		pid  = f.gets.chomp!.to_i
		args = f.gets.chomp
		return [pid, args]
	rescue
		Utils::cputs('error', "Can't read pidfile=#{fpath}")
		raise
	ensure
		f.close if f
	end
end


# pid եɤ߹ߡץ kill 
# See: note/kill_hup.txt
def mode_kill()
	pid, args = read_pid_file(D_PID_FILE)
	return kill_proc(pid)
end


# pid եɤ߹ߡץ kill 롣
# θ塢Ʊޥɤư롣
#
# NOTE: pid ե뤬̵㳰ǰ۾ｪλ
# NOTE: pid եϤ뤬 kill ˼Ԥ硢˥ץΩ夲
#
# See: note/kill_hup.txt
def mode_hup()
	pid, args = read_pid_file(D_PID_FILE)

	# kill ˼ԤƤ⿷ץΩ夲
	begin
		ret = kill_proc(pid)
		return ret if ret != 0
	rescue
		Utils::cputs('info', "Can't kill process #{pid}")
		Utils::cputs('info', "But, continue booting #{$0} ...")
	end

	# TODO: system ؤΰϤäȴʷˤǤʤΤ
	arg1, arg2 = args.split(' ')
	if    !arg1 then ret = nil
	elsif !arg2 then ret = system($0, arg1)
	else             ret = system($0, arg1, arg2)
	end

	if !ret
		Utils::cputs('error', "Can't reboot #{$0}")
		ret = 50
	elsif $?.to_i / 256 != 0
		Utils::cputs('error', "#{$0} returns #{$?.to_i / 256}")
		ret = 51
	else
		ret = 0
	end

	return ret
end


#################################################
# main
#################################################
def main()
	time_now = Time.now

	# ǰΤᡢumask ѹƤ
	File.umask(UMASK)

	# åƼ
	ret = main_check()
	return ret if ret != 0

	case ARGV[MODE]
	# clean ⡼:  send Ǥʤä᡼
	when 'clean' then mode_clean()
	when 'dcs'   then mode_daemon(nil)
	when 'dcsm'  then mode_daemon('mbox')
	when 'dcsp'  then mode_daemon('pop3')
	when 'hup'   then mode_hup()
	when 'kill'  then mode_kill()
	when 'mbox'  then mode_mbox()
	when 'pop3'  then mode_pop3()
	when 'send'  then mode_send(time_now)
	# sendmail  aliases ɸϤꡢ
	# ǥХå˥ƥȥե cat ήि˻
	when 'stdin' then process_incoming_mail(STDIN)
	else 
		raise 'Control never reach.'
	end

	return 0
end


# main μ¹
if $0 == __FILE__
	exit main()
end

__END__
