#!/usr/bin/env ruby
#
# SMTP Relay With ISP
# sendmail ӥɥᥤ˥᡼뤿Υȥġ
#
# Usage:
#  cat mail | smisp
# 
# ɸϤɤ߹᡼ꤵ줿 SMTP ФȤäޤ
# SMTP ФʤɤꤹˤϡΥեľԽƤ
# 
# $Id: smisp.rb 4 2007-04-23 18:09:11Z isr $
#

$KCODE = 'e' # !! եʸɤѹݤϤѹ뤳

require 'mailread'
require 'net/smtp'


#----------------------------------------------------------
# 桼꤬ɬפʲս
#----------------------------------------------------------

# ᡼Ȥ˻Ȥ SMTP Фȥݡֹ
# NOTE: Yahoo BB ʤ ybbsmtp.mail.yahoo.co.jp
SMTP_HOST	= '192.168.0.254'
SMTP_PORT	= 25
# ȤΥ᡼륢ɥ쥹򵭽ҤƤ
# NOTE: SMTP Ф MAIL FROM ̿ݡѤ
SMTP_FROM	= ''
# SMTP ˥ɬפС桼̾ѥɤ
# NOTE: ɬפ̵ nil ꤷƤ
SMTP_USER	= nil
SMTP_PASS	= nil 
# ǧˡ򵭤Ƥ (nil, :login, :plain, :cram_md5)
# NOTE: Yahoo BB  :plain
SMTP_AUTH	= :plain
# 狼ʤä˻ꤷʤƤȻפޤ
SMTP_HELO	= 'localhost.localdomain'

# 
# NOTE: ǥեȤ '/var/log/smisp'  make ˺ޤ
# See: Makefile
LOG_PATH	= '/var/log/smisp'

# äƤ⤤᡼륢ɥ쥹򵭽ҤƤ
WHITE_LIST = [
	# :
	# 'fooooo01@ezweb.ne.jp',
	# 'fooooo02@ezweb.ne.jp'
	''
]


#----------------------------------------------------------

# Message-ID, To, From 
# ǸΥɬ
class MailLogInfo
	attr_accessor :msgid, :to, :from
	def initialize(msgid, to, from)
		@msgid = msgid
		@to = to
		@from = from
	end


	# Ϥ줿 MailLogInfo ΥꥹȤ˼ʬƱ󤬤뤫
	def exist?(list)
		list.each { |i|
			return true if i.msgid == @msgid and i.to == @to and i.from == @from
		}
		return false
	end
end


#----------------------------------------------------------
# ʲ
#----------------------------------------------------------

def usage(argc)
	if argc != 0
		STDERR.print <<'EndOfUsage'
ˡ: cat mail | smisp.rb

ɸϤɤ߹᡼ꤵ줿 SMTP ФȤäޤ
SMTP ФʤɤꤹˤϡΥեľԽƤ

EndOfUsage
		return 10
	end

	return 0
end


# Ƽå
def main_check()
	ret = usage(ARGV.length)
	return ret if ret != 0

	# 뤫å
	begin
		f = File.open(LOG_PATH, 'a')
	rescue
		STDERR.puts "ERROR: Can't open a log file #{LOG_PATH}"
		return 20
	ensure
		f.close if f
	end

	return 0
end


# addr ˥᡼äƤɤȽꤷޤ
#
# TODO: ʸ˻ʸ󤬤뤫ǧƤʤΤȽ꤬Ť
#       ͤθƤɬפȻפ
def send_ok?(addr)
	# ʸäƤϤʤ
	return false if addr.empty?

	# ۥ磻ȥꥹȤʤСƤΥɥ쥹̵Ȥ
	return false if WHITE_LIST == []

	# ۥ磻ȥꥹȤ˺ܤäƤ뤫
	WHITE_LIST.each do |w|
		return true if w != '' and addr.index(w)
	end

	return false
end


# ᡼إåΥեɤ᡼륢ɥ쥹
# ΥꥹȤ֤
# NOTE: str ˲ԤäƤ
# TODO: ʤʰŪ
def make_address_list(str)
	return [] unless str
	return str.scan(/[^<,\s]+@[^>,\s]+/)
end


# Mail 饹鸵Υ᡼ƹۤ
def make_contents(mail)
	contents = ""
	return contents unless mail

	mail.header.each { |k, v|
		contents += "#{k}: " + v.gsub(/\n/, "\n ") + "\n"
	}
	contents += "\n" + mail.body.to_s
end


# ᡼
# id_list, ng_list Ϲ
def send_mail!(mail, id_list, ng_list)
	# To, Cc, Bcc Ƥΰ
	# TODO: Bcc إåϺƤޤǤѤǤʤ
	ads  = []
	ads += make_address_list(mail['to'])
	ads += make_address_list(mail['cc'])
	ads += make_address_list(mail['bcc'])

	sm = nil
	msgid = mail['message-id'] ? mail['message-id'].gsub(/\n/, ' ') : ''
	from  = mail['from'] ? mail['from'].gsub(/\n/, ' ') : ''

	ads.each { |ad|
		#  WHITE_LIST ˺ܤäƤ뤫
		next unless send_ok?(ad)

		# ѤߤΥ᡼ǤϤʤ
		minfo = MailLogInfo.new(msgid, ad, from)
		next if minfo.exist?(id_list)
		id_list << minfo

		# ʲ˰ܤ뤬
		# å󤬤ޤĥƤʤФĥ
		if sm == nil
			sm = Net::SMTP.start(SMTP_HOST, SMTP_PORT,
								 SMTP_HELO, SMTP_USER,
								 SMTP_PASS, SMTP_AUTH)
		end
		# ᡼ƹ
		contents = make_contents(mail)
		# 
		sm.send_mail(contents, SMTP_FROM, ad)
	}
	# 
	# ǤۤʤСΥ᡼ĤƤ
	if sm then sm.finish
	else       ng_list << MailLogInfo.new(msgid, ads.join(', '), from)
	end
end


# ᡼Υ񤭽Ф
# NOTE: Ǥʤä᡼ĤƤ
def write_log(id_list, ng_list)
	return if id_list == [] and ng_list == []

	log = File.open(LOG_PATH, 'a')
	ts = Time.now.strftime("%b %d %H:%M:%S")
	id_list.each { |i|
		log.print "#{ts} [SEND] "
		log.print "Message-ID='#{i.msgid}', To='#{i.to}', From='#{i.from}'\n"
	}
	ng_list.each { |i|
		log.print "#{ts} [REJECT] "
		log.print "Message-ID='#{i.msgid}', To='#{i.to}', From='#{i.from}'\n"
	}
	log.close
end


#################################################
# main
#################################################
def main()
	ret = main_check()
	return ret if ret != 0

	# ᡼ Message-ID, From, To ޤ
	id_list = []
	# Ǥʤä᡼ξƱͤ˻ĤƤ
	ng_list = []
	until (m = Mail.new(STDIN)).header.empty?
		send_mail!(m, id_list, ng_list)
	end

	# ᡼ΥäƤ
	write_log(id_list, ng_list)

	return 0
end


# main μ¹
exit main()
__END__
