/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class Terrarium {
    public static final int MAX_X = 300;
    public static final int MAX_Y = 300;
    public static final int MAX_Z = 100;
    public static ArrayList<Body> bodyList = new ArrayList();
    public static ArrayList<Food> foodList = new ArrayList();
    public static ArrayList<Shit> shitList = new ArrayList();
    public static ArrayList<Toilet> toiletList = new ArrayList();
    public static ArrayList<Barrier> barrierList = new ArrayList();
    private static int[][] map = new int[301][301];
    private static Random rnd = new Random();
    private static int alarmPeriod = 0;
    private static boolean alarm = false;
    private static ArrayList<Body> babyList = new ArrayList();
    private static final int ALARM_PERIOD = 300;

    public static void saveState(File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            out.writeUTF(Terrarium.class.getCanonicalName());
            out.writeInt(alarmPeriod);
            out.writeBoolean(alarm);
            out.writeObject(rnd);
            out.writeObject(bodyList);
            out.writeObject(foodList);
            out.writeObject(shitList);
            out.writeObject(toiletList);
            out.writeObject(barrierList);
            out.writeObject(map);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public static void loadState(File file) throws IOException, ClassNotFoundException {
        int[][] map;
        ArrayList barrierList;
        ArrayList toiletList;
        ArrayList shitList;
        ArrayList foodList;
        ArrayList bodyList;
        Random rnd;
        boolean alarm;
        int alarmPeriod;
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            String s = in.readUTF();
            if (!Terrarium.class.getCanonicalName().equals(s)) {
                String errMsg = "Bad save: " + s;
                throw new IOException(errMsg);
            }
            alarmPeriod = in.readInt();
            alarm = in.readBoolean();
            rnd = (Random)in.readObject();
            bodyList = (ArrayList)in.readObject();
            foodList = (ArrayList)in.readObject();
            shitList = (ArrayList)in.readObject();
            toiletList = (ArrayList)in.readObject();
            barrierList = (ArrayList)in.readObject();
            map = (int[][])in.readObject();
        }
        finally {
            in.close();
        }
        Terrarium.rnd = rnd;
        Terrarium.alarmPeriod = alarmPeriod;
        Terrarium.alarm = alarm;
        Terrarium.bodyList = bodyList;
        Terrarium.foodList = foodList;
        Terrarium.shitList = shitList;
        Terrarium.toiletList = toiletList;
        Terrarium.barrierList = barrierList;
        Terrarium.map = map;
    }

    private static void setLine(int x1, int y1, int x2, int y2, boolean setFlag) {
        int distance = (int)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double deltaX = (double)(x2 - x1) / (double)distance;
        double deltaY = (double)(y2 - y1) / (double)distance;
        int sX = x1;
        int sY = y1;
        int t = 0;
        while (t <= distance) {
            int x = sX + (int)(deltaX * (double)t);
            int y = sY + (int)(deltaY * (double)t);
            Terrarium.setPoint(x, y, setFlag);
            ++t;
        }
    }

    private static void setPoint(int x, int y, boolean setFlag) {
        if (setFlag) {
            int[] nArray = map[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
        } else {
            int[] nArray = map[x];
            int n = y;
            nArray[n] = nArray[n] - 1;
            if (map[x][y] < 0) {
                Terrarium.map[x][y] = 0;
            }
        }
    }

    public static void setBarrier(int x1, int y1, int x2, int y2) {
        x1 = Math.max(0, Math.min(x1, 300));
        x2 = Math.max(0, Math.min(x2, 300));
        y1 = Math.max(0, Math.min(y1, 300));
        y2 = Math.max(0, Math.min(y2, 300));
        Terrarium.setLine(x1, y1, x2, y2, true);
        barrierList.add(new Barrier(x1, y1, x2, y2));
    }

    public static void clearBarrier(Barrier b) {
        int x1 = b.getSX();
        int y1 = b.getSY();
        int x2 = b.getEX();
        int y2 = b.getEY();
        Terrarium.setLine(x1, y1, x2, y2, false);
        barrierList.remove(b);
    }

    public static ArrayList<Barrier> getBarriers() {
        return barrierList;
    }

    public static boolean onBarrier(int cx, int cy, int thx, int thy) {
        int sx = Math.max(0, cx - thx / 2);
        int sy = Math.max(0, cy - thy / 2);
        int ex = Math.min(cx + thx / 2, 300);
        int ey = Math.min(cy + thy / 2, 300);
        int x = sx;
        while (x < ex) {
            int y = sy;
            while (y < ey) {
                if (map[x][y] != 0) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public static boolean onBarrier(int cx, int cy, int thickness) {
        return Terrarium.onBarrier(cx, cy, thickness, thickness);
    }

    public static Barrier getBarrier(int cx, int cy, int thickness) {
        for (Barrier b : barrierList) {
            int x1 = b.getSX();
            int y1 = b.getSY();
            int x2 = b.getEX();
            int y2 = b.getEY();
            int distance = (int)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double deltaX = (double)(x2 - x1) / (double)distance;
            double deltaY = (double)(y2 - y1) / (double)distance;
            int sX = x1;
            int sY = y1;
            int t = 0;
            while (t <= distance) {
                int x = sX + (int)(deltaX * (double)t);
                int y = sY + (int)(deltaY * (double)t);
                if (Math.abs(x - cx) <= thickness && Math.abs(y - cy) <= thickness) {
                    return b;
                }
                ++t;
            }
        }
        return null;
    }

    private int distance(int x, int y) {
        return x * x + y * y;
    }

    private boolean checkPartner(Body b) {
        if (b.isDead() || b.isSleeping()) {
            return false;
        }
        boolean ret = false;
        Body found = null;
        int minDistance = b.getEyesight();
        if (b.isExciting() && b.partner != null && !b.partner.isDead() && !b.isRaper()) {
            found = b.partner;
            minDistance = this.distance(b.getX() - found.getX(), b.getY() - found.getY());
        } else {
            for (Body partner : bodyList) {
                int dy;
                if (partner == b || b.getZ() != partner.getZ() || (!b.isExciting() ? partner.isDead() && (!partner.hasAccessory() || b.isIdiot()) || !partner.isDead() && !b.isRude() && b.wantToShit() : !b.isRaper() && (partner.isDead() || !partner.isAdult() || partner.isChild(b) || partner.isParent(b)))) continue;
                int dx = b.getX() - partner.getX();
                int dist = this.distance(dx, dy = b.getY() - partner.getY());
                if (minDistance <= dist) continue;
                found = partner;
                minDistance = dist;
            }
        }
        if (found != null) {
            if (minDistance <= this.distance(b.getStep(), b.getStep())) {
                if (!found.isDead()) {
                    if (b.isExciting()) {
                        if (!b.isTalking()) {
                            b.doSukkiri(found);
                        }
                        ret = true;
                    } else if (!found.hasAccessory() && b.hasAccessory() && (b.isRude() || !b.isMotherhood(found))) {
                        if (!b.isTalking()) {
                            b.showHateYukkuri();
                            found.strike(b.getStrength());
                        }
                    } else if (b.isAdult() && !found.isAdult() && found.isDirty() && (found.isChild(b) || b.isMotherhood(found))) {
                        if (!b.isTalking()) {
                            b.doPeropero(found);
                        }
                    } else if (b.isParent(found)) {
                        if (!b.isTalking()) {
                            b.doPeropero(found);
                        }
                    } else if ((found.isPartner(b) || found.isParent(b)) && !b.isTalking()) {
                        b.doSurisuri(found);
                    }
                } else if (b.isExciting()) {
                    if (!b.isTalking()) {
                        b.doSukkiri(found);
                    }
                    ret = true;
                } else if (b.isAdult() && !b.isTalking()) {
                    if (b.isParent(found)) {
                        b.showSadnessForChild();
                    } else if (b.isPartner(found)) {
                        b.showSadnessForPartner(found);
                    }
                }
            } else if (!found.isDead()) {
                if (b.isExciting()) {
                    b.moveToSukkiri(found.getX(), found.getY());
                    ret = true;
                } else if (!found.hasAccessory() && b.hasAccessory() && (b.isRude() || !b.isMotherhood(found)) && rnd.nextInt(10) == 0) {
                    if (!b.isTalking()) {
                        b.showHateYukkuri();
                    }
                    b.moveTo(found.getX(), found.getY());
                } else if (b.isAdult() && !found.isAdult() && found.isDirty() && (found.isChild(b) || b.isMotherhood(found))) {
                    b.moveTo(found.getX(), found.getY());
                } else if (b.isChild() && found.isParent(b)) {
                    b.moveTo(found.getX(), found.getY());
                }
            } else if (b.isExciting()) {
                b.moveToSukkiri(found.getX(), found.getY());
                ret = true;
            } else if (rnd.nextInt(10) == 0) {
                if (b.isAdult()) {
                    if (b.isParent(found) || b.isPartner(found)) {
                        b.moveTo(found.getX(), found.getY());
                    } else {
                        b.lookTo(found.getX(), found.getY());
                    }
                } else {
                    b.runAway(found.getX(), found.getY());
                }
                if (!b.isTalking()) {
                    b.showScare();
                }
            }
        }
        return ret;
    }

    private boolean checkFood(Body b) {
        int dy;
        int dx;
        int distance;
        boolean ret = false;
        if (b.isExciting() || b.isSleeping() || b.isDead() || b.isFull() || b.isScare() || b.isSick()) {
            return false;
        }
        if (!b.isRude() && !b.isIdiot() && b.wantToShit()) {
            return false;
        }
        Obj found = null;
        int minDistance = b.getEyesight();
        for (Food food : foodList) {
            if (food.isEmpty() || b.getZ() != food.getZ() || minDistance <= (distance = this.distance(dx = b.getX() - food.getX(), dy = b.getY() - food.getY()))) continue;
            found = food;
            minDistance = distance;
        }
        for (Shit shit : shitList) {
            if (!b.isTooHungry() && !b.isIdiot()) break;
            if (b.getZ() != shit.getZ() || minDistance <= (distance = this.distance(dx = b.getX() - shit.getX(), dy = b.getY() - shit.getY()))) continue;
            found = shit;
            minDistance = distance;
        }
        for (Body body : bodyList) {
            if (!body.isDead() || body.hasAccessory() && !b.isIdiot() || b.getZ() != body.getZ() || minDistance <= (distance = this.distance(dx = b.getX() - body.getX(), dy = b.getY() - body.getY()))) continue;
            found = body;
            minDistance = distance;
        }
        if (found != null) {
            if (minDistance <= this.distance(b.getStep(), b.getStep())) {
                if (!b.isTalking()) {
                    if (found instanceof Food) {
                        Food food = (Food)found;
                        b.eatFood(food.getFoodType(), Math.min(b.getEatAmount(), food.getAmount()));
                        food.eatFood(Math.min(b.getEatAmount(), food.getAmount()));
                    } else if (found instanceof Shit) {
                        Shit shit = (Shit)found;
                        b.eatFood(Food.type.SHIT, b.getEatAmount());
                        shit.eatShit(b.getEatAmount());
                    } else if (found instanceof Body) {
                        Body body = (Body)found;
                        b.eatFood(Food.type.BODY, Math.min(b.getEatAmount(), body.getAmount()));
                        body.eatBody(Math.min(b.getEatAmount(), body.getAmount()));
                        if (body.isSick()) {
                            b.setSick();
                        }
                    }
                }
                ret = true;
            } else if (b.isHungry()) {
                if (!b.isTalking()) {
                    if (found instanceof Food) {
                        b.moveToFood(found.getX(), found.getY());
                    } else if (found instanceof Shit) {
                        b.moveToShit(found.getX(), found.getY());
                    } else if (found instanceof Body) {
                        b.moveToFood(found.getX(), found.getY());
                    }
                }
                ret = true;
            }
        } else if (b.isHungry() && !b.isTalking() && rnd.nextInt(10) == 0) {
            b.showNoFood();
        }
        return ret;
    }

    private boolean checkShit(Body b) {
        if (b.isIdiot()) {
            return false;
        }
        boolean ret = false;
        Shit found = null;
        int minDistance = b.getEyesight();
        for (Shit s : shitList) {
            int dy;
            int dx;
            int distance;
            if (b.getZ() != s.getZ() || minDistance <= (distance = this.distance(dx = b.getX() - s.getX(), dy = b.getY() - s.getY()))) continue;
            found = s;
            minDistance = distance;
        }
        if (!(found == null || minDistance > this.distance(b.getStep(), b.getStep()) || b.isSleeping() || b.isExciting() || b.isTalking())) {
            b.showHateShit();
        }
        return ret;
    }

    private boolean checkToilet(Body b) {
        if (b.isIdiot()) {
            return false;
        }
        boolean ret = false;
        Obj found = null;
        int minDistance = 90000;
        for (Toilet t : toiletList) {
            int dy;
            int dx = b.getX() - t.getX();
            int distance = this.distance(dx, dy = b.getY() - t.getY() - t.getSize() / 6);
            if (minDistance <= distance) continue;
            found = t;
            minDistance = distance;
        }
        if (found != null && b.wantToShit()) {
            b.moveToToilet(found.getX(), found.getY() - ((Toilet)found).getSize() / 6);
            ret = true;
        }
        return ret;
    }

    private void addBaby(int x, int y, int z, int type2, Body p1, Body p2) {
        babyList.add(this.makeBody(x, y, z, type2, Body.AgeState.BABY, p1, p2));
    }

    public Body makeBody(int x, int y, int z, int type2, Body.AgeState age, Body p1, Body p2) {
        Body b;
        switch (type2) {
            case 0: {
                b = new Marisa(x, y, z, age, p1, p2);
                break;
            }
            case 1: {
                b = new Reimu(x, y, z, age, p1, p2);
                break;
            }
            case 2: {
                b = new Alice(x, y, z, age, p1, p2);
                break;
            }
            case 3: {
                b = new WasaReimu(x, y, z, age, p1, p2);
                break;
            }
            case 4: {
                b = new Tarinai(x, y, z, age, p1, p2);
                break;
            }
            case 10000: {
                b = new MarisaReimu(x, y, z, age, p1, p2);
                break;
            }
            case 10001: {
                b = new ReimuMarisa(x, y, z, age, p1, p2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown yukkuri type.");
            }
        }
        return b;
    }

    public void addBody(int x, int y, int z, int type2, Body.AgeState age, Body p1, Body p2) {
        bodyList.add(this.makeBody(x, y, z, type2, age, p1, p2));
    }

    public void addBody(Body b) {
        bodyList.add(b);
    }

    public void addFood(int x, int y, Food.type type2) {
        foodList.add(new Food(x, y, type2));
    }

    public void addShit(int x, int y, int z, Body.AgeState ageState) {
        shitList.add(new Shit(x, y, z, ageState));
    }

    public void addCrushedShit(int x, int y, int z, Body.AgeState ageState) {
        Shit s = new Shit(x, y, z, ageState);
        s.crushShit();
        shitList.add(s);
    }

    public void addToilet(int x, int y) {
        toiletList.add(new Toilet(x, y));
    }

    public static void setAlarm() {
        alarm = true;
        alarmPeriod = 300;
    }

    public static boolean getAlarm() {
        return alarm;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run() {
        if (alarmPeriod >= 0 && --alarmPeriod <= 0) {
            alarmPeriod = 0;
            alarm = false;
        }
        Obj.Event ret = Obj.Event.DONOTHING;
        Iterator<Obj> i = foodList.iterator();
        while (i.hasNext()) {
            Food f = i.next();
            ret = f.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i.remove();
        }
        i = toiletList.iterator();
        while (i.hasNext()) {
            Toilet t = (Toilet)i.next();
            ret = t.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i.remove();
        }
        i = shitList.iterator();
        while (i.hasNext()) {
            Shit s = (Shit)i.next();
            ret = s.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i.remove();
        }
        i = bodyList.iterator();
        block9: while (i.hasNext()) {
            Body b = (Body)i.next();
            b.putStress(bodyList.size());
            ret = b.clockTick();
            block0 : switch (ret) {
                case DEAD: {
                    continue block9;
                }
                case BIRTHBABY: {
                    Iterator<Integer> iterator = b.getBabyTypes().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            b.getBabyTypes().clear();
                            break block0;
                        }
                        int babyType = iterator.next();
                        this.addBaby(b.getX(), b.getY(), b.getZ(), babyType, b, b.partner);
                    }
                }
                case DOSHIT: {
                    this.addShit(b.getX(), b.getY(), b.getZ(), b.getAgeState());
                    break;
                }
                case REMOVED: {
                    i.remove();
                    continue block9;
                }
            }
            if (this.checkFood(b) || this.checkPartner(b) || this.checkShit(b)) continue;
            this.checkToilet(b);
        }
        if (!babyList.isEmpty()) {
            bodyList.addAll(babyList);
            babyList.clear();
        }
    }
}

