/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class Food
extends Obj
implements Serializable {
    static final long serialVersionUID = 2L;
    public static final int FOOD_EMPTY = 0;
    public static final int FOOD_NOT_EMPTY_NORMAL = 1;
    public static final int FOOD_NOT_EMPTY_BITTER = 2;
    public static final int FOOD_NOT_EMPTY_LEMON = 3;
    public static final int FOOD_NOT_EMPTY_HOT = 4;
    public static final int FOOD_NOT_EMPTY_VIYUGRA = 5;
    public static final int FOOD_NOT_EMPTY_FUNGICIDE = 6;
    public static final int FOOD_SHADOW = 7;
    public static final int NUM_OF_FOOD_STATE = 8;
    public static final int FOOD_AMOUNT = 57600;
    private type foodType;
    private int amount;
    private static final int foodSize = 64;
    private static final int[] value;
    private static Image[] images;

    static {
        int[] nArray = new int[9];
        nArray[1] = 250;
        nArray[2] = 50;
        nArray[3] = 1000;
        nArray[4] = 500;
        nArray[5] = 300;
        nArray[6] = 500;
        nArray[8] = 800;
        value = nArray;
        images = new Image[8];
    }

    public static void loadImages(ClassLoader loader, String path) throws IOException {
        Food.images[0] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan1.png"));
        Food.images[1] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan2.png"));
        Food.images[2] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan3.png"));
        Food.images[3] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan4.png"));
        Food.images[4] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan5.png"));
        Food.images[5] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan6.png"));
        Food.images[6] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan6.png"));
        Food.images[7] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "gohan-shadow.png"));
        int i = 0;
        while (i < 8) {
            Food.images[i] = images[i].getScaledInstance(64, 32, 16);
            ++i;
        }
    }

    @Override
    public Image getImage() {
        if (this.isEmpty()) {
            return images[0];
        }
        switch (this.foodType) {
            default: {
                return images[1];
            }
            case BITTER: {
                return images[2];
            }
            case LEMONPOP: {
                return images[3];
            }
            case HOT: {
                return images[4];
            }
            case VIYUGRA: {
                return images[5];
            }
            case FUNGICIDE: 
        }
        return images[6];
    }

    @Override
    public Image getShadowImage() {
        return images[7];
    }

    @Override
    public int getSize() {
        return 64;
    }

    public static int getSizeS() {
        return 64;
    }

    @Override
    public int getPrice(Obj.Price priceType) {
        if (priceType == Obj.Price.BUYING) {
            return value[this.foodType.ordinal()];
        }
        return value[this.foodType.ordinal()] / 2 * this.amount / 57600;
    }

    public Food(int initX, int initY, type initType, int initAmount) {
        this.objType = Obj.Type.FOOD;
        this.x = initX;
        this.y = initY;
        this.z = 0;
        this.foodType = initType;
        this.amount = initAmount < 0 ? 57600 : initAmount;
        this.removed = false;
    }

    public type getFoodType() {
        return this.foodType;
    }

    public boolean isEmpty() {
        return this.amount == 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public void eatFood(int eatAmount) {
        if (this.isEmpty()) {
            return;
        }
        this.amount -= eatAmount;
        if (this.amount <= 0) {
            if (this.foodType == type.SELFFEEDER) {
                this.amount = 57600;
                Cash.delCash(value[type.YUKKURIFOOD.ordinal()]);
            } else {
                this.amount = 0;
            }
        }
    }

    @Override
    public void kick() {
        this.kick(0, -8, -4);
    }

    public static enum type {
        SHIT,
        YUKKURIFOOD,
        BITTER,
        SELFFEEDER,
        LEMONPOP,
        HOT,
        VIYUGRA,
        BODY,
        FUNGICIDE;

    }
}

