import java.io.*;
import java.util.*;

/**
 * ץåȥ᥽åɼΤݻޤ<BR>
 * ϥꥢ饤InnerDic.ser¸ޤ<BR>
 * ޤUnicodeͤǥȤƤɬפޤ<BR>
 * <BR>
 * Ȥ: java fuku.skk4j.devel.MakeInnerDic <ϥե> <>
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class MakeInnerDic {

    /** 겾̾ͭܳϥإå */
    private static final String _OKURI_ARI = ";; okuri-ari entries.";
    /** 겾̵̾ܳϥإå */
    private static final String _OKURI_NASI = ";; okuri-nasi entries.";

    /** ꤢ꼭 */
    private List _ariDic = new ArrayList();
    /** ʤ */
    private List _nasiDic = new ArrayList();


    /**
     * ᥤ᥽åɡ
     *
     * @param args ޥɹ԰
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            return;
        }
        String fname = args[1] + "/InnerDic.ser";
        MakeInnerDic myself = new MakeInnerDic();
        myself._load(args[0]);
        myself._store(fname);
    }


    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private MakeInnerDic() {
        super();
    }


    /**
     * ե뤫鼭Ƥɤ߹ߤޤ
     *
     * @param filename ե̾
     */
    private void _load(String filename) {
        _ariDic.clear();
        _nasiDic.clear();

        List dic = _ariDic;
        BufferedReader in = null;
        String line = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(filename),"UTF-8"));
            while ((line=in.readLine()) != null) {
                // ȡԤ̵
                if (line.startsWith(";;") || line.length() == 0) {
                    if (line.startsWith(_OKURI_NASI)) {
                        dic = _nasiDic;
                    }
                    continue;
                }
                dic.add(line);
            }
        } catch (IOException e) {
            System.err.println(e.getMessage());
            _ariDic.clear();
            _nasiDic.clear();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    /**
     * ¸ޤ
     *
     * @param filename ե̾
     */
    private void _store(String filename) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(filename));
            oos.writeObject(_ariDic);
            oos.writeObject(_nasiDic);
            oos.close();
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } finally {
            if (oos != null) {
                try {
                    oos.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }
}

// end of MakeInnerDic.java
