package fuku.skk4j.dic;

import java.io.*;
import java.util.*;

/**
 * å夵줿ǥåѤSKK񥯥饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class CacheDic implements SKKDic {

    /** ꤢ꼭񥤥ǥå */
    private Hashtable _ariDic = null;
    /** ʤ񥤥ǥå */
    private Hashtable _nasiDic = null;

    /** ե */
    private File _file = null;
    /** Υǥåե */
    private String _indexName = null;
    /** եΥ󥳡ǥ */
    private String _encoding = null;

    /** ¸ߤ뤫ɤ */
    private boolean _exist = false;


    /**
     * 󥹥ȥ饯Υǥå
     *
     * @param fname ե̾
     * @param iname ǥåե̾
     * @param enc եΥ󥳡ǥ
     */
    public CacheDic(String fname, String iname, String enc) {
        super();
        _indexName = iname;
        _encoding = enc;
        if (fname != null && fname.length() != 0) {
            _file = new File(fname);
        }
        _open();
    }


    /**
     * 򳫤ޤ
     *
     */
    private void _open() {
        if (_file == null) {
            _exist = false;
            return;
        }

        try {
            _exist = _file.canRead();
        } catch (SecurityException e) {
            System.err.println(e.getMessage());
            _exist = false;
        }

        if (!_exist) {
            return;
        }

        if (_indexName != null && _indexName.length() != 0) {
            File file = new File(_indexName);
            // ǽ
            if (_file.lastModified() > file.lastModified()) {
                _makeIndex();
                try {
                    _storeIndex(_indexName);
                } catch (SecurityException e) {
                    System.err.println(e.getMessage());
                }
            } else {
                _loadIndex(_indexName);
            }
        } else {
            _makeIndex();
        }
    }

    /**
     * Ĥƥ꥽ޤ
     *
     */
    public void close() {
        if (_ariDic != null) {
            _ariDic.clear();
            _ariDic = null;
        }
        if (_nasiDic != null) {
            _nasiDic.clear();
            _nasiDic = null;
        }
        _exist = false;
    }

    /**
     * Ǽ򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return η (ʤnull)
     */
    public synchronized String search(String key) {
        if (!_exist) {
            return null;
        }

        Long[] pos = null;
        boolean reverse = false;
        if (DicUtil.isOkuriAri(key)) {
            pos = (Long[])_ariDic.get(new Character(key.charAt(0)));
            reverse = true;
        } else {
            pos = (Long[])_nasiDic.get(new Character(key.charAt(0)));
        }

        if (pos == null) {
            return null;
        }

        long i = pos[0].longValue();
        long j = pos[1].longValue();

        RandomAccessFile raFile = null;
        try {
            // ե򳫤
            raFile = new RandomAccessFile(_file, "r");

            // Хʥꥵ
            while (i < j) {
                // ԤˤʤΤǹޤǥå
                raFile.seek((i+j)/2);
                if (_readEntry(raFile) == null) { // skip and EOF check
                    return null;
                }

                long x = raFile.getFilePointer();
                // (x)(j)ĶƤޤä硢˥Ǹ
                if (x >= j) {
                    raFile.seek(i);
                    while (raFile.getFilePointer() < j) {
                        String entry = _readEntry(raFile);
                        if (entry == null) {
                            return null;
                        }

                        int sep = entry.indexOf(' ');
                        if (sep != -1) {
                            String yomi = entry.substring(0, sep+1);
                            if (DicUtil.compare(yomi, key, _encoding) == 0) {
                                return entry.substring(sep+1);
                            }
                        }
                    }
                    return null;
                }

                String entry = _readEntry(raFile);
                if (entry == null) { // EOF check
                    return null;
                }

                int sep = entry.indexOf(' ');
                String yomi;
                if (sep != -1) {
                    yomi = entry.substring(0, sep+1);
                } else {
                    yomi = entry;
                }

                int comp = DicUtil.compare(yomi, key, _encoding);
                if (comp == 0) {
                    if (sep == -1) {
                        return null;
                    }
                    return entry.substring(sep+1);
                }

                if (reverse) {
                    comp = -comp;
                }
                if (comp < 0) {
                    i = x;
                } else {
                    j = x;
                }
            }
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } finally {
            if (raFile != null) {
                try {
                    raFile.close();
                    raFile = null;
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        return null;
    }

    /**
     * 񥤥ǥåɤ߹ߤޤ
     *
     * @param iname ǥåե̾
     */
    private void _loadIndex(String iname) {
        if (_ariDic != null && _nasiDic != null) {
            return;
        }

        boolean success = true;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(iname));
            _ariDic = (Hashtable)ois.readObject();
            _nasiDic = (Hashtable)ois.readObject();
        } catch (OptionalDataException e) {
            System.err.println(e.getMessage());
            success = false;
        } catch (ClassNotFoundException e) {
            System.err.println(e.getMessage());
            success = false;
        } catch (IOException e) {
            System.err.println(e.getMessage());
            success = false;
        } catch (SecurityException e) {
            System.err.println(e.getMessage());
            success = false;
        } finally {
            if (ois != null) {
                try {
                    ois.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        if (!success) {
            _ariDic = null;
            _nasiDic = null;
            _makeIndex();
        }
    }

    /**
     * 񥤥ǥåޤ
     *
     */
    private void _makeIndex() {
        if (_ariDic != null && _nasiDic != null) {
            return;
        }

        _ariDic = new Hashtable();
        _nasiDic = new Hashtable();

        Hashtable tmpDic = _ariDic;
        String entry = null;
        long start = -1;
        long end;
        char index = ';';
        boolean eof = false;
        RandomAccessFile raFile = null;
        try {
            raFile = new RandomAccessFile(_file, "r");
            while (!eof) {
                end = raFile.getFilePointer();
                entry = _readEntry(raFile);
                // եκǸ
                if (entry == null) {
                    Long[] pos = {new Long(start), new Long(end)};
                    tmpDic.put(new Character(index), pos);
                    eof = true;
                } else if (entry.startsWith(";;") || entry.length() == 0) {
                    // ȡԤ̵
                    if (entry.equals(OKURI_NASI)) { // 
                        Long[] pos = {new Long(start), new Long(end)};
                        tmpDic.put(new Character(index), pos);
                        tmpDic = _nasiDic;
                        index = ';';
                        start = -1;
                    }
                    continue;
                } else if (entry.charAt(0) != index) {
                    // ƬʸѲС
                    // ޤǤͤ򥤥ǥåȤϿ
                    if (start != -1) {
                        Long[] pos = {new Long(start), new Long(end)};
                        tmpDic.put(new Character(index), pos);
                    }
                    index = entry.charAt(0);
                    start = end;
                }
            }
        } catch (IOException e) {
            System.err.println(e.getMessage());
            _ariDic.clear();
            _nasiDic.clear();
        } finally {
            if (raFile != null) {
                try {
                    raFile.close();
                    raFile = null;
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }

        if (_ariDic.isEmpty() && _nasiDic.isEmpty()) {
            _exist = false;
        }
    }

    /**
     * 񥤥ǥå¸ޤ
     *
     * @param iname ե̾
     */
    private void _storeIndex(String iname) {
        if (!_exist) {
            return;
        }

        File file = new File(iname);
        File p = file.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(_ariDic);
            oos.writeObject(_nasiDic);
            oos.close();
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } catch (SecurityException e) {
            System.err.println(e.getMessage());
        } finally {
            if (oos != null) {
                try {
                    oos.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    /**
     * ե뤫1Ԥɤ߽Фޤ
     *
     * @param file ե
     * @return ɤ߽Фʸ (üʸϴޤޤʤ)
     * @exception IOException ɤ߽Фβ뤹٤ƤI/O㳰
     */
    private String _readEntry(RandomAccessFile file) throws IOException {
        List list = new ArrayList();
        int b = -1;
        boolean eol = false;

        if (file == null) {
            return null;
        }

        while (!eol) {
            b = file.read();
            switch (b) {
                case -1:
                    eol = true;
                    break;
                case '\n':
                    eol = true;
                    break;
                case '\r':
                    eol = true;
                    long mark = file.getFilePointer();
                    if ((file.read()) != '\n')
                        file.seek(mark);
                    break;
                default:
                    list.add(new Byte((byte)b));
                    break;
            }
        }

        if ((b == -1) && (list.isEmpty())) {
            return null;
        }

        int size = list.size();
        byte[] buf = new byte[size];
        for (int i=0; i<size; i++) {
            buf[i] = ((Byte)list.get(i)).byteValue();
        }

        String str = null;
        if (_encoding != null) {
            try {
                str = new String(buf, _encoding);
            } catch (UnsupportedEncodingException e) {
                str = new String(buf);
            }
        } else {
            str = new String(buf);
        }
        return str;
    }
}

// end of CacheDic.java
